/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.GroupArtifactRepository;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenRepository;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

public class RocksdbMavenPomCache
implements MavenPomCache {
    static ObjectMapper mapper;
    private static final Map<String, RocksCache> cacheMap;
    private final RocksCache cache;
    private final Set<String> unresolvablePoms = new HashSet<String>();
    CacheResult<RawMaven> UNAVAILABLE_POM = new CacheResult<Object>(CacheResult.State.Unavailable, null);
    CacheResult<MavenMetadata> UNAVAILABLE_METADATA = new CacheResult<Object>(CacheResult.State.Unavailable, null);
    CacheResult<MavenRepository> UNAVAILABLE_REPOSITORY = new CacheResult<Object>(CacheResult.State.Unavailable, null);

    static synchronized RocksCache getCache(String pomCacheDir) {
        return cacheMap.computeIfAbsent(pomCacheDir, RocksCache::new);
    }

    public RocksdbMavenPomCache(@Nullable Path workspace) {
        assert (workspace != null);
        File pomCacheDir = new File(workspace.toFile(), ".rewrite-cache");
        if (!pomCacheDir.exists() && !pomCacheDir.mkdirs()) {
            throw new IllegalStateException("Unable to find or create maven pom cache at " + pomCacheDir);
        }
        if (!pomCacheDir.isDirectory()) {
            throw new IllegalStateException("The maven pom cache workspace must be a directory at " + pomCacheDir);
        }
        File lock = new File(pomCacheDir, "LOCK");
        if (lock.exists()) {
            lock.delete();
        }
        this.cache = RocksdbMavenPomCache.getCache(pomCacheDir.getAbsolutePath());
        this.fillUnresolvablePoms();
    }

    @Override
    public CacheResult<MavenMetadata> computeMavenMetadata(URI repo, String groupId, String artifactId, Callable<MavenMetadata> orElseGet) throws Exception {
        byte[] key = RocksdbMavenPomCache.serialize(new GroupArtifactRepository(repo, new GroupArtifact(groupId, artifactId)));
        Optional<MavenMetadata> rawMavenMetadata = RocksdbMavenPomCache.deserializeMavenMetadata(this.cache.get(key));
        if (rawMavenMetadata == null) {
            try {
                MavenMetadata metadata2 = orElseGet.call();
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.ofNullable(metadata2)));
                return new CacheResult<MavenMetadata>(CacheResult.State.Updated, metadata2);
            }
            catch (Exception e) {
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.empty()));
                throw e;
            }
        }
        return rawMavenMetadata.map(metadata -> new CacheResult<MavenMetadata>(CacheResult.State.Cached, (MavenMetadata)metadata)).orElse(this.UNAVAILABLE_METADATA);
    }

    @Override
    public CacheResult<RawMaven> computeMaven(URI repo, String groupId, String artifactId, String version, Callable<RawMaven> orElseGet) throws Exception {
        String artifactCoordinates = groupId + ':' + artifactId + ':' + version;
        if (this.unresolvablePoms.contains(artifactCoordinates)) {
            return this.UNAVAILABLE_POM;
        }
        byte[] key = RocksdbMavenPomCache.serialize(repo.toString() + ":" + artifactCoordinates);
        Optional<RawMaven> rawMavenEntry = RocksdbMavenPomCache.deserializeRawMaven(this.cache.get(key));
        if (rawMavenEntry == null) {
            try {
                RawMaven rawMaven2 = orElseGet.call();
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.ofNullable(rawMaven2)));
                return new CacheResult<RawMaven>(CacheResult.State.Updated, rawMaven2);
            }
            catch (Exception e) {
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.empty()));
                throw e;
            }
        }
        return rawMavenEntry.map(rawMaven -> new CacheResult<RawMaven>(CacheResult.State.Cached, (RawMaven)rawMaven)).orElse(this.UNAVAILABLE_POM);
    }

    @Override
    public CacheResult<MavenRepository> computeRepository(MavenRepository repository, Callable<MavenRepository> orElseGet) throws Exception {
        byte[] key = RocksdbMavenPomCache.serialize(repository);
        Optional<MavenRepository> cacheEntry = RocksdbMavenPomCache.deserializeMavenRepository(this.cache.get(key));
        if (cacheEntry == null) {
            try {
                MavenRepository mavenRepository2 = orElseGet.call();
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.ofNullable(mavenRepository2)));
                return new CacheResult<MavenRepository>(CacheResult.State.Updated, mavenRepository2);
            }
            catch (Exception e) {
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.empty()));
                throw e;
            }
        }
        return cacheEntry.map(mavenRepository -> new CacheResult<MavenRepository>(CacheResult.State.Cached, (MavenRepository)mavenRepository)).orElse(this.UNAVAILABLE_REPOSITORY);
    }

    private void fillUnresolvablePoms() {
        new BufferedReader(new InputStreamReader(MavenPomDownloader.class.getResourceAsStream("/unresolvable.txt"), StandardCharsets.UTF_8)).lines().filter(line -> !line.isEmpty()).forEach(this.unresolvablePoms::add);
    }

    static <T> byte[] serialize(T object) {
        if (object == null) {
            return null;
        }
        try {
            return mapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize object to byte array.");
        }
    }

    static Optional<MavenRepository> deserializeMavenRepository(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (Optional)mapper.readValue(bytes, (TypeReference)new TypeReference<Optional<MavenRepository>>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    static Optional<RawMaven> deserializeRawMaven(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (Optional)mapper.readValue(bytes, (TypeReference)new TypeReference<Optional<RawMaven>>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    static Optional<MavenMetadata> deserializeMavenMetadata(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (Optional)mapper.readValue(bytes, (TypeReference)new TypeReference<Optional<MavenMetadata>>(){});
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        cacheMap = new HashMap<String, RocksCache>();
        SmileFactory f = new SmileFactory();
        f.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        ObjectMapper m = new ObjectMapper((JsonFactory)f).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY));
        RocksDB.loadLibrary();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> cacheMap.values().forEach(rec$ -> ((RocksCache)rec$).close())));
    }

    static class RocksCache {
        private final RocksDB database;
        private final Options options;
        private final WriteOptions writeOptions;

        RocksCache(String pomCacheDir) {
            try {
                this.options = new Options();
                this.options.setCreateIfMissing(true);
                this.options.setWriteBufferSize(1000000L);
                this.options.setParanoidChecks(false);
                this.options.setParanoidFileChecks(false);
                this.writeOptions = new WriteOptions();
                this.writeOptions.setDisableWAL(true);
                this.database = RocksDB.open((Options)this.options, (String)pomCacheDir);
            }
            catch (RocksDBException exception) {
                throw new IllegalStateException("Unable to create cache database." + exception.getMessage(), exception);
            }
            try {
                this.cleanCacheIfCorrupt(pomCacheDir);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to clear corrupt maven pom cache.", ex);
            }
        }

        private void cleanCacheIfCorrupt(String pomCacheDir) throws IOException {
            try {
                this.database.verifyChecksum();
            }
            catch (RocksDBException ex) {
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(Paths.get(pomCacheDir, new String[0]), "*");){
                    paths.forEach(path -> {
                        try {
                            Files.delete(path);
                        }
                        catch (IOException ioException) {
                            throw new IllegalStateException("Unable to delete maven pom cache at " + path, ioException);
                        }
                    });
                }
            }
        }

        private void put(byte[] key, byte[] value) throws RocksDBException {
            this.database.put(this.writeOptions, key, value);
        }

        private byte[] get(byte[] key) throws RocksDBException {
            return this.database.get(key);
        }

        private void close() {
            this.database.close();
            this.writeOptions.close();
            this.options.close();
        }
    }
}

