/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.tree.Xml;

public final class RemoveProperty
extends Recipe {
    @Option(displayName="Property name", description="Key name of the property to remove.", example="junit.version")
    private final String propertyName;

    public String getDisplayName() {
        return "Remove Maven project property";
    }

    public String getDescription() {
        return "Removes the specified Maven project property from the pom.xml.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new RemovePropertyVisitor();
    }

    public RemoveProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @NonNull
    public String toString() {
        return "RemoveProperty(propertyName=" + this.getPropertyName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveProperty)) {
            return false;
        }
        RemoveProperty other = (RemoveProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        return !(this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        return result;
    }

    private class RemovePropertyVisitor
    extends MavenVisitor {
        private RemovePropertyVisitor() {
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isPropertyTag() && RemoveProperty.this.propertyName.equals(tag.getName())) {
                return null;
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }
}

