/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.xml.tree.Xml;

class MavenTagInsertionComparator
implements Comparator<Xml.Tag> {
    private static final List<String> canonicalOrdering = Arrays.asList("modelVersion", "parent", "groupId", "artifactId", "version", "packaging", "name", "description", "url", "inceptionYear", "organization", "licenses", "developers", "contributors", "mailingLists", "prerequisites", "modules", "scm", "issueManagement", "ciManagement", "distributionManagement", "properties", "dependencyManagement", "dependencies", "repositories", "pluginRepositories", "build", "reports", "reporting", "profiles");
    private final Map<Xml.Tag, Integer> existingIndices = new IdentityHashMap<Xml.Tag, Integer>();

    MavenTagInsertionComparator(List<Xml.Tag> existingTags) {
        for (int i = 0; i < existingTags.size(); ++i) {
            this.existingIndices.put(existingTags.get(i), i);
        }
    }

    @Override
    public int compare(Xml.Tag t1, Xml.Tag t2) {
        int i1 = this.existingIndices.getOrDefault(t1, -1);
        int i2 = this.existingIndices.getOrDefault(t2, -1);
        if (i1 == -1) {
            if (i2 == -1) {
                return canonicalOrdering.indexOf(t1.getName()) - canonicalOrdering.indexOf(t2.getName());
            }
            for (int i = 0; i < canonicalOrdering.indexOf(t2.getName()); ++i) {
                if (!canonicalOrdering.get(i).equals(t1.getName())) continue;
                return -1;
            }
            return 1;
        }
        if (i2 == -1) {
            for (int i = 0; i < canonicalOrdering.indexOf(t1.getName()); ++i) {
                if (!canonicalOrdering.get(i).equals(t2.getName())) continue;
                return 1;
            }
            return -1;
        }
        return i1 - i2;
    }
}

