/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.marker.DotResult;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;

public class PrintMavenAsDot
extends Recipe {
    public String getDisplayName() {
        return "Print Maven dependency hierarchy in DOT format";
    }

    public String getDescription() {
        return "The DOT language format is specified [here](https://graphviz.org/doc/info/lang.html).";
    }

    protected MavenVisitor<ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                MavenResolutionResult mrr = this.getResolutionResult();
                if (!document.getMarkers().findFirst(DotResult.class).isPresent()) {
                    return document.withMarkers(document.getMarkers().add((Marker)new DotResult(Tree.randomId(), this.dot(mrr))));
                }
                return super.visitDocument(document, ctx);
            }

            private String dot(MavenResolutionResult mrr) {
                StringBuilder dot = new StringBuilder("digraph main {\n");
                HashMap<ResolvedGroupArtifactVersion, Integer> index = new HashMap<ResolvedGroupArtifactVersion, Integer>();
                ResolvedGroupArtifactVersion root = new ResolvedGroupArtifactVersion(null, mrr.getPom().getGroupId(), mrr.getPom().getArtifactId(), mrr.getPom().getVersion(), null);
                this.dotLabel(dot, 0, root);
                index.put(root, 0);
                for (List<ResolvedDependency> deps : mrr.getDependencies().values()) {
                    for (ResolvedDependency dep2 : deps) {
                        if (index.containsKey(dep2.getGav())) continue;
                        this.dotLabel(dot, index.size(), dep2.getGav());
                        index.put(dep2.getGav(), index.size());
                    }
                }
                Set seen = Collections.newSetFromMap(new IdentityHashMap());
                for (Scope scope : Scope.values()) {
                    if (scope.ordinal() < Scope.Compile.ordinal() || scope.ordinal() > Scope.Test.ordinal()) continue;
                    this.dotEdges(dot, root, scope, mrr.getDependencies().get((Object)scope).stream().filter(dep -> dep.getDepth() == 0 && seen.add(dep.getGav())).collect(Collectors.toList()), index);
                }
                dot.append("}");
                return dot.toString();
            }

            private void dotLabel(StringBuilder dot, int index, ResolvedGroupArtifactVersion gav) {
                dot.append(index).append(" [label=\"").append(gav.getGroupId()).append(":").append(gav.getArtifactId()).append(":").append(gav.getVersion()).append("\"];\n");
            }

            private void dotEdges(StringBuilder dot, ResolvedGroupArtifactVersion head, Scope scope, List<ResolvedDependency> resolvedDependencies, Map<ResolvedGroupArtifactVersion, Integer> index) {
                int headIndex = index.get(head);
                for (ResolvedDependency dep : resolvedDependencies) {
                    dot.append(headIndex).append(" -> ").append(index.get(dep.getGav())).append(" [taillabel=\"").append((Object)scope).append("\"];\n");
                    this.dotEdges(dot, dep.getGav(), scope, dep.getDependencies(), index);
                }
            }
        };
    }
}

