/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class RenamePropertyKey
extends Recipe {
    @Option(displayName="Old key", description="The old name of the property key to be replaced.", example="junit.version")
    private final String oldKey;
    @Option(displayName="New key", description="The new property name to use.", example="version.org.junit")
    private final String newKey;

    public String getDisplayName() {
        return "Rename Maven property key";
    }

    public String getDescription() {
        return "Rename the specified Maven project property key leaving the value unchanged.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext executionContext) {
                return (Xml)SearchResult.found((Tree)document);
            }
        };
    }

    public TreeVisitor<Xml, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            final String oldKeyAsProperty;
            final String newKeyAsProperty;
            {
                this.oldKeyAsProperty = "${" + RenamePropertyKey.this.oldKey + "}";
                this.newKeyAsProperty = "${" + RenamePropertyKey.this.newKey + "}";
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional value;
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isPropertyTag() && RenamePropertyKey.this.oldKey.equals(t.getName())) {
                    t = t.withName(RenamePropertyKey.this.newKey);
                }
                if (t.getChildren().isEmpty() && (value = t.getValue()).isPresent() && ((String)value.get()).contains(this.oldKeyAsProperty)) {
                    String newValue = ((String)value.get()).replace(this.oldKeyAsProperty, this.newKeyAsProperty);
                    this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(t, newValue));
                }
                return t;
            }
        };
    }

    public RenamePropertyKey(String oldKey, String newKey) {
        this.oldKey = oldKey;
        this.newKey = newKey;
    }

    public String getOldKey() {
        return this.oldKey;
    }

    public String getNewKey() {
        return this.newKey;
    }

    @NonNull
    public String toString() {
        return "RenamePropertyKey(oldKey=" + this.getOldKey() + ", newKey=" + this.getNewKey() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenamePropertyKey)) {
            return false;
        }
        RenamePropertyKey other = (RenamePropertyKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldKey = this.getOldKey();
        String other$oldKey = other.getOldKey();
        if (this$oldKey == null ? other$oldKey != null : !this$oldKey.equals(other$oldKey)) {
            return false;
        }
        String this$newKey = this.getNewKey();
        String other$newKey = other.getNewKey();
        return !(this$newKey == null ? other$newKey != null : !this$newKey.equals(other$newKey));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RenamePropertyKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldKey = this.getOldKey();
        result = result * 59 + ($oldKey == null ? 43 : $oldKey.hashCode());
        String $newKey = this.getNewKey();
        result = result * 59 + ($newKey == null ? 43 : $newKey.hashCode());
        return result;
    }
}

