/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.io.IOException;
import java.util.Optional;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.openrewrite.maven.internal.JacksonMapdbSerializer;

public class OptionalJacksonMapdbSerializer<T>
implements Serializer<Optional<T>> {
    private final JacksonMapdbSerializer<T> jacksonMapdbSerializer;

    public OptionalJacksonMapdbSerializer(Class<T> tClass) {
        this.jacksonMapdbSerializer = new JacksonMapdbSerializer<T>(tClass);
    }

    public void serialize(DataOutput2 out, Optional<T> value) throws IOException {
        if (value.isPresent()) {
            out.writeBoolean(true);
            this.jacksonMapdbSerializer.serialize(out, value.get());
        } else {
            out.writeBoolean(false);
        }
    }

    public Optional<T> deserialize(DataInput2 input, int available) throws IOException {
        boolean present = input.readBoolean();
        return present ? Optional.of(this.jacksonMapdbSerializer.deserialize(input, available)) : Optional.empty();
    }
}

