/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangePropertyValue
extends Recipe {
    @Option(displayName="Key", description="Property key to change.")
    private final String key;
    @Option(displayName="Value", description="Value to apply to the matching property.")
    private final String newValue;

    public String getDisplayName() {
        return "Change a Maven project property value.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangePropertyValueVisitor();
    }

    public ChangePropertyValue(String key, String newValue) {
        if (key != null) {
            key = key.replace("${", "").replace("}", "");
        }
        this.key = key;
        this.newValue = newValue;
    }

    public String getKey() {
        return this.key;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @NonNull
    public String toString() {
        return "ChangePropertyValue(key=" + this.getKey() + ", newValue=" + this.getNewValue() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyValue)) {
            return false;
        }
        ChangePropertyValue other = (ChangePropertyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        return result;
    }

    private class ChangePropertyValueVisitor
    extends MavenVisitor {
        private ChangePropertyValueVisitor() {
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isPropertyTag() && ChangePropertyValue.this.key.equals(tag.getName()) && !ChangePropertyValue.this.newValue.equals(tag.getValue().orElse(null))) {
                this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, ChangePropertyValue.this.newValue));
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }
}

