/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.RecipeSearchResult;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class FindProperties
extends Recipe {
    @Option(displayName="Property pattern", description="Regular expression pattern used to match property tag names.")
    private final String propertyPattern;

    public String getDisplayName() {
        return "Find Maven project properties";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern propertyMatcher = Pattern.compile(this.propertyPattern.replace(".", "\\.").replace("*", ".*"));
        return new MavenVisitor(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext context) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)context);
                if (this.isPropertyTag() && propertyMatcher.matcher(tag.getName()).matches()) {
                    t = (Xml.Tag)t.withMarker(new Marker[]{new RecipeSearchResult((Recipe)FindProperties.this)});
                }
                Optional value = tag.getValue();
                if (t.getContent() != null && value.isPresent() && ((String)value.get()).contains("${")) {
                    t = t.withContent(ListUtils.mapFirst((List)t.getContent(), v -> (Content)v.withMarker(new Marker[]{new RecipeSearchResult((Recipe)FindProperties.this, this.model.getValue((String)value.get()))})));
                }
                return t;
            }
        };
    }

    public FindProperties(String propertyPattern) {
        this.propertyPattern = propertyPattern;
    }

    public String getPropertyPattern() {
        return this.propertyPattern;
    }

    @NonNull
    public String toString() {
        return "FindProperties(propertyPattern=" + this.getPropertyPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindProperties)) {
            return false;
        }
        FindProperties other = (FindProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$propertyPattern = this.getPropertyPattern();
        String other$propertyPattern = other.getPropertyPattern();
        return !(this$propertyPattern == null ? other$propertyPattern != null : !this$propertyPattern.equals(other$propertyPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $propertyPattern = this.getPropertyPattern();
        result = result * 59 + ($propertyPattern == null ? 43 : $propertyPattern.hashCode());
        return result;
    }
}

