/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.GroupArtifactRepository;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenRepository;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class RocksdbMavenPomCache
implements MavenPomCache {
    static ObjectMapper mapper;
    private static final Map<String, RocksDB> cacheMap;
    private final RocksDB cache;
    private final Set<String> unresolvablePoms = new HashSet<String>();
    CacheResult<RawMaven> UNAVAILABLE_POM = new CacheResult<Object>(CacheResult.State.Unavailable, null);
    CacheResult<MavenMetadata> UNAVAILABLE_METADATA = new CacheResult<Object>(CacheResult.State.Unavailable, null);
    CacheResult<MavenRepository> UNAVAILABLE_REPOSITORY = new CacheResult<Object>(CacheResult.State.Unavailable, null);

    static synchronized RocksDB getCache(String workspace) {
        return cacheMap.computeIfAbsent(workspace, k -> {
            Options options = new Options();
            options.setCreateIfMissing(true);
            try {
                return RocksDB.open((Options)options, (String)k);
            }
            catch (RocksDBException exception) {
                throw new IllegalStateException("Unable to create cache database." + exception.getMessage());
            }
        });
    }

    public RocksdbMavenPomCache(@Nullable File workspace) {
        assert (workspace != null);
        if (!workspace.exists() && !workspace.mkdirs()) {
            throw new IllegalStateException("Unable to find or create maven pom cache at " + workspace);
        }
        if (!workspace.isDirectory()) {
            throw new IllegalStateException("The maven cache workspace must be a directory");
        }
        this.cache = RocksdbMavenPomCache.getCache(workspace.getAbsolutePath());
        this.fillUnresolvablePoms();
    }

    @Override
    public CacheResult<MavenMetadata> computeMavenMetadata(URI repo, String groupId, String artifactId, Callable<MavenMetadata> orElseGet) throws Exception {
        byte[] key = RocksdbMavenPomCache.serialize(new GroupArtifactRepository(repo, new GroupArtifact(groupId, artifactId)));
        Optional<MavenMetadata> rawMavenMetadata = RocksdbMavenPomCache.deserializeMavenMetadata(this.cache.get(key));
        if (rawMavenMetadata == null) {
            try {
                MavenMetadata metadata2 = orElseGet.call();
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.ofNullable(metadata2)));
                return new CacheResult<MavenMetadata>(CacheResult.State.Updated, metadata2);
            }
            catch (Exception e) {
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.empty()));
                throw e;
            }
        }
        return rawMavenMetadata.map(metadata -> new CacheResult<MavenMetadata>(CacheResult.State.Cached, (MavenMetadata)metadata)).orElse(this.UNAVAILABLE_METADATA);
    }

    @Override
    public CacheResult<RawMaven> computeMaven(URI repo, String groupId, String artifactId, String version, Callable<RawMaven> orElseGet) throws Exception {
        String artifactCoordinates = groupId + ':' + artifactId + ':' + version;
        if (this.unresolvablePoms.contains(artifactCoordinates)) {
            return this.UNAVAILABLE_POM;
        }
        byte[] key = RocksdbMavenPomCache.serialize(repo.toString() + ":" + artifactCoordinates);
        Optional<RawMaven> rawMavenEntry = RocksdbMavenPomCache.deserializeRawMaven(this.cache.get(key));
        if (rawMavenEntry == null) {
            try {
                RawMaven rawMaven2 = orElseGet.call();
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.ofNullable(rawMaven2)));
                return new CacheResult<RawMaven>(CacheResult.State.Updated, rawMaven2);
            }
            catch (Exception e) {
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.empty()));
                throw e;
            }
        }
        return rawMavenEntry.map(rawMaven -> new CacheResult<RawMaven>(CacheResult.State.Cached, (RawMaven)rawMaven)).orElse(this.UNAVAILABLE_POM);
    }

    @Override
    public CacheResult<MavenRepository> computeRepository(MavenRepository repository, Callable<MavenRepository> orElseGet) throws Exception {
        byte[] key = RocksdbMavenPomCache.serialize(repository);
        Optional<MavenRepository> cacheEntry = RocksdbMavenPomCache.deserializeMavenRepository(this.cache.get(key));
        if (cacheEntry == null) {
            try {
                MavenRepository mavenRepository2 = orElseGet.call();
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.ofNullable(mavenRepository2)));
                return new CacheResult<MavenRepository>(CacheResult.State.Updated, mavenRepository2);
            }
            catch (Exception e) {
                this.cache.put(key, RocksdbMavenPomCache.serialize(Optional.empty()));
                throw e;
            }
        }
        return cacheEntry.map(mavenRepository -> new CacheResult<MavenRepository>(CacheResult.State.Cached, (MavenRepository)mavenRepository)).orElse(this.UNAVAILABLE_REPOSITORY);
    }

    @Override
    public void close() {
        this.cache.close();
    }

    private void fillUnresolvablePoms() {
        new BufferedReader(new InputStreamReader(MavenPomDownloader.class.getResourceAsStream("/unresolvable.txt"), StandardCharsets.UTF_8)).lines().filter(line -> !line.isEmpty()).forEach(this.unresolvablePoms::add);
    }

    static <T> byte[] serialize(T object) {
        if (object == null) {
            return null;
        }
        try {
            return mapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize object to byte array.");
        }
    }

    static Optional<MavenRepository> deserializeMavenRepository(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (Optional)mapper.readValue(bytes, (TypeReference)new TypeReference<Optional<MavenRepository>>(){});
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to deserialize object to byte array.");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IO exception while deserializing object to byte array.");
        }
    }

    static Optional<RawMaven> deserializeRawMaven(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (Optional)mapper.readValue(bytes, (TypeReference)new TypeReference<Optional<RawMaven>>(){});
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to deserialize object to byte array.");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IO exception while deserializing object to byte array.");
        }
    }

    static Optional<MavenMetadata> deserializeMavenMetadata(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (Optional)mapper.readValue(bytes, (TypeReference)new TypeReference<Optional<MavenMetadata>>(){});
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to deserialize object to byte array.");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IO exception while deserializing object to byte array.");
        }
    }

    static {
        SmileFactory f = new SmileFactory();
        f.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        ObjectMapper m = new ObjectMapper((JsonFactory)f).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper = m.setVisibility(m.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY));
        RocksDB.loadLibrary();
        cacheMap = new HashMap<String, RocksDB>();
    }
}

