/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import org.openrewrite.Formatting;
import org.openrewrite.SourceVisitor;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.MavenSourceVisitor;
import org.openrewrite.maven.tree.Modules;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.XmlSourceVisitor;
import org.openrewrite.xml.tree.Xml;

public class Maven
extends Xml.Document {
    private final transient Pom model;
    private final transient Collection<Pom> modules;

    public Maven(Xml.Document document) {
        super(document.getId(), document.getSourcePath(), document.getProlog(), document.getRoot(), document.getFormatting(), document.getMarkers());
        this.model = document.getMarkers().findFirst(Pom.class).orElse(null);
        assert (this.model != null);
        this.modules = document.getMarkers().findFirst(Modules.class).map(Modules::getModules).orElse(Collections.emptyList());
    }

    @JsonIgnore
    public Pom getModel() {
        return this.model;
    }

    @JsonIgnore
    public Collection<Pom> getModules() {
        return this.modules;
    }

    public <R> R accept(SourceVisitor<R> v) {
        if (v instanceof MavenSourceVisitor) {
            return ((MavenSourceVisitor)v).visitMaven(this);
        }
        if (v instanceof XmlSourceVisitor) {
            return (R)super.accept(v);
        }
        return (R)v.defaultTo(null);
    }

    public Maven withRoot(Xml.Tag root) {
        Xml.Document m = super.withRoot(root);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withMarkers(Markers markers) {
        Xml.Document m = super.withMarkers(markers);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withFormatting(Formatting formatting) {
        Xml.Document m = super.withFormatting(formatting);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withProlog(Xml.Prolog prolog) {
        Xml.Document m = super.withProlog(prolog);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withModel(Pom model) {
        return this.withMarkers(this.getMarkers().addOrUpdate((Marker)model));
    }
}

