/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangeDependencyVersion;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.cache.NoopCache;
import org.openrewrite.maven.internal.MavenDownloader;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.tree.DependencyManagementDependency;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public class UpgradeDependencyVersion
extends MavenRefactorVisitor {
    @Nullable
    private Collection<String> availableVersions;
    private String groupId;
    @Nullable
    private String artifactId;
    private String toVersion;
    @Nullable
    private String metadataPattern;
    private VersionComparator versionComparator;

    public UpgradeDependencyVersion() {
        this.setCursoringOn();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(@Nullable String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public void setMetadataPattern(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"toVersion", (Object)this.toVersion)).and(Semver.validate((String)this.toVersion, (String)this.metadataPattern));
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public Maven visitMaven(Maven maven) {
        this.versionComparator = (VersionComparator)Semver.validate((String)this.toVersion, (String)this.metadataPattern).getValue();
        this.maybeChangeDependencyVersion(maven.getModel());
        for (Pom module : maven.getModules()) {
            this.maybeChangeDependencyVersion(module);
        }
        return super.visitMaven(maven);
    }

    private void maybeChangeDependencyVersion(Pom model) {
        for (Pom.Dependency dependency : model.getDependencies()) {
            if (!dependency.getGroupId().equals(this.groupId) || this.artifactId != null && !dependency.getArtifactId().equals(this.artifactId)) continue;
            this.findNewerDependencyVersion(this.groupId, dependency.getArtifactId(), dependency.getVersion()).ifPresent(newer -> {
                ChangeDependencyVersion changeDependencyVersion = new ChangeDependencyVersion();
                changeDependencyVersion.setGroupId(this.groupId);
                changeDependencyVersion.setArtifactId(dependency.getArtifactId());
                changeDependencyVersion.setToVersion((String)newer);
                this.andThen((RefactorVisitor)changeDependencyVersion);
            });
        }
        for (DependencyManagementDependency dependencyManagementDependency : model.getDependencyManagement().getDependencies()) {
            if (!dependencyManagementDependency.getGroupId().equals(this.groupId) || this.artifactId != null && !dependencyManagementDependency.getArtifactId().equals(this.artifactId)) continue;
            this.findNewerDependencyVersion(this.groupId, dependencyManagementDependency.getArtifactId(), dependencyManagementDependency.getVersion()).ifPresent(newer -> {
                ChangeDependencyVersion changeDependencyVersion = new ChangeDependencyVersion();
                changeDependencyVersion.setGroupId(this.groupId);
                changeDependencyVersion.setArtifactId(dependencyManagementDependency.getArtifactId());
                changeDependencyVersion.setToVersion((String)newer);
                this.andThen((RefactorVisitor)changeDependencyVersion);
            });
        }
    }

    private Optional<String> findNewerDependencyVersion(String groupId, String artifactId, String currentVersion) {
        if (this.availableVersions == null) {
            MavenMetadata mavenMetadata = new MavenDownloader(new NoopCache()).downloadMetadata(groupId, artifactId, Collections.emptyList());
            this.availableVersions = mavenMetadata.getVersioning().getVersions().stream().filter(arg_0 -> ((VersionComparator)this.versionComparator).isValid(arg_0)).collect(Collectors.toList());
        }
        LatestRelease latestRelease = new LatestRelease(this.metadataPattern);
        return this.availableVersions.stream().filter(v -> latestRelease.compare(currentVersion, v) < 0).max((Comparator<String>)this.versionComparator);
    }
}

