/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.cache.InMemoryCache;
import org.openrewrite.maven.cache.MavenCache;
import org.openrewrite.maven.internal.MavenDownloader;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.internal.RawMavenResolver;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Modules;
import org.openrewrite.maven.tree.Pom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenParser
implements Parser<Maven> {
    private static final Logger logger = LoggerFactory.getLogger(MavenParser.class);
    private final MavenCache mavenCache;
    private final Collection<String> activeProfiles;
    private final MavenSettings mavenSettings;
    private final boolean resolveOptional;

    private MavenParser(MavenCache mavenCache, Collection<String> activeProfiles, MavenSettings mavenSettings, boolean resolveOptional) {
        this.mavenCache = mavenCache;
        this.activeProfiles = activeProfiles;
        this.mavenSettings = mavenSettings;
        this.resolveOptional = resolveOptional;
    }

    public List<Maven> parseInputs(Iterable<Parser.Input> sources, @Nullable URI relativeTo) {
        Collection projectPoms = StreamSupport.stream(sources.spliterator(), false).map(source -> RawMaven.parse(source, relativeTo, null)).collect(Collectors.toList());
        MavenDownloader downloader = new MavenDownloader(this.mavenCache, projectPoms.stream().collect(Collectors.toMap(RawMaven::getSourcePath, Function.identity())));
        List parsed = projectPoms.stream().map(raw -> new RawMavenResolver(downloader, false, this.activeProfiles, this.mavenSettings, this.resolveOptional).resolve((RawMaven)raw)).filter(Objects::nonNull).map(Maven::new).collect(Collectors.toCollection(ArrayList::new));
        for (int i = 0; i < parsed.size(); ++i) {
            Maven maven = (Maven)((Object)parsed.get(i));
            ArrayList<Pom> modules = new ArrayList<Pom>(0);
            for (Maven possibleModule : parsed) {
                Pom parent = possibleModule.getModel().getParent();
                if (parent == null || !parent.getGroupId().equals(maven.getModel().getGroupId()) || !parent.getArtifactId().equals(maven.getModel().getArtifactId()) || !parent.getVersion().equals(maven.getModel().getVersion())) continue;
                modules.add(possibleModule.getModel());
            }
            if (modules.isEmpty()) continue;
            parsed.set(i, maven.withMarkers(maven.getMarkers().addOrUpdate((Marker)new Modules(modules))));
        }
        return parsed;
    }

    public static List<Maven> parseProject(Path path) {
        try {
            List poms = Files.find(path, Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.endsWith("pom.xml"), new FileVisitOption[0]).collect(Collectors.toList());
            if (logger.isInfoEnabled()) {
                for (Path pom : poms) {
                    logger.info("Parsing {}", (Object)pom);
                }
            }
            return MavenParser.builder().mavenConfig(path.resolve(".mvn/maven.config")).build().parse(poms, path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean accept(URI path) {
        return path.toString().equals("pom.xml") || path.toString().endsWith(".pom");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MavenCache mavenCache = new InMemoryCache();
        private final Collection<String> activeProfiles = new HashSet<String>();
        private boolean resolveOptional = true;
        @Nullable
        private MavenSettings mavenSettings;

        public Builder resolveOptional(@Nullable Boolean optional) {
            this.resolveOptional = optional == null || optional != false;
            return this;
        }

        public Builder activeProfiles(String ... profiles) {
            if (profiles != null) {
                Collections.addAll(this.activeProfiles, profiles);
            }
            return this;
        }

        public Builder mavenConfig(@Nullable Path mavenConfig) {
            if (mavenConfig != null && mavenConfig.toFile().exists()) {
                try {
                    String mavenConfigText = new String(Files.readAllBytes(mavenConfig));
                    Matcher matcher = Pattern.compile("(?:$|\\s)-P\\s+([^\\s]+)").matcher(mavenConfigText);
                    if (matcher.find()) {
                        String[] profiles = matcher.group(1).split(",");
                        return this.activeProfiles(profiles);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return this;
        }

        public Builder mavenSettings(Parser.Input source) {
            this.mavenSettings = MavenSettings.parse(source);
            return this;
        }

        public Builder cache(MavenCache cache) {
            this.mavenCache = cache;
            return this;
        }

        public MavenParser build() {
            return new MavenParser(this.mavenCache, this.activeProfiles, this.mavenSettings, this.resolveOptional);
        }
    }
}

