/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.Optional;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.AddToTag;
import org.openrewrite.xml.tree.Xml;

public class ExcludeDependency
extends MavenRefactorVisitor {
    private String groupId;
    private String artifactId;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId));
    }

    public ExcludeDependency() {
        this.setCursoringOn();
    }

    public Xml visitTag(Xml.Tag tag) {
        Pom.Dependency dependency;
        if (this.isDependencyTag() && (dependency = this.findDependency(tag)) != null && !dependency.findDependencies(this.groupId, this.artifactId).isEmpty()) {
            Optional maybeExclusions = tag.getChild("exclusions");
            if (maybeExclusions.isPresent()) {
                Xml.Tag exclusions = (Xml.Tag)maybeExclusions.get();
                List individualExclusions = exclusions.getChildren("exclusion");
                if (individualExclusions.stream().noneMatch(exclusion -> this.groupId.equals(exclusion.getChildValue("groupId").orElse(null)) && this.artifactId.equals(exclusion.getChildValue("artifactId").orElse(null)))) {
                    this.andThen((RefactorVisitor)new AddToTag.Scoped(exclusions, Xml.Tag.build((String)("<exclusion>\n<groupId>" + this.groupId + "</groupId>\n<artifactId>" + this.artifactId + "</artifactId>\n</exclusion>"))));
                }
            } else {
                this.andThen((RefactorVisitor)new AddToTag.Scoped(tag, Xml.Tag.build((String)"<exclusions/>")));
            }
        }
        return super.visitTag(tag);
    }
}

