/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenDownloader;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.internal.RequestedVersion;
import org.openrewrite.maven.tree.DependencyDescriptor;
import org.openrewrite.maven.tree.DependencyManagementDependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Xml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMavenResolver {
    private static final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}", null);
    private static final Logger logger = LoggerFactory.getLogger(RawMavenResolver.class);
    private final NavigableMap<Scope, Map<GroupArtifact, RequestedVersion>> versionSelection;
    private final Queue<ResolutionTask> workQueue = new LinkedList<ResolutionTask>();
    private final Map<PartialTreeKey, Optional<Pom>> resolved = new HashMap<PartialTreeKey, Optional<Pom>>();
    private final Map<ResolutionTask, PartialMaven> partialResults = new HashMap<ResolutionTask, PartialMaven>();
    private final MavenDownloader downloader;
    private final boolean forParent;
    private final boolean resolveOptional;

    public RawMavenResolver(MavenDownloader downloader, boolean forParent, boolean resolveOptional) {
        this.versionSelection = new TreeMap<Scope, Map<GroupArtifact, RequestedVersion>>();
        for (Scope scope : Scope.values()) {
            this.versionSelection.putIfAbsent(scope, new HashMap());
        }
        this.downloader = downloader;
        this.forParent = forParent;
        this.resolveOptional = resolveOptional;
    }

    @Nullable
    public Xml.Document resolve(RawMaven rawMaven) {
        Pom pom = this.resolve(rawMaven, Scope.None, rawMaven.getPom().getVersion(), Collections.emptyList());
        assert (pom != null);
        return rawMaven.getDocument().withMetadata(Collections.singletonList(pom));
    }

    @Nullable
    public Pom resolve(RawMaven rawMaven, Scope scope, @Nullable String requestedVersion, List<RawPom.Repository> repositories) {
        ResolutionTask rootTask = new ResolutionTask(scope, rawMaven, Collections.emptySet(), false, null, requestedVersion, repositories);
        this.workQueue.add(rootTask);
        while (!this.workQueue.isEmpty()) {
            this.processTask(this.workQueue.poll());
        }
        return this.assembleResults(rootTask, new Stack<ResolutionTask>());
    }

    private void processTask(ResolutionTask task) {
        RawMaven rawMaven = task.getRawMaven();
        if (this.partialResults.containsKey(task)) {
            return;
        }
        PartialMaven partialMaven = new PartialMaven(rawMaven.getDocument().getSourcePath(), rawMaven.getPom());
        this.processProperties(task, partialMaven);
        this.processRepositories(task, partialMaven);
        this.processParent(task, partialMaven);
        this.processDependencyManagement(task, partialMaven);
        this.processLicenses(task, partialMaven);
        this.processDependencies(task, partialMaven);
        this.partialResults.put(task, partialMaven);
    }

    private void processProperties(ResolutionTask task, PartialMaven partialMaven) {
        partialMaven.setProperties(task.getRawMaven().getActiveProperties());
    }

    private void processDependencyManagement(ResolutionTask task, PartialMaven partialMaven) {
        RawPom pom = task.getRawMaven().getPom();
        ArrayList<DependencyManagementDependency> managedDependencies = new ArrayList<DependencyManagementDependency>();
        RawPom.DependencyManagement dependencyManagement = pom.getDependencyManagement();
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            for (RawPom.Dependency d : dependencyManagement.getDependencies().getDependencies()) {
                assert (d.getVersion() != null);
                String groupId = partialMaven.getGroupId(d.getGroupId());
                String artifactId = partialMaven.getArtifactId(d.getArtifactId());
                String version = partialMaven.getVersion(d.getVersion());
                if (groupId == null || artifactId == null || version == null) {
                    assert (groupId != null);
                    assert (artifactId != null);
                    assert (version != null);
                }
                if (Objects.equals(d.getType(), "pom") && Objects.equals(d.getScope(), "import")) {
                    Pom maven;
                    RawMaven rawMaven = this.downloader.download(groupId, artifactId, version, null, null, null, partialMaven.getRepositories());
                    if (rawMaven == null || (maven = new RawMavenResolver(this.downloader, true, this.resolveOptional).resolve(rawMaven, Scope.Compile, d.getVersion(), partialMaven.getRepositories())) == null) continue;
                    managedDependencies.add(new DependencyManagementDependency.Imported(groupId, artifactId, version, d.getVersion(), maven));
                    continue;
                }
                managedDependencies.add(new DependencyManagementDependency.Defined(groupId, artifactId, version, d.getVersion(), d.getScope() == null ? null : Scope.fromName(d.getScope()), d.getClassifier(), d.getExclusions()));
            }
        }
        partialMaven.setDependencyManagement(new Pom.DependencyManagement(managedDependencies));
    }

    private void processDependencies(ResolutionTask task, PartialMaven partialMaven) {
        RawMaven rawMaven = task.getRawMaven();
        if (partialMaven.getParent() != null) {
            for (Pom.Dependency dependency : partialMaven.getParent().getDependencies()) {
                RequestedVersion requestedVersion = this.selectVersion(dependency.getScope(), dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
                ((Map)this.versionSelection.get((Object)dependency.getScope())).put(new GroupArtifact(dependency.getGroupId(), dependency.getArtifactId()), requestedVersion);
            }
        }
        partialMaven.setDependencyTasks(rawMaven.getActiveDependencies().stream().filter(dep -> dep.getType() == null || dep.getType().equals("jar")).filter(dep -> this.resolveOptional || dep.getOptional() == null || dep.getOptional() == false).map(dep -> {
            Scope requestedScope;
            Scope effectiveScope;
            String depVersion;
            String last;
            String groupId = partialMaven.getGroupId(dep.getGroupId());
            String artifactId = partialMaven.getArtifactId(dep.getArtifactId());
            if (groupId == null || artifactId == null) {
                assert (groupId != null);
                assert (artifactId != null);
            }
            for (GroupArtifact e : task.getExclusions()) {
                if (!dep.getGroupId().matches(e.getGroupId()) || !dep.getArtifactId().matches(e.getArtifactId())) continue;
                return null;
            }
            String version = null;
            int i = 0;
            do {
                Object partialMavenVersion;
                last = version;
                String result = null;
                if (last != null && (partialMavenVersion = partialMaven.getVersion(last)) != null) {
                    result = partialMavenVersion;
                }
                if (result == null) {
                    partialMavenVersion = partialMaven.getDependencyManagement().getDependencies().iterator();
                    block2: while (partialMavenVersion.hasNext()) {
                        DependencyManagementDependency managed = (DependencyManagementDependency)partialMavenVersion.next();
                        for (DependencyDescriptor dependencyDescriptor : managed.getDependencies()) {
                            if (!groupId.equals(partialMaven.getGroupId(dependencyDescriptor.getGroupId())) || !artifactId.equals(partialMaven.getArtifactId(dependencyDescriptor.getArtifactId()))) continue;
                            result = dependencyDescriptor.getVersion();
                            break block2;
                        }
                    }
                    if (result == null && partialMaven.getParent() != null) {
                        result = partialMaven.getParent().getManagedVersion(groupId, artifactId);
                    }
                }
                version = result;
            } while (i++ < 2 || !Objects.equals(version, last));
            if (version == null && (depVersion = dep.getVersion()) != null) {
                version = partialMaven.getVersion(depVersion);
            }
            if (version == null) {
                logger.error("Failed to determine version for {}:{}. Initial value was {}. Including POM is at {}", new Object[]{groupId, artifactId, dep.getVersion(), rawMaven.getSourcePath()});
                assert (version != null);
            }
            if ((effectiveScope = (requestedScope = Scope.fromName(partialMaven.getScope(dep.getScope()))).transitiveOf(task.getScope())) == null) {
                return null;
            }
            RequestedVersion requestedVersion = this.selectVersion(effectiveScope, groupId, artifactId, version);
            ((Map)this.versionSelection.get((Object)effectiveScope)).put(new GroupArtifact(groupId, artifactId), requestedVersion);
            version = requestedVersion.resolve(this.downloader, partialMaven.getRepositories());
            if (version.contains("${")) {
                logger.debug("Unable to download {}:{}:{}. Including POM is at {}", new Object[]{groupId, artifactId, version, rawMaven.getSourcePath()});
                return null;
            }
            RawMaven download = this.downloader.download(groupId, artifactId, version, dep.getClassifier(), null, rawMaven, partialMaven.getRepositories());
            if (download == null) {
                logger.debug("Unable to download {}:{}:{}. Including POM is at {}", new Object[]{groupId, artifactId, version, rawMaven.getSourcePath()});
                return null;
            }
            ResolutionTask resolutionTask = new ResolutionTask(requestedScope, download, dep.getExclusions() == null ? Collections.emptySet() : dep.getExclusions().stream().map(ex -> new GroupArtifact(ex.getGroupId().replace("*", ".*"), ex.getArtifactId().replace("*", ".*"))).collect(Collectors.toSet()), dep.getOptional() != null && dep.getOptional() != false, dep.getClassifier(), dep.getVersion(), partialMaven.getRepositories());
            if (!this.partialResults.containsKey(resolutionTask)) {
                this.workQueue.add(resolutionTask);
            }
            return resolutionTask;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void processParent(ResolutionTask task, PartialMaven partialMaven) {
        RawPom.Parent rawParent;
        RawMaven rawParentModel;
        RawMaven rawMaven = task.getRawMaven();
        RawPom pom = rawMaven.getPom();
        Pom parent = null;
        if (pom.getParent() != null && (rawParentModel = this.downloader.download((rawParent = pom.getParent()).getGroupId(), rawParent.getArtifactId(), rawParent.getVersion(), null, rawParent.getRelativePath(), rawMaven, partialMaven.getRepositories())) != null) {
            PartialTreeKey parentKey = new PartialTreeKey(rawParent.getGroupId(), rawParent.getArtifactId(), rawParent.getVersion());
            Optional<Pom> maybeParent = this.resolved.get(parentKey);
            if (maybeParent == null) {
                parent = new RawMavenResolver(this.downloader, true, this.resolveOptional).resolve(rawParentModel, Scope.Compile, rawParent.getVersion(), partialMaven.getRepositories());
                this.resolved.put(parentKey, Optional.ofNullable(parent));
            } else {
                parent = maybeParent.orElse(null);
            }
        }
        partialMaven.setParent(parent);
    }

    private void processRepositories(ResolutionTask task, PartialMaven partialMaven) {
        ArrayList<RawPom.Repository> repositories = new ArrayList<RawPom.Repository>();
        for (RawPom.Repository repository : task.getRawMaven().getPom().getRepositories()) {
            String url = repository.getUrl().trim();
            if (repository.getUrl().contains("${")) {
                url = placeholderHelper.replacePlaceholders(url, k -> partialMaven.getProperties().get(k));
            }
            try {
                URI.create(url);
                repositories.add(new RawPom.Repository(url, repository.getReleases(), repository.getSnapshots()));
            }
            catch (Throwable t) {
                logger.debug("Unable to make a URI out of repositoriy url {}", (Object)url);
            }
        }
        repositories.addAll(task.getRepositories());
        partialMaven.setRepositories(repositories);
    }

    private void processLicenses(ResolutionTask task, PartialMaven partialMaven) {
        List<RawPom.License> licenses = task.getRawMaven().getPom().getLicenses();
        ArrayList<Pom.License> list = new ArrayList<Pom.License>();
        for (RawPom.License license : licenses) {
            Pom.License fromName = Pom.License.fromName(license.getName());
            list.add(fromName);
        }
        partialMaven.setLicenses(list);
    }

    @Nullable
    private Pom assembleResults(ResolutionTask task, Stack<ResolutionTask> assemblyStack) {
        if (assemblyStack.contains(task)) {
            return null;
        }
        RawMaven rawMaven = task.getRawMaven();
        RawPom rawPom = rawMaven.getPom();
        PartialTreeKey taskKey = new PartialTreeKey(rawPom.getGroupId(), rawPom.getArtifactId(), rawPom.getVersion());
        Optional<Pom> result = this.resolved.get(taskKey);
        Stack<ResolutionTask> nextAssemblyStack = new Stack<ResolutionTask>();
        nextAssemblyStack.addAll(assemblyStack);
        nextAssemblyStack.push(task);
        if (result == null) {
            PartialMaven partial = this.partialResults.get(task);
            if (partial != null) {
                String version;
                List dependencies = partial.getDependencyTasks().stream().map(depTask -> {
                    Pom resolved;
                    boolean optional;
                    boolean bl = optional = depTask.isOptional() || assemblyStack.stream().anyMatch(ResolutionTask::isOptional);
                    if (logger.isDebugEnabled() && !this.forParent) {
                        String indent = CharBuffer.allocate(assemblyStack.size()).toString().replace('\u0000', ' ');
                        RawPom depPom = depTask.getRawMaven().getPom();
                        logger.debug("{}{}:{}:{}{} {}", new Object[]{indent, depPom.getGroupId(), depPom.getArtifactId(), depPom.getVersion(), optional ? " (optional) " : "", depTask.getRawMaven().getSourcePath()});
                    }
                    if ((resolved = this.assembleResults((ResolutionTask)depTask, nextAssemblyStack)) == null) {
                        return null;
                    }
                    return new Pom.Dependency(depTask.getScope(), depTask.getClassifier(), optional, resolved, depTask.getRequestedVersion(), depTask.getExclusions());
                }).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
                for (Pom ancestor = partial.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                    for (Pom.Dependency ancestorDep : ancestor.getDependencies()) {
                        String artifactId;
                        String groupId;
                        Scope scope = ancestorDep.getScope();
                        String conflictResolvedVersion = this.selectVersion(scope, groupId = ancestorDep.getGroupId(), artifactId = ancestorDep.getArtifactId(), ancestorDep.getVersion()).resolve(this.downloader, task.getRepositories());
                        if (!conflictResolvedVersion.equals(ancestorDep.getVersion())) {
                            RawMaven conflictResolvedRaw = this.downloader.download(groupId, artifactId, conflictResolvedVersion, ancestorDep.getClassifier(), null, null, task.getRepositories());
                            Pom conflictResolved = this.assembleResults(new ResolutionTask(scope, conflictResolvedRaw, ancestorDep.getExclusions(), ancestorDep.isOptional(), ancestorDep.getRequestedVersion(), ancestorDep.getClassifier(), task.getRepositories()), nextAssemblyStack);
                            if (conflictResolved == null) {
                                logger.debug("Unable to conflict resolve {}:{}:{} {}", new Object[]{ancestorDep.getGroupId(), ancestorDep.getArtifactId(), ancestorDep.getVersion(), conflictResolvedRaw == null ? "unknown URI" : conflictResolvedRaw.getSourcePath()});
                                dependencies.add(ancestorDep);
                                continue;
                            }
                            dependencies.add(new Pom.Dependency(scope, ancestorDep.getClassifier(), ancestorDep.isOptional(), conflictResolved, ancestorDep.getRequestedVersion(), ancestorDep.getExclusions()));
                            continue;
                        }
                        dependencies.add(ancestorDep);
                    }
                }
                String groupId = rawPom.getGroupId();
                if (groupId == null) {
                    groupId = partial.getParent().getGroupId();
                }
                if ((version = rawPom.getVersion()) == null) {
                    version = partial.getParent().getVersion();
                }
                ArrayList<Pom.Repository> repositories = new ArrayList<Pom.Repository>();
                for (RawPom.Repository repo : partial.getRepositories()) {
                    try {
                        repositories.add(new Pom.Repository(URI.create(repo.getUrl()).toURL(), repo.getReleases() == null || repo.getReleases().isEnabled(), repo.getSnapshots() == null || repo.getSnapshots().isEnabled()));
                    }
                    catch (MalformedURLException e) {
                        logger.debug("Malformed repository URL '{}'", (Object)repo.getUrl());
                    }
                }
                result = Optional.of(new Pom(partial.getSourcePath(), groupId, rawPom.getArtifactId(), version, rawPom.getSnapshotVersion(), null, null, partial.getParent(), dependencies, partial.getDependencyManagement(), partial.getLicenses(), repositories, partial.getProperties()));
            } else {
                result = Optional.empty();
            }
            this.resolved.put(taskKey, result);
        }
        return result.orElse(null);
    }

    private RequestedVersion selectVersion(@Nullable Scope scope, String groupId, String artifactId, String version) {
        GroupArtifact groupArtifact = new GroupArtifact(groupId, artifactId);
        if (scope == null) {
            return new RequestedVersion(groupArtifact, null, version);
        }
        RequestedVersion nearer = null;
        for (Map nearerInScope : this.versionSelection.headMap(scope, true).values()) {
            RequestedVersion requestedVersion = (RequestedVersion)nearerInScope.get(groupArtifact);
            if (requestedVersion == null) continue;
            nearer = requestedVersion;
            break;
        }
        return ((Map)this.versionSelection.get((Object)scope)).getOrDefault(groupArtifact, new RequestedVersion(groupArtifact, nearer, version));
    }

    static class PartialMaven {
        private final String sourcePath;
        private final RawPom rawPom;
        private Pom parent;
        private Pom.DependencyManagement dependencyManagement;
        private Collection<ResolutionTask> dependencyTasks = Collections.emptyList();
        private Collection<Pom.License> licenses = Collections.emptyList();
        private List<RawPom.Repository> repositories = Collections.emptyList();
        private Map<String, String> properties = Collections.emptyMap();

        @Nullable
        String getGroupId(String g) {
            if (g.equals("${project.groupId}") || g.equals("${pom.groupId}")) {
                String groupId = this.rawPom.getGroupId();
                if (groupId != null) {
                    return groupId;
                }
                return this.parent == null ? null : this.parent.getGroupId();
            }
            if (g.equals("${project.parent.groupId}")) {
                return this.parent != null ? this.parent.getGroupId() : null;
            }
            return this.getValue(g);
        }

        @Nullable
        String getArtifactId(String a) {
            if (a.equals("${project.artifactId}") || a.equals("${pom.artifactId}")) {
                return this.rawPom.getArtifactId();
            }
            if (a.equals("${project.parent.artifactId}")) {
                return this.parent != null ? this.parent.getArtifactId() : null;
            }
            return this.getValue(a);
        }

        @Nullable
        String getVersion(@Nullable String v) {
            String last = null;
            String version = v;
            while (version != null && !version.equals(last)) {
                last = version;
                if (version.equals("${project.version}") || version.equals("${pom.version}")) {
                    String rawVersion = this.rawPom.getVersion();
                    if (rawVersion != null) {
                        version = rawVersion;
                        continue;
                    }
                    version = this.parent == null ? null : this.parent.getVersion();
                    continue;
                }
                if (v.equals("${project.parent.version}")) {
                    version = this.parent != null ? this.parent.getVersion() : null;
                    continue;
                }
                version = this.getValue(version);
            }
            return version;
        }

        @Nullable
        String getScope(@Nullable String s) {
            return s == null ? null : this.getValue(s);
        }

        private String getValue(String v) {
            if (v.startsWith("${") && v.endsWith("}")) {
                String key = v.replace("${", "").replace("}", "");
                String value = this.rawPom.getActiveProperties().get(key);
                if (value != null) {
                    return value;
                }
                if (this.dependencyManagement != null) {
                    for (DependencyManagementDependency managedDependency : this.dependencyManagement.getDependencies()) {
                        value = managedDependency.getProperties().get(key);
                        if (value == null) continue;
                        return value;
                    }
                }
                for (Pom ancestor = this.parent; ancestor != null; ancestor = ancestor.getParent()) {
                    value = ancestor.getProperty(key);
                    if (value == null) continue;
                    return value;
                }
                value = System.getProperty(key);
                if (value != null) {
                    return value;
                }
                return v;
            }
            return v;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartialMaven)) {
                return false;
            }
            PartialMaven other = (PartialMaven)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            RawPom this$rawPom = this.getRawPom();
            RawPom other$rawPom = other.getRawPom();
            return !(this$rawPom == null ? other$rawPom != null : !((Object)this$rawPom).equals(other$rawPom));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartialMaven;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            RawPom $rawPom = this.getRawPom();
            result = result * 59 + ($rawPom == null ? 43 : ((Object)$rawPom).hashCode());
            return result;
        }

        @ConstructorProperties(value={"sourcePath", "rawPom"})
        public PartialMaven(String sourcePath, RawPom rawPom) {
            this.sourcePath = sourcePath;
            this.rawPom = rawPom;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public RawPom getRawPom() {
            return this.rawPom;
        }

        public Pom getParent() {
            return this.parent;
        }

        public Pom.DependencyManagement getDependencyManagement() {
            return this.dependencyManagement;
        }

        public Collection<ResolutionTask> getDependencyTasks() {
            return this.dependencyTasks;
        }

        public Collection<Pom.License> getLicenses() {
            return this.licenses;
        }

        public List<RawPom.Repository> getRepositories() {
            return this.repositories;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setParent(Pom parent) {
            this.parent = parent;
        }

        public void setDependencyManagement(Pom.DependencyManagement dependencyManagement) {
            this.dependencyManagement = dependencyManagement;
        }

        public void setDependencyTasks(Collection<ResolutionTask> dependencyTasks) {
            this.dependencyTasks = dependencyTasks;
        }

        public void setLicenses(Collection<Pom.License> licenses) {
            this.licenses = licenses;
        }

        public void setRepositories(List<RawPom.Repository> repositories) {
            this.repositories = repositories;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }
    }

    static class PartialTreeKey {
        private final String groupId;
        private final String artifactId;
        private final String version;

        @ConstructorProperties(value={"groupId", "artifactId", "version"})
        public PartialTreeKey(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartialTreeKey)) {
                return false;
            }
            PartialTreeKey other = (PartialTreeKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartialTreeKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "RawMavenResolver.PartialTreeKey(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
        }
    }

    private static class ResolutionTask {
        private final Scope scope;
        private final RawMaven rawMaven;
        @Nullable
        private final Set<GroupArtifact> exclusions;
        private final boolean optional;
        @Nullable
        private final String classifier;
        @Nullable
        private final String requestedVersion;
        private final List<RawPom.Repository> repositories;

        @JsonIgnore
        public Set<GroupArtifact> getExclusions() {
            return this.exclusions == null ? Collections.emptySet() : this.exclusions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResolutionTask)) {
                return false;
            }
            ResolutionTask other = (ResolutionTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOptional() != other.isOptional()) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
                return false;
            }
            RawMaven this$rawMaven = this.getRawMaven();
            RawMaven other$rawMaven = other.getRawMaven();
            if (this$rawMaven == null ? other$rawMaven != null : !((Object)this$rawMaven).equals(other$rawMaven)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            if (this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            String this$requestedVersion = this.getRequestedVersion();
            String other$requestedVersion = other.getRequestedVersion();
            return !(this$requestedVersion == null ? other$requestedVersion != null : !this$requestedVersion.equals(other$requestedVersion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResolutionTask;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOptional() ? 79 : 97);
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            RawMaven $rawMaven = this.getRawMaven();
            result = result * 59 + ($rawMaven == null ? 43 : ((Object)$rawMaven).hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            String $requestedVersion = this.getRequestedVersion();
            result = result * 59 + ($requestedVersion == null ? 43 : $requestedVersion.hashCode());
            return result;
        }

        @ConstructorProperties(value={"scope", "rawMaven", "exclusions", "optional", "classifier", "requestedVersion", "repositories"})
        public ResolutionTask(Scope scope, RawMaven rawMaven, Set<GroupArtifact> exclusions, boolean optional, String classifier, String requestedVersion, List<RawPom.Repository> repositories) {
            this.scope = scope;
            this.rawMaven = rawMaven;
            this.exclusions = exclusions;
            this.optional = optional;
            this.classifier = classifier;
            this.requestedVersion = requestedVersion;
            this.repositories = repositories;
        }

        public Scope getScope() {
            return this.scope;
        }

        public RawMaven getRawMaven() {
            return this.rawMaven;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getRequestedVersion() {
            return this.requestedVersion;
        }

        public List<RawPom.Repository> getRepositories() {
            return this.repositories;
        }

        public String toString() {
            return "RawMavenResolver.ResolutionTask(scope=" + (Object)((Object)this.getScope()) + ", rawMaven=" + this.getRawMaven() + ", exclusions=" + this.getExclusions() + ", optional=" + this.isOptional() + ", classifier=" + this.getClassifier() + ", requestedVersion=" + this.getRequestedVersion() + ", repositories=" + this.getRepositories() + ")";
        }
    }
}

