/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import java.util.Map;
import java.util.Set;
import org.openrewrite.Tree;
import org.openrewrite.maven.AbstractMavenSourceVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;

public class PrintMavenAsCycloneDxBom
extends AbstractMavenSourceVisitor<String> {
    public String defaultTo(Tree t) {
        return "";
    }

    @Override
    public String visitPom(Maven.Pom pom) {
        StringBuilder bom = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bom.append("<bom xmlns=\"http://cyclonedx.org/schema/bom/1.2\" serialNumber=\"urn:uuid:");
        bom.append(pom.getId().toString());
        bom.append("\" version=\"1\">\n");
        bom.append("  <components>\n");
        bom.append("    <component type=\"library\" bom-ref=\"").append(pom.getArtifactId()).append("\">\n");
        bom.append("      <group>").append(pom.getGroupId()).append("</group>\n");
        bom.append("      <name>").append(pom.getArtifactId()).append("</name>\n");
        bom.append("      <version>").append(pom.getVersion()).append("</version>\n");
        bom.append("      <purl>pkg:maven/").append(pom.getGroupId()).append("/").append(pom.getArtifactId()).append("@").append(pom.getVersion()).append("</purl>\n");
        this.writeLicenses(pom, bom);
        this.writeDependencies(pom, bom);
        bom.append("    </component>\n");
        bom.append("  </components>\n");
        bom.append("</bom>");
        return bom.toString();
    }

    private void writeLicenses(Maven.Pom pom, StringBuilder bom) {
        if (!pom.getModel().getLicenses().isEmpty()) {
            bom.append("      <licenses>\n");
            for (MavenModel.License license : pom.getModel().getLicenses()) {
                bom.append("        <license>").append(license.getName()).append("</license>\n");
            }
            bom.append("      </licenses>\n");
        }
    }

    private void writeDependencies(Maven.Pom pom, StringBuilder bom) {
        if (!pom.getModel().getDependencies().isEmpty()) {
            bom.append("      <dependencies>\n");
            bom.append("        <dependency ref=\"").append(pom.getArtifactId()).append("\">\n");
            for (Map.Entry<String, Set<MavenModel.ModuleVersionId>> dependenciesForScope : pom.getModel().getTransitiveDependenciesByScope().entrySet()) {
                String scope = dependenciesForScope.getKey();
                if (!scope.equals("compile") && !scope.equals("runtime")) continue;
                for (MavenModel.ModuleVersionId mvid : dependenciesForScope.getValue()) {
                    bom.append("          <dependency ref=\"pkg:maven/").append(mvid.getGroupId()).append("/").append(mvid.getArtifactId()).append("@").append(mvid.getVersion()).append("\"/>\n");
                }
            }
            bom.append("        </dependency>\n");
            bom.append("      </dependencies>\n");
        }
    }
}

