/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectModelResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentModelResolver
extends ProjectModelResolver {
    private static final Logger logger = LoggerFactory.getLogger(ParentModelResolver.class);

    public ParentModelResolver(RepositorySystemSession session, RepositorySystem resolver, RemoteRepositoryManager remoteRepositoryManager, List<RemoteRepository> repositories) {
        super(session, new RequestTrace(null), resolver, remoteRepositoryManager, repositories, ProjectBuildingRequest.RepositoryMerging.POM_DOMINANT, null);
    }

    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        try {
            URLConnection connection;
            if (repository.getUrl().contains("http:") && (connection = URI.create(repository.getUrl()).toURL().openConnection()) instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.setRequestMethod("HEAD");
                if (httpConnection.getResponseCode() == 403) {
                    repository.setUrl(repository.getUrl().replace("http:", "https:"));
                }
            }
            super.addRepository(repository, replace);
        }
        catch (IOException e) {
            logger.warn("Unable to add repository with URL: " + repository.getUrl(), (Throwable)e);
        }
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) {
        logger.trace("resolving model for: {}:{}", (Object)groupId, (Object)artifactId);
        try {
            return super.resolveModel(groupId, artifactId, version);
        }
        catch (UnresolvableModelException e) {
            logger.error("unable to resolve model", (Throwable)e);
            return new UnresolvedModelSource(groupId, artifactId, version);
        }
    }

    public ModelSource resolveModel(Parent parent) {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public ModelSource resolveModel(Dependency dependency) {
        logger.trace("resolving model for: {}:{}", (Object)dependency.getGroupId(), (Object)dependency.getArtifactId());
        try {
            return super.resolveModel(dependency);
        }
        catch (UnresolvableModelException e) {
            logger.error("unable to resolve model", (Throwable)e);
            return new UnresolvedModelSource(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
        }
    }

    public ModelResolver newCopy() {
        return this;
    }

    private static class UnresolvedModelSource
    implements ModelSource2 {
        private final String groupId;
        private final String artifactId;
        private final String version;

        private UnresolvedModelSource(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public ModelSource2 getRelatedSource(String relPath) {
            return null;
        }

        public URI getLocationURI() {
            return null;
        }

        public InputStream getInputStream() {
            String syntheticPom = "<project>\n<modelVersion>4.0.0</modelVersion>\n<packaging>pom</packaging>\n<groupId>" + this.groupId + "</groupId>\n<artifactId>" + this.artifactId + "</artifactId>\n<version>" + this.version + "</version>\n</project>";
            return new ByteArrayInputStream(syntheticPom.getBytes());
        }

        public String getLocation() {
            return null;
        }
    }
}

