/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.resolution.ModelResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParentModelResolver
implements ModelResolver {
    private static final Logger logger = LoggerFactory.getLogger(ParentModelResolver.class);
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;

    public ParentModelResolver(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = remoteRepositories;
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) {
        logger.trace("resolving model for: {}:{}", (Object)groupId, (Object)artifactId);
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)pomArtifact);
            artifactRequest.setRepositories(this.remoteRepositories);
            pomArtifact = this.repositorySystem.resolveArtifact(this.repositorySystemSession, artifactRequest).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            logger.error("unable to resolve model", (Throwable)e);
            return new UnresolvedModelSource(groupId, artifactId, version);
        }
        return new FileModelSource(pomArtifact.getFile());
    }

    public ModelSource resolveModel(Parent parent) {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public void addRepository(Repository repository) {
    }

    public void addRepository(Repository repository, boolean replace) {
    }

    public ModelResolver newCopy() {
        return this;
    }

    private static class UnresolvedModelSource
    implements ModelSource2 {
        private final String groupId;
        private final String artifactId;
        private final String version;

        private UnresolvedModelSource(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public ModelSource2 getRelatedSource(String relPath) {
            return null;
        }

        public URI getLocationURI() {
            return null;
        }

        public InputStream getInputStream() {
            String syntheticPom = "<project>\n<modelVersion>4.0.0</modelVersion>\n<packaging>pom</packaging>\n<groupId>" + this.groupId + "</groupId>\n<artifactId>" + this.artifactId + "</artifactId>\n<version>" + this.version + "</version>\n</project>";
            return new ByteArrayInputStream(syntheticPom.getBytes());
        }

        public String getLocation() {
            return null;
        }
    }
}

