/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import org.openrewrite.RefactorVisitorSupport;
import org.openrewrite.Tree;
import org.openrewrite.maven.MavenSourceVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.refactor.Formatter;
import org.openrewrite.xml.XmlRefactorVisitor;
import org.openrewrite.xml.tree.Xml;

public class MavenRefactorVisitor
extends MavenSourceVisitor<Maven>
implements RefactorVisitorSupport {
    protected Formatter formatter;
    XmlRefactorVisitor xmlRefactorVisitor = new XmlRefactorVisitor(){};

    public Maven defaultTo(Tree t) {
        return (Maven)t;
    }

    @Override
    public Maven visitPom(Maven.Pom pom) {
        this.formatter = new Formatter((Tree)pom.getDocument());
        Maven.Pom p = pom;
        p = p.withParent((Maven.Parent)this.refactor(p.getParent()));
        p = p.withDependencyManagement((Maven.DependencyManagement)this.refactor(p.getDependencyManagement()));
        p = p.withDependencies(this.refactor(p.getDependencies()));
        p = p.withProperties(this.refactor(p.getProperties()));
        return p;
    }

    @Override
    public Maven visitDependencyManagement(Maven.DependencyManagement dependencyManagement) {
        return dependencyManagement.withDependencies(this.refactor(dependencyManagement.getDependencies()));
    }

    @Override
    public Maven visitDependency(Maven.Dependency dependency) {
        Xml.Tag t = (Xml.Tag)this.xmlRefactorVisitor.visitTag(dependency.getTag());
        if (t != dependency.getTag()) {
            return new Maven.Dependency(dependency.isManaged(), dependency.getModel(), t);
        }
        return dependency;
    }

    @Override
    public Maven visitProperty(Maven.Property property) {
        Xml.Tag t = (Xml.Tag)this.xmlRefactorVisitor.visitTag(property.getTag());
        if (t != property.getTag()) {
            return new Maven.Property(t);
        }
        return property;
    }
}

