/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;

public class ChangeDependencyVersion
extends MavenRefactorVisitor {
    private String groupId;
    @Nullable
    private String artifactId;
    private String toVersion;

    public ChangeDependencyVersion() {
        this.setCursoringOn();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(@Nullable String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId)).and(Validated.required((String)"toVersion", (Object)this.toVersion));
    }

    @Override
    public Maven visitProperty(Maven.Property property) {
        Maven.Property p = (Maven.Property)this.refactor(property, x$0 -> super.visitProperty((Maven.Property)x$0));
        Maven.Pom pom = (Maven.Pom)this.getCursor().firstEnclosing(Maven.Pom.class);
        if (!property.getValue().equals(this.toVersion) && property.findDependencies(pom, this.groupId, this.artifactId).anyMatch(d -> d.getRequestedVersion().equals("${" + property.getKey() + "}"))) {
            p = p.withValue(this.toVersion);
        }
        return p;
    }

    @Override
    public Maven visitDependency(Maven.Dependency dependency) {
        Maven.Dependency d = (Maven.Dependency)this.refactor(dependency, x$0 -> super.visitDependency((Maven.Dependency)x$0));
        Maven.Pom pom = (Maven.Pom)this.getCursor().firstEnclosing(Maven.Pom.class);
        assert (pom != null);
        MavenModel.ModuleVersionId mvid = dependency.getModel().getModuleVersion();
        if (mvid.getGroupId().equals(this.groupId) && (this.artifactId == null || mvid.getArtifactId().equals(this.artifactId)) && !mvid.getVersion().equals(this.toVersion)) {
            Optional<Maven.Property> property = pom.getPropertyFromValue(dependency.getVersion());
            if (property.isPresent()) {
                this.andThen(new ChangePropertyValue.Scoped(property.get(), this.toVersion));
            } else {
                this.andThen(new Scoped(d, this.toVersion));
            }
        }
        return d;
    }

    public static class Scoped
    extends MavenRefactorVisitor {
        private final Maven.Dependency scope;
        private final String toVersion;

        public Scoped(Maven.Dependency scope, String toVersion) {
            this.scope = scope;
            this.toVersion = toVersion;
        }

        @Override
        public Maven visitDependency(Maven.Dependency dependency) {
            Maven.Dependency d = (Maven.Dependency)this.refactor(dependency, x$0 -> super.visitDependency((Maven.Dependency)x$0));
            if (this.scope.isScope(dependency)) {
                d = d.withVersion(this.toVersion);
            }
            return d;
        }
    }
}

