/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.openrewrite.maven.internal.ParentModelResolver;
import org.openrewrite.maven.tree.MavenModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MavenModuleLoader {
    private static final Logger logger = LoggerFactory.getLogger(MavenModuleLoader.class);
    private final boolean resolveDependencies;
    private final File localRepository;
    private final List<RemoteRepository> remoteRepositories;

    public MavenModuleLoader(boolean resolveDependencies, File localRepository, List<RemoteRepository> remoteRepositories) {
        this.resolveDependencies = resolveDependencies;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
    }

    public Map<Path, MavenModel> load(List<Path> sourceFiles) {
        HashMap<Path, MavenModel> modelsByPath = new HashMap<Path, MavenModel>();
        HashMap<MavenModel.ModuleVersionId, Collection> inheriting = new HashMap<MavenModel.ModuleVersionId, Collection>();
        for (Path sourceFile : sourceFiles) {
            MavenModel model = this.load(sourceFile);
            modelsByPath.put(sourceFile, model);
            MavenModel descendent = model;
            for (MavenModel ancestor = model.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                inheriting.computeIfAbsent(ancestor.getModuleVersion(), m -> new ArrayList()).add(descendent.withParent(null));
                descendent = ancestor;
            }
        }
        return modelsByPath.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, modelByPath -> {
            MavenModel m = (MavenModel)modelByPath.getValue();
            return new MavenModel(m.getParent(), m.getModuleVersion(), m.getDependencyManagement(), m.getDependencies(), m.getProperties(), inheriting.getOrDefault(m.getModuleVersion(), Collections.emptyList()));
        }));
    }

    private MavenModel load(Path sourceFile) {
        try {
            RepositorySystem repositorySystem = this.getRepositorySystem();
            DefaultRepositorySystemSession repositorySystemSession = this.getRepositorySystemSession(repositorySystem);
            DefaultModelBuildingRequest modelBuildingRequest = new DefaultModelBuildingRequest().setModelResolver((ModelResolver)new ParentModelResolver(repositorySystem, (RepositorySystemSession)repositorySystemSession, this.remoteRepositories)).setPomFile(sourceFile.toFile());
            DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
            ModelBuildingResult modelBuildingResult = modelBuilder.build((ModelBuildingRequest)modelBuildingRequest);
            return this.buildMavenModelRecursive(repositorySystem, (RepositorySystemSession)repositorySystemSession, modelBuildingResult, modelBuildingResult.getEffectiveModel());
        }
        catch (ModelBuildingException e) {
            throw new RuntimeException(e);
        }
    }

    private MavenModel buildMavenModelRecursive(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, ModelBuildingResult result, Model model) {
        MavenModel parent = null;
        if (model.getParent() != null) {
            parent = this.buildMavenModelRecursive(repositorySystem, repositorySystemSession, result, result.getRawModel(model.getParent().getId().replace(":pom", "")));
        }
        Model rawModel = result.getRawModel(model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion());
        List<MavenModel.Dependency> dependencies = model.getDependencies().stream().map(dependency -> this.resolveDependency(repositorySystem, repositorySystemSession, (Dependency)dependency, rawModel)).collect(Collectors.toList());
        MavenModel.DependencyManagement dependencyManagement = model.getDependencyManagement() == null ? null : new MavenModel.DependencyManagement(model.getDependencyManagement().getDependencies().stream().map(dependency -> this.resolveDependency(repositorySystem, repositorySystemSession, (Dependency)dependency, rawModel)).collect(Collectors.toList()));
        Map<String, String> properties = model.getProperties().entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        return new MavenModel(parent, new MavenModel.ModuleVersionId(model.getGroupId(), model.getArtifactId(), model.getVersion()), dependencyManagement, dependencies, properties, Collections.emptyList());
    }

    private MavenModel.Dependency resolveDependency(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, Dependency dependency, Model rawModel) {
        String requestedVersion = dependency.getVersion();
        if (rawModel != null) {
            requestedVersion = rawModel.getDependencies().stream().filter(d -> d.getGroupId().equals(dependency.getGroupId()) && d.getArtifactId().equals(dependency.getArtifactId()) && (d.getScope() == null || d.getScope().equals(dependency.getScope()))).map(Dependency::getVersion).filter(Objects::nonNull).findAny().orElse(dependency.getVersion());
            if (this.resolveDependencies) {
                DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getVersion());
                ArtifactRequest artifactRequest = new ArtifactRequest();
                artifactRequest.setArtifact((Artifact)artifact);
                artifactRequest.setRepositories(this.remoteRepositories);
                try {
                    ArtifactResult artifactResult = repositorySystem.resolveArtifact(repositorySystemSession, artifactRequest);
                    artifact = artifactResult.getArtifact();
                    logger.debug("artifact {} resolved to {}", (Object)artifact, (Object)artifact.getFile());
                    return new MavenModel.Dependency(new MavenModel.ModuleVersionId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), requestedVersion, dependency.getScope());
                }
                catch (ArtifactResolutionException e) {
                    logger.warn("error resolving artifact: {}", (Object)e.getMessage());
                }
            }
        }
        return new MavenModel.Dependency(new MavenModel.ModuleVersionId(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()), requestedVersion, dependency.getScope());
    }

    private RepositorySystem getRepositorySystem() {
        DefaultServiceLocator serviceLocator = MavenRepositorySystemUtils.newServiceLocator();
        serviceLocator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        serviceLocator.addService(TransporterFactory.class, FileTransporterFactory.class);
        serviceLocator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession getRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession repositorySystemSession = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(this.localRepository.getPath());
        repositorySystemSession.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)repositorySystemSession, localRepository));
        repositorySystemSession.setRepositoryListener((RepositoryListener)new ConsoleRepositoryEventListener());
        return repositorySystemSession;
    }

    private static class ConsoleRepositoryEventListener
    extends AbstractRepositoryListener {
        private ConsoleRepositoryEventListener() {
        }

        public void artifactInstalled(RepositoryEvent event) {
            logger.debug("artifact {} installed to file {}", (Object)event.getArtifact(), (Object)event.getFile());
        }

        public void artifactInstalling(RepositoryEvent event) {
            logger.debug("installing artifact {} to file {}", (Object)event.getArtifact(), (Object)event.getFile());
        }

        public void artifactResolved(RepositoryEvent event) {
            logger.debug("artifact {} resolved from repository {}", (Object)event.getArtifact(), (Object)event.getRepository());
        }

        public void artifactDownloading(RepositoryEvent event) {
            logger.debug("downloading artifact {} from repository {}", (Object)event.getArtifact(), (Object)event.getRepository());
        }

        public void artifactDownloaded(RepositoryEvent event) {
            logger.debug("downloaded artifact {} from repository {}", (Object)event.getArtifact(), (Object)event.getRepository());
        }

        public void artifactResolving(RepositoryEvent event) {
            logger.debug("resolving artifact {}", (Object)event.getArtifact());
        }
    }
}

