/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.backend.FirMetadataSource;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrMetadataSourceOwner;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.kotlin.KotlinIrTypeMapping;
import org.openrewrite.kotlin.internal.IrTreePrinterVisitor;
import org.openrewrite.kotlin.internal.PsiElementAssociations;
import org.openrewrite.kotlin.tree.K;

public class PsiTreePrinter {
    private static final String TAB = "    ";
    private static final String ELEMENT_PREFIX = "\\---";
    private static final char BRANCH_CONTINUE_CHAR = '|';
    private static final char BRANCH_END_CHAR = '\\';
    private static final int CONTENT_MAX_LENGTH = 200;
    private static final String CONTINUE_PREFIX = "----";
    private static final String UNVISITED_PREFIX = "#";
    private static final KotlinIrTypeMapping irTypeMapping = new KotlinIrTypeMapping(new JavaTypeCache());
    private static final boolean printTypes = true;
    private final List<StringBuilder> outputLines = new ArrayList<StringBuilder>();

    protected PsiTreePrinter() {
    }

    public static String print(PsiElement psiElement) {
        return PsiTreePrinter.printPsiTree(psiElement);
    }

    public static String print(Parser.Input input) {
        return PsiTreePrinter.printIndexedSourceCode(input.getSource((ExecutionContext)new InMemoryExecutionContext()).readFully());
    }

    public static String print(@Nullable IrFile file) {
        return PsiTreePrinter.printIrFile(file);
    }

    public static String print(Tree tree) {
        return PsiTreePrinter.printJTree(tree);
    }

    public static String print(@Nullable FirElement firElement) {
        if (firElement == null) {
            return "null";
        }
        return PsiTreePrinter.printFirTree(firElement);
    }

    public static String printPsiTreeSkeleton(PsiElement psiElement) {
        PsiTreePrinter treePrinter = new PsiTreePrinter();
        StringBuilder sb = new StringBuilder();
        sb.append("------------").append("\n");
        sb.append("PSI Tree Skeleton").append("\n");
        HashSet<TextRange> covered = new HashSet<TextRange>();
        PsiTreePrinter.collectCovered(psiElement, covered);
        treePrinter.printSkeletonNode(psiElement, 1);
        sb.append(String.join((CharSequence)"\n", treePrinter.outputLines));
        return sb.toString();
    }

    public static String printPsiTree(PsiElement psiElement) {
        PsiTreePrinter treePrinter = new PsiTreePrinter();
        StringBuilder sb = new StringBuilder();
        treePrinter.printNode(psiElement, 1);
        sb.append(String.join((CharSequence)"\n", treePrinter.outputLines));
        return sb.toString();
    }

    public static String printFirFile(FirFile file) {
        StringBuilder sb = new StringBuilder();
        ArrayList<StringBuilder> lines = new ArrayList<StringBuilder>();
        sb.append("------------").append("\n");
        sb.append("FirFile:").append("\n\n");
        TreePrinterContext context = new TreePrinterContext(lines, 1);
        new FirDefaultVisitor<Void, TreePrinterContext>(){

            public Void visitElement(@NotNull FirElement firElement, TreePrinterContext ctx) {
                FirTypeRef firTypeRef;
                StringBuilder line = new StringBuilder();
                line.append(PsiTreePrinter.leftPadding(ctx.getDepth())).append(PsiTreePrinter.printFirElement(firElement));
                PsiTreePrinter.connectToLatestSibling(ctx.getDepth(), ctx.getLines());
                ctx.getLines().add(line);
                ctx.setDepth(ctx.getDepth() + 1);
                firElement.acceptChildren((FirVisitor)this, (Object)ctx);
                if (firElement instanceof FirResolvedTypeRef && (firTypeRef = ((FirResolvedTypeRef)firElement).getDelegatedTypeRef()) != null) {
                    firTypeRef.accept((FirVisitor)this, (Object)ctx);
                }
                ctx.setDepth(ctx.getDepth() - 1);
                return null;
            }
        }.visitFile(file, (Object)context);
        sb.append(String.join((CharSequence)"\n", lines));
        return sb.toString();
    }

    public static String printFirTree(FirElement firElement) {
        StringBuilder sb = new StringBuilder();
        ArrayList<StringBuilder> lines = new ArrayList<StringBuilder>();
        TreePrinterContext context = new TreePrinterContext(lines, 1);
        new FirDefaultVisitor<Void, TreePrinterContext>(){

            public Void visitElement(@NotNull FirElement fir2, TreePrinterContext ctx) {
                FirTypeRef firTypeRef;
                StringBuilder line = new StringBuilder();
                line.append(PsiTreePrinter.leftPadding(ctx.getDepth())).append(PsiTreePrinter.printFirElement(fir2));
                PsiTreePrinter.connectToLatestSibling(ctx.getDepth(), ctx.getLines());
                ctx.getLines().add(line);
                ctx.setDepth(ctx.getDepth() + 1);
                fir2.acceptChildren((FirVisitor)this, (Object)ctx);
                if (fir2 instanceof FirResolvedTypeRef && (firTypeRef = ((FirResolvedTypeRef)fir2).getDelegatedTypeRef()) != null) {
                    firTypeRef.accept((FirVisitor)this, (Object)ctx);
                }
                ctx.setDepth(ctx.getDepth() - 1);
                return null;
            }
        }.visitElement(firElement, context);
        sb.append(String.join((CharSequence)"\n", lines));
        return sb.toString();
    }

    public static String printIrFile(@Nullable IrFile file) {
        if (file == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<StringBuilder> lines = new ArrayList<StringBuilder>();
        sb.append("------------").append("\n");
        sb.append("IrFile:").append("\n\n");
        TreePrinterContext context = new TreePrinterContext(lines, 1);
        new IrTreePrinterVisitor(new IrPrinter()).visitFile(file, context);
        sb.append(String.join((CharSequence)"\n", lines));
        return sb.toString();
    }

    private static String printType(Tree tree) {
        J.Identifier id;
        J.VariableDeclarations.NamedVariable v;
        J.MethodInvocation m;
        JavaType type;
        StringBuilder sb = new StringBuilder();
        if (tree instanceof TypedTree && (type = ((TypedTree)tree).getType()) != null && !(type instanceof JavaType.Unknown)) {
            sb.append(type);
        }
        if (tree instanceof J.MethodInvocation && (m = (J.MethodInvocation)tree).getMethodType() != null) {
            sb.append(" MethodType = ").append(m.getMethodType());
        }
        if (tree instanceof J.MethodDeclaration && (m = (J.MethodDeclaration)tree).getMethodType() != null) {
            sb.append(" MethodType = ").append(m.getMethodType());
        }
        if (tree instanceof J.VariableDeclarations.NamedVariable && (v = (J.VariableDeclarations.NamedVariable)tree).getVariableType() != null) {
            sb.append(" VariableType = ").append(v.getVariableType());
        }
        if (tree instanceof J.Identifier && (id = (J.Identifier)tree).getFieldType() != null) {
            sb.append(" FieldType = ").append(id.getFieldType());
        }
        return sb.toString();
    }

    private static String printTreeElement(Tree tree) {
        if (tree instanceof J.CompilationUnit || tree instanceof J.ClassDeclaration || tree instanceof J.Block || tree instanceof J.Empty || tree instanceof J.Try || tree instanceof J.Try.Catch || tree instanceof J.ForLoop || tree instanceof J.WhileLoop || tree instanceof J.DoWhileLoop || tree instanceof J.Lambda || tree instanceof J.Lambda.Parameters || tree instanceof J.If || tree instanceof J.If.Else || tree instanceof J.EnumValueSet || tree instanceof J.TypeParameter || tree instanceof K.ClassDeclaration || tree instanceof K.CompilationUnit || tree instanceof K.SpreadArgument || tree instanceof K.StatementExpression || tree instanceof K.KString || tree instanceof K.KString.Value || tree instanceof K.ExpressionStatement || tree instanceof K.FunctionType || tree instanceof K.ListLiteral || tree instanceof K.When || tree instanceof J.Package || tree instanceof J.ForEachLoop) {
            return "";
        }
        if (tree instanceof J.Literal) {
            String s = ((J.Literal)tree).getValueSource();
            return s != null ? s : "";
        }
        String[] lines = tree.toString().split("\n");
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            output.append(lines[i].trim());
            if (i >= lines.length - 1) continue;
            output.append(" ");
        }
        return output.toString();
    }

    private static String printSpace(Space space) {
        String sb = " whitespace=\"" + space.getWhitespace() + "\" comments=\"" + space.getComments().stream().map(c -> c.printComment(new Cursor(null, (Object)"root"))).collect(Collectors.joining(",")) + "\"";
        return sb.replace("\n", "\\s\n");
    }

    public static String printJTree(Tree tree) {
        TreeVisitingPrinter visitor = new TreeVisitingPrinter(true, true);
        visitor.visit(tree, (ExecutionContext)new InMemoryExecutionContext());
        return visitor.print();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String printIrElement(IrElement element) {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(element.getStartOffset()).append(",").append(element.getEndOffset()).append(") | ").append(element.getClass().getSimpleName());
        if (element instanceof IrMetadataSourceOwner) {
            IrMetadataSourceOwner irMetadataSourceOwner;
            MetadataSource metadata;
            String typeFromIr = PsiTreePrinter.getType(element);
            if (!typeFromIr.isEmpty()) {
                sb.append(" | IrType = ").append(typeFromIr);
            }
            if ((metadata = (irMetadataSourceOwner = (IrMetadataSourceOwner)element).getMetadata()) == null) return sb.toString();
            if (!(metadata instanceof FirMetadataSource)) throw new UnsupportedOperationException("TODO");
            FirMetadataSource firMetadataSource = (FirMetadataSource)irMetadataSourceOwner.getMetadata();
            FirDeclaration firDeclaration = firMetadataSource.getFir();
            if (firDeclaration == null) return sb.toString();
            sb.append(" | ").append(PsiTreePrinter.printFirElement((FirElement)firDeclaration));
            return sb.toString();
        } else {
            if (!(element instanceof IrConst)) return sb.toString();
            IrConst irConst = (IrConst)element;
            sb.append(" | ").append(irConst.getValue());
        }
        return sb.toString();
    }

    public static String getType(IrElement element) {
        return irTypeMapping.type(element).toString();
    }

    public static String printFirElement(FirElement firElement) {
        String firValue;
        StringBuilder sb = new StringBuilder();
        sb.append(firElement.getClass().getSimpleName());
        if (firElement.getSource() != null) {
            KtSourceElement source = firElement.getSource();
            sb.append(" | ");
            if (source instanceof KtRealPsiSourceElement) {
                sb.append("Real ");
            } else if (source instanceof KtFakeSourceElement) {
                sb.append("Fake ");
            } else {
                sb.append(source.getClass().getSimpleName());
            }
            sb.append("PSI(").append("[").append(source.getStartOffset()).append(",").append(source.getEndOffset()).append("]").append(" ").append(source.getElementType()).append(")");
        }
        if ((firValue = PsiTreePrinter.firElementToString(firElement)) != null && !firValue.isEmpty()) {
            sb.append(" | ").append(firValue);
        }
        return sb.toString();
    }

    private static String printConeKotlinType(ConeTypeProjection coneKotlinType) {
        StringBuilder sb = new StringBuilder();
        sb.append("Type:[").append(coneKotlinType);
        if (coneKotlinType instanceof ConeClassLikeType) {
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
            ConeClassLikeLookupTag coneClassLikeLookupTag = coneClassLikeType.getLookupTag();
            ClassId classId = coneClassLikeLookupTag.getClassId();
            FqName packageFqName = classId.getPackageFqName();
            sb.append(" packageFqName: ").append(packageFqName);
            FqName className = classId.getRelativeClassName();
            sb.append(" className: ").append(className);
            coneClassLikeLookupTag.getName();
            ConeTypeProjection[] typeArguments = coneClassLikeType.getTypeArguments();
            if (typeArguments != null && typeArguments.length > 0) {
                sb.append(" typeArgument: ");
                for (ConeTypeProjection typeArgument : typeArguments) {
                    sb.append(PsiTreePrinter.printConeKotlinType(typeArgument));
                }
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Nullable
    public static String firElementToString(FirElement firElement) {
        if (firElement instanceof FirFile) {
            return ((FirFile)firElement).getName();
        }
        if (firElement instanceof FirProperty) {
            return ((FirProperty)firElement).getName().toString();
        }
        if (firElement instanceof FirResolvedTypeRef) {
            FirResolvedTypeRef resolvedTypeRef = (FirResolvedTypeRef)firElement;
            ConeKotlinType coneKotlinType = resolvedTypeRef.getType();
            return PsiTreePrinter.printConeKotlinType((ConeTypeProjection)coneKotlinType);
        }
        if (firElement instanceof FirResolvedNamedReference) {
            return ((FirResolvedNamedReference)firElement).getName().toString();
        }
        if (firElement instanceof FirFunctionCall) {
            FirFunctionCall functionCall = (FirFunctionCall)firElement;
            if (functionCall.getExplicitReceiver() != null) {
                return PsiTreePrinter.firElementToString((FirElement)functionCall.getExplicitReceiver()) + "." + ((FirFunctionCall)firElement).getCalleeReference().getName() + "(" + PsiTreePrinter.firElementToString((FirElement)((FirFunctionCall)firElement).getArgumentList()) + ")";
            }
            return ((FirFunctionCall)firElement).getCalleeReference().getName() + "(" + PsiTreePrinter.firElementToString((FirElement)((FirFunctionCall)firElement).getArgumentList()) + ")";
        }
        if (firElement instanceof FirArgumentList) {
            List args = ((FirArgumentList)firElement).getArguments();
            if (!args.isEmpty()) {
                boolean first = true;
                StringBuilder sb = new StringBuilder();
                for (FirExpression arg : args) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(PsiTreePrinter.firElementToString((FirElement)arg));
                    first = false;
                }
                return sb.toString();
            }
        } else {
            if (firElement instanceof FirConstExpression) {
                Object value = ((FirConstExpression)firElement).getValue();
                return value != null ? value.toString() : null;
            }
            if (firElement instanceof FirWhenBranch) {
                FirWhenBranch whenBranch = (FirWhenBranch)firElement;
                return "when(" + PsiTreePrinter.firElementToString((FirElement)whenBranch.getCondition()) + ") -> " + PsiTreePrinter.firElementToString((FirElement)whenBranch.getResult());
            }
            if (firElement.getClass().getSimpleName().equals("FirElseIfTrueCondition")) {
                return PsiElementAssociations.Companion.printElement(firElement);
            }
            if (firElement.getClass().getSimpleName().equals("FirSingleExpressionBlock")) {
                return PsiElementAssociations.Companion.printElement(firElement);
            }
        }
        return "";
    }

    public static String printIndexedSourceCode(String sourceCode) {
        int count = 0;
        String[] lines = sourceCode.split("\n");
        StringBuilder sb = new StringBuilder();
        sb.append("------------").append("\n");
        sb.append("Source code with index:").append("\n\n");
        ArrayDeque<Integer> digits = new ArrayDeque<Integer>();
        for (String line : lines) {
            StringBuilder spacesSb = new StringBuilder();
            for (int i = 0; i < line.length(); ++i) {
                if (count % 10 == 0) {
                    String numStr = Integer.toString(count);
                    for (int j = 0; j < numStr.length(); ++j) {
                        char c = numStr.charAt(j);
                        int digit = Character.getNumericValue(c);
                        digits.add(digit);
                    }
                }
                if (!digits.isEmpty()) {
                    spacesSb.append(digits.poll());
                } else {
                    spacesSb.append(" ");
                }
                ++count;
            }
            sb.append(line).append("\n").append((CharSequence)spacesSb).append("\n");
            ++count;
        }
        return sb.toString();
    }

    private String toString(PsiElement psiElement) {
        return psiElement.getTextRange() + " | " + psiElement.getNode().getElementType() + " | " + psiElement.getClass().getSimpleName() + " | Text: \"" + PsiTreePrinter.truncate(psiElement.getText()).replace("\n", "\\n").replace("\r", "\\r") + "\"";
    }

    private void printSkeletonNode(PsiElement psiElement, int depth) {
        StringBuilder line = new StringBuilder();
        line.append(PsiTreePrinter.leftPadding(depth)).append(this.toString(psiElement));
        this.connectToLatestSibling(depth);
        this.outputLines.add(line);
        for (PsiElement childNode : psiElement.getChildren()) {
            this.printSkeletonNode(childNode, depth + 1);
        }
    }

    private void printNode(PsiElement psiElement, int depth) {
        StringBuilder line = new StringBuilder();
        line.append(PsiTreePrinter.leftPadding(depth)).append(this.toString(psiElement));
        this.connectToLatestSibling(depth);
        this.outputLines.add(line);
        PsiUtilsKt.getAllChildren((PsiElement)psiElement);
        for (PsiElement it : PsiUtilsKt.getAllChildren((PsiElement)psiElement)) {
            this.printNode(it, depth + 1);
        }
    }

    private static void collectCovered(PsiElement psiElement, Set<TextRange> covered) {
        covered.add(psiElement.getTextRange());
        for (PsiElement childNode : psiElement.getChildren()) {
            PsiTreePrinter.collectCovered(childNode, covered);
        }
    }

    private static String leftPadding(int depth) {
        StringBuilder sb = new StringBuilder();
        int tabCount = depth - 1;
        if (tabCount > 0) {
            sb.append(String.join((CharSequence)"", Collections.nCopies(tabCount, TAB)));
        }
        if (depth > 0) {
            sb.append(ELEMENT_PREFIX);
        }
        return sb.toString();
    }

    private void connectToLatestSibling(int depth) {
        StringBuilder line;
        if (depth <= 1) {
            return;
        }
        int pos = (depth - 1) * TAB.length();
        for (int i = this.outputLines.size() - 1; i > 0 && pos < (line = this.outputLines.get(i)).length(); --i) {
            if (line.charAt(pos) != ' ') {
                if (line.charAt(pos) != '\\') break;
                line.setCharAt(pos, '|');
                break;
            }
            line.setCharAt(pos, '|');
        }
    }

    private static void connectToLatestSibling(int depth, List<StringBuilder> lines) {
        StringBuilder line;
        if (depth <= 1) {
            return;
        }
        int pos = (depth - 1) * TAB.length();
        for (int i = lines.size() - 1; i > 0 && pos < (line = lines.get(i)).length(); --i) {
            if (line.charAt(pos) != ' ') {
                if (line.charAt(pos) != '\\') break;
                line.setCharAt(pos, '|');
                break;
            }
            line.setCharAt(pos, '|');
        }
    }

    private static String truncate(String content) {
        if (content.length() > 200) {
            return content.substring(0, 197) + "...";
        }
        return content;
    }

    public static class TreePrinterContext {
        List<StringBuilder> lines;
        int depth;

        public TreePrinterContext(List<StringBuilder> lines, int depth) {
            this.lines = lines;
            this.depth = depth;
        }

        public List<StringBuilder> getLines() {
            return this.lines;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setLines(List<StringBuilder> lines) {
            this.lines = lines;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TreePrinterContext)) {
                return false;
            }
            TreePrinterContext other = (TreePrinterContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDepth() != other.getDepth()) {
                return false;
            }
            List<StringBuilder> this$lines = this.getLines();
            List<StringBuilder> other$lines = other.getLines();
            return !(this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TreePrinterContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDepth();
            List<StringBuilder> $lines = this.getLines();
            result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
            return result;
        }

        public String toString() {
            return "PsiTreePrinter.TreePrinterContext(lines=" + this.getLines() + ", depth=" + this.getDepth() + ")";
        }
    }

    public static class IrPrinter {
        public void printElement(@NotNull IrElement element, @NotNull TreePrinterContext ctx) {
            StringBuilder line = new StringBuilder();
            line.append(PsiTreePrinter.leftPadding(ctx.getDepth())).append(PsiTreePrinter.printIrElement(element));
            PsiTreePrinter.connectToLatestSibling(ctx.getDepth(), ctx.getLines());
            ctx.getLines().add(line);
        }
    }

    static class TreeVisitingPrinter
    extends TreeVisitor<Tree, ExecutionContext> {
        private List<Object> lastCursorStack = new ArrayList<Object>();
        private final List<StringBuilder> outputLines = new ArrayList<StringBuilder>();
        private final boolean skipUnvisitedElement;
        private final boolean printContent;

        public TreeVisitingPrinter(boolean skipUnvisitedElement, boolean printContent) {
            this.skipUnvisitedElement = skipUnvisitedElement;
            this.printContent = printContent;
        }

        public String print() {
            return String.join((CharSequence)"\n", this.outputLines);
        }

        @Nullable
        public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            String content;
            String typeName;
            if (tree == null) {
                return super.visit((Tree)null, (Object)ctx);
            }
            Cursor cursor = this.getCursor();
            List cursorStack = StreamSupport.stream(Spliterators.spliteratorUnknownSize(cursor.getPath(), 0), false).collect(Collectors.toList());
            Collections.reverse(cursorStack);
            int depth = cursorStack.size();
            int diffPos = -1;
            for (int i = 0; i < cursorStack.size(); ++i) {
                if (i < this.lastCursorStack.size() && cursorStack.get(i) == this.lastCursorStack.get(i)) continue;
                diffPos = i;
                break;
            }
            StringBuilder line = new StringBuilder();
            if (diffPos >= 0) {
                for (int i = diffPos; i < cursorStack.size(); ++i) {
                    Object element = cursorStack.get(i);
                    if (this.skipUnvisitedElement) {
                        if (i == diffPos) {
                            line.append(PsiTreePrinter.leftPadding(i));
                            PsiTreePrinter.connectToLatestSibling(i, this.outputLines);
                            continue;
                        }
                        line.append(PsiTreePrinter.CONTINUE_PREFIX);
                        continue;
                    }
                    PsiTreePrinter.connectToLatestSibling(i, this.outputLines);
                    StringBuilder newLine = new StringBuilder().append(PsiTreePrinter.leftPadding(i)).append(PsiTreePrinter.UNVISITED_PREFIX).append(element instanceof String ? element : element.getClass().getSimpleName());
                    if (element instanceof JRightPadded) {
                        JRightPadded rp = (JRightPadded)element;
                        newLine.append(" | ");
                        newLine.append(" after = ").append(PsiTreePrinter.printSpace(rp.getAfter()));
                    }
                    if (element instanceof JLeftPadded) {
                        JLeftPadded lp = (JLeftPadded)element;
                        newLine.append(" | ");
                        newLine.append(" before = ").append(PsiTreePrinter.printSpace(lp.getBefore()));
                    }
                    this.outputLines.add(newLine);
                }
            }
            String string = typeName = tree instanceof J ? tree.getClass().getCanonicalName().substring(tree.getClass().getPackage().getName().length() + 1) : tree.getClass().getCanonicalName();
            if (this.skipUnvisitedElement) {
                boolean leftPadded;
                boolean bl = leftPadded = diffPos >= 0;
                if (leftPadded) {
                    line.append(PsiTreePrinter.CONTINUE_PREFIX);
                } else {
                    PsiTreePrinter.connectToLatestSibling(depth, this.outputLines);
                    line.append(PsiTreePrinter.leftPadding(depth));
                }
                line.append(typeName);
            } else {
                PsiTreePrinter.connectToLatestSibling(depth, this.outputLines);
                line.append(PsiTreePrinter.leftPadding(depth)).append(typeName);
            }
            String type = PsiTreePrinter.printType(tree);
            if (!type.isEmpty()) {
                line.append(" | TYPE = ").append(type);
            }
            if (this.printContent && !(content = PsiTreePrinter.truncate(PsiTreePrinter.printTreeElement(tree))).isEmpty()) {
                line.append(" | \"").append(content).append("\"");
            }
            this.outputLines.add(line);
            cursorStack.add(tree);
            this.lastCursorStack = cursorStack;
            return super.visit(tree, (Object)ctx);
        }
    }
}

