/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.marker.AnnotationUseSite;
import org.openrewrite.kotlin.marker.AnonymousFunction;
import org.openrewrite.kotlin.marker.By;
import org.openrewrite.kotlin.marker.Extension;
import org.openrewrite.kotlin.marker.Implicit;
import org.openrewrite.kotlin.marker.IndexedAccess;
import org.openrewrite.kotlin.marker.IsNullSafe;
import org.openrewrite.kotlin.marker.IsNullable;
import org.openrewrite.kotlin.marker.KObject;
import org.openrewrite.kotlin.marker.LogicalComma;
import org.openrewrite.kotlin.marker.Modifier;
import org.openrewrite.kotlin.marker.NotIs;
import org.openrewrite.kotlin.marker.OmitBraces;
import org.openrewrite.kotlin.marker.OmitEquals;
import org.openrewrite.kotlin.marker.PrimaryConstructor;
import org.openrewrite.kotlin.marker.Semicolon;
import org.openrewrite.kotlin.marker.SingleExpressionBlock;
import org.openrewrite.kotlin.marker.TrailingLambdaArgument;
import org.openrewrite.kotlin.marker.TypeReferencePrefix;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.kotlin.tree.KContainer;
import org.openrewrite.kotlin.tree.KRightPadded;
import org.openrewrite.kotlin.tree.KSpace;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class KotlinPrinter<P>
extends KotlinVisitor<PrintOutputCapture<P>> {
    private final KotlinJavaPrinter<P> delegate = this.delegate();
    private static final UnaryOperator<String> JAVA_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    protected KotlinJavaPrinter<P> delegate() {
        return new KotlinJavaPrinter(this);
    }

    public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
        if (!(tree instanceof K)) {
            return this.delegate.visit(tree, p);
        }
        return (J)super.visit(tree, p);
    }

    @Override
    public J visitCompilationUnit(K.CompilationUnit sourceFile, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)sourceFile, Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visit(sourceFile.getAnnotations(), p);
        JRightPadded<J.Package> pkg = sourceFile.getPadding().getPackageDeclaration();
        if (pkg != null) {
            this.visitRightPadded(pkg, p);
        }
        for (JRightPadded<J.Import> jRightPadded : sourceFile.getPadding().getImports()) {
            this.visitRightPadded(jRightPadded, p);
        }
        for (JRightPadded<J.Import> jRightPadded : sourceFile.getPadding().getStatements()) {
            this.visitRightPadded(jRightPadded, p);
        }
        this.visitSpace(sourceFile.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        this.afterSyntax(sourceFile, p);
        return sourceFile;
    }

    @Override
    public J visitAnnotatedExpression(K.AnnotatedExpression annotatedExpression, PrintOutputCapture<P> p) {
        this.visit(annotatedExpression.getAnnotations(), p);
        this.visit((Tree)annotatedExpression.getExpression(), p);
        this.afterSyntax(annotatedExpression, p);
        return annotatedExpression;
    }

    @Override
    public J visitBinary(K.Binary binary, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)binary, Space.Location.BINARY_PREFIX, p);
        String keyword = "";
        switch (binary.getOperator()) {
            case Contains: {
                keyword = "in";
                break;
            }
            case Elvis: {
                keyword = "?:";
                break;
            }
            case NotContains: {
                keyword = "!in";
                break;
            }
            case IdentityEquals: {
                keyword = "===";
                break;
            }
            case IdentityNotEquals: {
                keyword = "!==";
                break;
            }
            case RangeTo: {
                keyword = "..";
                break;
            }
            case RangeUntil: {
                keyword = "..<";
            }
        }
        this.visit((Tree)binary.getLeft(), p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), KSpace.Location.BINARY_OPERATOR, p);
        p.append(keyword);
        this.visit((Tree)binary.getRight(), p);
        this.visitSpace(binary.getAfter(), KSpace.Location.BINARY_SUFFIX, p);
        this.afterSyntax(binary, p);
        return binary;
    }

    @Override
    public J visitClassDeclaration(K.ClassDeclaration classDeclaration, PrintOutputCapture<P> p) {
        return ((KotlinJavaPrinter)this.delegate).visitClassDeclaration0(classDeclaration.getClassDeclaration(), classDeclaration.getTypeConstraints(), p);
    }

    @Override
    public J visitConstructor(K.Constructor constructor, PrintOutputCapture<P> p) {
        J.MethodDeclaration method = constructor.getMethodDeclaration();
        this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
        this.visit(method.getLeadingAnnotations(), p);
        for (J.Modifier m : method.getModifiers()) {
            this.delegate.visitModifier(m, p);
        }
        JContainer params = method.getPadding().getParameters();
        this.beforeSyntax(params.getBefore(), params.getMarkers(), JContainer.Location.METHOD_DECLARATION_PARAMETERS.getBeforeLocation(), p);
        p.append("(");
        List elements = params.getPadding().getElements();
        for (int i = 0; i < elements.size(); ++i) {
            ((KotlinJavaPrinter)this.delegate).printMethodParameters(p, i, elements);
        }
        this.afterSyntax(params.getMarkers(), p);
        p.append(")");
        this.visitSpace(constructor.getColon(), KSpace.Location.CONSTRUCTOR_COLON, p);
        p.append(':');
        this.visit((Tree)constructor.getConstructorInvocation(), p);
        this.afterSyntax(constructor, p);
        this.visit((Tree)method.getBody(), p);
        return constructor;
    }

    @Override
    public J visitConstructorInvocation(K.ConstructorInvocation constructorInvocation, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)constructorInvocation, KSpace.Location.CONSTRUCTOR_INVOCATION_PREFIX, p);
        this.visit((Tree)constructorInvocation.getTypeTree(), p);
        ((KotlinJavaPrinter)this.delegate).visitArgumentsContainer((JContainer<Expression>)constructorInvocation.getPadding().getArguments(), Space.Location.METHOD_INVOCATION_ARGUMENTS, p);
        this.afterSyntax(constructorInvocation, p);
        return constructorInvocation;
    }

    @Override
    public J visitDelegatedSuperType(K.DelegatedSuperType delegatedSuperType, PrintOutputCapture<P> p) {
        this.visit((Tree)delegatedSuperType.getTypeTree(), p);
        this.visitSpace(delegatedSuperType.getBy(), KSpace.Location.DELEGATED_SUPER_TYPE_BY, p);
        p.append("by");
        this.visit((Tree)delegatedSuperType.getDelegate(), p);
        this.afterSyntax(delegatedSuperType, p);
        return delegatedSuperType;
    }

    @Override
    public J visitDestructuringDeclaration(K.DestructuringDeclaration destructuringDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)destructuringDeclaration, KSpace.Location.DESTRUCTURING_DECLARATION_PREFIX, p);
        this.visit(destructuringDeclaration.getInitializer().getLeadingAnnotations(), p);
        for (J.Modifier m : destructuringDeclaration.getInitializer().getModifiers()) {
            this.delegate.visitModifier(m, p);
            if (!m.getType().equals((Object)J.Modifier.Type.Final)) continue;
            p.append("val");
        }
        this.visitSpace(destructuringDeclaration.getPadding().getDestructAssignments().getBefore(), Space.Location.LANGUAGE_EXTENSION, p);
        p.append("(");
        List elements = destructuringDeclaration.getPadding().getDestructAssignments().getPadding().getElements();
        for (int i = 0; i < elements.size(); ++i) {
            JRightPadded element = (JRightPadded)elements.get(i);
            this.visit((Tree)element.getElement(), p);
            this.visitSpace(element.getAfter(), Space.Location.LANGUAGE_EXTENSION, p);
            this.visitMarkers(element.getMarkers(), p);
            p.append(i == elements.size() - 1 ? ")" : ",");
        }
        if (!destructuringDeclaration.getInitializer().getVariables().isEmpty() && ((J.VariableDeclarations.NamedVariable)destructuringDeclaration.getInitializer().getVariables().get(0)).getPadding().getInitializer() != null) {
            this.visitSpace(Objects.requireNonNull(((J.VariableDeclarations.NamedVariable)destructuringDeclaration.getInitializer().getVariables().get(0)).getPadding().getInitializer()).getBefore(), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("=");
            this.visit((Tree)Objects.requireNonNull(((J.VariableDeclarations.NamedVariable)destructuringDeclaration.getInitializer().getVariables().get(0)).getPadding().getInitializer()).getElement(), p);
        }
        this.afterSyntax(destructuringDeclaration, p);
        return destructuringDeclaration;
    }

    @Override
    public J visitFunctionType(K.FunctionType functionType2, PrintOutputCapture<P> p) {
        boolean nullable = functionType2.getMarkers().findFirst(IsNullable.class).isPresent();
        this.beforeSyntax((K)functionType2, KSpace.Location.FUNCTION_TYPE_PREFIX, p);
        if (nullable) {
            p.append("(");
        }
        this.visit(functionType2.getLeadingAnnotations(), p);
        for (J.Modifier modifier : functionType2.getModifiers()) {
            this.delegate.visitModifier(modifier, p);
        }
        if (functionType2.getReceiver() != null) {
            this.visitRightPadded(functionType2.getReceiver(), p);
            p.append(".");
        }
        this.delegate.visitContainer("(", functionType2.getPadding().getParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ")", p);
        this.visitSpace(functionType2.getArrow() != null ? functionType2.getArrow() : Space.SINGLE_SPACE, KSpace.Location.FUNCTION_TYPE_ARROW_PREFIX, p);
        p.append("->");
        this.visitRightPadded(functionType2.getReturnType(), p);
        if (nullable) {
            p.append(")");
        }
        this.afterSyntax(functionType2, p);
        return functionType2;
    }

    @Override
    public J visitFunctionTypeParameter(K.FunctionType.Parameter parameter, PrintOutputCapture<P> p) {
        if (parameter.getName() != null) {
            this.visit((Tree)parameter.getName(), p);
            parameter.getMarkers().findFirst(TypeReferencePrefix.class).ifPresent(tref -> this.visitSpace(tref.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p));
            p.append(":");
        }
        this.visit((Tree)parameter.getParameterType(), p);
        return parameter;
    }

    @Override
    public J visitKReturn(K.KReturn kReturn, PrintOutputCapture<P> p) {
        J.Return return_ = kReturn.getExpression();
        if (kReturn.getLabel() != null) {
            this.beforeSyntax((J)return_, Space.Location.RETURN_PREFIX, p);
            p.append("return");
            p.append("@");
            this.visit((Tree)kReturn.getLabel(), p);
            if (return_.getExpression() != null) {
                this.visit((Tree)return_.getExpression(), p);
            }
            this.afterSyntax((J)return_, p);
        } else {
            this.visit((Tree)kReturn.getExpression(), p);
        }
        return kReturn;
    }

    @Override
    public J visitKString(K.KString kString, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)kString, KSpace.Location.KSTRING_PREFIX, p);
        String delimiter = kString.getDelimiter();
        p.append(delimiter);
        this.visit(kString.getStrings(), p);
        p.append(delimiter);
        this.afterSyntax(kString, p);
        return kString;
    }

    @Override
    public J visitKThis(K.KThis kThis, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)kThis, KSpace.Location.KTHIS_PREFIX, p);
        p.append("this");
        if (kThis.getLabel() != null) {
            p.append("@");
            this.visit((Tree)kThis.getLabel(), p);
        }
        this.afterSyntax(kThis, p);
        return kThis;
    }

    @Override
    public J visitKStringValue(K.KString.Value value, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)value, KSpace.Location.KSTRING_PREFIX, p);
        if (value.isEnclosedInBraces()) {
            p.append("${");
        } else {
            p.append("$");
        }
        this.visit((Tree)value.getTree(), p);
        if (value.isEnclosedInBraces()) {
            this.visitSpace(value.getAfter(), KSpace.Location.KSTRING_SUFFIX, p);
            p.append('}');
        }
        this.afterSyntax(value, p);
        return value;
    }

    @Override
    public J visitListLiteral(K.ListLiteral listLiteral, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)listLiteral, KSpace.Location.LIST_LITERAL_PREFIX, p);
        this.visitContainer("[", listLiteral.getPadding().getElements(), KContainer.Location.LIST_LITERAL_ELEMENTS, "]", p);
        this.afterSyntax(listLiteral, p);
        return listLiteral;
    }

    @Override
    public J visitMethodDeclaration(K.MethodDeclaration methodDeclaration, PrintOutputCapture<P> p) {
        return ((KotlinJavaPrinter)this.delegate).visitMethodDeclaration0(methodDeclaration.getMethodDeclaration(), methodDeclaration.getTypeConstraints(), p);
    }

    public J visitParenthesizedTypeTree(J.ParenthesizedTypeTree parTree, PrintOutputCapture<P> p) {
        this.visitSpace(parTree.getPrefix(), Space.Location.PARENTHESES_PREFIX, p);
        this.visitParentheses(parTree.getParenthesizedType(), p);
        return parTree;
    }

    @Override
    public J visitProperty(K.Property property, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)property, KSpace.Location.PROPERTY_PREFIX, p);
        J.VariableDeclarations vd = property.getVariableDeclarations();
        this.visit(vd.getLeadingAnnotations(), p);
        for (J.Modifier m : vd.getModifiers()) {
            this.delegate.visitModifier(m, p);
            if (!m.getType().equals((Object)J.Modifier.Type.Final)) continue;
            p.append("val");
        }
        this.delegate.visitContainer("<", property.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
        Extension extension = vd.getMarkers().findFirst(Extension.class).orElse(null);
        if (extension != null && property.getReceiver() != null) {
            this.visitRightPadded(property.getPadding().getReceiver(), p);
            p.append(".");
        }
        if (!vd.getVariables().isEmpty()) {
            J.VariableDeclarations.NamedVariable nv = (J.VariableDeclarations.NamedVariable)vd.getVariables().get(0);
            this.beforeSyntax((J)nv, Space.Location.VARIABLE_PREFIX, p);
            this.visit((Tree)nv.getName(), p);
            if (vd.getTypeExpression() != null) {
                vd.getMarkers().findFirst(TypeReferencePrefix.class).ifPresent(tref -> this.visitSpace(tref.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p));
                p.append(":");
                this.visit((Tree)vd.getTypeExpression(), p);
            }
            if (nv.getInitializer() != null) {
                String equals = KotlinPrinter.getEqualsText(vd);
                this.visitSpace(Objects.requireNonNull(nv.getPadding().getInitializer()).getBefore(), Space.Location.VARIABLE_INITIALIZER, p);
                p.append(equals);
            }
            this.visit((Tree)nv.getInitializer(), p);
        }
        if (property.getTypeConstraints() != null) {
            this.delegate.visitContainer("where", property.getTypeConstraints().getPadding().getConstraints(), JContainer.Location.TYPE_PARAMETERS, ",", "", p);
        }
        if (property.isSetterFirst()) {
            this.visit((Tree)property.getSetter(), p);
            this.visit((Tree)property.getGetter(), p);
        } else {
            this.visit((Tree)property.getGetter(), p);
            this.visit((Tree)property.getSetter(), p);
        }
        this.afterSyntax(property, p);
        return property;
    }

    @Override
    public J visitSpreadArgument(K.SpreadArgument spreadArgument, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)spreadArgument, KSpace.Location.SPREAD_ARGUMENT_PREFIX, p);
        p.append("*");
        this.visit((Tree)spreadArgument.getExpression(), p);
        this.afterSyntax(spreadArgument, p);
        return spreadArgument;
    }

    @Override
    public J visitUnary(K.Unary unary, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)unary, Space.Location.UNARY_PREFIX, p);
        switch (unary.getOperator()) {
            default: 
        }
        this.visit((Tree)unary.getExpression(), p);
        this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
        p.append("!!");
        this.afterSyntax(unary, p);
        return unary;
    }

    @Override
    public J visitWhen(K.When when, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)when, KSpace.Location.WHEN_PREFIX, p);
        p.append("when");
        this.visit((Tree)when.getSelector(), p);
        this.visit((Tree)when.getBranches(), p);
        this.afterSyntax(when, p);
        return when;
    }

    @Override
    public J visitWhenBranch(K.WhenBranch whenBranch, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)whenBranch, KSpace.Location.WHEN_BRANCH_PREFIX, p);
        this.visitContainer("", whenBranch.getPadding().getExpressions(), KContainer.Location.WHEN_BRANCH_EXPRESSION, "->", p);
        this.visit((Tree)whenBranch.getBody(), p);
        this.afterSyntax(whenBranch, p);
        return whenBranch;
    }

    @NotNull
    private static String getClassKind(J.ClassDeclaration classDecl) {
        String kind;
        if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Class || classDecl.getKind() == J.ClassDeclaration.Kind.Type.Enum || classDecl.getKind() == J.ClassDeclaration.Kind.Type.Annotation) {
            kind = "class";
        } else if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
            kind = "interface";
        } else {
            throw new UnsupportedOperationException("Class kind is not supported: " + classDecl.getKind());
        }
        return kind;
    }

    private void trailingMarkers(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            if (!(marker instanceof IsNullable)) continue;
            this.visitSpace(((IsNullable)marker).getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p);
            p.append("?");
        }
    }

    @Override
    public Space visitSpace(Space space, KSpace.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, loc, p);
    }

    protected void visitContainer(String before, @Nullable JContainer<? extends J> container, KContainer.Location location, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), p);
        p.append(after == null ? "" : after);
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, KRightPadded.Location location, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(",");
        }
    }

    @Override
    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        return this.delegate.visitMarker(marker, p);
    }

    private void beforeSyntax(K k, KSpace.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(k.getPrefix(), k.getMarkers(), loc, p);
    }

    private void beforeSyntax(J j, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable KSpace.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void beforeSyntax(K k, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(k.getPrefix(), k.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.delegate.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(J j, PrintOutputCapture<P> p) {
        this.trailingMarkers(j.getMarkers(), p);
        this.afterSyntax(j.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    @NotNull
    private static String getEqualsText(J.VariableDeclarations vd) {
        String equals = "=";
        for (Marker marker : vd.getMarkers().getMarkers()) {
            if (marker instanceof By) {
                equals = "by";
                break;
            }
            if (!(marker instanceof OmitEquals)) continue;
            equals = "";
            break;
        }
        return equals;
    }

    public static class KotlinJavaPrinter<P>
    extends JavaPrinter<P> {
        KotlinPrinter<P> kotlinPrinter;

        public KotlinJavaPrinter(KotlinPrinter<P> kp) {
            this.kotlinPrinter = kp;
        }

        public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
            if (tree instanceof K) {
                return this.kotlinPrinter.visit(tree, p);
            }
            return (J)super.visit(tree, p);
        }

        public J visitAnnotation(J.Annotation annotation, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)annotation, Space.Location.ANNOTATION_PREFIX, p);
            boolean isKModifier = annotation.getMarkers().findFirst(Modifier.class).isPresent();
            if (!isKModifier) {
                p.append("@");
            }
            this.visit((Tree)annotation.getAnnotationType(), p);
            String beforeArgs = "(";
            String afterArgs = ")";
            String delimiter = ",";
            AnnotationUseSite useSite = annotation.getMarkers().findFirst(AnnotationUseSite.class).orElse(null);
            if (useSite != null) {
                this.kotlinPrinter.visitSpace(useSite.getPrefix(), KSpace.Location.ANNOTATION_CALL_SITE_PREFIX, p);
                p.append(":");
                if (!useSite.isImplicitBracket()) {
                    beforeArgs = "[";
                    afterArgs = "]";
                } else {
                    beforeArgs = "";
                    afterArgs = "";
                }
                delimiter = "";
            }
            this.visitContainer(beforeArgs, (JContainer<J>)annotation.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, delimiter, afterArgs, p);
            this.afterSyntax((J)annotation, p);
            return annotation;
        }

        public J visitBinary(J.Binary binary, PrintOutputCapture<P> p) {
            String keyword = "";
            switch (binary.getOperator()) {
                case Addition: {
                    keyword = "+";
                    break;
                }
                case Subtraction: {
                    keyword = "-";
                    break;
                }
                case Multiplication: {
                    keyword = "*";
                    break;
                }
                case Division: {
                    keyword = "/";
                    break;
                }
                case Modulo: {
                    keyword = "%";
                    break;
                }
                case LessThan: {
                    keyword = "<";
                    break;
                }
                case GreaterThan: {
                    keyword = ">";
                    break;
                }
                case LessThanOrEqual: {
                    keyword = "<=";
                    break;
                }
                case GreaterThanOrEqual: {
                    keyword = ">=";
                    break;
                }
                case Equal: {
                    keyword = "==";
                    break;
                }
                case NotEqual: {
                    keyword = "!=";
                    break;
                }
                case BitAnd: {
                    keyword = "and";
                    break;
                }
                case BitOr: {
                    keyword = "or";
                    break;
                }
                case BitXor: {
                    keyword = "xor";
                    break;
                }
                case LeftShift: {
                    keyword = "shl";
                    break;
                }
                case RightShift: {
                    keyword = "shr";
                    break;
                }
                case UnsignedRightShift: {
                    keyword = "ushr";
                    break;
                }
                case Or: {
                    keyword = binary.getMarkers().findFirst(LogicalComma.class).isPresent() ? "," : "||";
                    break;
                }
                case And: {
                    keyword = "&&";
                }
            }
            this.beforeSyntax((J)binary, Space.Location.BINARY_PREFIX, p);
            this.visit((Tree)binary.getLeft(), p);
            this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
            p.append(keyword);
            this.visit((Tree)binary.getRight(), p);
            this.afterSyntax((J)binary, p);
            return binary;
        }

        public J visitBlock(J.Block block, PrintOutputCapture<P> p) {
            boolean omitBraces;
            boolean singleExpressionBlock;
            this.beforeSyntax((J)block, Space.Location.BLOCK_PREFIX, p);
            if (block.isStatic()) {
                p.append("init");
                this.visitRightPadded(block.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, p);
            }
            if (singleExpressionBlock = block.getMarkers().findFirst(SingleExpressionBlock.class).isPresent()) {
                p.append("=");
            }
            if (!(omitBraces = block.getMarkers().findFirst(OmitBraces.class).isPresent())) {
                p.append("{");
            }
            this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
            this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
            if (!omitBraces) {
                p.append("}");
            }
            this.afterSyntax((J)block, p);
            return block;
        }

        public J visitBreak(J.Break breakStatement, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)breakStatement, Space.Location.BREAK_PREFIX, p);
            p.append("break");
            if (breakStatement.getLabel() != null) {
                p.append("@");
            }
            this.visit((Tree)breakStatement.getLabel(), p);
            this.afterSyntax((J)breakStatement, p);
            return breakStatement;
        }

        public void visitContainer(String before, @Nullable JContainer<? extends J> container, JContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
            super.visitContainer(before, container, location, suffixBetween, after, p);
        }

        public <J2 extends J> JContainer<J2> visitContainer(@Nullable JContainer<J2> container, JContainer.Location loc, PrintOutputCapture<P> pPrintOutputCapture) {
            return super.visitContainer(container, loc, pPrintOutputCapture);
        }

        public J visitClassDeclaration(J.ClassDeclaration classDecl, PrintOutputCapture<P> p) {
            return this.visitClassDeclaration0(classDecl, null, p);
        }

        @NotNull
        private J.ClassDeclaration visitClassDeclaration0(J.ClassDeclaration classDecl, @Nullable K.TypeConstraints typeConstraints, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)classDecl, Space.Location.CLASS_DECLARATION_PREFIX, p);
            this.visit(classDecl.getLeadingAnnotations(), p);
            for (J.Modifier m : classDecl.getModifiers()) {
                this.visitModifier(m, p);
            }
            String kind = KotlinPrinter.getClassKind(classDecl);
            this.visit(classDecl.getAnnotations().getKind().getAnnotations(), p);
            this.visitSpace(classDecl.getAnnotations().getKind().getPrefix(), Space.Location.CLASS_KIND, p);
            KObject KObject2 = classDecl.getMarkers().findFirst(KObject.class).orElse(null);
            if (KObject2 != null) {
                p.append("object");
                if (!classDecl.getName().getMarkers().findFirst(Implicit.class).isPresent()) {
                    this.visit((Tree)classDecl.getName(), p);
                }
            } else {
                p.append(kind);
                this.visit((Tree)classDecl.getName(), p);
            }
            this.visitContainer("<", (JContainer<J>)classDecl.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            if (classDecl.getMarkers().findFirst(PrimaryConstructor.class).isPresent()) {
                for (Statement statement : classDecl.getBody().getStatements()) {
                    if (!(statement instanceof J.MethodDeclaration) || !statement.getMarkers().findFirst(PrimaryConstructor.class).isPresent() || statement.getMarkers().findFirst(Implicit.class).isPresent()) continue;
                    J.MethodDeclaration method = (J.MethodDeclaration)statement;
                    this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
                    this.visit(method.getLeadingAnnotations(), p);
                    for (J.Modifier modifier : method.getModifiers()) {
                        this.visitModifier(modifier, p);
                    }
                    JContainer params = method.getPadding().getParameters();
                    this.beforeSyntax(params.getBefore(), params.getMarkers(), JContainer.Location.METHOD_DECLARATION_PARAMETERS.getBeforeLocation(), p);
                    p.append("(");
                    List elements = params.getPadding().getElements();
                    for (int i = 0; i < elements.size(); ++i) {
                        this.printMethodParameters(p, i, elements);
                    }
                    this.afterSyntax(params.getMarkers(), p);
                    p.append(")");
                    this.afterSyntax((J)method, p);
                    break;
                }
            }
            if (classDecl.getImplements() != null) {
                JContainer container = classDecl.getPadding().getImplements();
                this.beforeSyntax(Objects.requireNonNull(container).getBefore(), container.getMarkers(), JContainer.Location.IMPLEMENTS.getBeforeLocation(), p);
                p.append(":");
                List nodes = container.getPadding().getElements();
                for (int i = 0; i < nodes.size(); ++i) {
                    JRightPadded node = (JRightPadded)nodes.get(i);
                    J element = (J)node.getElement();
                    this.visit((Tree)element, p);
                    this.visitSpace(node.getAfter(), JContainer.Location.IMPLEMENTS.getElementLocation().getAfterLocation(), p);
                    this.visitMarkers(node.getMarkers(), p);
                    if (i >= nodes.size() - 1) continue;
                    p.append(",");
                }
                this.afterSyntax(container.getMarkers(), p);
            }
            if (typeConstraints != null) {
                this.visitContainer("where", typeConstraints.getPadding().getConstraints(), JContainer.Location.TYPE_PARAMETERS, ",", "", p);
            }
            if (!classDecl.getBody().getMarkers().findFirst(OmitBraces.class).isPresent()) {
                this.visit((Tree)classDecl.getBody(), p);
            }
            this.afterSyntax((J)classDecl, p);
            return classDecl;
        }

        public J visitContinue(J.Continue continueStatement, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)continueStatement, Space.Location.CONTINUE_PREFIX, p);
            p.append("continue");
            if (continueStatement.getLabel() != null) {
                p.append("@");
            }
            this.visit((Tree)continueStatement.getLabel(), p);
            this.afterSyntax((J)continueStatement, p);
            return continueStatement;
        }

        public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)fieldAccess, Space.Location.FIELD_ACCESS_PREFIX, p);
            this.visit((Tree)fieldAccess.getTarget(), p);
            String prefix = fieldAccess.getMarkers().findFirst(IsNullSafe.class).isPresent() ? "?." : ".";
            this.visitLeftPadded(prefix, fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
            this.afterSyntax((J)fieldAccess, p);
            return fieldAccess;
        }

        public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
            p.append("for");
            J.ForEachLoop.Control ctrl = forEachLoop.getControl();
            this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
            p.append('(');
            this.visitRightPadded(ctrl.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, "in", p);
            this.visitRightPadded(ctrl.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, "", p);
            p.append(')');
            this.visitStatement((JRightPadded<Statement>)forEachLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
            this.afterSyntax((J)forEachLoop, p);
            return forEachLoop;
        }

        public J visitIdentifier(J.Identifier ident, PrintOutputCapture<P> p) {
            if (ident.getMarkers().findFirst(Implicit.class).isPresent()) {
                return ident;
            }
            this.visit(ident.getAnnotations(), p);
            this.beforeSyntax((J)ident, Space.Location.IDENTIFIER_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            p.append(ident.getSimpleName());
            this.afterSyntax((J)ident, p);
            return ident;
        }

        public J visitImport(J.Import import_, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)import_, Space.Location.IMPORT_PREFIX, p);
            p.append("import");
            if (import_.getQualid().getTarget() instanceof J.Empty) {
                this.visit((Tree)import_.getQualid().getName(), p);
            } else {
                this.visit((Tree)import_.getQualid(), p);
            }
            JLeftPadded alias = import_.getPadding().getAlias();
            if (alias != null) {
                this.visitSpace(alias.getBefore(), Space.Location.IMPORT_ALIAS_PREFIX, p);
                p.append("as");
                this.visit((Tree)alias.getElement(), p);
            }
            this.afterSyntax((J)import_, p);
            return import_;
        }

        public J visitInstanceOf(J.InstanceOf instanceOf, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)instanceOf, Space.Location.INSTANCEOF_PREFIX, p);
            String suffix = instanceOf.getMarkers().findFirst(NotIs.class).isPresent() ? "!is" : "is";
            this.visitRightPadded(instanceOf.getPadding().getExpr(), JRightPadded.Location.INSTANCEOF, suffix, p);
            this.visit((Tree)instanceOf.getClazz(), p);
            this.visit((Tree)instanceOf.getPattern(), p);
            this.afterSyntax((J)instanceOf, p);
            return instanceOf;
        }

        public J visitLabel(J.Label label, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)label, Space.Location.LABEL_PREFIX, p);
            this.visitRightPadded(label.getPadding().getLabel(), JRightPadded.Location.LABEL, "@", p);
            this.visit((Tree)label.getStatement(), p);
            this.afterSyntax((J)label, p);
            return label;
        }

        public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)lambda, Space.Location.LAMBDA_PREFIX, p);
            if (lambda.getMarkers().findFirst(AnonymousFunction.class).isPresent()) {
                p.append("fun");
                this.visitLambdaParameters(lambda.getParameters(), p);
                this.visitBlock((J.Block)lambda.getBody(), p);
            } else {
                boolean omitBraces = lambda.getMarkers().findFirst(OmitBraces.class).isPresent();
                if (!omitBraces) {
                    p.append('{');
                }
                this.visitSpace(lambda.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETER, p);
                this.visitLambdaParameters(lambda.getParameters(), p);
                if (!lambda.getParameters().getParameters().isEmpty()) {
                    this.visitSpace(lambda.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
                    p.append("->");
                }
                this.visit((Tree)lambda.getBody(), p);
                if (!omitBraces) {
                    p.append('}');
                }
            }
            this.afterSyntax((J)lambda, p);
            return lambda;
        }

        private void visitLambdaParameters(J.Lambda.Parameters parameters, PrintOutputCapture<P> p) {
            this.visitMarkers(parameters.getMarkers(), p);
            if (parameters.isParenthesized()) {
                this.visitSpace(parameters.getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
                p.append('(');
                this.visitRightPadded(parameters.getPadding().getParams(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
                p.append(')');
            } else {
                List params = parameters.getPadding().getParams();
                for (int i = 0; i < params.size(); ++i) {
                    JRightPadded param = (JRightPadded)params.get(i);
                    if (param.getElement() instanceof J.Lambda.Parameters) {
                        this.visitLambdaParameters((J.Lambda.Parameters)param.getElement(), p);
                        this.visitSpace(param.getAfter(), JRightPadded.Location.LAMBDA_PARAM.getAfterLocation(), p);
                        continue;
                    }
                    this.visit((Tree)param.getElement(), p);
                    this.visitSpace(param.getAfter(), JRightPadded.Location.LAMBDA_PARAM.getAfterLocation(), p);
                    this.visitMarkers(param.getMarkers(), p);
                    if (i >= params.size() - 1) continue;
                    p.append(',');
                }
            }
        }

        public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
            return this.visitMethodDeclaration0(method, null, p);
        }

        @NotNull
        private J.MethodDeclaration visitMethodDeclaration0(J.MethodDeclaration method, @Nullable K.TypeConstraints typeConstraints, PrintOutputCapture<P> p) {
            boolean hasReceiverType;
            for (Marker marker : method.getMarkers().getMarkers()) {
                if (!(marker instanceof Implicit) && !(marker instanceof PrimaryConstructor)) continue;
                return method;
            }
            this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
            this.visit(method.getLeadingAnnotations(), p);
            for (J.Modifier m : method.getModifiers()) {
                this.visitModifier(m, p);
            }
            J.TypeParameters typeParameters = method.getAnnotations().getTypeParameters();
            if (typeParameters != null) {
                this.visit(typeParameters.getAnnotations(), p);
                this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
                this.visitMarkers(typeParameters.getMarkers(), p);
                p.append("<");
                this.visitRightPadded(typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
                p.append(">");
            }
            if (hasReceiverType = method.getMarkers().findFirst(Extension.class).isPresent()) {
                J.VariableDeclarations infixReceiver = (J.VariableDeclarations)method.getParameters().get(0);
                JRightPadded receiver = (JRightPadded)infixReceiver.getPadding().getVariables().get(0);
                this.visitRightPadded(receiver, JRightPadded.Location.NAMED_VARIABLE, ".", p);
            }
            if (!method.getName().getMarkers().findFirst(Implicit.class).isPresent()) {
                this.visit(method.getAnnotations().getName().getAnnotations(), p);
                this.visit((Tree)method.getName(), p);
            }
            JContainer params = method.getPadding().getParameters();
            this.beforeSyntax(params.getBefore(), params.getMarkers(), JContainer.Location.METHOD_DECLARATION_PARAMETERS.getBeforeLocation(), p);
            if (!params.getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                p.append("(");
            }
            List elements = params.getPadding().getElements();
            for (int i = hasReceiverType ? 1 : 0; i < elements.size(); ++i) {
                this.printMethodParameters(p, i, elements);
            }
            this.afterSyntax(params.getMarkers(), p);
            if (!params.getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                p.append(")");
            }
            if (method.getReturnTypeExpression() != null) {
                method.getMarkers().findFirst(TypeReferencePrefix.class).ifPresent(typeReferencePrefix -> this.kotlinPrinter.visitSpace(typeReferencePrefix.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p));
                p.append(":");
                this.visit((Tree)method.getReturnTypeExpression(), p);
            }
            if (typeConstraints != null) {
                this.visitContainer("where", typeConstraints.getPadding().getConstraints(), JContainer.Location.TYPE_PARAMETERS, ",", "", p);
            }
            this.visit((Tree)method.getBody(), p);
            this.afterSyntax((J)method, p);
            return method;
        }

        private void printMethodParameters(PrintOutputCapture<P> p, int i, List<JRightPadded<Statement>> elements) {
            JRightPadded<Statement> element = elements.get(i);
            if (((Statement)element.getElement()).getMarkers().findFirst(Implicit.class).isPresent()) {
                return;
            }
            String suffix = i == elements.size() - 1 ? "" : ",";
            this.visit((Tree)element.getElement(), p);
            this.visitSpace(element.getAfter(), JContainer.Location.METHOD_DECLARATION_PARAMETERS.getElementLocation().getAfterLocation(), p);
            this.visitMarkers(element.getMarkers(), p);
            p.append(suffix);
        }

        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            boolean indexedAccess = method.getMarkers().findFirst(IndexedAccess.class).isPresent();
            this.beforeSyntax((J)method, Space.Location.METHOD_INVOCATION_PREFIX, p);
            this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, p);
            if (method.getSelect() != null && !method.getMarkers().findFirst(Extension.class).isPresent() && !indexedAccess) {
                if (method.getMarkers().findFirst(IsNullSafe.class).isPresent()) {
                    p.append("?");
                }
                if (!method.getName().getSimpleName().equals("<empty>") && !method.getName().getMarkers().findFirst(Implicit.class).isPresent()) {
                    p.append(".");
                }
            }
            if (!indexedAccess) {
                this.visit((Tree)method.getName(), p);
                this.visitContainer("<", (JContainer<J>)method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            }
            this.visitArgumentsContainer((JContainer<Expression>)method.getPadding().getArguments(), Space.Location.METHOD_INVOCATION_ARGUMENTS, p);
            this.afterSyntax((J)method, p);
            return method;
        }

        private void visitArgumentsContainer(JContainer<Expression> argContainer, Space.Location argsLocation, PrintOutputCapture<P> p) {
            boolean isTrailingLambda;
            this.visitSpace(argContainer.getBefore(), argsLocation, p);
            List args = argContainer.getPadding().getElements();
            boolean omitParensOnMethod = argContainer.getMarkers().findFirst(OmitParentheses.class).isPresent();
            boolean indexedAccess = argContainer.getMarkers().findFirst(IndexedAccess.class).isPresent();
            int argCount = args.size();
            boolean bl = isTrailingLambda = !args.isEmpty() && ((Expression)((JRightPadded)args.get(argCount - 1)).getElement()).getMarkers().findFirst(TrailingLambdaArgument.class).isPresent();
            if (!omitParensOnMethod) {
                p.append(indexedAccess ? (char)'[' : '(');
            }
            for (int i = 0; i < argCount; ++i) {
                JRightPadded arg = (JRightPadded)args.get(i);
                if (i == argCount - 1 && isTrailingLambda) {
                    this.visitSpace(arg.getAfter(), JRightPadded.Location.METHOD_INVOCATION_ARGUMENT.getAfterLocation(), p);
                    if (!omitParensOnMethod) {
                        p.append(indexedAccess ? (char)']' : ')');
                    }
                    this.visit((Tree)arg.getElement(), p);
                    break;
                }
                if (i > 0 && omitParensOnMethod && !((Expression)((JRightPadded)args.get(0)).getElement()).getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                    p.append(indexedAccess ? (char)']' : ')');
                } else if (i > 0) {
                    p.append(',');
                }
                this.visitRightPadded(arg, JRightPadded.Location.METHOD_INVOCATION_ARGUMENT, p);
            }
            if (!omitParensOnMethod && !isTrailingLambda) {
                p.append(indexedAccess ? (char)']' : ')');
            }
        }

        public J visitNewClass(J.NewClass newClass, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)newClass, Space.Location.NEW_CLASS_PREFIX, p);
            KObject kObject = newClass.getMarkers().findFirst(KObject.class).orElse(null);
            if (kObject != null) {
                p.append("object");
            }
            newClass.getMarkers().findFirst(TypeReferencePrefix.class).ifPresent(typeReferencePrefix -> this.kotlinPrinter.visitSpace(typeReferencePrefix.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p));
            if (kObject != null && newClass.getClazz() != null) {
                p.append(":");
            }
            this.visitRightPadded(newClass.getPadding().getEnclosing(), JRightPadded.Location.NEW_CLASS_ENCLOSING, ".", p);
            this.visitSpace(newClass.getNew(), Space.Location.NEW_PREFIX, p);
            this.visit((Tree)newClass.getClazz(), p);
            this.visitArgumentsContainer((JContainer<Expression>)newClass.getPadding().getArguments(), Space.Location.NEW_CLASS_ARGUMENTS, p);
            this.visit((Tree)newClass.getBody(), p);
            this.afterSyntax((J)newClass, p);
            return newClass;
        }

        public J visitReturn(J.Return return_, PrintOutputCapture<P> p) {
            if (return_.getMarkers().findFirst(ImplicitReturn.class).isPresent()) {
                this.visitSpace(return_.getPrefix(), Space.Location.RETURN_PREFIX, p);
                this.visitMarkers(return_.getMarkers(), p);
                this.visit((Tree)return_.getExpression(), p);
                this.afterSyntax((J)return_, p);
                return return_;
            }
            return super.visitReturn(return_, p);
        }

        public J visitTernary(J.Ternary ternary, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)ternary, Space.Location.TERNARY_PREFIX, p);
            this.visitLeftPadded("", ternary.getPadding().getTruePart(), JLeftPadded.Location.TERNARY_TRUE, p);
            this.visitLeftPadded("?:", ternary.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p);
            this.afterSyntax((J)ternary, p);
            return ternary;
        }

        public J visitTypeCast(J.TypeCast typeCast, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)typeCast, Space.Location.TYPE_CAST_PREFIX, p);
            this.visit((Tree)typeCast.getExpression(), p);
            J.ControlParentheses controlParens = typeCast.getClazz();
            this.beforeSyntax((J)controlParens, Space.Location.CONTROL_PARENTHESES_PREFIX, p);
            String as = typeCast.getMarkers().findFirst(IsNullSafe.class).isPresent() ? "as?" : "as";
            p.append(as);
            this.visit((Tree)controlParens.getTree(), p);
            this.afterSyntax((J)typeCast, p);
            return typeCast;
        }

        public J visitTypeParameter(J.TypeParameter typeParam, PrintOutputCapture<P> p) {
            Optional maybeTypeReferencePrefix;
            this.beforeSyntax((J)typeParam, Space.Location.TYPE_PARAMETERS_PREFIX, p);
            this.visit(typeParam.getAnnotations(), p);
            if (typeParam.getModifiers() != null) {
                for (J.Modifier m : typeParam.getModifiers()) {
                    this.visitModifier(m, p);
                }
            }
            String delimiter = "";
            this.visit((Tree)typeParam.getName(), p);
            if (typeParam.getBounds() != null && !typeParam.getBounds().isEmpty() && (maybeTypeReferencePrefix = typeParam.getMarkers().findFirst(TypeReferencePrefix.class)).isPresent()) {
                delimiter = ":";
                this.kotlinPrinter.visitSpace(((TypeReferencePrefix)maybeTypeReferencePrefix.get()).getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p);
            }
            this.visitContainer(delimiter, (JContainer<J>)typeParam.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, "&", "", p);
            this.afterSyntax((J)typeParam, p);
            return typeParam;
        }

        public J visitUnary(J.Unary unary, PrintOutputCapture<P> p) {
            if (unary.getOperator() == J.Unary.Type.Not && unary.getExpression() instanceof K.Binary && ((K.Binary)unary.getExpression()).getOperator() == K.Binary.Type.NotContains) {
                this.beforeSyntax((J)unary, Space.Location.UNARY_PREFIX, p);
                this.visit((Tree)unary.getExpression(), p);
                this.afterSyntax((J)unary, p);
                return unary;
            }
            return super.visitUnary(unary, p);
        }

        public J visitWildcard(J.Wildcard wildcard, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)wildcard, Space.Location.WILDCARD_PREFIX, p);
            if (wildcard.getPadding().getBound() != null) {
                p.append(wildcard.getPadding().getBound().getElement() == J.Wildcard.Bound.Super ? "in" : "out");
            }
            if (wildcard.getBoundedType() == null) {
                p.append('*');
            } else {
                this.visit((Tree)wildcard.getBoundedType(), p);
            }
            this.afterSyntax((J)wildcard, p);
            return wildcard;
        }

        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
            if (multiVariable.getLeadingAnnotations().stream().anyMatch(it -> "typealias".equals(it.getSimpleName()))) {
                this.visitTypeAlias(multiVariable, p);
                return multiVariable;
            }
            this.beforeSyntax((J)multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
            this.visit(multiVariable.getLeadingAnnotations(), p);
            for (J.Modifier m2 : multiVariable.getModifiers()) {
                this.visitModifier(m2, p);
                if (m2.getType() != J.Modifier.Type.Final) continue;
                p.append("val");
            }
            boolean containsTypeReceiver = multiVariable.getMarkers().findFirst(Extension.class).isPresent();
            List variables = multiVariable.getPadding().getVariables();
            for (int i = 0; i < variables.size(); ++i) {
                JRightPadded variable = (JRightPadded)variables.get(i);
                this.beforeSyntax((J)variable.getElement(), Space.Location.VARIABLE_PREFIX, p);
                if (variables.size() > 1 && !containsTypeReceiver && i == 0) {
                    p.append("(");
                }
                this.visit((Tree)((J.VariableDeclarations.NamedVariable)variable.getElement()).getName(), p);
                if (multiVariable.getTypeExpression() != null) {
                    TypeReferencePrefix typeReferencePrefix = multiVariable.getMarkers().findFirst(TypeReferencePrefix.class).orElse(null);
                    if (typeReferencePrefix != null) {
                        this.kotlinPrinter.visitSpace(typeReferencePrefix.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p);
                        p.append(":");
                    }
                    this.visit((Tree)multiVariable.getTypeExpression(), p);
                }
                if (((J.VariableDeclarations.NamedVariable)variable.getElement()).getPadding().getInitializer() != null) {
                    this.visitSpace(((J.VariableDeclarations.NamedVariable)variable.getElement()).getPadding().getInitializer().getBefore(), Space.Location.VARIABLE_INITIALIZER, p);
                }
                if (((J.VariableDeclarations.NamedVariable)variable.getElement()).getInitializer() != null) {
                    String equals = KotlinPrinter.getEqualsText(multiVariable);
                    p.append(equals);
                }
                this.visit((Tree)((J.VariableDeclarations.NamedVariable)variable.getElement()).getInitializer(), p);
                this.visitSpace(variable.getAfter(), Space.Location.VARIABLE_INITIALIZER, p);
                if (i < variables.size() - 1) {
                    p.append(",");
                } else if (variables.size() > 1 && !containsTypeReceiver) {
                    p.append(")");
                }
                variable.getMarkers().findFirst(Semicolon.class).ifPresent(m -> this.visitMarker((Marker)m, p));
            }
            this.afterSyntax((J)multiVariable, p);
            return multiVariable;
        }

        public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)variable, Space.Location.VARIABLE_PREFIX, p);
            boolean isTypeReceiver = variable.getMarkers().findFirst(Extension.class).isPresent();
            if (!isTypeReceiver) {
                this.visit((Tree)variable.getName(), p);
            }
            this.visitLeftPadded(isTypeReceiver ? "" : "=", variable.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p);
            this.afterSyntax((J)variable, p);
            return variable;
        }

        private void visitTypeAlias(J.VariableDeclarations typeAlias, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)typeAlias, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(typeAlias.getLeadingAnnotations(), p);
            for (J.Modifier m : typeAlias.getModifiers()) {
                this.visitModifier(m, p);
            }
            this.visit((Tree)typeAlias.getTypeExpression(), p);
            this.visitVariable((J.VariableDeclarations.NamedVariable)((JRightPadded)typeAlias.getPadding().getVariables().get(0)).getElement(), p);
            this.visitMarkers(((JRightPadded)typeAlias.getPadding().getVariables().get(0)).getMarkers(), p);
            this.afterSyntax((J)typeAlias, p);
        }

        protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, PrintOutputCapture<P> p) {
            if (paddedStat != null) {
                Statement element = (Statement)paddedStat.getElement();
                if (element.getMarkers().findFirst(Implicit.class).isPresent()) {
                    return;
                }
                this.visit((Tree)element, p);
                this.visitSpace(paddedStat.getAfter(), location.getAfterLocation(), p);
                this.visitMarkers(paddedStat.getMarkers(), p);
            }
        }

        public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
            if (marker instanceof Semicolon) {
                p.append(';');
            } else if (marker instanceof TrailingComma) {
                p.append(',');
                this.visitSpace(((TrailingComma)marker).getSuffix(), Space.Location.LANGUAGE_EXTENSION, p);
            }
            return (M)super.visitMarker(marker, p);
        }

        protected void visitModifier(J.Modifier mod, PrintOutputCapture<P> p) {
            this.visit(mod.getAnnotations(), p);
            String keyword = "";
            switch (mod.getType()) {
                case Default: {
                    keyword = "default";
                    break;
                }
                case Public: {
                    keyword = "public";
                    break;
                }
                case Protected: {
                    keyword = "protected";
                    break;
                }
                case Private: {
                    keyword = "private";
                    break;
                }
                case Abstract: {
                    keyword = "abstract";
                    break;
                }
                case Static: {
                    keyword = "static";
                    break;
                }
                case Native: {
                    keyword = "native";
                    break;
                }
                case NonSealed: {
                    keyword = "non-sealed";
                    break;
                }
                case Sealed: {
                    keyword = "sealed";
                    break;
                }
                case Strictfp: {
                    keyword = "strictfp";
                    break;
                }
                case Synchronized: {
                    keyword = "synchronized";
                    break;
                }
                case Transient: {
                    keyword = "transient";
                    break;
                }
                case Volatile: {
                    keyword = "volatile";
                    break;
                }
                case LanguageExtension: {
                    keyword = mod.getKeyword();
                }
            }
            this.beforeSyntax((J)mod, Space.Location.MODIFIER_PREFIX, p);
            p.append(keyword);
            this.afterSyntax((J)mod, p);
        }

        protected void afterSyntax(J j, PrintOutputCapture<P> p) {
            ((KotlinPrinter)this.kotlinPrinter).trailingMarkers(j.getMarkers(), p);
            super.afterSyntax(j, p);
        }
    }
}

