/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.style;

import org.openrewrite.kotlin.KotlinStyle;
import org.openrewrite.kotlin.style.IntelliJ;
import org.openrewrite.style.Style;
import org.openrewrite.style.StyleHelper;

public final class WrappingAndBracesStyle
implements KotlinStyle {
    private final KeepWhenFormatting keepWhenFormatting;
    private final ExtendsImplementsPermitsList extendsImplementsPermitsList;
    private final FunctionDeclarationParameters functionDeclarationParameters;
    private final FunctionCallArguments functionCallArguments;
    private final FunctionParentheses functionParentheses;
    private final ChainedFunctionCalls chainedFunctionCalls;
    private final IfStatement ifStatement;
    private final DoWhileStatement doWhileStatement;
    private final TryStatement tryStatement;
    private final BinaryExpression binaryExpression;
    private final WhenStatements whenStatements;
    private final BracesPlacement bracesPlacement;
    private final ExpressionBodyFunctions expressionBodyFunctions;
    private final ElvisExpressions elvisExpressions;

    public Style applyDefaults() {
        return (Style)StyleHelper.merge((Object)IntelliJ.wrappingAndBraces(), (Object)this);
    }

    public WrappingAndBracesStyle(KeepWhenFormatting keepWhenFormatting, ExtendsImplementsPermitsList extendsImplementsPermitsList, FunctionDeclarationParameters functionDeclarationParameters, FunctionCallArguments functionCallArguments, FunctionParentheses functionParentheses, ChainedFunctionCalls chainedFunctionCalls, IfStatement ifStatement, DoWhileStatement doWhileStatement, TryStatement tryStatement, BinaryExpression binaryExpression, WhenStatements whenStatements, BracesPlacement bracesPlacement, ExpressionBodyFunctions expressionBodyFunctions, ElvisExpressions elvisExpressions) {
        this.keepWhenFormatting = keepWhenFormatting;
        this.extendsImplementsPermitsList = extendsImplementsPermitsList;
        this.functionDeclarationParameters = functionDeclarationParameters;
        this.functionCallArguments = functionCallArguments;
        this.functionParentheses = functionParentheses;
        this.chainedFunctionCalls = chainedFunctionCalls;
        this.ifStatement = ifStatement;
        this.doWhileStatement = doWhileStatement;
        this.tryStatement = tryStatement;
        this.binaryExpression = binaryExpression;
        this.whenStatements = whenStatements;
        this.bracesPlacement = bracesPlacement;
        this.expressionBodyFunctions = expressionBodyFunctions;
        this.elvisExpressions = elvisExpressions;
    }

    public KeepWhenFormatting getKeepWhenFormatting() {
        return this.keepWhenFormatting;
    }

    public ExtendsImplementsPermitsList getExtendsImplementsPermitsList() {
        return this.extendsImplementsPermitsList;
    }

    public FunctionDeclarationParameters getFunctionDeclarationParameters() {
        return this.functionDeclarationParameters;
    }

    public FunctionCallArguments getFunctionCallArguments() {
        return this.functionCallArguments;
    }

    public FunctionParentheses getFunctionParentheses() {
        return this.functionParentheses;
    }

    public ChainedFunctionCalls getChainedFunctionCalls() {
        return this.chainedFunctionCalls;
    }

    public IfStatement getIfStatement() {
        return this.ifStatement;
    }

    public DoWhileStatement getDoWhileStatement() {
        return this.doWhileStatement;
    }

    public TryStatement getTryStatement() {
        return this.tryStatement;
    }

    public BinaryExpression getBinaryExpression() {
        return this.binaryExpression;
    }

    public WhenStatements getWhenStatements() {
        return this.whenStatements;
    }

    public BracesPlacement getBracesPlacement() {
        return this.bracesPlacement;
    }

    public ExpressionBodyFunctions getExpressionBodyFunctions() {
        return this.expressionBodyFunctions;
    }

    public ElvisExpressions getElvisExpressions() {
        return this.elvisExpressions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrappingAndBracesStyle)) {
            return false;
        }
        WrappingAndBracesStyle other = (WrappingAndBracesStyle)o;
        KeepWhenFormatting this$keepWhenFormatting = this.getKeepWhenFormatting();
        KeepWhenFormatting other$keepWhenFormatting = other.getKeepWhenFormatting();
        if (this$keepWhenFormatting == null ? other$keepWhenFormatting != null : !((Object)this$keepWhenFormatting).equals(other$keepWhenFormatting)) {
            return false;
        }
        ExtendsImplementsPermitsList this$extendsImplementsPermitsList = this.getExtendsImplementsPermitsList();
        ExtendsImplementsPermitsList other$extendsImplementsPermitsList = other.getExtendsImplementsPermitsList();
        if (this$extendsImplementsPermitsList == null ? other$extendsImplementsPermitsList != null : !((Object)this$extendsImplementsPermitsList).equals(other$extendsImplementsPermitsList)) {
            return false;
        }
        FunctionDeclarationParameters this$functionDeclarationParameters = this.getFunctionDeclarationParameters();
        FunctionDeclarationParameters other$functionDeclarationParameters = other.getFunctionDeclarationParameters();
        if (this$functionDeclarationParameters == null ? other$functionDeclarationParameters != null : !((Object)this$functionDeclarationParameters).equals(other$functionDeclarationParameters)) {
            return false;
        }
        FunctionCallArguments this$functionCallArguments = this.getFunctionCallArguments();
        FunctionCallArguments other$functionCallArguments = other.getFunctionCallArguments();
        if (this$functionCallArguments == null ? other$functionCallArguments != null : !((Object)this$functionCallArguments).equals(other$functionCallArguments)) {
            return false;
        }
        FunctionParentheses this$functionParentheses = this.getFunctionParentheses();
        FunctionParentheses other$functionParentheses = other.getFunctionParentheses();
        if (this$functionParentheses == null ? other$functionParentheses != null : !((Object)this$functionParentheses).equals(other$functionParentheses)) {
            return false;
        }
        ChainedFunctionCalls this$chainedFunctionCalls = this.getChainedFunctionCalls();
        ChainedFunctionCalls other$chainedFunctionCalls = other.getChainedFunctionCalls();
        if (this$chainedFunctionCalls == null ? other$chainedFunctionCalls != null : !((Object)this$chainedFunctionCalls).equals(other$chainedFunctionCalls)) {
            return false;
        }
        IfStatement this$ifStatement = this.getIfStatement();
        IfStatement other$ifStatement = other.getIfStatement();
        if (this$ifStatement == null ? other$ifStatement != null : !((Object)this$ifStatement).equals(other$ifStatement)) {
            return false;
        }
        DoWhileStatement this$doWhileStatement = this.getDoWhileStatement();
        DoWhileStatement other$doWhileStatement = other.getDoWhileStatement();
        if (this$doWhileStatement == null ? other$doWhileStatement != null : !((Object)this$doWhileStatement).equals(other$doWhileStatement)) {
            return false;
        }
        TryStatement this$tryStatement = this.getTryStatement();
        TryStatement other$tryStatement = other.getTryStatement();
        if (this$tryStatement == null ? other$tryStatement != null : !((Object)this$tryStatement).equals(other$tryStatement)) {
            return false;
        }
        BinaryExpression this$binaryExpression = this.getBinaryExpression();
        BinaryExpression other$binaryExpression = other.getBinaryExpression();
        if (this$binaryExpression == null ? other$binaryExpression != null : !((Object)this$binaryExpression).equals(other$binaryExpression)) {
            return false;
        }
        WhenStatements this$whenStatements = this.getWhenStatements();
        WhenStatements other$whenStatements = other.getWhenStatements();
        if (this$whenStatements == null ? other$whenStatements != null : !((Object)this$whenStatements).equals(other$whenStatements)) {
            return false;
        }
        BracesPlacement this$bracesPlacement = this.getBracesPlacement();
        BracesPlacement other$bracesPlacement = other.getBracesPlacement();
        if (this$bracesPlacement == null ? other$bracesPlacement != null : !((Object)this$bracesPlacement).equals(other$bracesPlacement)) {
            return false;
        }
        ExpressionBodyFunctions this$expressionBodyFunctions = this.getExpressionBodyFunctions();
        ExpressionBodyFunctions other$expressionBodyFunctions = other.getExpressionBodyFunctions();
        if (this$expressionBodyFunctions == null ? other$expressionBodyFunctions != null : !((Object)this$expressionBodyFunctions).equals(other$expressionBodyFunctions)) {
            return false;
        }
        ElvisExpressions this$elvisExpressions = this.getElvisExpressions();
        ElvisExpressions other$elvisExpressions = other.getElvisExpressions();
        return !(this$elvisExpressions == null ? other$elvisExpressions != null : !((Object)this$elvisExpressions).equals(other$elvisExpressions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        KeepWhenFormatting $keepWhenFormatting = this.getKeepWhenFormatting();
        result = result * 59 + ($keepWhenFormatting == null ? 43 : ((Object)$keepWhenFormatting).hashCode());
        ExtendsImplementsPermitsList $extendsImplementsPermitsList = this.getExtendsImplementsPermitsList();
        result = result * 59 + ($extendsImplementsPermitsList == null ? 43 : ((Object)$extendsImplementsPermitsList).hashCode());
        FunctionDeclarationParameters $functionDeclarationParameters = this.getFunctionDeclarationParameters();
        result = result * 59 + ($functionDeclarationParameters == null ? 43 : ((Object)$functionDeclarationParameters).hashCode());
        FunctionCallArguments $functionCallArguments = this.getFunctionCallArguments();
        result = result * 59 + ($functionCallArguments == null ? 43 : ((Object)$functionCallArguments).hashCode());
        FunctionParentheses $functionParentheses = this.getFunctionParentheses();
        result = result * 59 + ($functionParentheses == null ? 43 : ((Object)$functionParentheses).hashCode());
        ChainedFunctionCalls $chainedFunctionCalls = this.getChainedFunctionCalls();
        result = result * 59 + ($chainedFunctionCalls == null ? 43 : ((Object)$chainedFunctionCalls).hashCode());
        IfStatement $ifStatement = this.getIfStatement();
        result = result * 59 + ($ifStatement == null ? 43 : ((Object)$ifStatement).hashCode());
        DoWhileStatement $doWhileStatement = this.getDoWhileStatement();
        result = result * 59 + ($doWhileStatement == null ? 43 : ((Object)$doWhileStatement).hashCode());
        TryStatement $tryStatement = this.getTryStatement();
        result = result * 59 + ($tryStatement == null ? 43 : ((Object)$tryStatement).hashCode());
        BinaryExpression $binaryExpression = this.getBinaryExpression();
        result = result * 59 + ($binaryExpression == null ? 43 : ((Object)$binaryExpression).hashCode());
        WhenStatements $whenStatements = this.getWhenStatements();
        result = result * 59 + ($whenStatements == null ? 43 : ((Object)$whenStatements).hashCode());
        BracesPlacement $bracesPlacement = this.getBracesPlacement();
        result = result * 59 + ($bracesPlacement == null ? 43 : ((Object)$bracesPlacement).hashCode());
        ExpressionBodyFunctions $expressionBodyFunctions = this.getExpressionBodyFunctions();
        result = result * 59 + ($expressionBodyFunctions == null ? 43 : ((Object)$expressionBodyFunctions).hashCode());
        ElvisExpressions $elvisExpressions = this.getElvisExpressions();
        result = result * 59 + ($elvisExpressions == null ? 43 : ((Object)$elvisExpressions).hashCode());
        return result;
    }

    public String toString() {
        return "WrappingAndBracesStyle(keepWhenFormatting=" + this.getKeepWhenFormatting() + ", extendsImplementsPermitsList=" + this.getExtendsImplementsPermitsList() + ", functionDeclarationParameters=" + this.getFunctionDeclarationParameters() + ", functionCallArguments=" + this.getFunctionCallArguments() + ", functionParentheses=" + this.getFunctionParentheses() + ", chainedFunctionCalls=" + this.getChainedFunctionCalls() + ", ifStatement=" + this.getIfStatement() + ", doWhileStatement=" + this.getDoWhileStatement() + ", tryStatement=" + this.getTryStatement() + ", binaryExpression=" + this.getBinaryExpression() + ", whenStatements=" + this.getWhenStatements() + ", bracesPlacement=" + this.getBracesPlacement() + ", expressionBodyFunctions=" + this.getExpressionBodyFunctions() + ", elvisExpressions=" + this.getElvisExpressions() + ")";
    }

    public WrappingAndBracesStyle withKeepWhenFormatting(KeepWhenFormatting keepWhenFormatting) {
        return this.keepWhenFormatting == keepWhenFormatting ? this : new WrappingAndBracesStyle(keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withExtendsImplementsPermitsList(ExtendsImplementsPermitsList extendsImplementsPermitsList) {
        return this.extendsImplementsPermitsList == extendsImplementsPermitsList ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withFunctionDeclarationParameters(FunctionDeclarationParameters functionDeclarationParameters) {
        return this.functionDeclarationParameters == functionDeclarationParameters ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withFunctionCallArguments(FunctionCallArguments functionCallArguments) {
        return this.functionCallArguments == functionCallArguments ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withFunctionParentheses(FunctionParentheses functionParentheses) {
        return this.functionParentheses == functionParentheses ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withChainedFunctionCalls(ChainedFunctionCalls chainedFunctionCalls) {
        return this.chainedFunctionCalls == chainedFunctionCalls ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withIfStatement(IfStatement ifStatement) {
        return this.ifStatement == ifStatement ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withDoWhileStatement(DoWhileStatement doWhileStatement) {
        return this.doWhileStatement == doWhileStatement ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withTryStatement(TryStatement tryStatement) {
        return this.tryStatement == tryStatement ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withBinaryExpression(BinaryExpression binaryExpression) {
        return this.binaryExpression == binaryExpression ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withWhenStatements(WhenStatements whenStatements) {
        return this.whenStatements == whenStatements ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, whenStatements, this.bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withBracesPlacement(BracesPlacement bracesPlacement) {
        return this.bracesPlacement == bracesPlacement ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, bracesPlacement, this.expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withExpressionBodyFunctions(ExpressionBodyFunctions expressionBodyFunctions) {
        return this.expressionBodyFunctions == expressionBodyFunctions ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, expressionBodyFunctions, this.elvisExpressions);
    }

    public WrappingAndBracesStyle withElvisExpressions(ElvisExpressions elvisExpressions) {
        return this.elvisExpressions == elvisExpressions ? this : new WrappingAndBracesStyle(this.keepWhenFormatting, this.extendsImplementsPermitsList, this.functionDeclarationParameters, this.functionCallArguments, this.functionParentheses, this.chainedFunctionCalls, this.ifStatement, this.doWhileStatement, this.tryStatement, this.binaryExpression, this.whenStatements, this.bracesPlacement, this.expressionBodyFunctions, elvisExpressions);
    }

    public static final class KeepWhenFormatting {
        private final Boolean lineBreaks;
        private final Boolean commentAtFirstColumn;

        public KeepWhenFormatting(Boolean lineBreaks, Boolean commentAtFirstColumn) {
            this.lineBreaks = lineBreaks;
            this.commentAtFirstColumn = commentAtFirstColumn;
        }

        public Boolean getLineBreaks() {
            return this.lineBreaks;
        }

        public Boolean getCommentAtFirstColumn() {
            return this.commentAtFirstColumn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeepWhenFormatting)) {
                return false;
            }
            KeepWhenFormatting other = (KeepWhenFormatting)o;
            Boolean this$lineBreaks = this.getLineBreaks();
            Boolean other$lineBreaks = other.getLineBreaks();
            if (this$lineBreaks == null ? other$lineBreaks != null : !((Object)this$lineBreaks).equals(other$lineBreaks)) {
                return false;
            }
            Boolean this$commentAtFirstColumn = this.getCommentAtFirstColumn();
            Boolean other$commentAtFirstColumn = other.getCommentAtFirstColumn();
            return !(this$commentAtFirstColumn == null ? other$commentAtFirstColumn != null : !((Object)this$commentAtFirstColumn).equals(other$commentAtFirstColumn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $lineBreaks = this.getLineBreaks();
            result = result * 59 + ($lineBreaks == null ? 43 : ((Object)$lineBreaks).hashCode());
            Boolean $commentAtFirstColumn = this.getCommentAtFirstColumn();
            result = result * 59 + ($commentAtFirstColumn == null ? 43 : ((Object)$commentAtFirstColumn).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.KeepWhenFormatting(lineBreaks=" + this.getLineBreaks() + ", commentAtFirstColumn=" + this.getCommentAtFirstColumn() + ")";
        }

        public KeepWhenFormatting withLineBreaks(Boolean lineBreaks) {
            return this.lineBreaks == lineBreaks ? this : new KeepWhenFormatting(lineBreaks, this.commentAtFirstColumn);
        }

        public KeepWhenFormatting withCommentAtFirstColumn(Boolean commentAtFirstColumn) {
            return this.commentAtFirstColumn == commentAtFirstColumn ? this : new KeepWhenFormatting(this.lineBreaks, commentAtFirstColumn);
        }
    }

    public static final class ExtendsImplementsPermitsList {
        private final Boolean alignWhenMultiline;
        private final Boolean useContinuationIndent;

        public ExtendsImplementsPermitsList(Boolean alignWhenMultiline, Boolean useContinuationIndent) {
            this.alignWhenMultiline = alignWhenMultiline;
            this.useContinuationIndent = useContinuationIndent;
        }

        public Boolean getAlignWhenMultiline() {
            return this.alignWhenMultiline;
        }

        public Boolean getUseContinuationIndent() {
            return this.useContinuationIndent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtendsImplementsPermitsList)) {
                return false;
            }
            ExtendsImplementsPermitsList other = (ExtendsImplementsPermitsList)o;
            Boolean this$alignWhenMultiline = this.getAlignWhenMultiline();
            Boolean other$alignWhenMultiline = other.getAlignWhenMultiline();
            if (this$alignWhenMultiline == null ? other$alignWhenMultiline != null : !((Object)this$alignWhenMultiline).equals(other$alignWhenMultiline)) {
                return false;
            }
            Boolean this$useContinuationIndent = this.getUseContinuationIndent();
            Boolean other$useContinuationIndent = other.getUseContinuationIndent();
            return !(this$useContinuationIndent == null ? other$useContinuationIndent != null : !((Object)this$useContinuationIndent).equals(other$useContinuationIndent));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $alignWhenMultiline = this.getAlignWhenMultiline();
            result = result * 59 + ($alignWhenMultiline == null ? 43 : ((Object)$alignWhenMultiline).hashCode());
            Boolean $useContinuationIndent = this.getUseContinuationIndent();
            result = result * 59 + ($useContinuationIndent == null ? 43 : ((Object)$useContinuationIndent).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.ExtendsImplementsPermitsList(alignWhenMultiline=" + this.getAlignWhenMultiline() + ", useContinuationIndent=" + this.getUseContinuationIndent() + ")";
        }

        public ExtendsImplementsPermitsList withAlignWhenMultiline(Boolean alignWhenMultiline) {
            return this.alignWhenMultiline == alignWhenMultiline ? this : new ExtendsImplementsPermitsList(alignWhenMultiline, this.useContinuationIndent);
        }

        public ExtendsImplementsPermitsList withUseContinuationIndent(Boolean useContinuationIndent) {
            return this.useContinuationIndent == useContinuationIndent ? this : new ExtendsImplementsPermitsList(this.alignWhenMultiline, useContinuationIndent);
        }
    }

    public static final class FunctionDeclarationParameters {
        private final Boolean alignWhenMultiline;
        private final Boolean newLineAfterLeftParen;
        private final Boolean placeRightParenOnNewLine;
        private final Boolean useContinuationIndent;

        public FunctionDeclarationParameters(Boolean alignWhenMultiline, Boolean newLineAfterLeftParen, Boolean placeRightParenOnNewLine, Boolean useContinuationIndent) {
            this.alignWhenMultiline = alignWhenMultiline;
            this.newLineAfterLeftParen = newLineAfterLeftParen;
            this.placeRightParenOnNewLine = placeRightParenOnNewLine;
            this.useContinuationIndent = useContinuationIndent;
        }

        public Boolean getAlignWhenMultiline() {
            return this.alignWhenMultiline;
        }

        public Boolean getNewLineAfterLeftParen() {
            return this.newLineAfterLeftParen;
        }

        public Boolean getPlaceRightParenOnNewLine() {
            return this.placeRightParenOnNewLine;
        }

        public Boolean getUseContinuationIndent() {
            return this.useContinuationIndent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionDeclarationParameters)) {
                return false;
            }
            FunctionDeclarationParameters other = (FunctionDeclarationParameters)o;
            Boolean this$alignWhenMultiline = this.getAlignWhenMultiline();
            Boolean other$alignWhenMultiline = other.getAlignWhenMultiline();
            if (this$alignWhenMultiline == null ? other$alignWhenMultiline != null : !((Object)this$alignWhenMultiline).equals(other$alignWhenMultiline)) {
                return false;
            }
            Boolean this$newLineAfterLeftParen = this.getNewLineAfterLeftParen();
            Boolean other$newLineAfterLeftParen = other.getNewLineAfterLeftParen();
            if (this$newLineAfterLeftParen == null ? other$newLineAfterLeftParen != null : !((Object)this$newLineAfterLeftParen).equals(other$newLineAfterLeftParen)) {
                return false;
            }
            Boolean this$placeRightParenOnNewLine = this.getPlaceRightParenOnNewLine();
            Boolean other$placeRightParenOnNewLine = other.getPlaceRightParenOnNewLine();
            if (this$placeRightParenOnNewLine == null ? other$placeRightParenOnNewLine != null : !((Object)this$placeRightParenOnNewLine).equals(other$placeRightParenOnNewLine)) {
                return false;
            }
            Boolean this$useContinuationIndent = this.getUseContinuationIndent();
            Boolean other$useContinuationIndent = other.getUseContinuationIndent();
            return !(this$useContinuationIndent == null ? other$useContinuationIndent != null : !((Object)this$useContinuationIndent).equals(other$useContinuationIndent));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $alignWhenMultiline = this.getAlignWhenMultiline();
            result = result * 59 + ($alignWhenMultiline == null ? 43 : ((Object)$alignWhenMultiline).hashCode());
            Boolean $newLineAfterLeftParen = this.getNewLineAfterLeftParen();
            result = result * 59 + ($newLineAfterLeftParen == null ? 43 : ((Object)$newLineAfterLeftParen).hashCode());
            Boolean $placeRightParenOnNewLine = this.getPlaceRightParenOnNewLine();
            result = result * 59 + ($placeRightParenOnNewLine == null ? 43 : ((Object)$placeRightParenOnNewLine).hashCode());
            Boolean $useContinuationIndent = this.getUseContinuationIndent();
            result = result * 59 + ($useContinuationIndent == null ? 43 : ((Object)$useContinuationIndent).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.FunctionDeclarationParameters(alignWhenMultiline=" + this.getAlignWhenMultiline() + ", newLineAfterLeftParen=" + this.getNewLineAfterLeftParen() + ", placeRightParenOnNewLine=" + this.getPlaceRightParenOnNewLine() + ", useContinuationIndent=" + this.getUseContinuationIndent() + ")";
        }

        public FunctionDeclarationParameters withAlignWhenMultiline(Boolean alignWhenMultiline) {
            return this.alignWhenMultiline == alignWhenMultiline ? this : new FunctionDeclarationParameters(alignWhenMultiline, this.newLineAfterLeftParen, this.placeRightParenOnNewLine, this.useContinuationIndent);
        }

        public FunctionDeclarationParameters withNewLineAfterLeftParen(Boolean newLineAfterLeftParen) {
            return this.newLineAfterLeftParen == newLineAfterLeftParen ? this : new FunctionDeclarationParameters(this.alignWhenMultiline, newLineAfterLeftParen, this.placeRightParenOnNewLine, this.useContinuationIndent);
        }

        public FunctionDeclarationParameters withPlaceRightParenOnNewLine(Boolean placeRightParenOnNewLine) {
            return this.placeRightParenOnNewLine == placeRightParenOnNewLine ? this : new FunctionDeclarationParameters(this.alignWhenMultiline, this.newLineAfterLeftParen, placeRightParenOnNewLine, this.useContinuationIndent);
        }

        public FunctionDeclarationParameters withUseContinuationIndent(Boolean useContinuationIndent) {
            return this.useContinuationIndent == useContinuationIndent ? this : new FunctionDeclarationParameters(this.alignWhenMultiline, this.newLineAfterLeftParen, this.placeRightParenOnNewLine, useContinuationIndent);
        }
    }

    public static final class FunctionCallArguments {
        private final Boolean alignWhenMultiline;
        private final Boolean newLineAfterLeftParen;
        private final Boolean placeRightParenOnNewLine;
        private final Boolean useContinuationIndent;

        public FunctionCallArguments(Boolean alignWhenMultiline, Boolean newLineAfterLeftParen, Boolean placeRightParenOnNewLine, Boolean useContinuationIndent) {
            this.alignWhenMultiline = alignWhenMultiline;
            this.newLineAfterLeftParen = newLineAfterLeftParen;
            this.placeRightParenOnNewLine = placeRightParenOnNewLine;
            this.useContinuationIndent = useContinuationIndent;
        }

        public Boolean getAlignWhenMultiline() {
            return this.alignWhenMultiline;
        }

        public Boolean getNewLineAfterLeftParen() {
            return this.newLineAfterLeftParen;
        }

        public Boolean getPlaceRightParenOnNewLine() {
            return this.placeRightParenOnNewLine;
        }

        public Boolean getUseContinuationIndent() {
            return this.useContinuationIndent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionCallArguments)) {
                return false;
            }
            FunctionCallArguments other = (FunctionCallArguments)o;
            Boolean this$alignWhenMultiline = this.getAlignWhenMultiline();
            Boolean other$alignWhenMultiline = other.getAlignWhenMultiline();
            if (this$alignWhenMultiline == null ? other$alignWhenMultiline != null : !((Object)this$alignWhenMultiline).equals(other$alignWhenMultiline)) {
                return false;
            }
            Boolean this$newLineAfterLeftParen = this.getNewLineAfterLeftParen();
            Boolean other$newLineAfterLeftParen = other.getNewLineAfterLeftParen();
            if (this$newLineAfterLeftParen == null ? other$newLineAfterLeftParen != null : !((Object)this$newLineAfterLeftParen).equals(other$newLineAfterLeftParen)) {
                return false;
            }
            Boolean this$placeRightParenOnNewLine = this.getPlaceRightParenOnNewLine();
            Boolean other$placeRightParenOnNewLine = other.getPlaceRightParenOnNewLine();
            if (this$placeRightParenOnNewLine == null ? other$placeRightParenOnNewLine != null : !((Object)this$placeRightParenOnNewLine).equals(other$placeRightParenOnNewLine)) {
                return false;
            }
            Boolean this$useContinuationIndent = this.getUseContinuationIndent();
            Boolean other$useContinuationIndent = other.getUseContinuationIndent();
            return !(this$useContinuationIndent == null ? other$useContinuationIndent != null : !((Object)this$useContinuationIndent).equals(other$useContinuationIndent));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $alignWhenMultiline = this.getAlignWhenMultiline();
            result = result * 59 + ($alignWhenMultiline == null ? 43 : ((Object)$alignWhenMultiline).hashCode());
            Boolean $newLineAfterLeftParen = this.getNewLineAfterLeftParen();
            result = result * 59 + ($newLineAfterLeftParen == null ? 43 : ((Object)$newLineAfterLeftParen).hashCode());
            Boolean $placeRightParenOnNewLine = this.getPlaceRightParenOnNewLine();
            result = result * 59 + ($placeRightParenOnNewLine == null ? 43 : ((Object)$placeRightParenOnNewLine).hashCode());
            Boolean $useContinuationIndent = this.getUseContinuationIndent();
            result = result * 59 + ($useContinuationIndent == null ? 43 : ((Object)$useContinuationIndent).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.FunctionCallArguments(alignWhenMultiline=" + this.getAlignWhenMultiline() + ", newLineAfterLeftParen=" + this.getNewLineAfterLeftParen() + ", placeRightParenOnNewLine=" + this.getPlaceRightParenOnNewLine() + ", useContinuationIndent=" + this.getUseContinuationIndent() + ")";
        }

        public FunctionCallArguments withAlignWhenMultiline(Boolean alignWhenMultiline) {
            return this.alignWhenMultiline == alignWhenMultiline ? this : new FunctionCallArguments(alignWhenMultiline, this.newLineAfterLeftParen, this.placeRightParenOnNewLine, this.useContinuationIndent);
        }

        public FunctionCallArguments withNewLineAfterLeftParen(Boolean newLineAfterLeftParen) {
            return this.newLineAfterLeftParen == newLineAfterLeftParen ? this : new FunctionCallArguments(this.alignWhenMultiline, newLineAfterLeftParen, this.placeRightParenOnNewLine, this.useContinuationIndent);
        }

        public FunctionCallArguments withPlaceRightParenOnNewLine(Boolean placeRightParenOnNewLine) {
            return this.placeRightParenOnNewLine == placeRightParenOnNewLine ? this : new FunctionCallArguments(this.alignWhenMultiline, this.newLineAfterLeftParen, placeRightParenOnNewLine, this.useContinuationIndent);
        }

        public FunctionCallArguments withUseContinuationIndent(Boolean useContinuationIndent) {
            return this.useContinuationIndent == useContinuationIndent ? this : new FunctionCallArguments(this.alignWhenMultiline, this.newLineAfterLeftParen, this.placeRightParenOnNewLine, useContinuationIndent);
        }
    }

    public static final class FunctionParentheses {
        private final Boolean alignWhenMultiline;

        public FunctionParentheses(Boolean alignWhenMultiline) {
            this.alignWhenMultiline = alignWhenMultiline;
        }

        public Boolean getAlignWhenMultiline() {
            return this.alignWhenMultiline;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionParentheses)) {
                return false;
            }
            FunctionParentheses other = (FunctionParentheses)o;
            Boolean this$alignWhenMultiline = this.getAlignWhenMultiline();
            Boolean other$alignWhenMultiline = other.getAlignWhenMultiline();
            return !(this$alignWhenMultiline == null ? other$alignWhenMultiline != null : !((Object)this$alignWhenMultiline).equals(other$alignWhenMultiline));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $alignWhenMultiline = this.getAlignWhenMultiline();
            result = result * 59 + ($alignWhenMultiline == null ? 43 : ((Object)$alignWhenMultiline).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.FunctionParentheses(alignWhenMultiline=" + this.getAlignWhenMultiline() + ")";
        }

        public FunctionParentheses withAlignWhenMultiline(Boolean alignWhenMultiline) {
            return this.alignWhenMultiline == alignWhenMultiline ? this : new FunctionParentheses(alignWhenMultiline);
        }
    }

    public static final class ChainedFunctionCalls {
        private final Boolean wrapFirstCall;
        private final Boolean useContinuationIndent;

        public ChainedFunctionCalls(Boolean wrapFirstCall, Boolean useContinuationIndent) {
            this.wrapFirstCall = wrapFirstCall;
            this.useContinuationIndent = useContinuationIndent;
        }

        public Boolean getWrapFirstCall() {
            return this.wrapFirstCall;
        }

        public Boolean getUseContinuationIndent() {
            return this.useContinuationIndent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChainedFunctionCalls)) {
                return false;
            }
            ChainedFunctionCalls other = (ChainedFunctionCalls)o;
            Boolean this$wrapFirstCall = this.getWrapFirstCall();
            Boolean other$wrapFirstCall = other.getWrapFirstCall();
            if (this$wrapFirstCall == null ? other$wrapFirstCall != null : !((Object)this$wrapFirstCall).equals(other$wrapFirstCall)) {
                return false;
            }
            Boolean this$useContinuationIndent = this.getUseContinuationIndent();
            Boolean other$useContinuationIndent = other.getUseContinuationIndent();
            return !(this$useContinuationIndent == null ? other$useContinuationIndent != null : !((Object)this$useContinuationIndent).equals(other$useContinuationIndent));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $wrapFirstCall = this.getWrapFirstCall();
            result = result * 59 + ($wrapFirstCall == null ? 43 : ((Object)$wrapFirstCall).hashCode());
            Boolean $useContinuationIndent = this.getUseContinuationIndent();
            result = result * 59 + ($useContinuationIndent == null ? 43 : ((Object)$useContinuationIndent).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.ChainedFunctionCalls(wrapFirstCall=" + this.getWrapFirstCall() + ", useContinuationIndent=" + this.getUseContinuationIndent() + ")";
        }

        public ChainedFunctionCalls withWrapFirstCall(Boolean wrapFirstCall) {
            return this.wrapFirstCall == wrapFirstCall ? this : new ChainedFunctionCalls(wrapFirstCall, this.useContinuationIndent);
        }

        public ChainedFunctionCalls withUseContinuationIndent(Boolean useContinuationIndent) {
            return this.useContinuationIndent == useContinuationIndent ? this : new ChainedFunctionCalls(this.wrapFirstCall, useContinuationIndent);
        }
    }

    public static final class IfStatement {
        private final Boolean elseOnNewLine;
        private final Boolean placeRightParenOnNewLine;
        private final Boolean useContinuationIndentInConditions;

        public IfStatement(Boolean elseOnNewLine, Boolean placeRightParenOnNewLine, Boolean useContinuationIndentInConditions) {
            this.elseOnNewLine = elseOnNewLine;
            this.placeRightParenOnNewLine = placeRightParenOnNewLine;
            this.useContinuationIndentInConditions = useContinuationIndentInConditions;
        }

        public Boolean getElseOnNewLine() {
            return this.elseOnNewLine;
        }

        public Boolean getPlaceRightParenOnNewLine() {
            return this.placeRightParenOnNewLine;
        }

        public Boolean getUseContinuationIndentInConditions() {
            return this.useContinuationIndentInConditions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IfStatement)) {
                return false;
            }
            IfStatement other = (IfStatement)o;
            Boolean this$elseOnNewLine = this.getElseOnNewLine();
            Boolean other$elseOnNewLine = other.getElseOnNewLine();
            if (this$elseOnNewLine == null ? other$elseOnNewLine != null : !((Object)this$elseOnNewLine).equals(other$elseOnNewLine)) {
                return false;
            }
            Boolean this$placeRightParenOnNewLine = this.getPlaceRightParenOnNewLine();
            Boolean other$placeRightParenOnNewLine = other.getPlaceRightParenOnNewLine();
            if (this$placeRightParenOnNewLine == null ? other$placeRightParenOnNewLine != null : !((Object)this$placeRightParenOnNewLine).equals(other$placeRightParenOnNewLine)) {
                return false;
            }
            Boolean this$useContinuationIndentInConditions = this.getUseContinuationIndentInConditions();
            Boolean other$useContinuationIndentInConditions = other.getUseContinuationIndentInConditions();
            return !(this$useContinuationIndentInConditions == null ? other$useContinuationIndentInConditions != null : !((Object)this$useContinuationIndentInConditions).equals(other$useContinuationIndentInConditions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $elseOnNewLine = this.getElseOnNewLine();
            result = result * 59 + ($elseOnNewLine == null ? 43 : ((Object)$elseOnNewLine).hashCode());
            Boolean $placeRightParenOnNewLine = this.getPlaceRightParenOnNewLine();
            result = result * 59 + ($placeRightParenOnNewLine == null ? 43 : ((Object)$placeRightParenOnNewLine).hashCode());
            Boolean $useContinuationIndentInConditions = this.getUseContinuationIndentInConditions();
            result = result * 59 + ($useContinuationIndentInConditions == null ? 43 : ((Object)$useContinuationIndentInConditions).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.IfStatement(elseOnNewLine=" + this.getElseOnNewLine() + ", placeRightParenOnNewLine=" + this.getPlaceRightParenOnNewLine() + ", useContinuationIndentInConditions=" + this.getUseContinuationIndentInConditions() + ")";
        }

        public IfStatement withElseOnNewLine(Boolean elseOnNewLine) {
            return this.elseOnNewLine == elseOnNewLine ? this : new IfStatement(elseOnNewLine, this.placeRightParenOnNewLine, this.useContinuationIndentInConditions);
        }

        public IfStatement withPlaceRightParenOnNewLine(Boolean placeRightParenOnNewLine) {
            return this.placeRightParenOnNewLine == placeRightParenOnNewLine ? this : new IfStatement(this.elseOnNewLine, placeRightParenOnNewLine, this.useContinuationIndentInConditions);
        }

        public IfStatement withUseContinuationIndentInConditions(Boolean useContinuationIndentInConditions) {
            return this.useContinuationIndentInConditions == useContinuationIndentInConditions ? this : new IfStatement(this.elseOnNewLine, this.placeRightParenOnNewLine, useContinuationIndentInConditions);
        }
    }

    public static final class DoWhileStatement {
        private final Boolean whileOnNewLine;

        public DoWhileStatement(Boolean whileOnNewLine) {
            this.whileOnNewLine = whileOnNewLine;
        }

        public Boolean getWhileOnNewLine() {
            return this.whileOnNewLine;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DoWhileStatement)) {
                return false;
            }
            DoWhileStatement other = (DoWhileStatement)o;
            Boolean this$whileOnNewLine = this.getWhileOnNewLine();
            Boolean other$whileOnNewLine = other.getWhileOnNewLine();
            return !(this$whileOnNewLine == null ? other$whileOnNewLine != null : !((Object)this$whileOnNewLine).equals(other$whileOnNewLine));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $whileOnNewLine = this.getWhileOnNewLine();
            result = result * 59 + ($whileOnNewLine == null ? 43 : ((Object)$whileOnNewLine).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.DoWhileStatement(whileOnNewLine=" + this.getWhileOnNewLine() + ")";
        }

        public DoWhileStatement withWhileOnNewLine(Boolean whileOnNewLine) {
            return this.whileOnNewLine == whileOnNewLine ? this : new DoWhileStatement(whileOnNewLine);
        }
    }

    public static final class TryStatement {
        private final Boolean catchOnNewLine;
        private final Boolean finallyOnNewLine;

        public TryStatement(Boolean catchOnNewLine, Boolean finallyOnNewLine) {
            this.catchOnNewLine = catchOnNewLine;
            this.finallyOnNewLine = finallyOnNewLine;
        }

        public Boolean getCatchOnNewLine() {
            return this.catchOnNewLine;
        }

        public Boolean getFinallyOnNewLine() {
            return this.finallyOnNewLine;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TryStatement)) {
                return false;
            }
            TryStatement other = (TryStatement)o;
            Boolean this$catchOnNewLine = this.getCatchOnNewLine();
            Boolean other$catchOnNewLine = other.getCatchOnNewLine();
            if (this$catchOnNewLine == null ? other$catchOnNewLine != null : !((Object)this$catchOnNewLine).equals(other$catchOnNewLine)) {
                return false;
            }
            Boolean this$finallyOnNewLine = this.getFinallyOnNewLine();
            Boolean other$finallyOnNewLine = other.getFinallyOnNewLine();
            return !(this$finallyOnNewLine == null ? other$finallyOnNewLine != null : !((Object)this$finallyOnNewLine).equals(other$finallyOnNewLine));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $catchOnNewLine = this.getCatchOnNewLine();
            result = result * 59 + ($catchOnNewLine == null ? 43 : ((Object)$catchOnNewLine).hashCode());
            Boolean $finallyOnNewLine = this.getFinallyOnNewLine();
            result = result * 59 + ($finallyOnNewLine == null ? 43 : ((Object)$finallyOnNewLine).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.TryStatement(catchOnNewLine=" + this.getCatchOnNewLine() + ", finallyOnNewLine=" + this.getFinallyOnNewLine() + ")";
        }

        public TryStatement withCatchOnNewLine(Boolean catchOnNewLine) {
            return this.catchOnNewLine == catchOnNewLine ? this : new TryStatement(catchOnNewLine, this.finallyOnNewLine);
        }

        public TryStatement withFinallyOnNewLine(Boolean finallyOnNewLine) {
            return this.finallyOnNewLine == finallyOnNewLine ? this : new TryStatement(this.catchOnNewLine, finallyOnNewLine);
        }
    }

    public static final class BinaryExpression {
        private final Boolean alignWhenMultiline;

        public BinaryExpression(Boolean alignWhenMultiline) {
            this.alignWhenMultiline = alignWhenMultiline;
        }

        public Boolean getAlignWhenMultiline() {
            return this.alignWhenMultiline;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BinaryExpression)) {
                return false;
            }
            BinaryExpression other = (BinaryExpression)o;
            Boolean this$alignWhenMultiline = this.getAlignWhenMultiline();
            Boolean other$alignWhenMultiline = other.getAlignWhenMultiline();
            return !(this$alignWhenMultiline == null ? other$alignWhenMultiline != null : !((Object)this$alignWhenMultiline).equals(other$alignWhenMultiline));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $alignWhenMultiline = this.getAlignWhenMultiline();
            result = result * 59 + ($alignWhenMultiline == null ? 43 : ((Object)$alignWhenMultiline).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.BinaryExpression(alignWhenMultiline=" + this.getAlignWhenMultiline() + ")";
        }

        public BinaryExpression withAlignWhenMultiline(Boolean alignWhenMultiline) {
            return this.alignWhenMultiline == alignWhenMultiline ? this : new BinaryExpression(alignWhenMultiline);
        }
    }

    public static final class WhenStatements {
        private final Boolean alignWhenBranchesInColumns;
        private final Boolean newLineAfterMultilineEntry;

        public WhenStatements(Boolean alignWhenBranchesInColumns, Boolean newLineAfterMultilineEntry) {
            this.alignWhenBranchesInColumns = alignWhenBranchesInColumns;
            this.newLineAfterMultilineEntry = newLineAfterMultilineEntry;
        }

        public Boolean getAlignWhenBranchesInColumns() {
            return this.alignWhenBranchesInColumns;
        }

        public Boolean getNewLineAfterMultilineEntry() {
            return this.newLineAfterMultilineEntry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WhenStatements)) {
                return false;
            }
            WhenStatements other = (WhenStatements)o;
            Boolean this$alignWhenBranchesInColumns = this.getAlignWhenBranchesInColumns();
            Boolean other$alignWhenBranchesInColumns = other.getAlignWhenBranchesInColumns();
            if (this$alignWhenBranchesInColumns == null ? other$alignWhenBranchesInColumns != null : !((Object)this$alignWhenBranchesInColumns).equals(other$alignWhenBranchesInColumns)) {
                return false;
            }
            Boolean this$newLineAfterMultilineEntry = this.getNewLineAfterMultilineEntry();
            Boolean other$newLineAfterMultilineEntry = other.getNewLineAfterMultilineEntry();
            return !(this$newLineAfterMultilineEntry == null ? other$newLineAfterMultilineEntry != null : !((Object)this$newLineAfterMultilineEntry).equals(other$newLineAfterMultilineEntry));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $alignWhenBranchesInColumns = this.getAlignWhenBranchesInColumns();
            result = result * 59 + ($alignWhenBranchesInColumns == null ? 43 : ((Object)$alignWhenBranchesInColumns).hashCode());
            Boolean $newLineAfterMultilineEntry = this.getNewLineAfterMultilineEntry();
            result = result * 59 + ($newLineAfterMultilineEntry == null ? 43 : ((Object)$newLineAfterMultilineEntry).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.WhenStatements(alignWhenBranchesInColumns=" + this.getAlignWhenBranchesInColumns() + ", newLineAfterMultilineEntry=" + this.getNewLineAfterMultilineEntry() + ")";
        }

        public WhenStatements withAlignWhenBranchesInColumns(Boolean alignWhenBranchesInColumns) {
            return this.alignWhenBranchesInColumns == alignWhenBranchesInColumns ? this : new WhenStatements(alignWhenBranchesInColumns, this.newLineAfterMultilineEntry);
        }

        public WhenStatements withNewLineAfterMultilineEntry(Boolean newLineAfterMultilineEntry) {
            return this.newLineAfterMultilineEntry == newLineAfterMultilineEntry ? this : new WhenStatements(this.alignWhenBranchesInColumns, newLineAfterMultilineEntry);
        }
    }

    public static final class BracesPlacement {
        private final Boolean putLeftBraceOnNewLine;

        public BracesPlacement(Boolean putLeftBraceOnNewLine) {
            this.putLeftBraceOnNewLine = putLeftBraceOnNewLine;
        }

        public Boolean getPutLeftBraceOnNewLine() {
            return this.putLeftBraceOnNewLine;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BracesPlacement)) {
                return false;
            }
            BracesPlacement other = (BracesPlacement)o;
            Boolean this$putLeftBraceOnNewLine = this.getPutLeftBraceOnNewLine();
            Boolean other$putLeftBraceOnNewLine = other.getPutLeftBraceOnNewLine();
            return !(this$putLeftBraceOnNewLine == null ? other$putLeftBraceOnNewLine != null : !((Object)this$putLeftBraceOnNewLine).equals(other$putLeftBraceOnNewLine));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $putLeftBraceOnNewLine = this.getPutLeftBraceOnNewLine();
            result = result * 59 + ($putLeftBraceOnNewLine == null ? 43 : ((Object)$putLeftBraceOnNewLine).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.BracesPlacement(putLeftBraceOnNewLine=" + this.getPutLeftBraceOnNewLine() + ")";
        }

        public BracesPlacement withPutLeftBraceOnNewLine(Boolean putLeftBraceOnNewLine) {
            return this.putLeftBraceOnNewLine == putLeftBraceOnNewLine ? this : new BracesPlacement(putLeftBraceOnNewLine);
        }
    }

    public static final class ExpressionBodyFunctions {
        private final Boolean useContinuationIndent;

        public ExpressionBodyFunctions(Boolean useContinuationIndent) {
            this.useContinuationIndent = useContinuationIndent;
        }

        public Boolean getUseContinuationIndent() {
            return this.useContinuationIndent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionBodyFunctions)) {
                return false;
            }
            ExpressionBodyFunctions other = (ExpressionBodyFunctions)o;
            Boolean this$useContinuationIndent = this.getUseContinuationIndent();
            Boolean other$useContinuationIndent = other.getUseContinuationIndent();
            return !(this$useContinuationIndent == null ? other$useContinuationIndent != null : !((Object)this$useContinuationIndent).equals(other$useContinuationIndent));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $useContinuationIndent = this.getUseContinuationIndent();
            result = result * 59 + ($useContinuationIndent == null ? 43 : ((Object)$useContinuationIndent).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.ExpressionBodyFunctions(useContinuationIndent=" + this.getUseContinuationIndent() + ")";
        }

        public ExpressionBodyFunctions withUseContinuationIndent(Boolean useContinuationIndent) {
            return this.useContinuationIndent == useContinuationIndent ? this : new ExpressionBodyFunctions(useContinuationIndent);
        }
    }

    public static final class ElvisExpressions {
        private final Boolean useContinuationIndent;

        public ElvisExpressions(Boolean useContinuationIndent) {
            this.useContinuationIndent = useContinuationIndent;
        }

        public Boolean getUseContinuationIndent() {
            return this.useContinuationIndent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElvisExpressions)) {
                return false;
            }
            ElvisExpressions other = (ElvisExpressions)o;
            Boolean this$useContinuationIndent = this.getUseContinuationIndent();
            Boolean other$useContinuationIndent = other.getUseContinuationIndent();
            return !(this$useContinuationIndent == null ? other$useContinuationIndent != null : !((Object)this$useContinuationIndent).equals(other$useContinuationIndent));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $useContinuationIndent = this.getUseContinuationIndent();
            result = result * 59 + ($useContinuationIndent == null ? 43 : ((Object)$useContinuationIndent).hashCode());
            return result;
        }

        public String toString() {
            return "WrappingAndBracesStyle.ElvisExpressions(useContinuationIndent=" + this.getUseContinuationIndent() + ")";
        }

        public ElvisExpressions withUseContinuationIndent(Boolean useContinuationIndent) {
            return this.useContinuationIndent == useContinuationIndent ? this : new ElvisExpressions(useContinuationIndent);
        }
    }
}

