/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.List;
import java.util.Objects;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.kotlin.marker.AnnotationCallSite;
import org.openrewrite.kotlin.marker.CheckNotNull;
import org.openrewrite.kotlin.marker.IsNullSafe;
import org.openrewrite.kotlin.marker.IsNullable;
import org.openrewrite.kotlin.marker.KObject;
import org.openrewrite.kotlin.marker.SpreadArgument;
import org.openrewrite.kotlin.marker.TypeReferencePrefix;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.kotlin.tree.KContainer;
import org.openrewrite.kotlin.tree.KRightPadded;
import org.openrewrite.kotlin.tree.KSpace;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class KotlinVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof K.CompilationUnit;
    }

    public String getLanguage() {
        return "kotlin";
    }

    public J visitCompilationUnit(K.CompilationUnit cu, P p) {
        K.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        if ((c = c.withAnnotations(ListUtils.map(c.getAnnotations(), e -> (J.Annotation)this.visitAndCast((Tree)e, p)))).getPadding().getPackageDeclaration() != null) {
            c = c.getPadding().withPackageDeclaration((JRightPadded<J.Package>)this.visitRightPadded(c.getPadding().getPackageDeclaration(), JRightPadded.Location.PACKAGE, p));
        }
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.getPadding().withStatements(ListUtils.map(c.getPadding().getStatements(), rp -> rp.withElement((Object)Objects.requireNonNull((Statement)this.visitAndCast((Tree)rp.getElement(), p))).withAfter(this.visitSpace(rp.getAfter(), Space.Location.BLOCK_STATEMENT_SUFFIX, p))));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("Kotlin has a different structure for its compilation unit. See K.CompilationUnit.");
    }

    public J visitAnnotatedExpression(K.AnnotatedExpression annotatedExpression, P p) {
        K.AnnotatedExpression ae = annotatedExpression;
        ae = ae.withMarkers(this.visitMarkers(ae.getMarkers(), p));
        Expression temp = (Expression)this.visitExpression(ae = ae.withAnnotations(ListUtils.map(ae.getAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))), p);
        if (!(temp instanceof K.AnnotatedExpression)) {
            return temp;
        }
        ae = (K.AnnotatedExpression)temp;
        return ae;
    }

    public J visitBinary(K.Binary binary, P p) {
        K.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), KSpace.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof K.Binary)) {
            return temp;
        }
        b = (K.Binary)temp;
        b = b.withLeft((Expression)this.visitAndCast((Tree)b.getLeft(), p));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), p));
        b = b.withRight((Expression)this.visitAndCast((Tree)b.getRight(), p));
        b = b.withType(this.visitType(b.getType(), p));
        return b;
    }

    public J visitClassDeclaration(K.ClassDeclaration classDeclaration, P p) {
        K.ClassDeclaration c = classDeclaration;
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withClassDeclaration((J.ClassDeclaration)this.visitAndCast((Tree)c.getClassDeclaration(), p));
        c = c.withTypeConstraints((K.TypeConstraints)this.visitAndCast((Tree)c.getTypeConstraints(), p));
        return c;
    }

    public J visitConstructor(K.Constructor constructor, P p) {
        K.Constructor c = constructor;
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withMethodDeclaration((J.MethodDeclaration)this.visitAndCast((Tree)c.getMethodDeclaration(), p));
        c = c.withColon(this.visitSpace(c.getColon(), KSpace.Location.CONSTRUCTOR_COLON, p));
        c = c.withConstructorInvocation((K.ConstructorInvocation)this.visitAndCast((Tree)c.getConstructorInvocation(), p));
        return c;
    }

    public J visitConstructorInvocation(K.ConstructorInvocation constructorInvocation, P p) {
        K.ConstructorInvocation d = constructorInvocation;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), KSpace.Location.CONSTRUCTOR_INVOCATION_PREFIX, p));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withTypeTree((TypeTree)this.visitAndCast((Tree)d.getTypeTree(), p));
        d = d.getPadding().withArguments((JContainer<Expression>)this.visitContainer(d.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, p));
        return d;
    }

    public J visitDelegatedSuperType(K.DelegatedSuperType delegatedSuperType, P p) {
        K.DelegatedSuperType d = delegatedSuperType;
        d = d.withBy(this.visitSpace(d.getBy(), KSpace.Location.DELEGATED_SUPER_TYPE_BY, p));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withTypeTree((TypeTree)this.visitAndCast((Tree)d.getTypeTree(), p));
        d = d.withDelegate((Expression)this.visitAndCast((Tree)d.getDelegate(), p));
        return d;
    }

    public J visitDestructuringDeclaration(K.DestructuringDeclaration destructuringDeclaration, P p) {
        K.DestructuringDeclaration d = destructuringDeclaration;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), KSpace.Location.DESTRUCTURING_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof K.DestructuringDeclaration)) {
            return temp;
        }
        d = (K.DestructuringDeclaration)temp;
        d = d.withInitializer((J.VariableDeclarations)this.visitAndCast((Tree)d.getInitializer(), p));
        d = d.getPadding().withAssignments(this.visitContainer(d.getPadding().getAssignments(), p));
        return d;
    }

    public J visitFunctionType(K.FunctionType functionType2, P p) {
        K.FunctionType f2 = functionType2;
        f2 = f2.withPrefix(this.visitSpace(f2.getPrefix(), KSpace.Location.FUNCTION_TYPE_PREFIX, p));
        f2 = f2.withMarkers(this.visitMarkers(f2.getMarkers(), p));
        f2 = f2.withLeadingAnnotations(ListUtils.map(f2.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p)));
        f2 = f2.withModifiers(ListUtils.map(f2.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p)));
        if ((f2 = f2.withReceiver(this.visitRightPadded(f2.getReceiver(), p))).getPadding().getParameters() != null) {
            f2 = f2.getPadding().withParameters(this.visitContainer(f2.getPadding().getParameters(), KContainer.Location.FUNCTION_TYPE_PARAMETERS, p));
        }
        f2 = f2.withReturnType(this.visitRightPadded(f2.getReturnType(), p));
        return f2;
    }

    public J visitFunctionTypeParameter(K.FunctionType.Parameter parameter, P p) {
        K.FunctionType.Parameter pa = parameter;
        if ((pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), p))).getName() != null) {
            pa = pa.withName((J.Identifier)this.visitAndCast((Tree)pa.getName(), p));
        }
        pa = pa.withParameterType((TypeTree)this.visitAndCast((Tree)pa.getParameterType(), p));
        return pa;
    }

    public J visitKReturn(K.KReturn kReturn, P p) {
        K.KReturn r = kReturn;
        r = (K.KReturn)r.withPrefix(this.visitSpace(r.getPrefix(), KSpace.Location.KRETURN_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(r = (K.KReturn)r.withMarkers(this.visitMarkers(r.getMarkers(), p)), p);
        if (!(temp instanceof K.KReturn)) {
            return temp;
        }
        r = (K.KReturn)temp;
        Expression temp2 = (Expression)this.visitExpression(r, p);
        if (!(temp2 instanceof K.KReturn)) {
            return temp2;
        }
        r = (K.KReturn)temp2;
        r = r.withExpression((J.Return)this.visitAndCast((Tree)r.getExpression(), p));
        r = r.withLabel((J.Identifier)this.visitAndCast((Tree)r.getLabel(), p));
        return r;
    }

    public J visitKString(K.KString kString, P p) {
        K.KString k = kString;
        k = k.withPrefix(this.visitSpace(k.getPrefix(), KSpace.Location.KSTRING_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(k = k.withMarkers(this.visitMarkers(k.getMarkers(), p)), p);
        if (!(temp instanceof K.KString)) {
            return temp;
        }
        k = (K.KString)temp;
        k = k.withStrings(ListUtils.map(k.getStrings(), s -> (J)this.visit((Tree)s, p)));
        k = k.withType(this.visitType(k.getType(), p));
        return k;
    }

    public J visitKThis(K.KThis kThis, P p) {
        K.KThis k = kThis;
        k = k.withPrefix(this.visitSpace(k.getPrefix(), KSpace.Location.KTHIS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(k = k.withMarkers(this.visitMarkers(k.getMarkers(), p)), p);
        if (!(temp instanceof K.KThis)) {
            return temp;
        }
        k = (K.KThis)temp;
        k = k.withType(this.visitType(k.getType(), p));
        return k;
    }

    public J visitKStringValue(K.KString.Value value, P p) {
        K.KString.Value v = value;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), KSpace.Location.KSTRING_VALUE_PREFIX, p));
        v = v.withMarkers(this.visitMarkers(v.getMarkers(), p));
        v = v.withTree((J)this.visit((Tree)v.getTree(), p));
        v = v.withAfter(this.visitSpace(v.getAfter(), KSpace.Location.KSTRING_VALUE_AFTER, p));
        return v;
    }

    public J visitListLiteral(K.ListLiteral listLiteral, P p) {
        K.ListLiteral l = listLiteral;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), KSpace.Location.LIST_LITERAL_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(l = l.withMarkers(this.visitMarkers(l.getMarkers(), p)), p);
        if (!(temp instanceof K.ListLiteral)) {
            return temp;
        }
        l = (K.ListLiteral)temp;
        l = l.getPadding().withElements(this.visitContainer(l.getPadding().getElements(), p));
        l = l.withType(this.visitType(l.getType(), p));
        return l;
    }

    public J visitMethodDeclaration(K.MethodDeclaration methodDeclaration, P p) {
        K.MethodDeclaration m = methodDeclaration;
        m = m.withMarkers(this.visitMarkers(m.getMarkers(), p));
        m = m.withMethodDeclaration((J.MethodDeclaration)this.visitAndCast((Tree)m.getMethodDeclaration(), p));
        m = m.withTypeConstraints((K.TypeConstraints)this.visitAndCast((Tree)m.getTypeConstraints(), p));
        return m;
    }

    public J visitNamedVariableInitializer(K.NamedVariableInitializer namedVariableInitializer, P p) {
        K.NamedVariableInitializer n = namedVariableInitializer;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), KSpace.Location.NAMED_VARIABLE_INITIALIZER_PREFIX, p));
        n = n.withMarkers(this.visitMarkers(n.getMarkers(), p));
        n = n.withInitializations(ListUtils.map(n.getInitializations(), it -> (J)this.visitAndCast((Tree)it, p)));
        return n;
    }

    public J visitProperty(K.Property property, P p) {
        K.Property pr = property;
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), KSpace.Location.PROPERTY_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(pr = pr.withMarkers(this.visitMarkers(pr.getMarkers(), p)), p);
        if (!(temp instanceof K.Property)) {
            return temp;
        }
        pr = (K.Property)temp;
        pr = pr.withVariableDeclarations((J.VariableDeclarations)this.visitAndCast((Tree)pr.getVariableDeclarations(), p));
        pr = pr.getPadding().withReceiver(this.visitRightPadded(pr.getPadding().getReceiver(), p));
        pr = pr.withGetter((J.MethodDeclaration)this.visitAndCast((Tree)pr.getGetter(), p));
        pr = pr.withSetter((J.MethodDeclaration)this.visitAndCast((Tree)pr.getSetter(), p));
        return pr;
    }

    public J visitSpreadArgument(K.SpreadArgument spreadArgument, P p) {
        K.SpreadArgument s = spreadArgument;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), KSpace.Location.SPREAD_ARGUMENT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(s = s.withMarkers(this.visitMarkers(s.getMarkers(), p)), p);
        if (!(temp instanceof K.SpreadArgument)) {
            return temp;
        }
        s = (K.SpreadArgument)temp;
        s = s.withExpression((Expression)this.visitAndCast((Tree)s.getExpression(), p));
        return s;
    }

    public J visitTypeConstraints(K.TypeConstraints typeConstraints, P p) {
        K.TypeConstraints t = typeConstraints;
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        t = t.getPadding().withConstraints(this.visitContainer(t.getPadding().getConstraints(), p));
        return t;
    }

    public J visitUnary(K.Unary unary, P p) {
        K.Unary u = unary;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), KSpace.Location.UNARY_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof K.Unary)) {
            return temp;
        }
        u = (K.Unary)temp;
        Expression temp2 = (Expression)this.visitExpression(u, p);
        if (!(temp2 instanceof K.Unary)) {
            return temp2;
        }
        u = (K.Unary)temp2;
        u = u.getPadding().withOperator((JLeftPadded<K.Unary.Type>)this.visitLeftPadded(u.getPadding().getOperator(), JLeftPadded.Location.UNARY_OPERATOR, p));
        u = u.withExpression((Expression)this.visitAndCast((Tree)u.getExpression(), p));
        u = u.withType(this.visitType(u.getType(), p));
        return u;
    }

    public J visitWhen(K.When when, P p) {
        K.When w = when;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), KSpace.Location.WHEN_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof K.When)) {
            return temp;
        }
        w = (K.When)temp;
        w = w.withSelector((J.ControlParentheses<J>)((J.ControlParentheses)this.visitAndCast((Tree)w.getSelector(), p)));
        w = w.withBranches((J.Block)this.visitAndCast((Tree)w.getBranches(), p));
        w = w.withType(this.visitType(w.getType(), p));
        return w;
    }

    public J visitWhenBranch(K.WhenBranch whenBranch, P p) {
        K.WhenBranch w = whenBranch;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), KSpace.Location.WHEN_BRANCH_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof K.WhenBranch)) {
            return temp;
        }
        w = (K.WhenBranch)temp;
        w = w.getPadding().withExpressions(this.visitContainer(w.getPadding().getExpressions(), p));
        w = w.getPadding().withBody((JRightPadded<J>)this.visitRightPadded(w.getPadding().getBody(), JRightPadded.Location.CASE_BODY, p));
        return w;
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, KSpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> JContainer<J2> visitContainer(@Nullable JContainer<J2> container, KContainer.Location loc, P p) {
        if (container == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
        List js = ListUtils.map((List)container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build((Space)before, (List)js, (Markers)container.getMarkers());
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, KRightPadded.Location loc, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)right.getElement()), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        Markers markers = this.visitMarkers(right.getMarkers(), p);
        return after == right.getAfter() && t == right.getElement() && markers == right.getMarkers() ? right : new JRightPadded<T>(t, after, markers);
    }

    public <M extends Marker> M visitMarker(Marker marker, P p) {
        Marker m = super.visitMarker(marker, p);
        if (m instanceof AnnotationCallSite) {
            AnnotationCallSite acs = (AnnotationCallSite)marker;
            m = acs.withSuffix(this.visitSpace(acs.getSuffix(), KSpace.Location.ANNOTATION_CALL_SITE_PREFIX, p));
        } else if (marker instanceof CheckNotNull) {
            CheckNotNull cnn = (CheckNotNull)marker;
            m = cnn.withPrefix(this.visitSpace(cnn.getPrefix(), KSpace.Location.CHECK_NOT_NULL_PREFIX, p));
        } else if (marker instanceof IsNullable) {
            IsNullable isn = (IsNullable)marker;
            m = isn.withPrefix(this.visitSpace(isn.getPrefix(), KSpace.Location.IS_NULLABLE_PREFIX, p));
        } else if (marker instanceof IsNullSafe) {
            IsNullSafe ins = (IsNullSafe)marker;
            m = ins.withPrefix(this.visitSpace(ins.getPrefix(), KSpace.Location.IS_NULLABLE_PREFIX, p));
        } else if (marker instanceof KObject) {
            KObject ko = (KObject)marker;
            m = ko.withPrefix(this.visitSpace(ko.getPrefix(), KSpace.Location.OBJECT_PREFIX, p));
        } else if (marker instanceof SpreadArgument) {
            SpreadArgument sa = (SpreadArgument)marker;
            m = sa.withPrefix(this.visitSpace(sa.getPrefix(), KSpace.Location.SPREAD_ARGUMENT_PREFIX, p));
        } else if (marker instanceof TypeReferencePrefix) {
            TypeReferencePrefix tr = (TypeReferencePrefix)marker;
            m = tr.withPrefix(this.visitSpace(tr.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p));
        }
        return (M)m;
    }
}

