/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.kotlin.internal.PsiToken;
import org.openrewrite.kotlin.internal.PsiTree;

public class PsiTreePrinter {
    private static final String TAB = "    ";
    private static final String ELEMENT_PREFIX = "\\---";
    private static final char BRANCH_CONTINUE_CHAR = '|';
    private static final char BRANCH_END_CHAR = '\\';
    private static final int CONTENT_MAX_LENGTH = 200;
    private final List<StringBuilder> outputLines = new ArrayList<StringBuilder>();

    protected PsiTreePrinter() {
    }

    public static String print(PsiElement psiElement) {
        return PsiTreePrinter.printPsiTree(psiElement);
    }

    public static String print(Parser.Input input) {
        return PsiTreePrinter.printIndexedSourceCode(input.getSource((ExecutionContext)new InMemoryExecutionContext()).readFully());
    }

    public static String printPsiTreeSkeleton(PsiElement psiElement) {
        PsiTreePrinter treePrinter = new PsiTreePrinter();
        StringBuilder sb = new StringBuilder();
        sb.append("------------").append("\n");
        sb.append("PSI Tree Skeleton").append("\n");
        HashSet<TextRange> covered = new HashSet<TextRange>();
        PsiTreePrinter.collectCovered(psiElement, covered);
        treePrinter.printNode(psiElement, 1);
        sb.append(String.join((CharSequence)"\n", treePrinter.outputLines));
        return sb.toString();
    }

    public static String printPsiTree(PsiElement psiElement) {
        PsiTreePrinter treePrinter = new PsiTreePrinter();
        StringBuilder sb = new StringBuilder();
        sb.append("------------").append("\n");
        sb.append("PSI Tree All").append("\n");
        HashSet<TextRange> covered = new HashSet<TextRange>();
        PsiTreePrinter.collectCovered(psiElement, covered);
        treePrinter.printNode(psiElement, 1, covered, false);
        sb.append(String.join((CharSequence)"\n", treePrinter.outputLines));
        return sb.toString();
    }

    public static String printIndexedSourceCode(String sourceCode) {
        int count = 0;
        String[] lines = sourceCode.split("\n");
        StringBuilder sb = new StringBuilder();
        sb.append("------------").append("\n");
        sb.append("Source code with index:").append("\n\n");
        ArrayDeque<Integer> digits = new ArrayDeque<Integer>();
        for (String line : lines) {
            StringBuilder spacesSb = new StringBuilder();
            for (int i = 0; i < line.length(); ++i) {
                if (count % 10 == 0) {
                    String numStr = Integer.toString(count);
                    for (int j = 0; j < numStr.length(); ++j) {
                        char c = numStr.charAt(j);
                        int digit = Character.getNumericValue(c);
                        digits.add(digit);
                    }
                }
                if (!digits.isEmpty()) {
                    spacesSb.append(digits.poll());
                } else {
                    spacesSb.append(" ");
                }
                ++count;
            }
            sb.append(line).append("\n").append((CharSequence)spacesSb).append("\n");
            ++count;
        }
        return sb.toString();
    }

    public static String printPsiTree(PsiTree psiTree) {
        StringBuilder sb = new StringBuilder();
        sb.append("------------").append("\n");
        sb.append("PSI Tokens").append("\n");
        for (int i = 0; i < psiTree.getTokens().size(); ++i) {
            PsiToken t = psiTree.getTokens().get(i);
            sb.append(i).append(": ").append(t).append("\n");
        }
        sb.append(PsiTreePrinter.printIndexedSourceCode(psiTree.getSource())).append("\n");
        PsiTreePrinter treePrinter = new PsiTreePrinter();
        sb.append("------------").append("\n");
        sb.append("Parsed Full PSI AST").append("\n");
        treePrinter.printNode(psiTree.getRoot(), 1);
        sb.append(String.join((CharSequence)"\n", treePrinter.outputLines));
        return sb.toString();
    }

    private void printNode(PsiElement psiElement, int depth) {
        StringBuilder line = new StringBuilder();
        line.append(PsiTreePrinter.leftPadding(depth));
        line.append(psiElement.getTextRange()).append(" | ").append(psiElement.getNode().getElementType()).append(" | ").append(psiElement.getClass().getSimpleName()).append(" | Text: \"").append(this.truncate(psiElement.getText()).replace("\n", "\\n")).append("\"");
        this.connectToLatestSibling(depth);
        this.outputLines.add(line);
        for (PsiElement childNode : psiElement.getChildren()) {
            this.printNode(childNode, depth + 1);
        }
    }

    private void printNode(PsiElement psiElement, int depth, Set<TextRange> covered, boolean isExtendedNode) {
        StringBuilder line = new StringBuilder();
        line.append(PsiTreePrinter.leftPadding(depth));
        line.append(psiElement.getTextRange()).append(isExtendedNode ? " [E]" : "").append(" | ").append(psiElement.getNode().getElementType()).append(" | ").append(psiElement.getClass().getSimpleName()).append(" | Text: \"").append(this.truncate(psiElement.getText()).replace("\n", "\\n")).append("\"");
        this.connectToLatestSibling(depth);
        this.outputLines.add(line);
        for (PsiElement childNode : psiElement.getChildren()) {
            ArrayList<PsiElement> preSiblings = new ArrayList<PsiElement>();
            for (PsiElement prevSibling = childNode.getPrevSibling(); prevSibling != null && covered.add(prevSibling.getTextRange()); prevSibling = prevSibling.getPrevSibling()) {
                preSiblings.add(prevSibling);
            }
            Collections.reverse(preSiblings);
            for (PsiElement p : preSiblings) {
                this.printNode(p, depth + 1, covered, true);
            }
            this.printNode(childNode, depth + 1, covered, false);
            ArrayList<PsiElement> nextSiblings = new ArrayList<PsiElement>();
            for (PsiElement nextSibling = childNode.getNextSibling(); nextSibling != null && covered.add(nextSibling.getTextRange()); nextSibling = nextSibling.getNextSibling()) {
                nextSiblings.add(nextSibling);
            }
            for (PsiElement n : nextSiblings) {
                this.printNode(n, depth + 1, covered, true);
            }
        }
    }

    private static void collectCovered(PsiElement psiElement, Set<TextRange> covered) {
        covered.add(psiElement.getTextRange());
        for (PsiElement childNode : psiElement.getChildren()) {
            PsiTreePrinter.collectCovered(childNode, covered);
        }
    }

    private void printNode(PsiTree.Node node, int depth) {
        StringBuilder line = new StringBuilder();
        line.append(PsiTreePrinter.leftPadding(depth));
        line.append(" ").append(node.getRange()).append(" | ").append(node.getType()).append(" | Text: \"").append(this.truncate(node.getPsiElement().getText()).replace("\n", "\\n")).append("\"");
        this.connectToLatestSibling(depth);
        this.outputLines.add(line);
        for (PsiTree.Node childNode : node.getChildNodes()) {
            this.printNode(childNode, depth + 1);
        }
    }

    private static String leftPadding(int depth) {
        StringBuilder sb = new StringBuilder();
        int tabCount = depth - 1;
        if (tabCount > 0) {
            sb.append(String.join((CharSequence)"", Collections.nCopies(tabCount, TAB)));
        }
        if (depth > 0) {
            sb.append(ELEMENT_PREFIX);
        }
        return sb.toString();
    }

    private void connectToLatestSibling(int depth) {
        StringBuilder line;
        if (depth <= 1) {
            return;
        }
        int pos = (depth - 1) * TAB.length();
        for (int i = this.outputLines.size() - 1; i > 0 && pos < (line = this.outputLines.get(i)).length(); --i) {
            if (line.charAt(pos) != ' ') {
                if (line.charAt(pos) != '\\') break;
                line.setCharAt(pos, '|');
                break;
            }
            line.setCharAt(pos, '|');
        }
    }

    private String truncate(String content) {
        if (content.length() > 200) {
            return content.substring(0, 197) + "...";
        }
        return content;
    }
}

