/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.psi.KtElement;
import org.openrewrite.Parser;

public class KotlinSource {
    Parser.Input input;
    Map<Integer, ASTNode> nodes;
    FirFile firFile;

    public KotlinSource(Parser.Input input, @Nullable PsiFile psiFile) {
        this.input = input;
        this.nodes = this.map(psiFile);
    }

    private Map<Integer, ASTNode> map(@Nullable PsiFile psiFile) {
        final LinkedHashMap<Integer, ASTNode> result = new LinkedHashMap<Integer, ASTNode>();
        if (psiFile == null) {
            return result;
        }
        final Set visited = Collections.newSetFromMap(new IdentityHashMap());
        PsiElementVisitor v = new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (!visited.add(element)) {
                    return;
                }
                result.put(element.getTextRange().getStartOffset(), element.getNode());
                for (PsiElement child : element.getChildren()) {
                    if (!(child instanceof KtElement)) continue;
                    this.visitElement(child);
                }
                if (element.getNextSibling() instanceof KtElement) {
                    this.visitElement(element.getNextSibling());
                }
            }
        };
        v.visitElement((PsiElement)psiFile);
        return result;
    }

    public Parser.Input getInput() {
        return this.input;
    }

    public Map<Integer, ASTNode> getNodes() {
        return this.nodes;
    }

    public FirFile getFirFile() {
        return this.firFile;
    }

    public void setFirFile(FirFile firFile) {
        this.firFile = firFile;
    }
}

