/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Unit;
import kotlin.annotation.AnnotationTarget;
import kotlin.jvm.functions.Function2;
import org.jetbrains.kotlin.KtVirtualFileSourceFile;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CoreEnvironmentUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.VfsBasedProjectEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.pipeline.CompilerPipelineKt;
import org.jetbrains.kotlin.cli.jvm.compiler.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.cli.jvm.compiler.pipeline.ModuleCompilerEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.pipeline.ModuleCompilerInput;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporterFactory;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.session.environment.AbstractProjectEnvironment;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.incremental.IncrementalFirJvmCompilerRunnerKt;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.utils.PathUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.kotlin.internal.CompiledSource;
import org.openrewrite.kotlin.internal.KotlinParserVisitor;
import org.openrewrite.kotlin.internal.KotlinSource;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class KotlinParser
implements Parser {
    public static final String SKIP_SOURCE_SET_TYPE_GENERATION = "org.openrewrite.kotlin.skipSourceSetTypeGeneration";
    private String sourceSet = "main";
    @Nullable
    private transient JavaSourceSet sourceSetProvenance;
    @Nullable
    private final Collection<Path> classpath;
    private final List<NamedStyles> styles;
    private final boolean logCompilationWarningsAndErrors;
    private final JavaTypeCache typeCache;
    private final String moduleName;

    public Stream<SourceFile> parse(String ... sources) {
        Pattern packagePattern = Pattern.compile("^package\\s+([^;]+);");
        Pattern classPattern = Pattern.compile("(class|interface|enum)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        return this.parseInputs(Arrays.stream(sources).map(sourceFile -> {
            Matcher packageMatcher = packagePattern.matcher((CharSequence)sourceFile);
            String pkg = packageMatcher.find() ? packageMatcher.group(1).replace('.', '/') + "/" : "";
            String className = Optional.ofNullable((String)simpleName.apply((String)sourceFile)).orElse(Long.toString(System.nanoTime())) + ".kt";
            Path path = Paths.get(pkg + className, new String[0]);
            return new Parser.Input(path, null, () -> new ByteArrayInputStream(sourceFile.getBytes(StandardCharsets.UTF_8)), true);
        }).collect(Collectors.toList()), null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        CompiledSource compilerCus;
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        Disposable disposable = Disposer.newDisposable();
        try {
            compilerCus = this.parse(this.acceptedInputs(sources).collect(Collectors.toList()), disposable, (ExecutionContext)pctx);
        }
        catch (Exception e) {
            return Stream.empty();
        }
        FirSession firSession = compilerCus.getFirSession();
        Stream<SourceFile> cus = compilerCus.getSources().stream().map(compiled -> {
            try {
                KotlinParserVisitor mappingVisitor = new KotlinParserVisitor((KotlinSource)compiled, relativeTo, this.styles, this.typeCache, firSession, ctx);
                SourceFile kcu = (SourceFile)mappingVisitor.visitFile(compiled.getFirFile(), (ExecutionContext)new InMemoryExecutionContext());
                parsingListener.parsed(compiled.getInput(), kcu);
                return kcu;
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build((Parser)this, (Parser.Input)compiled.getInput(), (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
            }
        });
        Disposer.dispose((Disposable)disposable);
        return cus;
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".kt");
    }

    public KotlinParser reset() {
        this.typeCache.clear();
        return this;
    }

    @Deprecated
    public void setSourceSet(String sourceSet) {
        this.sourceSetProvenance = null;
        this.sourceSet = sourceSet;
    }

    @Deprecated
    public JavaSourceSet getSourceSet(ExecutionContext ctx) {
        if (this.sourceSetProvenance == null) {
            this.sourceSetProvenance = (Boolean)ctx.getMessage(SKIP_SOURCE_SET_TYPE_GENERATION, (Object)false) != false ? new JavaSourceSet(Tree.randomId(), this.sourceSet, Collections.emptyList()) : JavaSourceSet.build((String)this.sourceSet, this.classpath == null ? Collections.emptyList() : this.classpath, (JavaTypeCache)this.typeCache, (boolean)false);
        }
        return this.sourceSetProvenance;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("openRewriteFile.kt");
    }

    public static Builder builder() {
        return new Builder();
    }

    public CompiledSource parse(List<Parser.Input> sources, Disposable disposable, ExecutionContext ctx) {
        CompilerConfiguration compilerConfiguration = this.compilerConfiguration();
        File buildFile = null;
        K2JVMCompilerArguments arguments = new K2JVMCompilerArguments();
        ModuleChunk moduleChunk = K2JVMCompilerKt.configureModuleChunk((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments, buildFile);
        List chunk = moduleChunk.getModules();
        if (this.classpath != null) {
            for (Path path : this.classpath) {
                File file;
                try {
                    file = path.toFile();
                }
                catch (UnsupportedOperationException ex) {
                    continue;
                }
                JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)compilerConfiguration, (File)file);
            }
        }
        JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)compilerConfiguration, (File)PathUtil.getResourcePathForClass(AnnotationTarget.class));
        JvmArgumentsKt.configureJavaModulesContentRoots((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments);
        JvmArgumentsKt.configureAdvancedJvmOptions((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments);
        JvmArgumentsKt.configureKlibPaths((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments);
        KotlinToJVMBytecodeCompilerKt.configureSourceRoots((CompilerConfiguration)compilerConfiguration, (List)chunk, buildFile);
        JvmContentRootsKt.configureJdkClasspathRoots((CompilerConfiguration)compilerConfiguration);
        IncrementalFirJvmCompilerRunnerKt.configureBaseRoots((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments);
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForProduction((Disposable)disposable, (CompilerConfiguration)compilerConfiguration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        Project project = environment.getProject();
        VfsBasedProjectEnvironment projectEnvironment = CompilerPipelineKt.createProjectEnvironment((CompilerConfiguration)compilerConfiguration, (Disposable)disposable, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES, (MessageCollector)((MessageCollector)compilerConfiguration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY)));
        if (chunk.size() > 1) {
            throw new IllegalStateException("Implement me. Expects chunk size of 1, but was " + chunk.size());
        }
        Module module = (Module)chunk.get(0);
        CompilerConfiguration moduleConfiguration = CoreEnvironmentUtilsKt.applyModuleProperties((CompilerConfiguration)compilerConfiguration, (Module)module, buildFile);
        moduleConfiguration.put(JVMConfigurationKeys.FRIEND_PATHS, (Object)module.getFriendPaths());
        LinkedHashSet<KtVirtualFileSourceFile> platformSources = new LinkedHashSet<KtVirtualFileSourceFile>();
        LinkedHashSet commonSources = new LinkedHashSet();
        List contentRoots = (List)compilerConfiguration.get(CLIConfigurationKeys.CONTENT_ROOTS);
        List roots = contentRoots == null ? Collections.emptyList() : contentRoots.stream().filter(KotlinSourceRoot.class::isInstance).map(KotlinSourceRoot.class::cast).collect(Collectors.toList());
        Function2 sortFiles = (virtualFile, isCommon) -> {
            KtVirtualFileSourceFile file = new KtVirtualFileSourceFile(virtualFile);
            if (isCommon.booleanValue()) {
                commonSources.add(file);
            } else {
                platformSources.add(file);
            }
            return Unit.INSTANCE;
        };
        CoreEnvironmentUtilsKt.forAllFiles(roots, (CompilerConfiguration)compilerConfiguration, (Project)project, null, (Function2)sortFiles);
        ArrayList<KotlinSource> cus = new ArrayList<KotlinSource>(sources.size());
        for (int i = 0; i < sources.size(); ++i) {
            Parser.Input source = sources.get(i);
            String fileName = "openRewriteFile.kt".equals(source.getPath().toString()) ? "openRewriteFile" + i + ".kt" : source.getPath().toString();
            LightVirtualFile vFile = new LightVirtualFile(fileName, (FileType)KotlinFileType.INSTANCE, (CharSequence)source.getSource(ctx).readFully());
            SingleRootFileViewProvider fileViewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)environment.getProject()), (VirtualFile)vFile);
            PsiFile file = fileViewProvider.getPsi((Language)KotlinLanguage.INSTANCE);
            KotlinSource kotlinSource = new KotlinSource(source, file);
            cus.add(kotlinSource);
            platformSources.add(new KtVirtualFileSourceFile((VirtualFile)vFile));
        }
        ModuleCompilerInput compilerInput = new ModuleCompilerInput(new TargetId(module.getModuleName(), module.getModuleType()), CommonPlatforms.INSTANCE.getDefaultCommonPlatform(), commonSources, JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform(), platformSources, moduleConfiguration, Collections.emptyList());
        BaseDiagnosticsCollector diagnosticsReporter = DiagnosticReporterFactory.INSTANCE.createReporter(false);
        ModuleCompilerEnvironment compilerEnvironment = new ModuleCompilerEnvironment((AbstractProjectEnvironment)projectEnvironment, diagnosticsReporter);
        CommonCompilerPerformanceManager performanceManager = (CommonCompilerPerformanceManager)compilerConfiguration.get(CLIConfigurationKeys.PERF_MANAGER);
        ModuleCompilerAnalyzedOutput output = CompilerPipelineKt.compileModuleToAnalyzedFir((ModuleCompilerInput)compilerInput, (ModuleCompilerEnvironment)compilerEnvironment, Collections.emptyList(), null, (DiagnosticReporter)diagnosticsReporter, (CommonCompilerPerformanceManager)performanceManager);
        try {
            CompilerPipelineKt.convertAnalyzedFirToIr((ModuleCompilerInput)compilerInput, (ModuleCompilerAnalyzedOutput)output, (ModuleCompilerEnvironment)compilerEnvironment);
        }
        catch (Throwable file) {
            // empty catch block
        }
        List firFiles = output.getFir();
        assert (firFiles.size() == cus.size());
        for (int j = 0; j < sources.size(); ++j) {
            FirFile firFile = (FirFile)firFiles.get(j);
            ((KotlinSource)cus.get(j)).setFirFile(firFile);
        }
        return new CompiledSource(output.getSession(), cus);
    }

    private CompilerConfiguration compilerConfiguration() {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.put(CommonConfigurationKeys.MODULE_NAME, (Object)this.moduleName);
        compilerConfiguration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, this.logCompilationWarningsAndErrors ? new PrintingMessageCollector(System.err, MessageRenderer.PLAIN_FULL_PATHS, true) : MessageCollector.Companion.getNONE());
        compilerConfiguration.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, (Object)new LanguageVersionSettingsImpl(LanguageVersion.KOTLIN_1_8, ApiVersion.KOTLIN_1_8));
        compilerConfiguration.put(CommonConfigurationKeys.USE_FIR, (Object)true);
        compilerConfiguration.put(JVMConfigurationKeys.DO_NOT_CLEAR_BINDING_CONTEXT, (Object)true);
        compilerConfiguration.put(CommonConfigurationKeys.ALLOW_ANY_SCRIPTS_IN_SOURCE_ROOTS, (Object)true);
        compilerConfiguration.put(CommonConfigurationKeys.INCREMENTAL_COMPILATION, (Object)true);
        JvmContentRootsKt.addJvmSdkRoots((CompilerConfiguration)compilerConfiguration, (List)PathUtil.getJdkClassesRootsFromCurrentJre());
        return compilerConfiguration;
    }

    private KotlinParser(Collection<Path> classpath, List<NamedStyles> styles, boolean logCompilationWarningsAndErrors, JavaTypeCache typeCache, String moduleName) {
        this.classpath = classpath;
        this.styles = styles;
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        this.typeCache = typeCache;
        this.moduleName = moduleName;
    }

    public static class Builder
    extends Parser.Builder {
        @Nullable
        private Collection<Path> classpath = JavaParser.runtimeClasspath();
        private JavaTypeCache typeCache = new JavaTypeCache();
        private boolean logCompilationWarningsAndErrors;
        private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
        private String moduleName = "main";

        public Builder() {
            super(K.CompilationUnit.class);
        }

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder classpath(Collection<Path> classpath) {
            this.classpath = classpath;
            return this;
        }

        public Builder classpath(String ... classpath) {
            this.classpath = JavaParser.dependenciesFromClasspath((String[])classpath);
            return this;
        }

        public Builder typeCache(JavaTypeCache typeCache) {
            this.typeCache = typeCache;
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public KotlinParser build() {
            return new KotlinParser(this.classpath, this.styles, this.logCompilationWarningsAndErrors, this.typeCache, this.moduleName);
        }

        public String getDslName() {
            return "kotlin";
        }
    }
}

