/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.openrewrite.kotlin.internal.PsiToken;
import org.openrewrite.kotlin.internal.PsiTree;

public class PsiTreePrinter {
    private static final String TAB = "    ";
    private static final String ELEMENT_PREFIX = "\\----";
    private static final char BRANCH_CONTINUE_CHAR = '|';
    private static final char BRANCH_END_CHAR = '\\';
    private static final int CONTENT_MAX_LENGTH = 200;
    private final List<StringBuilder> outputLines = new ArrayList<StringBuilder>();

    protected PsiTreePrinter() {
    }

    public static String printPsiTree(PsiFile psiFile) {
        PsiTreePrinter treePrinter = new PsiTreePrinter();
        StringBuilder sb = new StringBuilder();
        sb.append("Raw PSI AST").append("\n");
        treePrinter.printNode((PsiElement)psiFile, 1);
        sb.append(String.join((CharSequence)"\n", treePrinter.outputLines));
        return sb.toString();
    }

    public static String printPsiTree(PsiTree psiTree) {
        StringBuilder sb = new StringBuilder();
        sb.append("------------").append("\n");
        sb.append("Source code with index").append("\n");
        sb.append(PsiTreePrinter.printIndexedSourceCode(psiTree.getSource())).append("\n");
        sb.append("------------").append("\n");
        sb.append("PSI Tokens").append("\n");
        for (int i = 0; i < psiTree.getTokens().size(); ++i) {
            PsiToken t = psiTree.getTokens().get(i);
            sb.append(i).append(": ").append(t).append("\n");
        }
        PsiTreePrinter treePrinter = new PsiTreePrinter();
        sb.append("------------").append("\n");
        sb.append("Parsed Full PSI AST").append("\n");
        treePrinter.printNode(psiTree.getRoot(), 1);
        sb.append(String.join((CharSequence)"\n", treePrinter.outputLines));
        return sb.toString();
    }

    private void printNode(PsiElement psiElement, int depth) {
        StringBuilder line = new StringBuilder();
        line.append(PsiTreePrinter.leftPadding(depth));
        line.append(" ").append(psiElement.getTextRange()).append(" | Type:").append(psiElement.getNode().getElementType()).append(" | Text: \"").append(this.truncate(psiElement.getText()).replace("\n", "\\n")).append("\"");
        this.connectToLatestSibling(depth);
        this.outputLines.add(line);
        for (PsiElement childNode : psiElement.getChildren()) {
            this.printNode(childNode, depth + 1);
        }
    }

    private void printNode(PsiTree.Node node, int depth) {
        StringBuilder line = new StringBuilder();
        line.append(PsiTreePrinter.leftPadding(depth));
        line.append(" ").append(node.getRange()).append(" | Type:").append(node.getType()).append(" | Text: \"").append(this.truncate(node.getPsiElement().getText()).replace("\n", "\\n")).append("\"");
        this.connectToLatestSibling(depth);
        this.outputLines.add(line);
        for (PsiTree.Node childNode : node.getChildNodes()) {
            this.printNode(childNode, depth + 1);
        }
    }

    private static String printIndexedSourceCode(String sourceCode) {
        int count = 0;
        String[] lines = sourceCode.split("\n");
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            StringBuilder spacesSb = new StringBuilder();
            for (int i = 0; i < line.length(); ++i) {
                if (count % 10 == 0) {
                    spacesSb.append(count / 10 % 10);
                } else {
                    spacesSb.append(" ");
                }
                ++count;
            }
            result.append(line).append("\n").append((CharSequence)spacesSb).append("\n");
            ++count;
        }
        return result.toString();
    }

    private static String leftPadding(int depth) {
        StringBuilder sb = new StringBuilder();
        int tabCount = depth - 1;
        if (tabCount > 0) {
            sb.append(String.join((CharSequence)"", Collections.nCopies(tabCount, TAB)));
        }
        if (depth > 0) {
            sb.append(ELEMENT_PREFIX);
        }
        return sb.toString();
    }

    private void connectToLatestSibling(int depth) {
        StringBuilder line;
        if (depth <= 1) {
            return;
        }
        int pos = (depth - 1) * TAB.length();
        for (int i = this.outputLines.size() - 1; i > 0 && pos < (line = this.outputLines.get(i)).length(); --i) {
            if (line.charAt(pos) != ' ') {
                if (line.charAt(pos) != '\\') break;
                line.setCharAt(pos, '|');
                break;
            }
            line.setCharAt(pos, '|');
        }
    }

    private String truncate(String content) {
        if (content.length() > 200) {
            return content.substring(0, 197) + "...";
        }
        return content;
    }
}

