/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;

public class KotlinSource {
    Parser.Input input;
    Map<Integer, Node> nodes;
    FirFile firFile;

    public KotlinSource(Parser.Input input, @Nullable PsiFile psiFile) {
        this.input = input;
        this.nodes = this.map(psiFile);
    }

    private Map<Integer, Node> map(@Nullable PsiFile psiFile) {
        final HashMap<Integer, Node> result = new HashMap<Integer, Node>();
        if (psiFile == null) {
            return result;
        }
        final String source = this.input.getSource((ExecutionContext)new InMemoryExecutionContext()).readFully();
        final Set visited = Collections.newSetFromMap(new IdentityHashMap());
        PsiElementVisitor v = new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (!(element instanceof KtFile) && element.getTextLength() != 0) {
                    result.put(element.getTextRange().getStartOffset(), new Node(element.getTextRange().getEndOffset(), element.getNode().getTreeParent().getElementType().getDebugName(), element.getNode().getElementType().getDebugName()));
                    assert (source.substring(element.getTextRange().getStartOffset(), element.getTextRange().getEndOffset()).equals(element.getText()));
                }
                for (PsiElement child : element.getChildren()) {
                    if (!visited.add(child)) continue;
                    this.visitElement(child);
                }
                if (element.getNextSibling() != null && visited.add(element.getNextSibling())) {
                    this.visitElement(element.getNextSibling());
                }
            }
        };
        v.visitElement((PsiElement)psiFile);
        return result;
    }

    public Parser.Input getInput() {
        return this.input;
    }

    public Map<Integer, Node> getNodes() {
        return this.nodes;
    }

    public FirFile getFirFile() {
        return this.firFile;
    }

    public void setFirFile(FirFile firFile) {
        this.firFile = firFile;
    }

    public static final class Node {
        private final int endOffset;
        private final String parentName;
        private final String name;

        public Node(int endOffset, String parentName, String name) {
            this.endOffset = endOffset;
            this.parentName = parentName;
            this.name = name;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String getParentName() {
            return this.parentName;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (this.getEndOffset() != other.getEndOffset()) {
                return false;
            }
            String this$parentName = this.getParentName();
            String other$parentName = other.getParentName();
            if (this$parentName == null ? other$parentName != null : !this$parentName.equals(other$parentName)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getEndOffset();
            String $parentName = this.getParentName();
            result = result * 59 + ($parentName == null ? 43 : $parentName.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "KotlinSource.Node(endOffset=" + this.getEndOffset() + ", parentName=" + this.getParentName() + ", name=" + this.getName() + ")";
        }
    }
}

