/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirPackageDirective;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.FirLegacyRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirRawContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirErrorImport;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationArgumentMapping;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirAssignmentOperatorStatement;
import org.jetbrains.kotlin.fir.expressions.FirAugmentedArraySetCall;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirBreakExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirCheckedSafeCallSubject;
import org.jetbrains.kotlin.fir.expressions.FirClassReferenceExpression;
import org.jetbrains.kotlin.fir.expressions.FirComparisonExpression;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirContextReceiverArgumentListOwner;
import org.jetbrains.kotlin.fir.expressions.FirContinueExpression;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirDoWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirErrorLoop;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirIntegerLiteralOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirJump;
import org.jetbrains.kotlin.fir.expressions.FirLambdaArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirLoopJump;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirResolvedReifiedParameterReference;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirThrowExpression;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhileLoop;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedDelegateExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirUnitExpression;
import org.jetbrains.kotlin.fir.references.FirBackingFieldReference;
import org.jetbrains.kotlin.fir.references.FirDelegateFieldReference;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirDynamicTypeRef;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirIntersectionTypeRef;
import org.jetbrains.kotlin.fir.types.FirPlaceholderProjection;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRefWithNullability;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitUnitTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.KotlinTypeMapping;
import org.openrewrite.kotlin.internal.KotlinParsingException;
import org.openrewrite.kotlin.internal.KotlinSource;
import org.openrewrite.kotlin.marker.AnnotationCallSite;
import org.openrewrite.kotlin.marker.By;
import org.openrewrite.kotlin.marker.CheckNotNull;
import org.openrewrite.kotlin.marker.ExplicitInlineConstructor;
import org.openrewrite.kotlin.marker.Implicit;
import org.openrewrite.kotlin.marker.IsNullable;
import org.openrewrite.kotlin.marker.KObject;
import org.openrewrite.kotlin.marker.LogicalComma;
import org.openrewrite.kotlin.marker.Modifier;
import org.openrewrite.kotlin.marker.NotIs;
import org.openrewrite.kotlin.marker.OmitBraces;
import org.openrewrite.kotlin.marker.OmitEquals;
import org.openrewrite.kotlin.marker.ReceiverType;
import org.openrewrite.kotlin.marker.Semicolon;
import org.openrewrite.kotlin.marker.SingleExpressionBlock;
import org.openrewrite.kotlin.marker.SpreadArgument;
import org.openrewrite.kotlin.marker.TrailingLambdaArgument;
import org.openrewrite.kotlin.marker.TypeReferencePrefix;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;

public class KotlinParserVisitor
extends FirDefaultVisitor<J, ExecutionContext> {
    private final Path sourcePath;
    @Nullable
    private final FileAttributes fileAttributes;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private final List<NamedStyles> styles;
    private final KotlinTypeMapping typeMapping;
    private final ExecutionContext ctx;
    private final FirSession firSession;
    private int cursor;
    private final Map<Integer, KotlinSource.Node> nodes;
    @Nullable
    private FirFile currentFile;
    private final Function<FirElement, Space> commaDelim = ignored -> this.sourceBefore(",");
    private final Function<FirElement, Space> noDelim = ignored -> Space.EMPTY;

    public KotlinParserVisitor(KotlinSource kotlinSource, @Nullable Path relativeTo, List<NamedStyles> styles, JavaTypeCache typeCache, FirSession firSession, ExecutionContext ctx) {
        this.sourcePath = kotlinSource.getInput().getRelativePath(relativeTo);
        this.fileAttributes = kotlinSource.getInput().getFileAttributes();
        EncodingDetectingInputStream is = kotlinSource.getInput().getSource(ctx);
        this.source = is.readFully();
        this.charset = is.getCharset();
        this.charsetBomMarked = is.isCharsetBomMarked();
        this.styles = styles;
        this.typeMapping = new KotlinTypeMapping(typeCache, firSession);
        this.ctx = ctx;
        this.firSession = firSession;
        this.nodes = kotlinSource.getNodes();
    }

    public J visitFile(FirFile file, ExecutionContext ctx) {
        this.currentFile = file;
        List<J.Annotation> annotations = this.mapAnnotations(file.getAnnotations());
        JRightPadded<J.Package> paddedPkg = null;
        if (!file.getPackageDirective().getPackageFqName().isRoot()) {
            J.Package pkg;
            try {
                pkg = (J.Package)this.visitPackageDirective(file.getPackageDirective(), ctx);
            }
            catch (Exception e) {
                throw new KotlinParsingException("Failed to parse package directive", e);
            }
            paddedPkg = this.maybeSemicolon(pkg);
        }
        ArrayList<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>(file.getImports().size());
        for (FirImport anImport : file.getImports()) {
            J.Import importStatement;
            try {
                importStatement = (J.Import)this.visitImport(anImport, ctx);
            }
            catch (Exception e) {
                throw new KotlinParsingException("Failed to parse import", e);
            }
            imports.add(this.maybeSemicolon(importStatement));
        }
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>(file.getDeclarations().size());
        for (FirDeclaration declaration : file.getDeclarations()) {
            Statement statement;
            int savedCursor = this.cursor;
            try {
                statement = (Statement)this.visitElement((FirElement)declaration, ctx);
            }
            catch (Exception e) {
                if (declaration.getSource() == null) {
                    throw new KotlinParsingException("Failed to parse declaration", e);
                }
                this.cursor = savedCursor;
                Space prefix = this.whitespace();
                String text = declaration.getSource().getLighterASTNode().toString();
                this.skip(text);
                statement = new J.Unknown(Tree.randomId(), prefix, Markers.EMPTY, new J.Unknown.Source(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(ParseExceptionResult.build(KotlinParser.class, (Throwable)e).withTreeType(declaration.getSource().getKind().toString()))), text));
            }
            statements.add(this.maybeSemicolon(statement));
        }
        return new K.CompilationUnit(Tree.randomId(), Space.EMPTY, Markers.build(this.styles), this.sourcePath, this.fileAttributes, this.charset.name(), this.charsetBomMarked, null, annotations, paddedPkg, imports, statements, Space.format((String)this.source.substring(this.cursor)));
    }

    public J visitErrorNamedReference(FirErrorNamedReference errorNamedReference, ExecutionContext ctx) {
        if (errorNamedReference.getSource() instanceof KtRealPsiSourceElement && ((KtRealPsiSourceElement)errorNamedReference.getSource()).getPsi() instanceof KtNameReferenceExpression) {
            KtNameReferenceExpression nameReferenceExpression = (KtNameReferenceExpression)((KtRealPsiSourceElement)errorNamedReference.getSource()).getPsi();
            String name = nameReferenceExpression.getIdentifier() == null ? "{error}" : nameReferenceExpression.getIdentifier().getText();
            Space prefix = this.sourceBefore(name);
            return new J.Identifier(Tree.randomId(), prefix, Markers.EMPTY, name, null, null);
        }
        if (errorNamedReference.getSource() instanceof KtLightSourceElement) {
            String fullName = errorNamedReference.getSource().getLighterASTNode().toString();
            Space prefix = this.whitespace();
            this.skip(fullName);
            return TypeTree.build((String)fullName).withPrefix(prefix);
        }
        throw new UnsupportedOperationException("Unsupported error name reference type.");
    }

    public J visitAnnotationCall(FirAnnotationCall annotationCall, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        this.skip("@");
        if (annotationCall.getUseSiteTarget() == AnnotationUseSiteTarget.FILE) {
            this.skip("file");
            markers = markers.addIfAbsent((Marker)new AnnotationCallSite(Tree.randomId(), "file", this.sourceBefore(":")));
        }
        if (annotationCall.getUseSiteTarget() == AnnotationUseSiteTarget.PROPERTY_GETTER) {
            this.skip("get");
            markers = markers.addIfAbsent((Marker)new AnnotationCallSite(Tree.randomId(), "get", this.sourceBefore(":")));
        }
        J.Identifier name = (J.Identifier)this.visitElement((FirElement)annotationCall.getCalleeReference(), ctx);
        JContainer args = null;
        if (!annotationCall.getArgumentList().getArguments().isEmpty()) {
            List expressions;
            Space argsPrefix = this.sourceBefore("(");
            if (annotationCall.getArgumentList().getArguments().size() == 1) {
                if (annotationCall.getArgumentList().getArguments().get(0) instanceof FirVarargArgumentsExpression) {
                    FirVarargArgumentsExpression varargArgumentsExpression = (FirVarargArgumentsExpression)annotationCall.getArgumentList().getArguments().get(0);
                    expressions = this.convertAll(varargArgumentsExpression.getArguments(), this.commaDelim, t -> this.sourceBefore(")"), ctx, true);
                } else {
                    FirExpression arg = (FirExpression)annotationCall.getArgumentList().getArguments().get(0);
                    expressions = Collections.singletonList(this.convert((FirElement)arg, t -> this.sourceBefore(")"), ctx));
                }
            } else {
                expressions = this.convertAll(annotationCall.getArgumentList().getArguments(), this.commaDelim, t -> this.sourceBefore(")"), ctx, true);
            }
            args = JContainer.build((Space)argsPrefix, expressions, (Markers)Markers.EMPTY);
        }
        return new J.Annotation(Tree.randomId(), prefix, markers, (NameTree)name, args);
    }

    public J visitAnonymousFunction(FirAnonymousFunction anonymousFunction, ExecutionContext ctx) {
        J body;
        boolean omitBraces;
        Markers markers = Markers.EMPTY;
        J.Label label = null;
        if (anonymousFunction.getLabel() != null && anonymousFunction.getLabel().getSource() != null && anonymousFunction.getLabel().getSource().getKind() != KtFakeSourceElementKind.GeneratedLambdaLabel.INSTANCE) {
            label = (J.Label)this.visitElement((FirElement)anonymousFunction.getLabel(), ctx);
        }
        Space prefix = this.whitespace();
        boolean bl = omitBraces = !this.source.startsWith("{", this.cursor);
        if (omitBraces) {
            markers = markers.addIfAbsent((Marker)new OmitBraces(Tree.randomId()));
        } else {
            this.skip("{");
        }
        JavaType closureType = null;
        boolean omitDestruct = false;
        ArrayList<JRightPadded> paramExprs = new ArrayList<JRightPadded>(anonymousFunction.getValueParameters().size());
        if (!anonymousFunction.getValueParameters().isEmpty()) {
            List parameters = anonymousFunction.getValueParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                FirValueParameter p = (FirValueParameter)parameters.get(i);
                if (p.getSource() != null && p.getSource().getKind() instanceof KtFakeSourceElementKind.ItLambdaParameter) continue;
                if ("<destruct>".equals(p.getName().asString())) {
                    omitDestruct = true;
                    Space destructPrefix = this.sourceBefore("(");
                    int saveCursor = this.cursor;
                    String params = this.sourceBefore(")").getWhitespace();
                    String[] paramNames = params.split(",");
                    ArrayList<JRightPadded> destructParams = new ArrayList<JRightPadded>(paramNames.length);
                    this.cursor(saveCursor);
                    ConeTypeProjection[] typeArguments = null;
                    if (p.getReturnTypeRef() instanceof FirResolvedTypeRef && (p.getReturnTypeRef().getSource() == null || !(p.getReturnTypeRef().getSource().getKind() instanceof KtFakeSourceElementKind))) {
                        FirResolvedTypeRef typeRef = (FirResolvedTypeRef)p.getReturnTypeRef();
                        typeArguments = typeRef.getType().getTypeArguments();
                    }
                    for (int j = 0; j < paramNames.length; ++j) {
                        String paramName = paramNames[j].trim();
                        JavaType type = typeArguments == null || j >= typeArguments.length ? null : this.typeMapping.type(typeArguments[j]);
                        J.Identifier param2 = this.createIdentifier(paramName, type, null);
                        JRightPadded paramExpr = JRightPadded.build((Object)param2);
                        Space after = j < paramNames.length - 1 ? this.sourceBefore(",") : this.sourceBefore(")");
                        paramExpr = paramExpr.withAfter(after);
                        destructParams.add(paramExpr);
                    }
                    J.Lambda.Parameters destructParamsExpr = new J.Lambda.Parameters(Tree.randomId(), destructPrefix, Markers.EMPTY, true, destructParams);
                    paramExprs.add(JRightPadded.build((Object)destructParamsExpr));
                    continue;
                }
                J expr = this.visitElement((FirElement)p, ctx);
                JRightPadded param3 = JRightPadded.build((Object)expr);
                if (i != parameters.size() - 1) {
                    param3 = param3.withAfter(this.sourceBefore(","));
                }
                paramExprs.add(param3);
            }
        }
        J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), Space.EMPTY, Markers.EMPTY, false, paramExprs);
        int saveCursor = this.cursor;
        Space arrowPrefix = this.whitespace();
        if (this.source.startsWith("->", this.cursor)) {
            this.skip("->");
            params = params.getParameters().isEmpty() ? params.getPadding().withParams(Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(arrowPrefix))) : params.getPadding().withParams(ListUtils.mapLast((List)params.getPadding().getParams(), param -> param.withAfter(arrowPrefix)));
        } else {
            this.cursor(saveCursor);
        }
        Set<FirElement> skip = Collections.newSetFromMap(new IdentityHashMap());
        if (omitDestruct && anonymousFunction.getBody() != null) {
            for (FirStatement statement : anonymousFunction.getBody().getStatements()) {
                if (!(statement instanceof FirProperty) || !(((FirProperty)statement).getInitializer() instanceof FirComponentCall) || !(((FirComponentCall)((FirProperty)statement).getInitializer()).getDispatchReceiver() instanceof FirPropertyAccessExpression) || !(((FirPropertyAccessExpression)((FirComponentCall)((FirProperty)statement).getInitializer()).getDispatchReceiver()).getCalleeReference() instanceof FirResolvedNamedReference) || !"<destruct>".equals(((FirResolvedNamedReference)((FirPropertyAccessExpression)((FirComponentCall)((FirProperty)statement).getInitializer()).getDispatchReceiver()).getCalleeReference()).getName().asString())) continue;
                skip.add((FirElement)statement);
            }
        }
        J j = body = anonymousFunction.getBody() == null ? null : this.visitBlock(anonymousFunction.getBody(), skip, ctx);
        if (body instanceof J.Block && !omitBraces) {
            body = ((J.Block)body).withEnd(this.sourceBefore("}"));
        }
        if (body != null && anonymousFunction.getValueParameters().isEmpty()) {
            body = (J)body.withMarkers(body.getMarkers().removeByType(OmitBraces.class));
        }
        if (body == null) {
            body = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.EMPTY);
        }
        J.Lambda lambda = new J.Lambda(Tree.randomId(), prefix, markers, params, Space.EMPTY, body, closureType);
        return label != null ? label.withStatement((Statement)lambda) : lambda;
    }

    public J visitAnonymousFunctionExpression(FirAnonymousFunctionExpression anonymousFunctionExpression, ExecutionContext ctx) {
        if (!anonymousFunctionExpression.getAnonymousFunction().isLambda()) {
            throw new UnsupportedOperationException("Unsupported anonymous function expression.");
        }
        return this.visitAnonymousFunction(anonymousFunctionExpression.getAnonymousFunction(), ctx);
    }

    public J visitAnonymousInitializer(FirAnonymousInitializer anonymousInitializer, ExecutionContext ctx) {
        Space prefix = this.sourceBefore("init");
        J.Block staticInit = (J.Block)this.visitElement((FirElement)anonymousInitializer.getBody(), ctx);
        staticInit = staticInit.getPadding().withStatic(staticInit.getPadding().getStatic().withAfter(staticInit.getPrefix()));
        staticInit = staticInit.withPrefix(prefix);
        return staticInit.withStatic(true);
    }

    public J visitAnonymousObject(FirAnonymousObject anonymousObject, ExecutionContext ctx) {
        JContainer<Expression> args;
        Space objectPrefix = this.sourceBefore("object");
        Markers markers = Markers.EMPTY.addIfAbsent((Marker)new KObject(Tree.randomId(), objectPrefix));
        Space typeExpressionPrefix = this.sourceBefore(":");
        Space prefix = this.whitespace();
        TypeTree clazz = (TypeTree)this.visitElement((FirElement)anonymousObject.getSuperTypeRefs().get(0), ctx);
        int saveCursor = this.cursor;
        Space before = this.whitespace();
        if (this.source.startsWith("(", this.cursor)) {
            if (!anonymousObject.getDeclarations().isEmpty() && anonymousObject.getDeclarations().get(0) instanceof FirPrimaryConstructor && !((FirPrimaryConstructor)anonymousObject.getDeclarations().get(0)).getDelegatedConstructor().getArgumentList().getArguments().isEmpty()) {
                this.cursor(saveCursor);
                args = this.mapFunctionalCallArguments(((FirPrimaryConstructor)anonymousObject.getDeclarations().get(0)).getDelegatedConstructor().getArgumentList().getArguments());
            } else {
                this.skip("(");
                args = JContainer.build((Space)before, Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
            }
        } else {
            this.cursor(saveCursor);
            args = JContainer.empty().withMarkers(Markers.build(Collections.singletonList(new OmitParentheses(Tree.randomId()))));
        }
        saveCursor = this.cursor;
        J.Block body = null;
        Space bodyPrefix = this.whitespace();
        if (this.source.startsWith("{", this.cursor)) {
            this.skip("{");
            ArrayList<FirDeclaration> declarations = new ArrayList<FirDeclaration>(anonymousObject.getDeclarations().size());
            for (FirDeclaration declaration : anonymousObject.getDeclarations()) {
                if (declaration.getSource() != null && declaration.getSource().getKind() instanceof KtFakeSourceElementKind) continue;
                declarations.add(declaration);
            }
            ArrayList<JRightPadded> statements = new ArrayList<JRightPadded>(declarations.size());
            for (FirElement firElement : declarations) {
                statements.add(JRightPadded.build((Object)((Statement)this.visitElement(firElement, ctx))));
            }
            body = new J.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), statements, this.sourceBefore("}"));
        } else {
            this.cursor(saveCursor);
        }
        return new J.NewClass(Tree.randomId(), prefix, markers, null, typeExpressionPrefix, clazz, args, body, null);
    }

    public J visitAnonymousObjectExpression(FirAnonymousObjectExpression anonymousObjectExpression, ExecutionContext ctx) {
        return this.visitElement((FirElement)anonymousObjectExpression.getAnonymousObject(), ctx);
    }

    public J visitCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        FirResolvedCallableReference reference = (FirResolvedCallableReference)callableReferenceAccess.getCalleeReference();
        JavaType.Method methodReferenceType = null;
        if (reference.getResolvedSymbol() instanceof FirNamedFunctionSymbol) {
            methodReferenceType = this.typeMapping.methodDeclarationType((FirFunction)((FirNamedFunctionSymbol)reference.getResolvedSymbol()).getFir(), TypeUtils.asFullyQualified((JavaType)this.typeMapping.type(callableReferenceAccess.getExplicitReceiver())), this.getCurrentFile());
        }
        JavaType.Variable fieldReferenceType = null;
        if (reference.getResolvedSymbol() instanceof FirPropertySymbol) {
            fieldReferenceType = this.typeMapping.variableType((FirVariableSymbol<? extends FirVariable>)((FirVariableSymbol)reference.getResolvedSymbol()), TypeUtils.asFullyQualified((JavaType)this.typeMapping.type(callableReferenceAccess.getExplicitReceiver())), this.getCurrentFile());
        }
        return new J.MemberReference(Tree.randomId(), prefix, Markers.EMPTY, this.padRight(callableReferenceAccess.getExplicitReceiver() == null ? new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY) : (Expression)this.visitElement((FirElement)callableReferenceAccess.getExplicitReceiver(), ctx), this.sourceBefore("::")), callableReferenceAccess.getTypeArguments().isEmpty() ? null : this.mapTypeArguments(callableReferenceAccess.getTypeArguments()), this.padLeft(this.whitespace(), (J.Identifier)this.visitElement((FirElement)callableReferenceAccess.getCalleeReference(), ctx)), this.typeMapping.type(callableReferenceAccess.getCalleeReference()), methodReferenceType, fieldReferenceType);
    }

    public J visitArrayOfCall(FirArrayOfCall arrayOfCall, ExecutionContext ctx) {
        return new K.ListLiteral(Tree.randomId(), this.sourceBefore("["), Markers.EMPTY, (JContainer<Expression>)(arrayOfCall.getArgumentList().getArguments().isEmpty() ? JContainer.build(Collections.singletonList(new JRightPadded((Object)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), this.sourceBefore("]"), Markers.EMPTY))) : JContainer.build((Space)Space.EMPTY, this.convertAll(arrayOfCall.getArgumentList().getArguments(), this.commaDelim, t -> this.sourceBefore("]"), ctx, true), (Markers)Markers.EMPTY)), this.typeMapping.type(arrayOfCall));
    }

    public J visitBackingFieldReference(FirBackingFieldReference backingFieldReference, ExecutionContext ctx) {
        String name = backingFieldReference.getName().asString().startsWith("$") ? backingFieldReference.getName().asString().substring(1) : backingFieldReference.getName().asString();
        return this.createIdentifier(name, (FirResolvedNamedReference)backingFieldReference);
    }

    public J visitBinaryLogicExpression(FirBinaryLogicExpression binaryLogicExpression, ExecutionContext ctx) {
        J.Binary.Type op;
        Space prefix = this.whitespace();
        Space beforeParens = Space.EMPTY;
        boolean includeParentheses = false;
        if (this.source.startsWith("(", this.cursor)) {
            this.skip("(");
            beforeParens = prefix;
            prefix = this.whitespace();
            includeParentheses = true;
        }
        Expression left = (Expression)this.visitElement((FirElement)binaryLogicExpression.getLeftOperand(), ctx);
        Markers markers = Markers.EMPTY;
        Space opPrefix = this.whitespace();
        if (LogicOperationKind.AND == binaryLogicExpression.getKind()) {
            this.skip("&&");
            op = J.Binary.Type.And;
        } else if (LogicOperationKind.OR == binaryLogicExpression.getKind()) {
            if (this.source.startsWith(",", this.cursor)) {
                this.skip(",");
                markers = Markers.build(Collections.singletonList(new LogicalComma(Tree.randomId())));
            } else {
                this.skip("||");
            }
            op = J.Binary.Type.Or;
        } else {
            throw new UnsupportedOperationException("Unsupported binary expression type " + binaryLogicExpression.getKind().name());
        }
        Expression right = (Expression)this.visitElement((FirElement)binaryLogicExpression.getRightOperand(), ctx);
        J.Binary binary = new J.Binary(Tree.randomId(), prefix, markers, left, this.padLeft(opPrefix, op), right, this.typeMapping.type(binaryLogicExpression));
        return includeParentheses ? new J.Parentheses(Tree.randomId(), beforeParens, Markers.EMPTY, JRightPadded.build((Object)binary).withAfter(this.sourceBefore(")"))) : binary;
    }

    public J visitBlock(FirBlock block, ExecutionContext ctx) {
        return this.visitBlock(block, Collections.emptySet(), ctx);
    }

    private J visitBlock(FirBlock block, Set<FirElement> skipStatements, ExecutionContext ctx) {
        boolean isEmptyBody;
        int saveCursor = this.cursor;
        Space prefix = this.whitespace();
        OmitBraces omitBraces = null;
        boolean bl = isEmptyBody = !this.source.startsWith("{", this.cursor);
        if (isEmptyBody) {
            this.cursor(saveCursor);
            prefix = Space.EMPTY;
            omitBraces = new OmitBraces(Tree.randomId());
        } else {
            this.skip("{");
        }
        ArrayList<FirStatement> firStatements = new ArrayList<FirStatement>(block.getStatements().size());
        for (FirStatement s : block.getStatements()) {
            if (skipStatements.contains(s) || s.getSource() != null && s.getSource().getKind() instanceof KtFakeSourceElementKind.ImplicitConstructor) continue;
            firStatements.add(s);
        }
        ArrayList<JRightPadded> statements = new ArrayList<JRightPadded>(firStatements.size());
        for (int i = 0; i < firStatements.size(); ++i) {
            FirBlock check;
            FirElement firElement = (FirElement)firStatements.get(i);
            if (firElement.getSource() != null && firElement.getSource().getKind() instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement && !(firElement instanceof FirVariableAssignment)) continue;
            J expr = null;
            if (firElement instanceof FirBlock && ((FirBlock)firElement).getStatements().size() == 2 && (check = (FirBlock)firElement).getStatements().get(0) instanceof FirProperty && "<iterator>".equals(((FirProperty)check.getStatements().get(0)).getName().asString()) && check.getStatements().get(1) instanceof FirWhileLoop) {
                expr = this.mapForLoop(check);
            }
            int skipImplicitDestructs = 0;
            if (firElement instanceof FirProperty && "<destruct>".equals(((FirProperty)firElement).getName().asString())) {
                saveCursor = this.cursor;
                this.sourceBefore("(");
                skipImplicitDestructs = this.sourceBefore(")").getWhitespace().split(",").length;
                this.cursor(saveCursor);
            }
            if (expr == null) {
                expr = this.visitElement(firElement, ctx);
                if (!(expr instanceof Statement)) {
                    if (expr instanceof Expression) {
                        expr = new K.ExpressionStatement(Tree.randomId(), (Expression)expr);
                    } else {
                        throw new IllegalStateException("Unexpected expression type " + expr.getClass().getSimpleName());
                    }
                }
                i += skipImplicitDestructs;
            }
            JRightPadded stat = JRightPadded.build((Object)((Statement)expr));
            saveCursor = this.cursor;
            Space beforeSemicolon = this.whitespace();
            if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == ';') {
                stat = stat.withMarkers(stat.getMarkers().add((Marker)new Semicolon(Tree.randomId()))).withAfter(beforeSemicolon);
                this.skip(";");
            } else {
                this.cursor(saveCursor);
            }
            statements.add(stat);
        }
        return new J.Block(Tree.randomId(), prefix, omitBraces == null ? Markers.EMPTY : Markers.EMPTY.addIfAbsent((Marker)omitBraces), JRightPadded.build((Object)false), statements, isEmptyBody ? Space.EMPTY : this.sourceBefore("}"));
    }

    public J visitBreakExpression(FirBreakExpression breakExpression, ExecutionContext ctx) {
        Space prefix = this.sourceBefore("break");
        J.Identifier label = null;
        if (breakExpression.getTarget().getLabelName() != null) {
            this.skip("@");
            label = this.createIdentifier(breakExpression.getTarget().getLabelName());
        }
        return new J.Break(Tree.randomId(), prefix, Markers.EMPTY, label);
    }

    public J visitCatch(FirCatch firCatch, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        this.skip("catch");
        Space paramPrefix = this.sourceBefore("(");
        J.VariableDeclarations paramDecl = (J.VariableDeclarations)this.visitElement((FirElement)firCatch.getParameter(), ctx);
        J.ControlParentheses param = new J.ControlParentheses(Tree.randomId(), paramPrefix, Markers.EMPTY, this.padRight(paramDecl, this.sourceBefore(")")));
        return new J.Try.Catch(Tree.randomId(), prefix, Markers.EMPTY, param, (J.Block)this.visitElement((FirElement)firCatch.getBlock(), ctx));
    }

    public J visitCheckNotNullCall(FirCheckNotNullCall checkNotNullCall, ExecutionContext ctx) {
        J j = this.visitElement((FirElement)checkNotNullCall.getArgumentList().getArguments().get(0), ctx);
        return (J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new CheckNotNull(Tree.randomId(), this.sourceBefore("!!"))));
    }

    public J visitComparisonExpression(FirComparisonExpression comparisonExpression, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        FirFunctionCall functionCall = comparisonExpression.getCompareToCall();
        FirExpression receiver = functionCall.getExplicitReceiver() != null ? functionCall.getExplicitReceiver() : functionCall.getDispatchReceiver();
        J j = this.visitElement((FirElement)receiver, ctx);
        Expression left = !(j instanceof Expression) && j instanceof Statement ? new K.StatementExpression(Tree.randomId(), (Statement)j) : (Expression)j;
        Space opPrefix = this.whitespace();
        J.Binary.Type op = this.mapOperation(comparisonExpression.getOperation());
        if (functionCall.getArgumentList().getArguments().size() != 1) {
            throw new UnsupportedOperationException("Unsupported FirComparisonExpression argument size");
        }
        j = this.visitElement((FirElement)functionCall.getArgumentList().getArguments().get(0), ctx);
        Expression right = !(j instanceof Expression) && j instanceof Statement ? new K.StatementExpression(Tree.randomId(), (Statement)j) : (Expression)j;
        return new J.Binary(Tree.randomId(), prefix, Markers.EMPTY, left, this.padLeft(opPrefix, op), right, this.typeMapping.type(comparisonExpression));
    }

    public <T> J visitConstExpression(FirConstExpression<T> constExpression, ExecutionContext ctx) {
        String valueSource = this.source.substring(constExpression.getSource().getStartOffset(), constExpression.getSource().getEndOffset());
        Space prefix = this.sourceBefore(valueSource);
        Object value = constExpression.getValue();
        if (!(constExpression.getTypeRef() instanceof FirResolvedTypeRef) || !(((FirResolvedTypeRef)constExpression.getTypeRef()).getType() instanceof ConeClassLikeType)) {
            throw new IllegalArgumentException("Unresolved primitive type.");
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((FirResolvedTypeRef)constExpression.getTypeRef()).getType();
        JavaType.Primitive type = this.typeMapping.primitive(coneClassLikeType);
        return new J.Literal(Tree.randomId(), prefix, Markers.EMPTY, value, valueSource, null, type);
    }

    public J visitEqualityOperatorCall(FirEqualityOperatorCall equalityOperatorCall, ExecutionContext ctx) {
        Expression rightExpr;
        if (equalityOperatorCall.getArgumentList().getArguments().size() != 2) {
            throw new UnsupportedOperationException("Unsupported number of equality operator arguments.");
        }
        FirElement left = (FirElement)equalityOperatorCall.getArgumentList().getArguments().get(0);
        FirElement right = (FirElement)equalityOperatorCall.getArgumentList().getArguments().get(1);
        if (left instanceof FirWhenSubjectExpression || right instanceof FirWhenSubjectExpression) {
            return left instanceof FirWhenSubjectExpression ? (Expression)this.visitElement(right, ctx) : (Expression)this.visitElement(left, ctx);
        }
        Space prefix = this.whitespace();
        J j = this.visitElement(left, ctx);
        Expression leftExpr = !(j instanceof Expression) && j instanceof Statement ? new K.StatementExpression(Tree.randomId(), (Statement)j) : (Expression)j;
        FirOperation op = equalityOperatorCall.getOperation();
        Space opPrefix = this.sourceBefore(op.getOperator());
        j = this.visitElement(right, ctx);
        Expression expression = rightExpr = !(j instanceof Expression) && j instanceof Statement ? new K.StatementExpression(Tree.randomId(), (Statement)j) : (Expression)j;
        if (op == FirOperation.IDENTITY || op == FirOperation.NOT_IDENTITY) {
            return new K.Binary(Tree.randomId(), prefix, Markers.EMPTY, leftExpr, this.padLeft(opPrefix, op == FirOperation.IDENTITY ? K.Binary.Type.IdentityEquals : K.Binary.Type.IdentityNotEquals), rightExpr, Space.EMPTY, this.typeMapping.type(equalityOperatorCall));
        }
        return new J.Binary(Tree.randomId(), prefix, Markers.EMPTY, leftExpr, this.padLeft(opPrefix, this.mapOperation(op)), rightExpr, this.typeMapping.type(equalityOperatorCall));
    }

    public J visitContinueExpression(FirContinueExpression continueExpression, ExecutionContext ctx) {
        Space prefix = this.sourceBefore("continue");
        J.Identifier label = null;
        if (continueExpression.getTarget().getLabelName() != null) {
            this.skip("@");
            label = this.createIdentifier(continueExpression.getTarget().getLabelName());
        }
        return new J.Continue(Tree.randomId(), prefix, Markers.EMPTY, label);
    }

    public J visitDoWhileLoop(FirDoWhileLoop doWhileLoop, ExecutionContext ctx) {
        J.Label label = null;
        if (doWhileLoop.getLabel() != null) {
            label = (J.Label)this.visitElement((FirElement)doWhileLoop.getLabel(), ctx);
        }
        Space prefix = this.whitespace();
        this.skip("do");
        J.DoWhileLoop statement = new J.DoWhileLoop(Tree.randomId(), prefix, Markers.EMPTY, JRightPadded.build((Object)((Statement)this.visitElement((FirElement)doWhileLoop.getBlock(), ctx))), this.padLeft(this.sourceBefore("while"), this.mapControlParentheses((FirElement)doWhileLoop.getCondition())));
        return label != null ? label.withStatement((Statement)statement) : statement;
    }

    public J visitElvisExpression(FirElvisExpression elvisExpression, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        J lhs = this.visitElement((FirElement)elvisExpression.getLhs(), ctx);
        if (lhs instanceof Statement && !(lhs instanceof Expression)) {
            lhs = new K.StatementExpression(Tree.randomId(), (Statement)lhs);
        }
        Space before = this.sourceBefore("?:");
        J rhs = this.visitElement((FirElement)elvisExpression.getRhs(), ctx);
        if (rhs instanceof Statement && !(rhs instanceof Expression)) {
            rhs = new K.StatementExpression(Tree.randomId(), (Statement)rhs);
        }
        return new J.Ternary(Tree.randomId(), prefix, Markers.EMPTY, (Expression)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), this.padLeft(Space.EMPTY, (Expression)lhs), this.padLeft(before, (Expression)rhs), this.typeMapping.type(elvisExpression));
    }

    public J visitEnumEntry(FirEnumEntry enumEntry, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        List<J.Annotation> annotations = this.mapAnnotations(enumEntry.getAnnotations());
        return new J.EnumValue(Tree.randomId(), prefix, Markers.EMPTY, annotations == null ? Collections.emptyList() : annotations, this.createIdentifier(enumEntry.getName().asString(), (FirElement)enumEntry), null);
    }

    public J visitSuperReference(FirSuperReference superReference, ExecutionContext ctx) {
        Space prefix = this.sourceBefore("super");
        return new J.Identifier(Tree.randomId(), prefix, Markers.EMPTY, "super", null, null);
    }

    public J visitFunctionCall(FirFunctionCall functionCall, ExecutionContext ctx) {
        String operatorName;
        FirFunctionCallOrigin origin = functionCall.getOrigin();
        J j = origin == FirFunctionCallOrigin.Operator && !(functionCall instanceof FirImplicitInvokeCall) ? (this.isUnaryOperation(operatorName = functionCall.getCalleeReference().getName().asString()) ? this.mapUnaryOperation(functionCall) : ("contains".equals(operatorName) || "rangeTo".equals(operatorName) || "get".equals(operatorName) || "set".equals(operatorName) ? this.mapKotlinBinaryOperation(functionCall) : this.mapBinaryOperation(functionCall))) : this.mapFunctionCall(functionCall, origin == FirFunctionCallOrigin.Infix);
        return j;
    }

    private J mapFunctionCall(FirFunctionCall functionCall, boolean isInfix) {
        FirNamedFunctionSymbol namedFunctionSymbol;
        ConeClassLikeLookupTag lookupTag;
        FirBasedSymbol symbol;
        JContainer args;
        Space prefix = this.whitespace();
        FirNamedReference namedReference = functionCall.getCalleeReference();
        if (namedReference instanceof FirResolvedNamedReference && ((FirResolvedNamedReference)namedReference).getResolvedSymbol() instanceof FirConstructorSymbol) {
            J.Identifier name;
            if (functionCall.getExplicitReceiver() != null) {
                J j = this.visitElement((FirElement)functionCall.getExplicitReceiver(), null);
                name = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)j, this.padLeft(this.sourceBefore("."), this.createIdentifier(namedReference.getName().asString(), (FirElement)namedReference)), this.typeMapping.type(functionCall, this.getCurrentFile()));
            } else {
                name = (J.Identifier)this.visitElement((FirElement)namedReference, null);
            }
            int saveCursor = this.cursor;
            this.whitespace();
            if (this.source.startsWith("<", this.cursor) && !functionCall.getTypeArguments().isEmpty()) {
                this.cursor(saveCursor);
                name = new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (NameTree)name, this.mapTypeArguments(functionCall.getTypeArguments()), this.typeMapping.type(functionCall, this.getCurrentFile()));
            } else {
                this.cursor(saveCursor);
            }
            ArrayList<FirExpression> arrExpressions = new ArrayList(functionCall.getArgumentList().getArguments().size());
            FirLambdaArgumentExpression init = null;
            if (functionCall.getArgumentList() instanceof FirResolvedArgumentList) {
                for (Map.Entry entry : ((FirResolvedArgumentList)functionCall.getArgumentList()).getMapping().entrySet()) {
                    if (entry.getKey() instanceof FirLambdaArgumentExpression && "init".equals(((FirValueParameter)entry.getValue()).getName().asString())) {
                        init = (FirLambdaArgumentExpression)entry.getKey();
                        continue;
                    }
                    arrExpressions.add((FirExpression)entry.getKey());
                }
            } else {
                arrExpressions = functionCall.getArgumentList().getArguments();
            }
            JContainer<Expression> args2 = this.mapFunctionalCallArguments(arrExpressions);
            J.Block body = null;
            if (init != null) {
                body = new J.Block(Tree.randomId(), this.sourceBefore("{"), Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), Collections.singletonList(this.padRight((Statement)this.visitElement((FirElement)init, this.ctx), Space.EMPTY)), this.sourceBefore("}"));
            }
            return new J.NewClass(Tree.randomId(), prefix, Markers.EMPTY, null, Space.EMPTY, (TypeTree)name, args2, body, this.typeMapping.methodInvocationType(functionCall, this.getCurrentFile()));
        }
        Markers markers = Markers.EMPTY;
        JRightPadded select = null;
        if (isInfix) {
            markers = markers.addIfAbsent((Marker)new ReceiverType(Tree.randomId()));
        }
        if (!(functionCall instanceof FirImplicitInvokeCall)) {
            FirElement receiver = this.getReceiver((FirElement)functionCall.getExplicitReceiver());
            if (receiver == null) {
                receiver = this.getReceiver((FirElement)functionCall.getDispatchReceiver());
            }
            if (receiver != null) {
                Expression selectExpr = (Expression)this.visitElement(receiver, this.ctx);
                Space after = this.whitespace();
                if (this.source.startsWith(".", this.cursor)) {
                    this.skip(".");
                } else if (this.source.startsWith("?.", this.cursor)) {
                    this.skip("?.");
                    markers = markers.addIfAbsent((Marker)new IsNullable(Tree.randomId(), Space.EMPTY));
                }
                select = JRightPadded.build((Object)selectExpr).withAfter(after);
            }
        }
        J.Identifier name = (J.Identifier)this.visitElement((FirElement)namedReference, null);
        JContainer<Expression> typeParams = null;
        if (!functionCall.getTypeArguments().isEmpty()) {
            int saveCursor = this.cursor;
            this.whitespace();
            boolean parseTypeArguments = this.source.startsWith("<", this.cursor);
            this.cursor(saveCursor);
            if (parseTypeArguments) {
                typeParams = this.mapTypeArguments(functionCall.getTypeArguments());
            }
        }
        int saveCursor = this.cursor;
        this.whitespace();
        if (this.source.startsWith("(", this.cursor)) {
            this.cursor(saveCursor);
            args = this.mapFunctionalCallArguments(functionCall.getArgumentList().getArguments());
        } else {
            this.cursor(saveCursor);
            markers = markers.addIfAbsent((Marker)new OmitParentheses(Tree.randomId()));
            ArrayList<JRightPadded> arguments = new ArrayList<JRightPadded>(functionCall.getArgumentList().getArguments().size());
            for (FirExpression argument : functionCall.getArgumentList().getArguments()) {
                J j = this.visitElement((FirElement)argument, null);
                if (j instanceof Statement && !(j instanceof Expression)) {
                    j = new K.StatementExpression(Tree.randomId(), (Statement)j);
                }
                JRightPadded padded = JRightPadded.build((Object)((Expression)j));
                arguments.add(padded);
            }
            args = JContainer.build(arguments);
        }
        FirRegularClassSymbol owner = this.getCurrentFile();
        if (namedReference instanceof FirResolvedNamedReference && (symbol = ((FirResolvedNamedReference)namedReference).getResolvedSymbol()) instanceof FirNamedFunctionSymbol && (lookupTag = ClassMembersKt.containingClass((FirCallableSymbol)(namedFunctionSymbol = (FirNamedFunctionSymbol)symbol))) != null) {
            owner = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)lookupTag, (FirSession)this.firSession);
        }
        JavaType.Method type = this.typeMapping.methodInvocationType(functionCall, (FirBasedSymbol<?>)owner);
        return new J.MethodInvocation(Tree.randomId(), prefix, markers, select, typeParams, name.withType((JavaType)type), args, type);
    }

    @Nullable
    private FirElement getReceiver(@Nullable FirElement firElement) {
        if (firElement == null || firElement.getSource() == null) {
            return null;
        }
        FirExpression receiver = null;
        if (firElement instanceof FirCheckedSafeCallSubject) {
            receiver = ((FirCheckedSafeCallSubject)firElement).getOriginalReceiverRef().getValue();
        } else if (firElement instanceof FirThisReceiverExpression) {
            receiver = firElement;
        } else if (!(firElement instanceof FirNoReceiverExpression)) {
            receiver = firElement;
        }
        return receiver;
    }

    private JContainer<Expression> mapFunctionalCallArguments(List<FirExpression> firExpressions) {
        JContainer args;
        if (firExpressions.size() == 1) {
            FirExpression firExpression = firExpressions.get(0);
            if (firExpression instanceof FirVarargArgumentsExpression) {
                FirVarargArgumentsExpression argumentsExpression = (FirVarargArgumentsExpression)firExpressions.get(0);
                args = JContainer.build((Space)this.sourceBefore("("), argumentsExpression.getArguments().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(argumentsExpression.getArguments(), this.commaDelim, t -> this.sourceBefore(")"), this.ctx, true), (Markers)Markers.EMPTY);
            } else {
                args = JContainer.build((Space)this.sourceBefore("("), this.convertAll(Collections.singletonList(firExpression), this.commaDelim, t -> this.sourceBefore(")"), this.ctx, true), (Markers)Markers.EMPTY);
            }
        } else if (firExpressions.isEmpty()) {
            int saveCursor = this.cursor;
            Space before = this.whitespace();
            if (this.source.startsWith("{", this.cursor)) {
                this.cursor(saveCursor);
                args = JContainer.build((Space)before, Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY.addIfAbsent((Marker)new OmitParentheses(Tree.randomId())));
            } else {
                this.skip("(");
                args = JContainer.build((Space)before, Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
            }
        } else {
            Space containerPrefix = this.sourceBefore("(");
            List flattenedExpressions = firExpressions.stream().map(e -> e instanceof FirVarargArgumentsExpression ? ((FirVarargArgumentsExpression)e).getArguments() : Collections.singletonList(e)).flatMap(Collection::stream).collect(Collectors.toList());
            ArrayList<JRightPadded<Expression>> expressions = new ArrayList<JRightPadded<Expression>>(flattenedExpressions.size());
            boolean isTrailingComma = false;
            for (int i = 0; i < flattenedExpressions.size(); ++i) {
                FirExpression expression = (FirExpression)flattenedExpressions.get(i);
                Object j = this.convert((FirElement)expression, this.ctx);
                if (j instanceof Statement && !(j instanceof Expression)) {
                    j = new K.StatementExpression(Tree.randomId(), (Statement)j);
                }
                Expression expr = (Expression)j;
                if (isTrailingComma) {
                    expr = (Expression)expr.withMarkers(expr.getMarkers().addIfAbsent((Marker)new TrailingLambdaArgument(Tree.randomId())));
                    expressions.add(this.padRight(expr, Space.EMPTY));
                    break;
                }
                Space padding = this.whitespace();
                if (i < flattenedExpressions.size() - 1) {
                    if (this.source.startsWith(",", this.cursor)) {
                        this.skip(",");
                    } else if (this.source.startsWith(")", this.cursor) && flattenedExpressions.get(i + 1) instanceof FirLambdaArgumentExpression) {
                        isTrailingComma = true;
                        this.skip(")");
                    }
                } else {
                    this.skip(")");
                }
                expressions.add(this.padRight(expr, padding));
            }
            args = JContainer.build((Space)containerPrefix, expressions, (Markers)Markers.EMPTY);
        }
        return args;
    }

    private JContainer<Expression> mapTypeArguments(List<? extends FirElement> types) {
        Space prefix = this.whitespace();
        if (this.source.startsWith("<", this.cursor)) {
            this.skip("<");
        }
        ArrayList<JRightPadded> parameters = new ArrayList<JRightPadded>(types.size());
        for (int i = 0; i < types.size(); ++i) {
            FirElement type = types.get(i);
            JRightPadded padded = JRightPadded.build((Object)((Expression)this.visitElement(type, null))).withAfter(i < types.size() - 1 ? this.sourceBefore(",") : this.whitespace());
            parameters.add(padded);
        }
        if (this.source.startsWith(">", this.cursor)) {
            this.skip(">");
        }
        return JContainer.build((Space)prefix, parameters, (Markers)Markers.EMPTY);
    }

    private J mapUnaryOperation(FirFunctionCall functionCall) {
        Expression expr;
        JLeftPadded<J.Unary.Type> op;
        String name;
        Space prefix = this.whitespace();
        switch (name = functionCall.getCalleeReference().getName().asString()) {
            case "dec": {
                if (this.source.startsWith("--", this.cursor)) {
                    this.skip("--");
                    op = this.padLeft(Space.EMPTY, J.Unary.Type.PreDecrement);
                    expr = (Expression)this.visitElement((FirElement)functionCall.getDispatchReceiver(), this.ctx);
                    break;
                }
                int saveCursor = this.cursor;
                String opName = this.sourceBefore("--").getWhitespace().trim();
                this.cursor(saveCursor);
                expr = this.createIdentifier(opName);
                op = this.padLeft(this.sourceBefore("--"), J.Unary.Type.PostDecrement);
                break;
            }
            case "inc": {
                if (this.source.startsWith("++", this.cursor)) {
                    this.skip("++");
                    op = this.padLeft(Space.EMPTY, J.Unary.Type.PreIncrement);
                    expr = (Expression)this.visitElement((FirElement)functionCall.getDispatchReceiver(), this.ctx);
                    break;
                }
                int saveCursor = this.cursor;
                String opName = this.sourceBefore("++").getWhitespace().trim();
                this.cursor(saveCursor);
                expr = this.createIdentifier(opName);
                op = this.padLeft(this.sourceBefore("++"), J.Unary.Type.PostIncrement);
                break;
            }
            case "not": {
                this.skip("!");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Not);
                expr = (Expression)this.visitElement((FirElement)functionCall.getDispatchReceiver(), this.ctx);
                break;
            }
            case "unaryMinus": {
                this.skip("-");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Negative);
                expr = (Expression)this.visitElement((FirElement)functionCall.getDispatchReceiver(), this.ctx);
                break;
            }
            case "unaryPlus": {
                this.skip("+");
                op = this.padLeft(Space.EMPTY, J.Unary.Type.Positive);
                expr = (Expression)this.visitElement((FirElement)functionCall.getDispatchReceiver(), this.ctx);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported unary operator type.");
            }
        }
        return new J.Unary(Tree.randomId(), prefix, Markers.EMPTY, op, expr, this.typeMapping.type(functionCall));
    }

    private J mapKotlinBinaryOperation(FirFunctionCall functionCall) {
        Expression right;
        K.Binary.Type kotlinBinaryType;
        Space opPrefix;
        Object left;
        Space prefix = this.whitespace();
        Space after = Space.EMPTY;
        String name = functionCall.getCalleeReference().getName().asString();
        if ("contains".equals(name)) {
            left = functionCall.getArgumentList().getArguments().get(0) instanceof FirWhenSubjectExpression ? new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY) : (Expression)this.visitElement((FirElement)functionCall.getArgumentList().getArguments().get(0), this.ctx);
            opPrefix = this.sourceBefore("in");
            kotlinBinaryType = K.Binary.Type.Contains;
            right = (Expression)this.visitElement((FirElement)functionCall.getExplicitReceiver(), this.ctx);
        } else if ("get".equals(name)) {
            left = (Expression)this.visitElement((FirElement)functionCall.getExplicitReceiver(), this.ctx);
            opPrefix = this.sourceBefore("[");
            kotlinBinaryType = K.Binary.Type.Get;
            right = (Expression)this.visitElement((FirElement)functionCall.getArgumentList().getArguments().get(0), this.ctx);
            after = this.sourceBefore("]");
        } else {
            if ("set".equals(name)) {
                Expression left2 = (Expression)this.visitElement((FirElement)functionCall.getExplicitReceiver(), this.ctx);
                left2 = new J.ArrayAccess(Tree.randomId(), left2.getPrefix(), Markers.EMPTY, (Expression)left2.withPrefix(Space.EMPTY), new J.ArrayDimension(Tree.randomId(), this.sourceBefore("["), Markers.EMPTY, this.padRight((Expression)this.visitElement((FirElement)functionCall.getArgumentList().getArguments().get(0), this.ctx), this.sourceBefore("]"))), this.typeMapping.type(this.typeMapping.type(functionCall.getArgumentList().getArguments().get(1))));
                Space before = this.whitespace();
                if (!this.source.startsWith("=", this.cursor)) {
                    throw new UnsupportedOperationException("Unsupported set operator type.");
                }
                this.skip("=");
                return new J.Assignment(Tree.randomId(), prefix, Markers.EMPTY, left2, this.padLeft(before, (Expression)this.visitElement((FirElement)functionCall.getArgumentList().getArguments().get(1), this.ctx)), this.typeMapping.type(functionCall.getArgumentList().getArguments().get(1)));
            }
            left = (Expression)this.visitElement((FirElement)functionCall.getExplicitReceiver(), this.ctx);
            opPrefix = this.sourceBefore("..");
            kotlinBinaryType = K.Binary.Type.RangeTo;
            right = (Expression)this.visitElement((FirElement)functionCall.getArgumentList().getArguments().get(0), this.ctx);
        }
        return new K.Binary(Tree.randomId(), prefix, Markers.EMPTY, (Expression)left, this.padLeft(opPrefix, kotlinBinaryType), right, after, this.typeMapping.type(functionCall));
    }

    private J mapBinaryOperation(FirFunctionCall functionCall) {
        Space opPrefix;
        J.Binary.Type javaBinaryType;
        String name;
        Space binaryPrefix;
        Space prefix = this.whitespace();
        boolean isParenthesized = false;
        if (!(functionCall.getDispatchReceiver() instanceof FirFunctionCall) && this.source.startsWith("(", this.cursor)) {
            isParenthesized = true;
            this.skip("(");
            binaryPrefix = this.whitespace();
        } else {
            binaryPrefix = prefix;
        }
        FirExpression receiver = functionCall.getExplicitReceiver() != null ? functionCall.getExplicitReceiver() : functionCall.getDispatchReceiver();
        Expression left = (Expression)this.visitElement((FirElement)receiver, this.ctx);
        switch (name = functionCall.getCalleeReference().getName().asString()) {
            case "div": {
                javaBinaryType = J.Binary.Type.Division;
                opPrefix = this.sourceBefore("/");
                break;
            }
            case "minus": {
                javaBinaryType = J.Binary.Type.Subtraction;
                opPrefix = this.sourceBefore("-");
                break;
            }
            case "plus": {
                javaBinaryType = J.Binary.Type.Addition;
                opPrefix = this.sourceBefore("+");
                break;
            }
            case "rem": {
                javaBinaryType = J.Binary.Type.Modulo;
                opPrefix = this.sourceBefore("%");
                break;
            }
            case "times": {
                javaBinaryType = J.Binary.Type.Multiplication;
                opPrefix = this.sourceBefore("*");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported binary operator type.");
            }
        }
        Expression right = (Expression)this.visitElement((FirElement)functionCall.getArgumentList().getArguments().get(0), this.ctx);
        J.Binary binary = new J.Binary(Tree.randomId(), binaryPrefix, Markers.EMPTY, left, this.padLeft(opPrefix, javaBinaryType), right, this.typeMapping.type(functionCall));
        return !isParenthesized ? binary : new J.Parentheses(Tree.randomId(), prefix, Markers.EMPTY, this.padRight(binary, this.sourceBefore(")")));
    }

    public J visitFunctionTypeRef(FirFunctionTypeRef functionTypeRef, ExecutionContext ctx) {
        J.Annotation annotation = null;
        if (functionTypeRef.isSuspend()) {
            Space suspendPrefix = this.whitespace();
            annotation = this.convertToAnnotation(this.mapModifier(suspendPrefix, Collections.emptyList()));
        } else if (this.source.startsWith("noinline", this.cursor)) {
            annotation = this.convertToAnnotation(this.mapModifier(Space.EMPTY, Collections.emptyList()));
        } else if (this.source.startsWith("crossinline", this.cursor)) {
            annotation = this.convertToAnnotation(this.mapModifier(Space.EMPTY, Collections.emptyList()));
        }
        ArrayList<JRightPadded> paramExprs = new ArrayList<JRightPadded>(functionTypeRef.getValueParameters().size());
        JRightPadded receiver = null;
        if (functionTypeRef.getReceiverTypeRef() != null) {
            NameTree receiverName = (NameTree)this.visitElement((FirElement)functionTypeRef.getReceiverTypeRef(), ctx);
            receiver = JRightPadded.build((Object)receiverName).withAfter(this.whitespace());
            this.skip(".");
        }
        Space prefix = this.whitespace();
        boolean parenthesized = this.source.charAt(this.cursor) == '(';
        this.skip("(");
        JavaType closureType = this.typeMapping.type(functionTypeRef);
        if (!functionTypeRef.getValueParameters().isEmpty()) {
            List parameters = functionTypeRef.getValueParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                FirValueParameter p = (FirValueParameter)parameters.get(i);
                J expr = this.visitElement((FirElement)p, ctx);
                JRightPadded param = JRightPadded.build((Object)expr);
                Space after = i < parameters.size() - 1 ? this.sourceBefore(",") : (parenthesized ? this.sourceBefore(")") : Space.EMPTY);
                param = param.withAfter(after);
                paramExprs.add(param);
            }
        }
        J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), Space.EMPTY, Markers.EMPTY, parenthesized, paramExprs);
        if (parenthesized && functionTypeRef.getValueParameters().isEmpty()) {
            params = params.getPadding().withParams(Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(this.sourceBefore(")"))));
        }
        Space arrow = this.sourceBefore("->");
        int saveCursor = this.cursor;
        this.whitespace();
        boolean omitBraces = !this.source.startsWith("{");
        this.cursor(saveCursor);
        J body = this.visitElement((FirElement)functionTypeRef.getReturnTypeRef(), ctx);
        if (body instanceof J.Block) {
            body = ((J.Block)body).withEnd(this.sourceBefore("}"));
        }
        if (functionTypeRef.getValueParameters().isEmpty()) {
            body = (J)body.withMarkers(body.getMarkers().removeByType(OmitBraces.class));
        }
        J.Lambda lambda = new J.Lambda(Tree.randomId(), prefix, omitBraces ? Markers.EMPTY.addIfAbsent((Marker)new OmitBraces(Tree.randomId())) : Markers.EMPTY, params, arrow, body, closureType);
        return new K.FunctionType(Tree.randomId(), (TypedTree)lambda, annotation, (JRightPadded<NameTree>)receiver);
    }

    public J visitImport(FirImport firImport, ExecutionContext ctx) {
        Space prefix = this.sourceBefore("import");
        JLeftPadded<Boolean> static_ = this.padLeft(Space.EMPTY, false);
        Space space = this.whitespace();
        String packageName = firImport.getImportedFqName() == null ? "" : (firImport.isAllUnder() ? firImport.getImportedFqName().asString() + ".*" : firImport.getImportedFqName().asString());
        J.FieldAccess qualid = (J.FieldAccess)TypeTree.build((String)packageName).withPrefix(space);
        this.skip(qualid.toString());
        JLeftPadded<J.Identifier> alias = null;
        if (firImport.getAliasName() != null) {
            Space asPrefix = this.sourceBefore("as");
            Space aliasPrefix = this.whitespace();
            String aliasText = firImport.getAliasName().asString();
            this.skip(aliasText);
            J.Identifier aliasId = this.createIdentifier(aliasText).withPrefix(aliasPrefix);
            alias = this.padLeft(asPrefix, aliasId);
        }
        return new J.Import(Tree.randomId(), prefix, Markers.EMPTY, static_, qualid, alias);
    }

    public J visitPackageDirective(FirPackageDirective packageDirective, ExecutionContext ctx) {
        Space pkgPrefix = this.whitespace();
        this.skip("package");
        Space pkgNamePrefix = this.whitespace();
        String packageName = packageDirective.getPackageFqName().asString();
        this.skip(packageName);
        return new J.Package(Tree.randomId(), pkgPrefix, Markers.EMPTY, (Expression)TypeTree.build((String)packageName).withPrefix(pkgNamePrefix), Collections.emptyList());
    }

    public J visitGetClassCall(FirGetClassCall getClassCall, ExecutionContext ctx) {
        return new J.MemberReference(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.padRight((Expression)this.visitElement((FirElement)getClassCall.getArgument(), ctx), this.sourceBefore("::")), null, this.padLeft(this.whitespace(), this.createIdentifier("class")), this.typeMapping.type(getClassCall), null, null);
    }

    public J visitLabel(FirLabel label, ExecutionContext ctx) {
        return new J.Label(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.padRight(this.createIdentifier(label.getName()), this.sourceBefore("@")), null);
    }

    public J visitLambdaArgumentExpression(FirLambdaArgumentExpression lambdaArgumentExpression, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        J j = this.visitElement((FirElement)lambdaArgumentExpression.getExpression(), ctx);
        return j.withPrefix(prefix);
    }

    public J visitNamedArgumentExpression(FirNamedArgumentExpression namedArgumentExpression, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        J.Identifier name = this.createIdentifier(namedArgumentExpression.getName().toString());
        Space exprPrefix = this.sourceBefore("=");
        J j = this.visitElement((FirElement)namedArgumentExpression.getExpression(), ctx);
        if (j instanceof Statement && !(j instanceof Expression)) {
            j = new K.StatementExpression(Tree.randomId(), (Statement)j);
        }
        Expression expr = (Expression)j;
        return new J.Assignment(Tree.randomId(), prefix, Markers.EMPTY, (Expression)name, this.padLeft(exprPrefix, expr), this.typeMapping.type(namedArgumentExpression.getTypeRef()));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public J visitProperty(FirProperty property, ExecutionContext ctx) {
        Markers initMarkers;
        ArrayList<Object> expressions;
        Space exprPrefix;
        J.Identifier name;
        Space namePrefix;
        void var12_17;
        ArrayList<Object> variables;
        List<J.Annotation> annotations;
        Markers markers;
        Space prefix;
        block57: {
            J.MethodDeclaration setter;
            J.MethodDeclaration getter;
            J.VariableDeclarations receiver;
            block56: {
                String methodName;
                FirResolvedTypeRef typeRef;
                J initializer;
                prefix = this.whitespace();
                markers = Markers.EMPTY;
                List modifiers = Collections.emptyList();
                ArrayList<FirAnnotation> mapAnnotations = new ArrayList<FirAnnotation>(property.getAnnotations());
                if (property.getGetter() != null && !property.getGetter().getAnnotations().isEmpty()) {
                    mapAnnotations.addAll(property.getGetter().getAnnotations());
                }
                annotations = this.mapModifiers(mapAnnotations, property.getName().asString());
                receiver = null;
                if (property.getReceiverTypeRef() != null) {
                    TypeTree receiverName = (TypeTree)this.visitElement((FirElement)property.getReceiverTypeRef(), ctx);
                    markers = markers.addIfAbsent((Marker)new ReceiverType(Tree.randomId()));
                    J.VariableDeclarations.NamedVariable receiverVar = new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "", null, null), Collections.emptyList(), null, null);
                    receiver = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), receiverName, null, Collections.emptyList(), Collections.singletonList(this.padRight(receiverVar, this.sourceBefore(".")))).withMarkers(Markers.EMPTY.addIfAbsent((Marker)new Implicit(Tree.randomId())));
                }
                boolean isDestruct = "<destruct>".equals(property.getName().asString()) && property.getReturnTypeRef() instanceof FirResolvedTypeRef;
                int initialCapacity = isDestruct ? ((FirResolvedTypeRef)property.getReturnTypeRef()).getType().getTypeArguments().length : 1;
                variables = new ArrayList<Object>(initialCapacity);
                Object var12_14 = null;
                if (isDestruct) {
                    Space destructPrefix = this.sourceBefore("(");
                    int saveCursor = this.cursor;
                    String params = this.sourceBefore(")").getWhitespace();
                    String[] paramNames = params.split(",");
                    this.cursor(saveCursor);
                    ConeTypeProjection[] typeArguments = null;
                    if (property.getReturnTypeRef() instanceof FirResolvedTypeRef && (property.getReturnTypeRef().getSource() == null || !(property.getReturnTypeRef().getSource().getKind() instanceof KtFakeSourceElementKind))) {
                        FirResolvedTypeRef typeRef2 = (FirResolvedTypeRef)property.getReturnTypeRef();
                        typeArguments = typeRef2.getType().getTypeArguments();
                    }
                    JRightPadded namedVariable = null;
                    for (int j = 0; j < paramNames.length; ++j) {
                        String paramName = paramNames[j].trim();
                        JavaType type = typeArguments == null || j >= typeArguments.length ? null : this.typeMapping.type(typeArguments[j]);
                        J.Identifier name2 = this.createIdentifier(paramName, type, null);
                        namedVariable = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), destructPrefix == null ? Space.EMPTY : destructPrefix, Markers.EMPTY, name2, Collections.emptyList(), null, this.typeMapping.variableType((FirVariableSymbol<? extends FirVariable>)property.getSymbol(), null, this.getCurrentFile())));
                        if (j != paramNames.length - 1) {
                            namedVariable = namedVariable.withAfter(this.sourceBefore(","));
                            variables.add(namedVariable);
                        } else {
                            namedVariable = namedVariable.withAfter(this.sourceBefore(")"));
                        }
                        destructPrefix = null;
                    }
                    J expr = null;
                    saveCursor = this.cursor;
                    Space exprPrefix2 = this.whitespace();
                    if (property.getInitializer() != null && this.source.startsWith("=", this.cursor)) {
                        this.skip("=");
                        expr = this.visitElement((FirElement)property.getInitializer(), ctx);
                        if (expr instanceof Statement && !(expr instanceof Expression)) {
                            expr = new K.StatementExpression(Tree.randomId(), (Statement)expr);
                        }
                    } else {
                        exprPrefix2 = Space.EMPTY;
                        this.cursor(saveCursor);
                    }
                    assert (namedVariable != null);
                    namedVariable = namedVariable.withElement((Object)((J.VariableDeclarations.NamedVariable)namedVariable.getElement()).getPadding().withInitializer(expr == null ? null : this.padLeft(exprPrefix2, (Expression)expr)));
                    variables.add(namedVariable);
                    return new J.VariableDeclarations(Tree.randomId(), prefix, markers, annotations, Collections.emptyList(), (TypeTree)var12_17, null, Collections.emptyList(), variables);
                }
                namePrefix = this.whitespace();
                name = this.createIdentifier(property.getName().asString(), (FirElement)property);
                exprPrefix = Space.EMPTY;
                expressions = null;
                initMarkers = Markers.EMPTY;
                if (property.getDelegate() != null) {
                    if (!(property.getDelegate() instanceof FirFunctionCall) || !"lazy".equals(((FirFunctionCall)property.getDelegate()).getCalleeReference().getName().asString())) throw new UnsupportedOperationException(this.generateUnsupportedMessage("Unexpected property delegation. FirProperty#delegate for name: " + ((FirFunctionCall)property.getDelegate()).getCalleeReference().getName().asString()));
                    exprPrefix = this.whitespace();
                    String current = this.source.substring(this.cursor);
                    J.Identifier delegateName = this.createIdentifier(current.substring(0, current.indexOf(((FirFunctionCall)property.getDelegate()).getCalleeReference().getName().asString())).trim());
                    this.skip(delegateName.getSimpleName());
                    initializer = this.visitElement((FirElement)property.getDelegate(), ctx);
                    initMarkers = initMarkers.addIfAbsent((Marker)new By(Tree.randomId()));
                    if (initializer instanceof Statement && !(initializer instanceof Expression)) {
                        initializer = new K.StatementExpression(Tree.randomId(), (Statement)initializer);
                    }
                    expressions = new ArrayList(1);
                    expressions.add(initializer);
                } else if (property.getReturnTypeRef() instanceof FirResolvedTypeRef && (property.getReturnTypeRef().getSource() == null || !(property.getReturnTypeRef().getSource().getKind() instanceof KtFakeSourceElementKind)) && (typeRef = (FirResolvedTypeRef)property.getReturnTypeRef()).getDelegatedTypeRef() != null) {
                    J j;
                    Space delimiterPrefix = this.whitespace();
                    boolean addTypeReferencePrefix = this.source.startsWith(":", this.cursor);
                    this.skip(":");
                    if (addTypeReferencePrefix) {
                        markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), delimiterPrefix));
                    }
                    if ((j = this.visitElement((FirElement)typeRef, ctx)) instanceof TypeTree) {
                        TypeTree typeTree = (TypeTree)j;
                    } else {
                        K.FunctionType functionType = new K.FunctionType(Tree.randomId(), (TypedTree)j, null, null);
                    }
                }
                if (property.getInitializer() != null && this.source.substring(this.cursor).trim().startsWith("=")) {
                    exprPrefix = this.whitespace();
                    expressions = new ArrayList<J>(1);
                    this.skip("=");
                    initializer = this.visitElement((FirElement)property.getInitializer(), ctx);
                    if (initializer instanceof Statement && !(initializer instanceof Expression)) {
                        initializer = new K.StatementExpression(Tree.randomId(), (Statement)initializer);
                    }
                    expressions.add(initializer);
                } else if (initMarkers.getMarkers().isEmpty()) {
                    initMarkers = initMarkers.addIfAbsent((Marker)new OmitEquals(Tree.randomId()));
                }
                if (!this.isValidGetter(property.getGetter()) || !this.isValidSetter(property.getSetter())) break block56;
                if (expressions == null) {
                    expressions = new ArrayList(2);
                }
                int saveCursor = this.cursor;
                this.whitespace();
                switch (methodName = this.source.substring(this.cursor, this.cursor + 3)) {
                    case "get": {
                        this.cursor(saveCursor);
                        if (!this.isValidGetter(property.getGetter())) break;
                        getter = (J.MethodDeclaration)this.visitElement((FirElement)property.getGetter(), ctx);
                        if (receiver != null) {
                            getter = getter.withParameters(ListUtils.concat((Object)receiver, (List)getter.getParameters()));
                        }
                        expressions.add(getter);
                        break;
                    }
                    case "set": {
                        this.cursor(saveCursor);
                        if (!this.isValidSetter(property.getSetter())) break;
                        setter = (J.MethodDeclaration)this.visitElement((FirElement)property.getSetter(), ctx);
                        if (receiver != null) {
                            setter = setter.withParameters(ListUtils.concat((Object)receiver, (List)setter.getParameters()));
                        }
                        expressions.add(setter);
                        break;
                    }
                    default: {
                        this.cursor(saveCursor);
                    }
                }
                saveCursor = this.cursor;
                this.whitespace();
                switch (methodName = this.source.substring(this.cursor, this.cursor + 3)) {
                    case "get": {
                        this.cursor(saveCursor);
                        if (this.isValidGetter(property.getGetter())) {
                            getter = (J.MethodDeclaration)this.visitElement((FirElement)property.getGetter(), ctx);
                            if (receiver != null) {
                                getter = getter.withParameters(ListUtils.concat((Object)receiver, (List)getter.getParameters()));
                            }
                            expressions.add(getter);
                            break;
                        }
                        break block57;
                    }
                    case "set": {
                        this.cursor(saveCursor);
                        if (this.isValidSetter(property.getSetter())) {
                            setter = (J.MethodDeclaration)this.visitElement((FirElement)property.getSetter(), ctx);
                            if (receiver != null) {
                                setter = setter.withParameters(ListUtils.concat((Object)receiver, (List)setter.getParameters()));
                            }
                            expressions.add(setter);
                            break;
                        }
                        break block57;
                    }
                    default: {
                        this.cursor(saveCursor);
                        break;
                    }
                }
                break block57;
            }
            if (this.isValidGetter(property.getGetter()) && !this.isValidSetter(property.getSetter())) {
                if (expressions == null) {
                    expressions = new ArrayList(2);
                }
                getter = (J.MethodDeclaration)this.visitElement((FirElement)property.getGetter(), ctx);
                if (receiver != null) {
                    getter = getter.withParameters(ListUtils.concat((Object)receiver, (List)getter.getParameters()));
                    setter = this.createImplicitMethodDeclaration("set").withParameters(Collections.singletonList(receiver));
                    expressions.add((J)setter);
                }
                expressions.add((J)getter);
            } else if (!this.isValidGetter(property.getGetter()) && this.isValidSetter(property.getSetter())) {
                if (expressions == null) {
                    expressions = new ArrayList(2);
                }
                setter = (J.MethodDeclaration)this.visitElement((FirElement)property.getSetter(), ctx);
                if (receiver != null) {
                    setter = setter.withParameters(ListUtils.concat((Object)receiver, (List)setter.getParameters()));
                    getter = this.createImplicitMethodDeclaration("get").withParameters(Collections.singletonList(receiver));
                    expressions.add((J)getter);
                }
                expressions.add((J)setter);
            } else if (receiver != null) {
                if (expressions == null) {
                    expressions = new ArrayList(2);
                }
                getter = this.createImplicitMethodDeclaration("get").withParameters(Collections.singletonList(receiver));
                expressions.add((J)getter);
                setter = this.createImplicitMethodDeclaration("set").withParameters(Collections.singletonList(receiver));
                expressions.add((J)setter);
            }
        }
        K.NamedVariableInitializer expr = null;
        if (expressions != null) {
            expr = new K.NamedVariableInitializer(Tree.randomId(), Space.EMPTY, initMarkers, expressions);
        }
        JRightPadded<J.VariableDeclarations.NamedVariable> namedVariable = this.maybeSemicolon(new J.VariableDeclarations.NamedVariable(Tree.randomId(), namePrefix, Markers.EMPTY, name, Collections.emptyList(), expr == null ? null : this.padLeft(exprPrefix, expr), this.typeMapping.variableType((FirVariableSymbol<? extends FirVariable>)property.getSymbol(), null, this.getCurrentFile())));
        variables.add(namedVariable);
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, annotations, Collections.emptyList(), (TypeTree)var12_17, null, Collections.emptyList(), variables);
    }

    private boolean isValidGetter(@Nullable FirPropertyAccessor getter) {
        return getter != null && !(getter instanceof FirDefaultPropertyGetter) && (getter.getSource() == null || !(getter.getSource().getKind() instanceof KtFakeSourceElementKind));
    }

    private boolean isValidSetter(@Nullable FirPropertyAccessor setter) {
        return setter != null && !(setter instanceof FirDefaultPropertySetter) && (setter.getSource() == null || !(setter.getSource().getKind() instanceof KtFakeSourceElementKind));
    }

    public J visitPropertyAccessExpression(FirPropertyAccessExpression propertyAccessExpression, ExecutionContext ctx) {
        JavaType type = this.typeMapping.type(propertyAccessExpression);
        if (propertyAccessExpression.getExplicitReceiver() != null) {
            Space prefix = this.whitespace();
            Expression target = (Expression)this.visitElement((FirElement)propertyAccessExpression.getExplicitReceiver(), ctx);
            Space before = this.whitespace();
            Markers markers = Markers.EMPTY;
            if (this.source.startsWith(".", this.cursor)) {
                this.skip(".");
            } else if (this.source.startsWith("?.", this.cursor)) {
                this.skip("?.");
                markers = markers.addIfAbsent((Marker)new IsNullable(Tree.randomId(), Space.EMPTY));
            }
            JLeftPadded<J.Identifier> name = this.padLeft(before, (J.Identifier)this.visitElement((FirElement)propertyAccessExpression.getCalleeReference(), ctx));
            return new J.FieldAccess(Tree.randomId(), prefix, markers, target, name, type);
        }
        return this.visitElement((FirElement)propertyAccessExpression.getCalleeReference(), ctx);
    }

    public J visitPropertyAccessor(FirPropertyAccessor propertyAccessor, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        if (propertyAccessor.isGetter() || propertyAccessor.isSetter()) {
            Markers markers = Markers.EMPTY;
            List modifiers = Collections.emptyList();
            List annotations = Collections.emptyList();
            J.TypeParameters typeParameters = propertyAccessor.getTypeParameters().isEmpty() ? null : new J.TypeParameters(Tree.randomId(), this.sourceBefore("<"), Markers.EMPTY, Collections.emptyList(), this.convertAll(propertyAccessor.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">"), ctx));
            String methodName = propertyAccessor.isGetter() ? "get" : "set";
            J.Identifier name = this.createIdentifier(methodName, (FirElement)propertyAccessor);
            JContainer params = JContainer.build((Space)this.sourceBefore("("), propertyAccessor.isGetter() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(propertyAccessor.getValueParameters(), this.commaDelim, t -> this.sourceBefore(")"), ctx, true), (Markers)Markers.EMPTY);
            int saveCursor = this.cursor;
            Space nextPrefix = this.whitespace();
            TypeTree returnTypeExpression = null;
            if (!(propertyAccessor.getReturnTypeRef() instanceof FirImplicitUnitTypeRef) && this.source.startsWith(":", this.cursor)) {
                this.skip(":");
                markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), nextPrefix));
                returnTypeExpression = (TypeTree)this.visitElement((FirElement)propertyAccessor.getReturnTypeRef(), ctx);
            } else {
                this.cursor(saveCursor);
            }
            J.Block body = null;
            saveCursor = this.cursor;
            Space blockPrefix = this.whitespace();
            if (propertyAccessor.getBody() instanceof FirSingleExpressionBlock) {
                if (this.source.startsWith("=", this.cursor)) {
                    this.skip("=");
                    SingleExpressionBlock singleExpressionBlock = new SingleExpressionBlock(Tree.randomId());
                    body = (J.Block)this.convertOrNull((FirElement)propertyAccessor.getBody(), ctx);
                    body = body.withPrefix(blockPrefix);
                    body = body.withMarkers(body.getMarkers().addIfAbsent((Marker)singleExpressionBlock));
                }
            } else {
                this.cursor(saveCursor);
                body = (J.Block)this.convertOrNull((FirElement)propertyAccessor.getBody(), ctx);
            }
            return new J.MethodDeclaration(Tree.randomId(), prefix, markers, annotations, Collections.emptyList(), typeParameters, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, this.typeMapping.methodDeclarationType((FirFunction)propertyAccessor, null, this.getCurrentFile()));
        }
        throw new UnsupportedOperationException("Unsupported property accessor.");
    }

    public J visitResolvedNamedReference(FirResolvedNamedReference resolvedNamedReference, ExecutionContext ctx) {
        String name = resolvedNamedReference.getName().asString();
        return this.createIdentifier(name, resolvedNamedReference);
    }

    public J visitReturnExpression(FirReturnExpression returnExpression, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        J.Identifier label = null;
        boolean explicitReturn = this.source.startsWith("return", this.cursor);
        if (explicitReturn) {
            this.skip("return");
            if (this.source.startsWith("@", this.cursor)) {
                this.skip("@");
                label = this.createIdentifier(returnExpression.getTarget().getLabelName());
            }
        }
        J j = null;
        if (!(returnExpression.getResult() instanceof FirUnitExpression)) {
            j = this.visitElement((FirElement)returnExpression.getResult(), ctx);
        }
        Expression returnExpr = j == null ? null : (j instanceof Statement && !(j instanceof Expression) ? new K.StatementExpression(Tree.randomId(), (Statement)j) : (Expression)j);
        K.KReturn k = new K.KReturn(Tree.randomId(), new J.Return(Tree.randomId(), prefix, Markers.EMPTY, returnExpr), label);
        return explicitReturn ? k : (J)k.withMarkers(k.getMarkers().addIfAbsent((Marker)new ImplicitReturn(Tree.randomId())));
    }

    public J visitResolvedTypeRef(FirResolvedTypeRef resolvedTypeRef, ExecutionContext ctx) {
        if (resolvedTypeRef.getDelegatedTypeRef() != null) {
            J j = this.visitElement((FirElement)resolvedTypeRef.getDelegatedTypeRef(), ctx);
            JavaType type = this.typeMapping.type(resolvedTypeRef);
            if (j instanceof TypeTree) {
                j = ((TypeTree)j).withType(type);
            }
            if (j instanceof J.ParameterizedType) {
                J.ParameterizedType parameterizedType = (J.ParameterizedType)j;
                j = parameterizedType.withClazz((NameTree)parameterizedType.getClazz().withType(type));
            }
            return j;
        }
        FirRegularClassSymbol symbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)resolvedTypeRef.getType(), (FirSession)this.firSession);
        if (symbol != null) {
            Space prefix = this.whitespace();
            String name = symbol.getName().asString();
            int pos = this.source.substring(this.cursor).indexOf(name);
            String fullName = this.source.substring(this.cursor, this.cursor + pos + name.length());
            this.skip(fullName);
            TypeTree typeTree = (TypeTree)TypeTree.build((String)fullName).withPrefix(prefix);
            int saveCursor = this.cursor;
            Space nextPrefix = this.whitespace();
            if (this.source.startsWith("?", this.cursor)) {
                this.skip("?");
                if (typeTree instanceof J.FieldAccess) {
                    J.FieldAccess fa = (J.FieldAccess)typeTree;
                    typeTree = fa.withName(fa.getName().withMarkers(fa.getName().getMarkers().addIfAbsent((Marker)new IsNullable(Tree.randomId(), nextPrefix))));
                } else {
                    typeTree = (TypeTree)typeTree.withMarkers(typeTree.getMarkers().addIfAbsent((Marker)new IsNullable(Tree.randomId(), nextPrefix)));
                }
            } else {
                this.cursor(saveCursor);
            }
            return typeTree.withType(this.typeMapping.type(resolvedTypeRef));
        }
        throw new UnsupportedOperationException("Unsupported null delegated type reference.");
    }

    public J visitResolvedReifiedParameterReference(FirResolvedReifiedParameterReference resolvedReifiedParameterReference, ExecutionContext ctx) {
        return this.createIdentifier(((FirTypeParameter)resolvedReifiedParameterReference.getSymbol().getFir()).getName().asString(), this.typeMapping.type(resolvedReifiedParameterReference), null);
    }

    public J visitResolvedQualifier(FirResolvedQualifier resolvedQualifier, ExecutionContext ctx) {
        String fieldAccess = resolvedQualifier.getPackageFqName().asString();
        String resolvedName = resolvedQualifier.getRelativeClassFqName() == null ? "" : "." + resolvedQualifier.getRelativeClassFqName().asString();
        String[] split = (fieldAccess + resolvedName).split("\\.");
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            String part = split[i];
            name.append(this.whitespace().getWhitespace());
            if (this.source.startsWith(part, this.cursor)) {
                this.skip(part);
                name.append(part);
            }
            if (i >= split.length - 1) continue;
            name.append(this.whitespace().getWhitespace());
            if (!this.source.startsWith(".", this.cursor)) continue;
            this.skip(".");
            name.append(".");
        }
        TypeTree typeTree = TypeTree.build((String)name.toString());
        if (resolvedQualifier.getRelativeClassFqName() != null) {
            typeTree = (TypeTree)typeTree.withType(this.typeMapping.type(resolvedQualifier));
        }
        return typeTree;
    }

    public J visitSafeCallExpression(FirSafeCallExpression safeCallExpression, ExecutionContext ctx) {
        return this.visitElement((FirElement)safeCallExpression.getSelector(), ctx);
    }

    public J visitCheckedSafeCallSubject(FirCheckedSafeCallSubject checkedSafeCallSubject, ExecutionContext ctx) {
        return this.visitElement((FirElement)checkedSafeCallSubject.getOriginalReceiverRef().getValue(), ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public J visitSimpleFunction(FirSimpleFunction simpleFunction, ExecutionContext ctx) {
        J.Block body;
        JContainer params;
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        List modifiers = Collections.emptyList();
        List<J.Annotation> annotations = this.mapModifiers(simpleFunction.getAnnotations(), simpleFunction.getName().asString());
        J.TypeParameters typeParameters = simpleFunction.getTypeParameters().isEmpty() ? null : new J.TypeParameters(Tree.randomId(), this.sourceBefore("<"), Markers.EMPTY, Collections.emptyList(), this.convertAll(simpleFunction.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">"), ctx));
        JRightPadded infixReceiver = null;
        if (simpleFunction.getReceiverTypeRef() != null) {
            markers = markers.addIfAbsent((Marker)new ReceiverType(Tree.randomId()));
            Expression receiver = (Expression)this.visitElement((FirElement)simpleFunction.getReceiverTypeRef(), ctx);
            infixReceiver = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new ReceiverType(Tree.randomId())), new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "<receiverType>", null, null), Collections.emptyList(), this.padLeft(Space.EMPTY, receiver), null)).withAfter(this.sourceBefore("."));
        }
        if ("<no name provided>".equals(simpleFunction.getName().asString())) {
            throw new IllegalStateException("Unresolved function.");
        }
        String methodName = simpleFunction.getName().asString();
        J.Identifier name = this.createIdentifier(methodName, (FirElement)simpleFunction);
        Space before = this.sourceBefore("(");
        JContainer jContainer = params = !simpleFunction.getValueParameters().isEmpty() ? JContainer.build((Space)before, this.convertAll(simpleFunction.getValueParameters(), this.commaDelim, t -> this.sourceBefore(")"), ctx, true), (Markers)Markers.EMPTY) : JContainer.build((Space)before, Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
        if (simpleFunction.getReceiverTypeRef() != null) {
            J.VariableDeclarations implicitParam = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new ReceiverType(Tree.randomId())), Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), Collections.singletonList(infixReceiver));
            implicitParam = implicitParam.withMarkers(implicitParam.getMarkers().addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), Space.EMPTY)));
            ArrayList<JRightPadded> newStatements = new ArrayList<JRightPadded>(params.getElements().size() + 1);
            newStatements.add(JRightPadded.build((Object)implicitParam));
            newStatements.addAll(params.getPadding().getElements());
            params = params.getPadding().withElements(newStatements);
        }
        int saveCursor = this.cursor;
        TypeTree returnTypeExpression = null;
        before = this.whitespace();
        if (this.source.startsWith(":", this.cursor)) {
            this.skip(":");
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), before));
            returnTypeExpression = (TypeTree)this.visitElement((FirElement)simpleFunction.getReturnTypeRef(), ctx);
            saveCursor = this.cursor;
            before = this.whitespace();
            if (this.source.startsWith("?", this.cursor)) {
                returnTypeExpression = (TypeTree)returnTypeExpression.withMarkers(returnTypeExpression.getMarkers().addIfAbsent((Marker)new IsNullable(Tree.randomId(), before)));
            } else {
                this.cursor(saveCursor);
            }
        } else {
            this.cursor(saveCursor);
        }
        saveCursor = this.cursor;
        before = this.whitespace();
        if (simpleFunction.getBody() instanceof FirSingleExpressionBlock) {
            if (!this.source.startsWith("=", this.cursor)) throw new IllegalStateException("Unexpected single block expression, cursor is likely at the wrong position.");
            this.skip("=");
            SingleExpressionBlock singleExpressionBlock = new SingleExpressionBlock(Tree.randomId());
            body = (J.Block)this.convertOrNull((FirElement)simpleFunction.getBody(), ctx);
            body = body.withPrefix(before);
            body = body.withMarkers(body.getMarkers().addIfAbsent((Marker)singleExpressionBlock));
            return new J.MethodDeclaration(Tree.randomId(), prefix, markers, annotations, Collections.emptyList(), typeParameters, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, this.typeMapping.methodDeclarationType((FirFunction)simpleFunction, null, this.getCurrentFile()));
        } else {
            this.cursor(saveCursor);
            body = (J.Block)this.convertOrNull((FirElement)simpleFunction.getBody(), ctx);
        }
        return new J.MethodDeclaration(Tree.randomId(), prefix, markers, annotations, Collections.emptyList(), typeParameters, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, this.typeMapping.methodDeclarationType((FirFunction)simpleFunction, null, this.getCurrentFile()));
    }

    public J visitSmartCastExpression(FirSmartCastExpression smartCastExpression, ExecutionContext ctx) {
        return this.visitElement((FirElement)smartCastExpression.getOriginalExpression(), ctx);
    }

    public J visitStarProjection(FirStarProjection starProjection, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        this.skip("*");
        return new J.Wildcard(Tree.randomId(), prefix, Markers.EMPTY, null, null);
    }

    public J visitStringConcatenationCall(FirStringConcatenationCall stringConcatenationCall, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        String delimiter = this.source.startsWith("\"\"\"", this.cursor) ? "\"\"\"" : (this.source.startsWith("$", this.cursor) ? "$" : "\"");
        this.cursor += delimiter.length();
        ArrayList<J> values = new ArrayList<J>(stringConcatenationCall.getArgumentList().getArguments().size());
        for (FirExpression e : stringConcatenationCall.getArgumentList().getArguments()) {
            if (this.source.startsWith("$", this.cursor)) {
                this.skip("$");
                boolean inBraces = this.source.startsWith("{", this.cursor);
                if (inBraces) {
                    this.skip("{");
                }
                values.add(new K.KString.Value(Tree.randomId(), Markers.EMPTY, this.visitElement((FirElement)e, ctx), inBraces));
                if (!inBraces) continue;
                this.skip("}");
                continue;
            }
            values.add(this.visitElement((FirElement)e, ctx));
        }
        this.cursor += delimiter.length();
        return new K.KString(Tree.randomId(), prefix, Markers.EMPTY, delimiter, values, this.typeMapping.type(stringConcatenationCall));
    }

    @Nullable
    public J visitThisReceiverExpression(FirThisReceiverExpression thisReceiverExpression, ExecutionContext ctx) {
        if (thisReceiverExpression.isImplicit()) {
            return null;
        }
        Space prefix = this.sourceBefore("this");
        J.Identifier label = null;
        if (thisReceiverExpression.getCalleeReference().getLabelName() != null) {
            this.skip("@");
            label = this.createIdentifier(thisReceiverExpression.getCalleeReference().getLabelName(), (FirElement)thisReceiverExpression.getCalleeReference().getBoundSymbol().getFir());
        }
        return new K.KThis(Tree.randomId(), prefix, Markers.EMPTY, label, this.typeMapping.type(thisReceiverExpression));
    }

    public J visitTypeAlias(FirTypeAlias typeAlias, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        List modifiers = Collections.emptyList();
        Markers markers = Markers.EMPTY;
        List<J.Annotation> annotations = this.mapModifiers(typeAlias.getAnnotations(), "typealias");
        Space aliasPrefix = this.whitespace();
        J.Annotation aliasAnnotation = new J.Annotation(Tree.randomId(), aliasPrefix, Markers.EMPTY.addIfAbsent((Marker)new Modifier(Tree.randomId())), (NameTree)this.createIdentifier("typealias"), JContainer.empty());
        annotations.add(aliasAnnotation);
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> vars = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        Space namePrefix = Space.EMPTY;
        String valueName = "";
        if ("<no name provided>".equals(typeAlias.getName().toString())) {
            KtSourceElement sourceElement = typeAlias.getSource();
            if (sourceElement == null) {
                throw new IllegalStateException("Unexpected null source.");
            }
        } else {
            valueName = typeAlias.getName().asString();
        }
        J.Identifier name = this.createIdentifier(valueName, this.typeMapping.type(typeAlias.getExpandedTypeRef()), null);
        J.Identifier typeExpression = typeAlias.getTypeParameters().isEmpty() ? name : new J.ParameterizedType(Tree.randomId(), name.getPrefix(), Markers.EMPTY, (NameTree)name.withPrefix(Space.EMPTY), JContainer.build((Space)this.sourceBefore("<"), this.convertAll(typeAlias.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">"), ctx), (Markers)Markers.EMPTY), null);
        List dimensionsAfterName = Collections.emptyList();
        Space initializerPrefix = this.sourceBefore("=");
        Expression expr = (Expression)this.visitElement((FirElement)typeAlias.getExpandedTypeRef(), ctx);
        JRightPadded<J.VariableDeclarations.NamedVariable> namedVariable = this.maybeSemicolon(new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "", null, null), dimensionsAfterName, this.padLeft(initializerPrefix, expr), null));
        vars.add(namedVariable);
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, annotations, Collections.emptyList(), (TypeTree)typeExpression, null, null, vars);
    }

    public J visitTypeOperatorCall(FirTypeOperatorCall typeOperatorCall, ExecutionContext ctx) {
        Space after;
        J.Empty element;
        Space prefix = this.whitespace();
        FirExpression expression = (FirExpression)typeOperatorCall.getArgumentList().getArguments().get(0);
        Markers markers = Markers.EMPTY;
        boolean includeParentheses = false;
        if (typeOperatorCall.getOperation() == FirOperation.AS && this.source.startsWith("(", this.cursor)) {
            this.skip("(");
            includeParentheses = true;
        }
        if (expression instanceof FirWhenSubjectExpression) {
            element = new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
        } else {
            FirExpression target = expression instanceof FirSmartCastExpression ? ((FirSmartCastExpression)expression).getOriginalExpression() : expression;
            element = (Expression)this.visitElement((FirElement)target, ctx);
        }
        switch (typeOperatorCall.getOperation()) {
            case IS: {
                after = this.sourceBefore("is");
                break;
            }
            case NOT_IS: {
                after = this.sourceBefore("!is");
                markers = markers.addIfAbsent((Marker)new NotIs(Tree.randomId()));
                break;
            }
            case AS: {
                after = this.sourceBefore("as");
                break;
            }
            case SAFE_AS: {
                after = this.sourceBefore("as?");
                markers = markers.addIfAbsent((Marker)new IsNullable(Tree.randomId(), Space.EMPTY));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type operator " + typeOperatorCall.getOperation().name());
            }
        }
        if (typeOperatorCall.getOperation() == FirOperation.AS || typeOperatorCall.getOperation() == FirOperation.SAFE_AS) {
            if (!includeParentheses) {
                markers = markers.addIfAbsent((Marker)new OmitParentheses(Tree.randomId()));
            }
            return new J.TypeCast(Tree.randomId(), prefix, markers, new J.ControlParentheses(Tree.randomId(), after, Markers.EMPTY, JRightPadded.build((Object)((TypeTree)this.visitElement((FirElement)typeOperatorCall.getConversionTypeRef(), ctx))).withAfter(includeParentheses ? this.sourceBefore(")") : Space.EMPTY)), (Expression)element);
        }
        JRightPadded expr = JRightPadded.build((Object)element).withAfter(after);
        J clazz = this.visitElement((FirElement)typeOperatorCall.getConversionTypeRef(), ctx);
        J pattern = null;
        return new J.InstanceOf(Tree.randomId(), prefix, markers, expr, clazz, pattern, this.typeMapping.type(typeOperatorCall));
    }

    public J visitTypeParameter(FirTypeParameter typeParameter, ExecutionContext ctx) {
        if (!typeParameter.getAnnotations().isEmpty()) {
            throw new IllegalStateException("Implement me.");
        }
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>(typeParameter.getAnnotations().size() + (typeParameter.isReified() ? 1 : 0));
        if (typeParameter.isReified()) {
            J.Identifier name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "reified", null, null);
            J.Annotation reified = new J.Annotation(Tree.randomId(), this.sourceBefore("reified"), Markers.EMPTY.addIfAbsent((Marker)new Modifier(Tree.randomId())), (NameTree)name, JContainer.empty());
            annotations.add(reified);
        }
        ArrayList<FirTypeRef> nonImplicitParams = new ArrayList<FirTypeRef>(typeParameter.getBounds().size());
        boolean hasImplicitAny = false;
        for (FirTypeRef bound : typeParameter.getBounds()) {
            if (bound instanceof FirImplicitNullableAnyTypeRef) {
                hasImplicitAny = true;
                continue;
            }
            nonImplicitParams.add(bound);
        }
        if (hasImplicitAny && (this.source.startsWith("in", this.cursor) || this.source.startsWith("out", this.cursor))) {
            J.Wildcard.Bound bound;
            if (this.source.startsWith("in", this.cursor)) {
                this.skip("in");
                bound = J.Wildcard.Bound.Super;
            } else {
                this.skip("out");
                bound = J.Wildcard.Bound.Extends;
            }
            J.Identifier name = this.createIdentifier(typeParameter.getName().asString(), (FirElement)typeParameter);
            return new J.Wildcard(Tree.randomId(), prefix, Markers.EMPTY, this.padLeft(Space.EMPTY, bound), (NameTree)name);
        }
        J.Identifier name = this.createIdentifier(typeParameter.getName().asString(), (FirElement)typeParameter);
        JContainer bounds = null;
        if (nonImplicitParams.size() == 1) {
            bounds = JContainer.build((Space)this.sourceBefore(":"), this.convertAll(nonImplicitParams, t -> this.sourceBefore(","), this.noDelim, ctx, true), (Markers)Markers.EMPTY);
        }
        return new J.TypeParameter(Tree.randomId(), prefix, markers, annotations, (Expression)name, bounds);
    }

    public J visitTryExpression(FirTryExpression tryExpression, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        this.skip("try");
        JContainer resources = null;
        J.Block block = (J.Block)this.visitElement((FirElement)tryExpression.getTryBlock(), ctx);
        ArrayList<J.Try.Catch> catches = new ArrayList<J.Try.Catch>(tryExpression.getCatches().size());
        for (FirCatch aCatch : tryExpression.getCatches()) {
            catches.add((J.Try.Catch)this.visitElement((FirElement)aCatch, ctx));
        }
        JLeftPadded<J.Block> finally_ = tryExpression.getFinallyBlock() == null ? null : this.padLeft(this.sourceBefore("finally"), (J.Block)this.visitElement((FirElement)tryExpression.getFinallyBlock(), ctx));
        return new J.Try(Tree.randomId(), prefix, Markers.EMPTY, resources, block, catches, finally_);
    }

    public J visitTypeProjectionWithVariance(FirTypeProjectionWithVariance typeProjectionWithVariance, ExecutionContext ctx) {
        return this.visitResolvedTypeRef((FirResolvedTypeRef)typeProjectionWithVariance.getTypeRef(), ctx);
    }

    public J visitUserTypeRef(FirUserTypeRef userTypeRef, ExecutionContext ctx) {
        FirQualifierPart part;
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        StringBuilder name = new StringBuilder();
        List qualifier = userTypeRef.getQualifier();
        for (int i = 0; i < qualifier.size(); ++i) {
            part = (FirQualifierPart)qualifier.get(i);
            Space whitespace = this.whitespace();
            name.append(whitespace.getWhitespace());
            name.append(part.getName().asString());
            this.skip(part.getName().asString());
            if (i >= qualifier.size() - 1) continue;
            if (!part.getTypeArgumentList().getTypeArguments().isEmpty()) {
                throw new IllegalArgumentException("Unsupported type parameters in user part " + part.getName());
            }
            name.append(this.whitespace().getWhitespace());
            name.append(".");
            this.skip(".");
        }
        TypeTree nameTree = TypeTree.build((String)name.toString());
        part = (FirQualifierPart)userTypeRef.getQualifier().get(userTypeRef.getQualifier().size() - 1);
        if (!part.getTypeArgumentList().getTypeArguments().isEmpty()) {
            Space typeArgPrefix = this.sourceBefore("<");
            ArrayList<JRightPadded> parameters = new ArrayList<JRightPadded>(part.getTypeArgumentList().getTypeArguments().size());
            List typeArguments = part.getTypeArgumentList().getTypeArguments();
            for (int i = 0; i < typeArguments.size(); ++i) {
                FirTypeProjection typeArgument = (FirTypeProjection)typeArguments.get(i);
                parameters.add(JRightPadded.build((Object)((Expression)this.visitElement((FirElement)typeArgument, ctx))).withAfter(i < typeArguments.size() - 1 ? this.sourceBefore(",") : this.sourceBefore(">")));
            }
            if (userTypeRef.isMarkedNullable()) {
                markers = markers.addIfAbsent((Marker)new IsNullable(Tree.randomId(), this.sourceBefore("?")));
            }
            return new J.ParameterizedType(Tree.randomId(), prefix, markers, (NameTree)nameTree, JContainer.build((Space)typeArgPrefix, parameters, (Markers)Markers.EMPTY), this.typeMapping.type(userTypeRef));
        }
        if (userTypeRef.isMarkedNullable()) {
            markers = markers.addIfAbsent((Marker)new IsNullable(Tree.randomId(), this.sourceBefore("?")));
        }
        return (J)nameTree.withPrefix(prefix).withMarkers(markers);
    }

    public J visitValueParameter(FirValueParameter valueParameter, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        List modifiers = Collections.emptyList();
        Markers markers = Markers.EMPTY;
        List<J.Annotation> annotations = this.mapModifiers(valueParameter.getAnnotations(), valueParameter.getName().asString());
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> vars = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        Space namePrefix = Space.EMPTY;
        String valueName = "";
        if ("<no name provided>".equals(valueParameter.getName().toString())) {
            KtSourceElement sourceElement = valueParameter.getSource();
            if (sourceElement == null) {
                throw new IllegalStateException("Unexpected null source.");
            }
        } else if ("<unused var>".equals(valueParameter.getName().toString())) {
            valueName = "_";
            namePrefix = this.whitespace();
        } else {
            valueName = valueParameter.getName().asString();
            namePrefix = this.whitespace();
        }
        J.Identifier name = this.createIdentifier(valueName, (FirElement)valueParameter);
        Object typeExpression = null;
        if (valueParameter.getReturnTypeRef() instanceof FirResolvedTypeRef && (valueParameter.getReturnTypeRef().getSource() == null || !(valueParameter.getReturnTypeRef().getSource().getKind() instanceof KtFakeSourceElementKind))) {
            FirResolvedTypeRef typeRef = (FirResolvedTypeRef)valueParameter.getReturnTypeRef();
            if (typeRef.getDelegatedTypeRef() != null) {
                J j;
                Space delimiterPrefix = this.whitespace();
                boolean addTypeReferencePrefix = this.source.startsWith(":", this.cursor);
                this.skip(":");
                if (addTypeReferencePrefix) {
                    markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), delimiterPrefix));
                }
                typeExpression = (j = this.visitElement((FirElement)typeRef, ctx)) instanceof TypeTree ? (TypeTree)j : new K.FunctionType(Tree.randomId(), (TypedTree)j, null, null);
            } else if ("_".equals(valueName)) {
                int savedCursor = this.cursor;
                Space delimiterPrefix = this.whitespace();
                if (this.source.startsWith(":", this.cursor)) {
                    this.skip(":");
                    markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), delimiterPrefix));
                    J j = this.visitElement((FirElement)typeRef, ctx);
                    typeExpression = j instanceof TypeTree ? (TypeTree)j : new K.FunctionType(Tree.randomId(), (TypedTree)j, null, null);
                } else {
                    this.cursor = savedCursor;
                }
            }
        }
        List dimensionsAfterName = Collections.emptyList();
        FirExpression initializer = valueParameter.getInitializer() != null ? valueParameter.getInitializer() : (valueParameter.getDefaultValue() != null ? valueParameter.getDefaultValue() : null);
        JRightPadded<J.VariableDeclarations.NamedVariable> namedVariable = this.maybeSemicolon(new J.VariableDeclarations.NamedVariable(Tree.randomId(), namePrefix, Markers.EMPTY, name, dimensionsAfterName, initializer != null ? this.padLeft(this.sourceBefore("="), (Expression)this.visitElement((FirElement)initializer, ctx)) : null, this.typeMapping.variableType((FirVariableSymbol<? extends FirVariable>)valueParameter.getSymbol(), null, this.getCurrentFile())));
        vars.add(namedVariable);
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, annotations, Collections.emptyList(), typeExpression, null, dimensionsAfterName, vars);
    }

    public J visitVariableAssignment(FirVariableAssignment variableAssignment, ExecutionContext ctx) {
        Expression variable;
        boolean unaryAssignment;
        boolean bl = unaryAssignment = variableAssignment.getRValue() instanceof FirFunctionCall && ((FirFunctionCall)variableAssignment.getRValue()).getOrigin() == FirFunctionCallOrigin.Operator && ((FirFunctionCall)variableAssignment.getRValue()).getCalleeReference() instanceof FirResolvedNamedReference && this.isUnaryOperation(((FirFunctionCall)variableAssignment.getRValue()).getCalleeReference().getName().asString());
        if (unaryAssignment) {
            return this.visitElement((FirElement)variableAssignment.getRValue(), ctx);
        }
        Space prefix = this.whitespace();
        if (variableAssignment.getExplicitReceiver() != null) {
            Expression target = (Expression)this.visitElement((FirElement)variableAssignment.getExplicitReceiver(), ctx);
            JLeftPadded<J.Identifier> name = this.padLeft(this.sourceBefore("."), (J.Identifier)this.visitElement((FirElement)variableAssignment.getLValue(), ctx));
            variable = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, target, name, this.typeMapping.type(variableAssignment, this.getCurrentFile()));
        } else {
            variable = (Expression)this.convert((FirElement)variableAssignment.getLValue(), ctx);
        }
        int saveCursor = this.cursor;
        this.whitespace();
        boolean isCompoundAssignment = this.source.startsWith("-=", this.cursor) || this.source.startsWith("+=", this.cursor) || this.source.startsWith("*=", this.cursor) || this.source.startsWith("/=", this.cursor);
        this.cursor(saveCursor);
        if (isCompoundAssignment) {
            J.AssignmentOperation.Type op;
            Space opPrefix = this.whitespace();
            if (this.source.startsWith("-=", this.cursor)) {
                this.skip("-=");
                op = J.AssignmentOperation.Type.Subtraction;
            } else if (this.source.startsWith("+=", this.cursor)) {
                this.skip("+=");
                op = J.AssignmentOperation.Type.Addition;
            } else if (this.source.startsWith("*=", this.cursor)) {
                this.skip("*=");
                op = J.AssignmentOperation.Type.Multiplication;
            } else if (this.source.startsWith("/=", this.cursor)) {
                this.skip("/=");
                op = J.AssignmentOperation.Type.Division;
            } else {
                throw new IllegalArgumentException("Unexpected compound assignment.");
            }
            if (!(variableAssignment.getRValue() instanceof FirFunctionCall) || ((FirFunctionCall)variableAssignment.getRValue()).getArgumentList().getArguments().size() != 1) {
                throw new IllegalArgumentException("Unexpected compound assignment.");
            }
            FirElement rhs = (FirElement)((FirFunctionCall)variableAssignment.getRValue()).getArgumentList().getArguments().get(0);
            return new J.AssignmentOperation(Tree.randomId(), prefix, Markers.EMPTY, variable, this.padLeft(opPrefix, op), (Expression)this.visitElement(rhs, ctx), this.typeMapping.type(variableAssignment));
        }
        Space exprPrefix = this.sourceBefore("=");
        Object j = this.convert((FirElement)variableAssignment.getRValue(), ctx);
        if (j instanceof Statement && !(j instanceof Expression)) {
            j = new K.StatementExpression(Tree.randomId(), (Statement)j);
        }
        Expression expr = (Expression)j;
        return new J.Assignment(Tree.randomId(), prefix, Markers.EMPTY, variable, this.padLeft(exprPrefix, expr), this.typeMapping.type(variableAssignment));
    }

    public J visitWhenBranch(FirWhenBranch whenBranch, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        if (this.source.substring(this.cursor).startsWith("if")) {
            this.skip("if");
        } else if (!(whenBranch.getCondition() instanceof FirElseIfTrueCondition) && !(whenBranch.getCondition() instanceof FirEqualityOperatorCall)) {
            throw new IllegalArgumentException("Unsupported condition type.");
        }
        boolean singleExpression = whenBranch.getResult() instanceof FirSingleExpressionBlock;
        if (whenBranch.getCondition() instanceof FirElseIfTrueCondition) {
            FirBlock result = singleExpression ? ((FirSingleExpressionBlock)whenBranch.getResult()).getStatement() : whenBranch.getResult();
            J j = this.visitElement((FirElement)result, ctx);
            return j.withPrefix(prefix);
        }
        J.ControlParentheses<Expression> controlParentheses = this.mapControlParentheses((FirElement)whenBranch.getCondition());
        Object result = singleExpression ? ((FirSingleExpressionBlock)whenBranch.getResult()).getStatement() : whenBranch.getResult();
        Object j = this.convert((FirElement)result, ctx);
        if (!(j instanceof Statement) && j instanceof Expression) {
            j = new K.ExpressionStatement(Tree.randomId(), (Expression)j);
        }
        return new J.If(Tree.randomId(), prefix, Markers.EMPTY, controlParentheses, JRightPadded.build((Object)((Statement)j)), null);
    }

    public J visitWhenExpression(FirWhenExpression whenExpression, ExecutionContext ctx) {
        int saveCursor = this.cursor;
        Space prefix = this.whitespace();
        if (this.source.startsWith("when", this.cursor)) {
            this.skip("when");
            J.ControlParentheses controlParentheses = null;
            if (whenExpression.getSubject() != null) {
                controlParentheses = new J.ControlParentheses(Tree.randomId(), this.sourceBefore("("), Markers.EMPTY, this.padRight((Expression)this.visitElement((FirElement)whenExpression.getSubject(), ctx), this.sourceBefore(")")));
            }
            Space bodyPrefix = this.sourceBefore("{");
            ArrayList<JRightPadded<K.WhenBranch>> statements = new ArrayList<JRightPadded<K.WhenBranch>>(whenExpression.getBranches().size());
            for (FirWhenBranch whenBranch : whenExpression.getBranches()) {
                int exprSize = whenBranch.getCondition() instanceof FirEqualityOperatorCall ? ((FirEqualityOperatorCall)whenBranch.getCondition()).getArgumentList().getArguments().size() - 1 : 1;
                ArrayList<Object> expressions = new ArrayList<Object>(exprSize);
                if (whenBranch.getCondition() instanceof FirElseIfTrueCondition) {
                    expressions.add(this.padRight(this.createIdentifier("else"), this.sourceBefore("->")));
                } else if (whenBranch.getCondition() instanceof FirEqualityOperatorCall) {
                    ArrayList<FirExpression> arguments = new ArrayList<FirExpression>(((FirEqualityOperatorCall)whenBranch.getCondition()).getArgumentList().getArguments().size());
                    for (FirExpression argument : ((FirEqualityOperatorCall)whenBranch.getCondition()).getArgumentList().getArguments()) {
                        if (argument instanceof FirWhenSubjectExpression) continue;
                        arguments.add(argument);
                    }
                    if (arguments.size() == 1) {
                        expressions.add(this.padRight((Expression)this.visitElement((FirElement)arguments.get(0), ctx), this.sourceBefore("->")));
                    } else {
                        Expression expr = (Expression)this.visitElement((FirElement)whenBranch.getCondition(), ctx);
                        expressions.add(this.padRight(expr, this.sourceBefore("->")));
                    }
                } else {
                    expressions.add(this.padRight((Expression)this.visitElement((FirElement)whenBranch.getCondition(), ctx), this.sourceBefore("->")));
                }
                JContainer expressionContainer = JContainer.build((Space)Space.EMPTY, expressions, (Markers)Markers.EMPTY);
                J body = this.visitElement((FirElement)whenBranch.getResult(), ctx);
                K.WhenBranch branch = new K.WhenBranch(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (JContainer<Expression>)expressionContainer, this.padRight(body, Space.EMPTY));
                statements.add(this.padRight(branch, Space.EMPTY));
            }
            Space bodySuffix = this.sourceBefore("}");
            J.Block body = new J.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), statements, bodySuffix);
            return new K.When(Tree.randomId(), prefix, Markers.EMPTY, (J.ControlParentheses<Expression>)controlParentheses, body, this.typeMapping.type(whenExpression));
        }
        this.cursor(saveCursor);
        FirWhenBranch whenBranch = (FirWhenBranch)whenExpression.getBranches().get(0);
        J firstElement = this.visitElement((FirElement)whenBranch, ctx);
        if (!(firstElement instanceof J.If)) {
            throw new IllegalStateException("First element of when expression was not an if.");
        }
        J.If ifStatement = (J.If)firstElement;
        ArrayList<Object> elses = new ArrayList<Object>(whenExpression.getBranches().size() - 1);
        List branches = whenExpression.getBranches();
        for (int i = 1; i < branches.size(); ++i) {
            FirWhenBranch branch = (FirWhenBranch)branches.get(i);
            Space elsePrefix = this.sourceBefore("else");
            J j = this.visitWhenBranch(branch, ctx);
            if (!(j instanceof Statement) && j instanceof Expression) {
                j = new K.ExpressionStatement(Tree.randomId(), (Expression)j);
            }
            J.If.Else ifElse = new J.If.Else(Tree.randomId(), elsePrefix, Markers.EMPTY, JRightPadded.build((Object)((Statement)j)));
            elses.add(ifElse);
        }
        elses.add(0, ifStatement);
        J.If.Else ifElse = null;
        for (int i = elses.size() - 1; i >= 0; --i) {
            J j = (J)elses.get(i);
            if (j instanceof J.If.Else) {
                if (((J.If.Else)j).getBody() instanceof J.If) {
                    J.If addElse = (J.If)((J.If.Else)j).getBody();
                    addElse = addElse.withElsePart(ifElse);
                    j = ((J.If.Else)j).withBody((Statement)addElse);
                }
                ifElse = (J.If.Else)j;
                continue;
            }
            if (!(j instanceof J.If)) continue;
            ifStatement = ((J.If)j).withElsePart(ifElse);
        }
        return ifStatement;
    }

    public J visitWhileLoop(FirWhileLoop whileLoop, ExecutionContext ctx) {
        J.Label label = null;
        if (whileLoop.getLabel() != null) {
            label = (J.Label)this.visitElement((FirElement)whileLoop.getLabel(), ctx);
        }
        Space prefix = this.whitespace();
        this.skip("while");
        J.ControlParentheses<Expression> controlParentheses = this.mapControlParentheses((FirElement)whileLoop.getCondition());
        Statement body = (Statement)this.visitElement((FirElement)whileLoop.getBlock(), ctx);
        J.WhileLoop statement = new J.WhileLoop(Tree.randomId(), prefix, Markers.EMPTY, controlParentheses, JRightPadded.build((Object)body));
        return label != null ? label.withStatement((Statement)statement) : statement;
    }

    public J visitArgumentList(FirArgumentList argumentList, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirArgumentList"));
    }

    public J visitAugmentedArraySetCall(FirAugmentedArraySetCall augmentedArraySetCall, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirAugmentedArraySetCall"));
    }

    public J visitAssignmentOperatorStatement(FirAssignmentOperatorStatement assignmentOperatorStatement, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirAssignmentOperatorStatement"));
    }

    public J visitAnnotation(FirAnnotation annotation, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirAnnotation"));
    }

    public J visitAnnotationContainer(FirAnnotationContainer annotationContainer, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirAnnotationContainer"));
    }

    public J visitAnnotationArgumentMapping(FirAnnotationArgumentMapping annotationArgumentMapping, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirAnnotationArgumentMapping"));
    }

    public J visitBackingField(FirBackingField backingField, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirBackingField"));
    }

    public J visitContextReceiver(FirContextReceiver contextReceiver, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirContextReceiver"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public J visitConstructor(FirConstructor constructor, ExecutionContext ctx) {
        J.Block body;
        JContainer params;
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        List modifiers = Collections.emptyList();
        List<J.Annotation> annotations = this.mapModifiers(constructor.getAnnotations(), "constructor");
        JRightPadded infixReceiver = null;
        if (constructor.getReceiverTypeRef() != null) {
            markers = markers.addIfAbsent((Marker)new ReceiverType(Tree.randomId()));
            Expression receiver = (Expression)this.visitElement((FirElement)constructor.getReceiverTypeRef(), ctx);
            infixReceiver = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new ReceiverType(Tree.randomId())), new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "<receiverType>", null, null), Collections.emptyList(), this.padLeft(Space.EMPTY, receiver), null)).withAfter(this.sourceBefore("."));
        }
        String methodName = "constructor";
        J.Identifier name = this.createIdentifier(methodName, (FirElement)constructor);
        Space before = this.sourceBefore("(");
        JContainer jContainer = params = !constructor.getValueParameters().isEmpty() ? JContainer.build((Space)before, this.convertAll(constructor.getValueParameters(), this.commaDelim, t -> this.sourceBefore(")"), ctx, true), (Markers)Markers.EMPTY) : JContainer.build((Space)before, Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
        if (constructor.getReceiverTypeRef() != null) {
            J.VariableDeclarations implicitParam = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new ReceiverType(Tree.randomId())), Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), Collections.singletonList(infixReceiver));
            implicitParam = implicitParam.withMarkers(implicitParam.getMarkers().addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), Space.EMPTY)));
            ArrayList<JRightPadded> newStatements = new ArrayList<JRightPadded>(params.getElements().size() + 1);
            newStatements.add(JRightPadded.build((Object)implicitParam));
            newStatements.addAll(params.getPadding().getElements());
            params = params.getPadding().withElements(newStatements);
        }
        int saveCursor = this.cursor;
        TypeTree returnTypeExpression = null;
        before = this.whitespace();
        if (this.source.startsWith(":", this.cursor)) {
            this.skip(":");
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), before));
            if (constructor.getDelegatedConstructor() != null && (constructor.getDelegatedConstructor().isThis() || constructor.getDelegatedConstructor().isSuper())) {
                Space thisPrefix = this.whitespace();
                J.Identifier delegateName = this.createIdentifier(constructor.getDelegatedConstructor().isThis() ? "this" : "super");
                JContainer args = this.mapFunctionalCallArguments(constructor.getDelegatedConstructor().getArgumentList().getArguments()).withBefore(before);
                JavaType type = this.typeMapping.type(constructor);
                J.NewClass newClass = new J.NewClass(Tree.randomId(), thisPrefix, Markers.EMPTY, null, Space.EMPTY, (TypeTree)delegateName, args, null, type instanceof JavaType.Method ? (JavaType.Method)type : null);
                returnTypeExpression = new K.FunctionType(Tree.randomId(), (TypedTree)newClass, null, null);
            } else {
                returnTypeExpression = (TypeTree)this.visitElement((FirElement)constructor.getReturnTypeRef(), ctx);
            }
            saveCursor = this.cursor;
            before = this.whitespace();
            if (this.source.startsWith("?", this.cursor)) {
                returnTypeExpression = (TypeTree)returnTypeExpression.withMarkers(returnTypeExpression.getMarkers().addIfAbsent((Marker)new IsNullable(Tree.randomId(), before)));
            } else {
                this.cursor(saveCursor);
            }
        } else {
            this.cursor(saveCursor);
        }
        saveCursor = this.cursor;
        before = this.whitespace();
        if (constructor.getBody() instanceof FirSingleExpressionBlock) {
            if (!this.source.startsWith("=", this.cursor)) throw new IllegalStateException("Unexpected single block expression.");
            this.skip("=");
            SingleExpressionBlock singleExpressionBlock = new SingleExpressionBlock(Tree.randomId());
            body = (J.Block)this.convertOrNull((FirElement)constructor.getBody(), ctx);
            body = body.withPrefix(before);
            body = body.withMarkers(body.getMarkers().addIfAbsent((Marker)singleExpressionBlock));
            return new J.MethodDeclaration(Tree.randomId(), prefix, markers, annotations, Collections.emptyList(), null, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, this.typeMapping.methodDeclarationType((FirFunction)constructor, null, this.getCurrentFile()));
        } else {
            this.cursor(saveCursor);
            body = (J.Block)this.convertOrNull((FirElement)constructor.getBody(), ctx);
        }
        return new J.MethodDeclaration(Tree.randomId(), prefix, markers, annotations, Collections.emptyList(), null, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, this.typeMapping.methodDeclarationType((FirFunction)constructor, null, this.getCurrentFile()));
    }

    public J visitComponentCall(FirComponentCall componentCall, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirComponentCall"));
    }

    public J visitContractDescriptionOwner(FirContractDescriptionOwner contractDescriptionOwner, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirContractDescriptionOwner"));
    }

    public J visitContextReceiverArgumentListOwner(FirContextReceiverArgumentListOwner contextReceiverArgumentListOwner, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirContextReceiverArgumentListOwner"));
    }

    public J visitClassReferenceExpression(FirClassReferenceExpression classReferenceExpression, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirClassReferenceExpression"));
    }

    public J visitClassLikeDeclaration(FirClassLikeDeclaration classLikeDeclaration, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirClassLikeDeclaration"));
    }

    public J visitCall(FirCall call, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirCall"));
    }

    public J visitCallableDeclaration(FirCallableDeclaration callableDeclaration, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirCallableDeclaration"));
    }

    public J visitDelegatedConstructorCall(FirDelegatedConstructorCall delegatedConstructorCall, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirDelegatedConstructorCall"));
    }

    public J visitDeclaration(FirDeclaration declaration, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirDeclaration"));
    }

    public J visitDynamicTypeRef(FirDynamicTypeRef dynamicTypeRef, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirDynamicTypeRef"));
    }

    public J visitDelegateFieldReference(FirDelegateFieldReference delegateFieldReference, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirDelegateFieldReference"));
    }

    public J visitDeclarationStatus(FirDeclarationStatus declarationStatus, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirDeclarationStatus"));
    }

    public J visitField(FirField field, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirField"));
    }

    public J visitFunction(FirFunction function, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirFunction"));
    }

    public J visitImplicitInvokeCall(FirImplicitInvokeCall implicitInvokeCall, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirImplicitInvokeCall"));
    }

    public J visitImplicitTypeRef(FirImplicitTypeRef implicitTypeRef, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirImplicitTypeRef"));
    }

    public J visitIntegerLiteralOperatorCall(FirIntegerLiteralOperatorCall integerLiteralOperatorCall, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirIntegerLiteralOperatorCall"));
    }

    public J visitIntersectionTypeRef(FirIntersectionTypeRef intersectionTypeRef, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirIntersectionTypeRef"));
    }

    public <E extends FirTargetElement> J visitJump(FirJump<E> jump, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirJump"));
    }

    public J visitLoop(FirLoop loop, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirLoop"));
    }

    public J visitLoopJump(FirLoopJump loopJump, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirLoopJump"));
    }

    public J visitMemberDeclaration(FirMemberDeclaration memberDeclaration, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirMemberDeclaration"));
    }

    public J visitNamedReference(FirNamedReference namedReference, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirNamedReference"));
    }

    public J visitPlaceholderProjection(FirPlaceholderProjection placeholderProjection, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirPlaceholderProjection"));
    }

    public J visitQualifiedAccess(FirQualifiedAccess qualifiedAccess, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirQualifiedAccess"));
    }

    public J visitQualifiedAccessExpression(FirQualifiedAccessExpression qualifiedAccessExpression, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirQualifiedAccessExpression"));
    }

    public J visitReference(FirReference reference, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirReference"));
    }

    public J visitRegularClass(FirRegularClass regularClass, ExecutionContext ctx) {
        J.Block body;
        boolean inlineConstructor;
        J.ClassDeclaration.Kind kind;
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        List modifiers = Collections.emptyList();
        ClassKind classKind = regularClass.getClassKind();
        String stopWord = ClassKind.INTERFACE == classKind ? "interface" : (ClassKind.OBJECT == classKind ? "object" : "class");
        List<J.Annotation> leadingAnnotation = this.mapModifiers(regularClass.getAnnotations(), stopWord);
        List kindAnnotations = Collections.emptyList();
        if (ClassKind.INTERFACE == classKind) {
            kind = new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("interface"), Markers.EMPTY, kindAnnotations, J.ClassDeclaration.Kind.Type.Interface);
        } else if (ClassKind.OBJECT == classKind) {
            markers = markers.addIfAbsent((Marker)new KObject(Tree.randomId(), Space.EMPTY));
            kind = new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("object"), Markers.EMPTY, kindAnnotations, J.ClassDeclaration.Kind.Type.Class);
        } else {
            kind = new J.ClassDeclaration.Kind(Tree.randomId(), this.sourceBefore("class"), Markers.EMPTY, kindAnnotations, J.ClassDeclaration.Kind.Type.Class);
        }
        J.Identifier name = ClassKind.OBJECT == classKind && leadingAnnotation.stream().anyMatch(a -> a.getAnnotationType() instanceof J.Identifier && "companion".equals(((J.Identifier)a.getAnnotationType()).getSimpleName())) ? new J.Identifier(Tree.randomId(), prefix, Markers.EMPTY, regularClass.getName().asString(), null, null) : this.createIdentifier(regularClass.getName().asString(), (FirElement)regularClass);
        JContainer typeParams = regularClass.getTypeParameters().isEmpty() ? null : JContainer.build((Space)this.sourceBefore("<"), this.convertAll(regularClass.getTypeParameters(), this.commaDelim, t -> this.sourceBefore(">"), ctx), (Markers)Markers.EMPTY);
        ArrayList<FirDeclaration> membersMultiVariablesSeparated = new ArrayList<FirDeclaration>(regularClass.getDeclarations().size());
        ArrayList<FirDeclaration> jcEnums = new ArrayList<FirDeclaration>(regularClass.getDeclarations().size());
        FirPrimaryConstructor firPrimaryConstructor = null;
        for (FirDeclaration declaration : regularClass.getDeclarations()) {
            if (declaration instanceof FirEnumEntry) {
                jcEnums.add(declaration);
                continue;
            }
            if (declaration instanceof FirPrimaryConstructor) {
                firPrimaryConstructor = (FirPrimaryConstructor)declaration;
                continue;
            }
            if (ClassKind.ENUM_CLASS == classKind && declaration.getSource() != null && declaration.getSource().getKind() instanceof KtFakeSourceElementKind.PropertyFromParameter) continue;
            membersMultiVariablesSeparated.add(declaration);
        }
        int saveCursor = this.cursor;
        Space before = this.whitespace();
        JContainer primaryConstructor = null;
        boolean bl = inlineConstructor = (this.source.startsWith("internal", this.cursor) || this.source.startsWith("constructor", this.cursor) || this.source.startsWith("(", this.cursor)) && firPrimaryConstructor != null;
        if (inlineConstructor) {
            J.Annotation annotation;
            if (this.source.startsWith("internal", this.cursor)) {
                annotation = this.convertToAnnotation(this.mapModifier(before, Collections.emptyList()));
                annotation = annotation.withMarkers(annotation.getMarkers().addIfAbsent((Marker)new ExplicitInlineConstructor(Tree.randomId())));
                annotation = annotation.withMarkers(annotation.getMarkers().addIfAbsent((Marker)new Modifier(Tree.randomId())));
                leadingAnnotation.add(annotation);
                before = this.whitespace();
            }
            if (this.source.startsWith("constructor", this.cursor)) {
                annotation = new J.Annotation(Tree.randomId(), before, Markers.EMPTY, (NameTree)this.createIdentifier("constructor", (FirElement)regularClass), null);
                annotation = annotation.withMarkers(annotation.getMarkers().addIfAbsent((Marker)new ExplicitInlineConstructor(Tree.randomId())));
                annotation = annotation.withMarkers(annotation.getMarkers().addIfAbsent((Marker)new Modifier(Tree.randomId())));
                leadingAnnotation.add(annotation);
                before = this.whitespace();
            }
            this.skip("(");
            primaryConstructor = JContainer.build((Space)before, firPrimaryConstructor.getValueParameters().isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY), Space.EMPTY)) : this.convertAll(firPrimaryConstructor.getValueParameters(), this.commaDelim, t -> this.sourceBefore(")"), ctx, true), (Markers)Markers.EMPTY);
        } else {
            this.cursor(saveCursor);
        }
        JContainer implementings = null;
        ArrayList<JRightPadded> superTypes = null;
        saveCursor = this.cursor;
        before = this.whitespace();
        if (this.source.startsWith(":", this.cursor)) {
            this.skip(":");
        }
        for (int i2 = 0; i2 < regularClass.getSuperTypeRefs().size(); ++i2) {
            FirTypeRef typeRef = (FirTypeRef)regularClass.getSuperTypeRefs().get(i2);
            FirRegularClassSymbol symbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)typeRef), (FirSession)this.firSession);
            if (typeRef.getSource() == null || typeRef.getSource().getKind() instanceof KtFakeSourceElementKind) continue;
            if (superTypes == null) {
                superTypes = new ArrayList<JRightPadded>(regularClass.getSuperTypeRefs().size());
            }
            TypeTree element = (TypeTree)this.visitElement((FirElement)typeRef, ctx);
            if (symbol != null && ClassKind.CLASS == ((FirRegularClass)symbol.getFir()).getClassKind()) {
                J.NewClass newClass = new J.NewClass(Tree.randomId(), element.getPrefix(), Markers.EMPTY, null, Space.EMPTY, (TypeTree)element.withPrefix(Space.EMPTY), JContainer.build((Space)this.sourceBefore("("), Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), this.sourceBefore(")"), Markers.EMPTY))), (Markers)Markers.EMPTY), null, null);
                element = new K.FunctionType(Tree.randomId(), (TypedTree)newClass, null, null);
            }
            superTypes.add(JRightPadded.build((Object)element).withAfter(i2 == regularClass.getSuperTypeRefs().size() - 1 ? Space.EMPTY : this.sourceBefore(",")));
        }
        if (superTypes == null) {
            this.cursor(saveCursor);
        } else {
            implementings = JContainer.build((Space)before, superTypes, (Markers)Markers.EMPTY);
        }
        saveCursor = this.cursor;
        Space bodyPrefix = this.whitespace();
        if (this.source.substring(this.cursor).isEmpty() || !this.source.substring(this.cursor).startsWith("{")) {
            this.cursor(saveCursor);
            OmitBraces omitBraces = new OmitBraces(Tree.randomId());
            body = new J.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.EMPTY);
            body = body.withMarkers(body.getMarkers().addIfAbsent((Marker)omitBraces));
        } else {
            this.skip("{");
            JRightPadded<J.EnumValueSet> enumSet = null;
            if (!jcEnums.isEmpty()) {
                AtomicBoolean semicolonPresent = new AtomicBoolean(false);
                List enumValues = this.convertAll(jcEnums, this.commaDelim, t -> {
                    semicolonPresent.set(this.positionOfNext(";", Character.valueOf('}')) > 0);
                    return semicolonPresent.get() ? this.sourceBefore(";", Character.valueOf('}')) : Space.EMPTY;
                }, ctx);
                enumSet = this.padRight(new J.EnumValueSet(Tree.randomId(), ((J.EnumValue)enumValues.get(0).getElement()).getPrefix(), Markers.EMPTY, ListUtils.map(enumValues, (i, ev) -> i == 0 ? ev.withElement((Object)((J.EnumValue)ev.getElement()).withPrefix(Space.EMPTY)) : ev), semicolonPresent.get()), Space.EMPTY);
            }
            ArrayList<Object> members = new ArrayList<Object>(membersMultiVariablesSeparated.size() + (enumSet == null ? 0 : 1));
            if (enumSet != null) {
                members.add(enumSet);
            }
            for (FirElement firElement : membersMultiVariablesSeparated) {
                if (firElement instanceof FirEnumEntry || firElement.getSource() != null && firElement.getSource().getKind() instanceof KtFakeSourceElementKind) continue;
                members.add(this.maybeSemicolon((Statement)this.visitElement(firElement, ctx)));
            }
            body = new J.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), members, this.sourceBefore("}"));
        }
        return new J.ClassDeclaration(Tree.randomId(), prefix, markers, leadingAnnotation, Collections.emptyList(), kind, name, typeParams, primaryConstructor, null, implementings, null, body, (JavaType.FullyQualified)this.typeMapping.type(regularClass));
    }

    public J visitResolvable(FirResolvable resolvable, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirResolvable"));
    }

    public J visitResolvedCallableReference(FirResolvedCallableReference resolvedCallableReference, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirResolvedCallableReference"));
    }

    public J visitResolvedDeclarationStatus(FirResolvedDeclarationStatus resolvedDeclarationStatus, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirResolvedDeclarationStatus"));
    }

    public J visitResolvedImport(FirResolvedImport resolvedImport, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirResolvedImport"));
    }

    public J visitSpreadArgumentExpression(FirSpreadArgumentExpression spreadArgumentExpression, ExecutionContext ctx) {
        if (!spreadArgumentExpression.isSpread()) {
            throw new UnsupportedOperationException("Only spread arguments are supported");
        }
        Space prefix = this.whitespace();
        this.skip("*");
        J j = this.visitElement((FirElement)spreadArgumentExpression.getExpression(), ctx);
        return (J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new SpreadArgument(Tree.randomId(), prefix)));
    }

    public J visitTypeRef(FirTypeRef typeRef, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirTypeRef"));
    }

    public J visitTargetElement(FirTargetElement targetElement, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirTargetElement"));
    }

    public J visitThisReference(FirThisReference thisReference, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirThisReference"));
    }

    public J visitThrowExpression(FirThrowExpression throwExpression, ExecutionContext ctx) {
        Space prefix = this.whitespace();
        this.skip("throw");
        return new J.Throw(Tree.randomId(), prefix, Markers.EMPTY, (Expression)this.visitElement((FirElement)throwExpression.getException(), ctx));
    }

    public J visitTypeParameterRef(FirTypeParameterRef typeParameterRef, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirTypeParameterRef"));
    }

    public J visitTypeParameterRefsOwner(FirTypeParameterRefsOwner typeParameterRefsOwner, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirTypeParameterRefsOwner"));
    }

    public J visitTypeParametersOwner(FirTypeParametersOwner typeParametersOwner, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirTypeParametersOwner"));
    }

    public J visitTypeProjection(FirTypeProjection typeProjection, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirTypeProjection"));
    }

    public J visitTypeRefWithNullability(FirTypeRefWithNullability typeRefWithNullability, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirTypeRefWithNullability"));
    }

    public J visitVarargArgumentsExpression(FirVarargArgumentsExpression varargArgumentsExpression, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirVarargArgumentsExpression"));
    }

    public J visitWhenSubjectExpression(FirWhenSubjectExpression whenSubjectExpression, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirWhenSubjectExpression"));
    }

    public J visitWrappedArgumentExpression(FirWrappedArgumentExpression wrappedArgumentExpression, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirWrappedArgumentExpression"));
    }

    public J visitWrappedDelegateExpression(FirWrappedDelegateExpression wrappedDelegateExpression, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirWrappedDelegateExpression"));
    }

    public J visitWrappedExpression(FirWrappedExpression wrappedExpression, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirWrappedExpression"));
    }

    public J visitNoReceiverExpression(FirNoReceiverExpression noReceiverExpression, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirNoReceiverExpression"));
    }

    public J visitErrorExpression(FirErrorExpression errorExpression, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirErrorExpression"));
    }

    public J visitErrorFunction(FirErrorFunction errorFunction, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirErrorFunction"));
    }

    public J visitErrorImport(FirErrorImport errorImport, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirErrorImport"));
    }

    public J visitErrorLoop(FirErrorLoop errorLoop, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirErrorLoop"));
    }

    public J visitErrorProperty(FirErrorProperty errorProperty, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirErrorProperty"));
    }

    public J visitErrorResolvedQualifier(FirErrorResolvedQualifier errorResolvedQualifier, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirErrorResolvedQualifier"));
    }

    public J visitErrorTypeRef(FirErrorTypeRef errorTypeRef, ExecutionContext ctx) {
        throw new UnsupportedOperationException(this.generateUnsupportedMessage("FirErrorTypeRef"));
    }

    private String generateUnsupportedMessage(String typeName) {
        StringBuilder msg = new StringBuilder(typeName);
        msg.append(" is not supported at cursor: ");
        msg.append(this.source, this.cursor, Math.min(this.source.length(), this.cursor + 30));
        if (this.currentFile != null) {
            msg.append("in file: ");
            msg.append(this.currentFile.getName());
        }
        return msg.toString();
    }

    @Nullable
    public J visitElement(@Nullable FirElement firElement, ExecutionContext ctx) {
        if (firElement == null) {
            return null;
        }
        int saveCursor = this.cursor;
        Space prefix = this.whitespace();
        KotlinSource.Node node = this.nodes.get(this.cursor);
        if (node != null) {
            switch (node.getName()) {
                case "PARENTHESIZED": {
                    if (node.getEndOffset() < firElement.getSource().getEndOffset()) break;
                    return this.wrapInParens(firElement, prefix, ctx);
                }
                case "REFERENCE_EXPRESSION": {
                    if (!"POSTFIX_EXPRESSION".equals(node.getParentName()) || !(firElement instanceof FirBlock)) break;
                    firElement = (FirElement)((FirBlock)firElement).getStatements().get(1);
                    break;
                }
                case "OPERATION_REFERENCE": {
                    if (!"PREFIX_EXPRESSION".equals(node.getParentName()) || !(firElement instanceof FirBlock)) break;
                    firElement = (FirElement)((FirBlock)firElement).getStatements().get(0);
                    break;
                }
            }
        }
        this.cursor = saveCursor;
        if (firElement instanceof FirErrorNamedReference) {
            return this.visitErrorNamedReference((FirErrorNamedReference)firElement, ctx);
        }
        if (firElement instanceof FirErrorExpression) {
            return this.visitErrorExpression((FirErrorExpression)firElement, ctx);
        }
        if (firElement instanceof FirErrorFunction) {
            return this.visitErrorFunction((FirErrorFunction)firElement, ctx);
        }
        if (firElement instanceof FirErrorImport) {
            return this.visitErrorImport((FirErrorImport)firElement, ctx);
        }
        if (firElement instanceof FirErrorLoop) {
            return this.visitErrorLoop((FirErrorLoop)firElement, ctx);
        }
        if (firElement instanceof FirErrorProperty) {
            return this.visitErrorProperty((FirErrorProperty)firElement, ctx);
        }
        if (firElement instanceof FirErrorResolvedQualifier) {
            return this.visitErrorResolvedQualifier((FirErrorResolvedQualifier)firElement, ctx);
        }
        if (firElement instanceof FirErrorTypeRef) {
            return this.visitErrorTypeRef((FirErrorTypeRef)firElement, ctx);
        }
        if (firElement instanceof FirAnnotationCall) {
            return this.visitAnnotationCall((FirAnnotationCall)firElement, ctx);
        }
        if (firElement instanceof FirAnonymousFunction) {
            return this.visitAnonymousFunction((FirAnonymousFunction)firElement, ctx);
        }
        if (firElement instanceof FirAnonymousFunctionExpression) {
            return this.visitAnonymousFunctionExpression((FirAnonymousFunctionExpression)firElement, ctx);
        }
        if (firElement instanceof FirAnonymousObject) {
            return this.visitAnonymousObject((FirAnonymousObject)firElement, ctx);
        }
        if (firElement instanceof FirAnonymousObjectExpression) {
            return this.visitAnonymousObjectExpression((FirAnonymousObjectExpression)firElement, ctx);
        }
        if (firElement instanceof FirArrayOfCall) {
            return this.visitArrayOfCall((FirArrayOfCall)firElement, ctx);
        }
        if (firElement instanceof FirBinaryLogicExpression) {
            return this.visitBinaryLogicExpression((FirBinaryLogicExpression)firElement, ctx);
        }
        if (firElement instanceof FirBlock) {
            return this.visitBlock((FirBlock)firElement, ctx);
        }
        if (firElement instanceof FirBreakExpression) {
            return this.visitBreakExpression((FirBreakExpression)firElement, ctx);
        }
        if (firElement instanceof FirCallableReferenceAccess) {
            return this.visitCallableReferenceAccess((FirCallableReferenceAccess)firElement, ctx);
        }
        if (firElement instanceof FirCatch) {
            return this.visitCatch((FirCatch)firElement, ctx);
        }
        if (firElement instanceof FirCheckNotNullCall) {
            return this.visitCheckNotNullCall((FirCheckNotNullCall)firElement, ctx);
        }
        if (firElement instanceof FirRegularClass) {
            return this.visitRegularClass((FirRegularClass)firElement, ctx);
        }
        if (firElement instanceof FirComparisonExpression) {
            return this.visitComparisonExpression((FirComparisonExpression)firElement, ctx);
        }
        if (firElement instanceof FirConstExpression) {
            return this.visitConstExpression((FirConstExpression)firElement, ctx);
        }
        if (firElement instanceof FirConstructor) {
            return this.visitConstructor((FirConstructor)firElement, ctx);
        }
        if (firElement instanceof FirContinueExpression) {
            return this.visitContinueExpression((FirContinueExpression)firElement, ctx);
        }
        if (firElement instanceof FirDoWhileLoop) {
            return this.visitDoWhileLoop((FirDoWhileLoop)firElement, ctx);
        }
        if (firElement instanceof FirElvisExpression) {
            return this.visitElvisExpression((FirElvisExpression)firElement, ctx);
        }
        if (firElement instanceof FirEnumEntry) {
            return this.visitEnumEntry((FirEnumEntry)firElement, ctx);
        }
        if (firElement instanceof FirEqualityOperatorCall) {
            return this.visitEqualityOperatorCall((FirEqualityOperatorCall)firElement, ctx);
        }
        if (firElement instanceof FirSuperReference) {
            return this.visitSuperReference((FirSuperReference)firElement, ctx);
        }
        if (firElement instanceof FirFunctionCall) {
            return this.visitFunctionCall((FirFunctionCall)firElement, ctx);
        }
        if (firElement instanceof FirFunctionTypeRef) {
            return this.visitFunctionTypeRef((FirFunctionTypeRef)firElement, ctx);
        }
        if (firElement instanceof FirGetClassCall) {
            return this.visitGetClassCall((FirGetClassCall)firElement, ctx);
        }
        if (firElement instanceof FirLabel) {
            return this.visitLabel((FirLabel)firElement, ctx);
        }
        if (firElement instanceof FirLambdaArgumentExpression) {
            return this.visitLambdaArgumentExpression((FirLambdaArgumentExpression)firElement, ctx);
        }
        if (firElement instanceof FirNamedArgumentExpression) {
            return this.visitNamedArgumentExpression((FirNamedArgumentExpression)firElement, ctx);
        }
        if (firElement instanceof FirProperty) {
            return this.visitProperty((FirProperty)firElement, ctx);
        }
        if (firElement instanceof FirPropertyAccessExpression) {
            return this.visitPropertyAccessExpression((FirPropertyAccessExpression)firElement, ctx);
        }
        if (firElement instanceof FirPropertyAccessor) {
            return this.visitPropertyAccessor((FirPropertyAccessor)firElement, ctx);
        }
        if (firElement instanceof FirBackingFieldReference) {
            return this.visitBackingFieldReference((FirBackingFieldReference)firElement, ctx);
        }
        if (firElement instanceof FirResolvedNamedReference) {
            return this.visitResolvedNamedReference((FirResolvedNamedReference)firElement, ctx);
        }
        if (firElement instanceof FirResolvedTypeRef) {
            return this.visitResolvedTypeRef((FirResolvedTypeRef)firElement, ctx);
        }
        if (firElement instanceof FirResolvedQualifier) {
            return this.visitResolvedQualifier((FirResolvedQualifier)firElement, ctx);
        }
        if (firElement instanceof FirReturnExpression) {
            return this.visitReturnExpression((FirReturnExpression)firElement, ctx);
        }
        if (firElement instanceof FirSafeCallExpression) {
            return this.visitSafeCallExpression((FirSafeCallExpression)firElement, ctx);
        }
        if (firElement instanceof FirCheckedSafeCallSubject) {
            return this.visitCheckedSafeCallSubject((FirCheckedSafeCallSubject)firElement, ctx);
        }
        if (firElement instanceof FirSimpleFunction) {
            return this.visitSimpleFunction((FirSimpleFunction)firElement, ctx);
        }
        if (firElement instanceof FirSmartCastExpression) {
            return this.visitSmartCastExpression((FirSmartCastExpression)firElement, ctx);
        }
        if (firElement instanceof FirStarProjection) {
            return this.visitStarProjection((FirStarProjection)firElement, ctx);
        }
        if (firElement instanceof FirStringConcatenationCall) {
            return this.visitStringConcatenationCall((FirStringConcatenationCall)firElement, ctx);
        }
        if (firElement instanceof FirThisReceiverExpression) {
            return this.visitThisReceiverExpression((FirThisReceiverExpression)firElement, ctx);
        }
        if (firElement instanceof FirThrowExpression) {
            return this.visitThrowExpression((FirThrowExpression)firElement, ctx);
        }
        if (firElement instanceof FirTypeOperatorCall) {
            return this.visitTypeOperatorCall((FirTypeOperatorCall)firElement, ctx);
        }
        if (firElement instanceof FirTypeParameter) {
            return this.visitTypeParameter((FirTypeParameter)firElement, ctx);
        }
        if (firElement instanceof FirTryExpression) {
            return this.visitTryExpression((FirTryExpression)firElement, ctx);
        }
        if (firElement instanceof FirTypeAlias) {
            return this.visitTypeAlias((FirTypeAlias)firElement, ctx);
        }
        if (firElement instanceof FirTypeProjectionWithVariance) {
            return this.visitTypeProjectionWithVariance((FirTypeProjectionWithVariance)firElement, ctx);
        }
        if (firElement instanceof FirUserTypeRef) {
            return this.visitUserTypeRef((FirUserTypeRef)firElement, ctx);
        }
        if (firElement instanceof FirValueParameter) {
            return this.visitValueParameter((FirValueParameter)firElement, ctx);
        }
        if (firElement instanceof FirVariableAssignment) {
            return this.visitVariableAssignment((FirVariableAssignment)firElement, ctx);
        }
        if (firElement instanceof FirWhenBranch) {
            return this.visitWhenBranch((FirWhenBranch)firElement, ctx);
        }
        if (firElement instanceof FirWhenExpression) {
            return this.visitWhenExpression((FirWhenExpression)firElement, ctx);
        }
        if (firElement instanceof FirWhenSubjectExpression) {
            return this.visitWhenSubjectExpression((FirWhenSubjectExpression)firElement, ctx);
        }
        if (firElement instanceof FirWhileLoop) {
            return this.visitWhileLoop((FirWhileLoop)firElement, ctx);
        }
        if (firElement instanceof FirArgumentList) {
            return this.visitArgumentList((FirArgumentList)firElement, ctx);
        }
        if (firElement instanceof FirAugmentedArraySetCall) {
            return this.visitAugmentedArraySetCall((FirAugmentedArraySetCall)firElement, ctx);
        }
        if (firElement instanceof FirAssignmentOperatorStatement) {
            return this.visitAssignmentOperatorStatement((FirAssignmentOperatorStatement)firElement, ctx);
        }
        if (firElement instanceof FirAnonymousInitializer) {
            return this.visitAnonymousInitializer((FirAnonymousInitializer)firElement, ctx);
        }
        if (firElement instanceof FirAnnotationArgumentMapping) {
            return this.visitAnnotationArgumentMapping((FirAnnotationArgumentMapping)firElement, ctx);
        }
        if (firElement instanceof FirBackingField) {
            return this.visitBackingField((FirBackingField)firElement, ctx);
        }
        if (firElement instanceof FirLegacyRawContractDescription) {
            return (J)this.visitLegacyRawContractDescription((FirLegacyRawContractDescription)firElement, ctx);
        }
        if (firElement instanceof FirRawContractDescription) {
            return (J)this.visitRawContractDescription((FirRawContractDescription)firElement, ctx);
        }
        if (firElement instanceof FirResolvedContractDescription) {
            return (J)this.visitResolvedContractDescription((FirResolvedContractDescription)firElement, ctx);
        }
        if (firElement instanceof FirContractDescription) {
            return (J)this.visitContractDescription((FirContractDescription)firElement, ctx);
        }
        if (firElement instanceof FirContextReceiver) {
            return this.visitContextReceiver((FirContextReceiver)firElement, ctx);
        }
        if (firElement instanceof FirContractDescriptionOwner) {
            return this.visitContractDescriptionOwner((FirContractDescriptionOwner)firElement, ctx);
        }
        if (firElement instanceof FirQualifiedAccessExpression) {
            return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)firElement, ctx);
        }
        if (firElement instanceof FirQualifiedAccess) {
            return this.visitQualifiedAccess((FirQualifiedAccess)firElement, ctx);
        }
        if (firElement instanceof FirContextReceiverArgumentListOwner) {
            return this.visitContextReceiverArgumentListOwner((FirContextReceiverArgumentListOwner)firElement, ctx);
        }
        if (firElement instanceof FirClassReferenceExpression) {
            return this.visitClassReferenceExpression((FirClassReferenceExpression)firElement, ctx);
        }
        if (firElement instanceof FirClassLikeDeclaration) {
            return this.visitClassLikeDeclaration((FirClassLikeDeclaration)firElement, ctx);
        }
        if (firElement instanceof FirCall) {
            return this.visitCall((FirCall)firElement, ctx);
        }
        if (firElement instanceof FirDynamicTypeRef) {
            return this.visitDynamicTypeRef((FirDynamicTypeRef)firElement, ctx);
        }
        if (firElement instanceof FirResolvedDeclarationStatus) {
            return this.visitResolvedDeclarationStatus((FirResolvedDeclarationStatus)firElement, ctx);
        }
        if (firElement instanceof FirDeclarationStatus) {
            return this.visitDeclarationStatus((FirDeclarationStatus)firElement, ctx);
        }
        if (firElement instanceof FirEffectDeclaration) {
            return (J)this.visitEffectDeclaration((FirEffectDeclaration)firElement, ctx);
        }
        if (firElement instanceof FirField) {
            return this.visitField((FirField)firElement, ctx);
        }
        if (firElement instanceof FirFunction) {
            return this.visitFunction((FirFunction)firElement, ctx);
        }
        if (firElement instanceof FirImplicitTypeRef) {
            return this.visitImplicitTypeRef((FirImplicitTypeRef)firElement, ctx);
        }
        if (firElement instanceof FirIntersectionTypeRef) {
            return this.visitIntersectionTypeRef((FirIntersectionTypeRef)firElement, ctx);
        }
        if (firElement instanceof FirLoopJump) {
            return this.visitLoopJump((FirLoopJump)firElement, ctx);
        }
        if (firElement instanceof FirJump) {
            return this.visitJump((FirJump)firElement, ctx);
        }
        if (firElement instanceof FirNamedReference) {
            return this.visitNamedReference((FirNamedReference)firElement, ctx);
        }
        if (firElement instanceof FirPlaceholderProjection) {
            return this.visitPlaceholderProjection((FirPlaceholderProjection)firElement, ctx);
        }
        if (firElement instanceof FirThisReference) {
            return this.visitThisReference((FirThisReference)firElement, ctx);
        }
        if (firElement instanceof FirReference) {
            return this.visitReference((FirReference)firElement, ctx);
        }
        if (firElement instanceof FirResolvable) {
            return this.visitResolvable((FirResolvable)firElement, ctx);
        }
        if (firElement instanceof FirResolvedImport) {
            return this.visitResolvedImport((FirResolvedImport)firElement, ctx);
        }
        if (firElement instanceof FirResolvedReifiedParameterReference) {
            return this.visitResolvedReifiedParameterReference((FirResolvedReifiedParameterReference)firElement, ctx);
        }
        if (firElement instanceof FirSpreadArgumentExpression) {
            return this.visitSpreadArgumentExpression((FirSpreadArgumentExpression)firElement, ctx);
        }
        if (firElement instanceof FirTypeRefWithNullability) {
            return this.visitTypeRefWithNullability((FirTypeRefWithNullability)firElement, ctx);
        }
        if (firElement instanceof FirTypeRef) {
            return this.visitTypeRef((FirTypeRef)firElement, ctx);
        }
        if (firElement instanceof FirTypeParameterRef) {
            return this.visitTypeParameterRef((FirTypeParameterRef)firElement, ctx);
        }
        if (firElement instanceof FirTypeParametersOwner) {
            return this.visitTypeParametersOwner((FirTypeParametersOwner)firElement, ctx);
        }
        if (firElement instanceof FirTypeProjection) {
            return this.visitTypeProjection((FirTypeProjection)firElement, ctx);
        }
        if (firElement instanceof FirVarargArgumentsExpression) {
            return this.visitVarargArgumentsExpression((FirVarargArgumentsExpression)firElement, ctx);
        }
        if (firElement instanceof FirWrappedArgumentExpression) {
            return this.visitWrappedArgumentExpression((FirWrappedArgumentExpression)firElement, ctx);
        }
        if (firElement instanceof FirWrappedExpression) {
            return this.visitWrappedExpression((FirWrappedExpression)firElement, ctx);
        }
        if (firElement instanceof FirNoReceiverExpression) {
            return this.visitNoReceiverExpression((FirNoReceiverExpression)firElement, ctx);
        }
        throw new IllegalArgumentException("Unsupported FirElement " + firElement.getClass().getName());
    }

    private <J2 extends J> J wrapInParens(FirElement firElement, Space prefix, ExecutionContext ctx) {
        this.skip("(");
        return new J.Parentheses(Tree.randomId(), prefix, Markers.EMPTY, this.padRight(this.visitElement(firElement, ctx), this.sourceBefore(")")));
    }

    private J.Identifier createIdentifier(@Nullable String name) {
        return this.createIdentifier(name == null ? "" : name, null, null);
    }

    private J.Identifier createIdentifier(String name, FirElement firElement) {
        return this.createIdentifier(name, this.typeMapping.type(firElement, this.getCurrentFile()), null);
    }

    private J.Identifier createIdentifier(String name, FirResolvedNamedReference namedReference) {
        FirBasedSymbol resolvedSymbol = namedReference.getResolvedSymbol();
        if (resolvedSymbol instanceof FirVariableSymbol) {
            FirVariableSymbol propertySymbol = (FirVariableSymbol)resolvedSymbol;
            JavaType.FullyQualified owner = null;
            ConeClassLikeLookupTag lookupTag = ClassMembersKt.containingClass((FirCallableSymbol)propertySymbol);
            if (lookupTag != null) {
                owner = (JavaType.FullyQualified)this.typeMapping.type(LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)lookupTag, (FirSession)this.firSession).getFir());
            }
            return this.createIdentifier(name, this.typeMapping.type(namedReference, this.getCurrentFile()), this.typeMapping.variableType((FirVariableSymbol<? extends FirVariable>)propertySymbol, owner, this.getCurrentFile()));
        }
        return this.createIdentifier(name, (FirElement)namedReference);
    }

    private J.Identifier createIdentifier(String name, @Nullable JavaType type, @Nullable JavaType.Variable fieldType) {
        String value;
        Space prefix = this.whitespace();
        boolean isQuotedSymbol = this.source.startsWith("`", this.cursor);
        if (isQuotedSymbol) {
            this.skip("`");
            value = this.source.substring(this.cursor, this.cursor + this.source.substring(this.cursor).indexOf(96));
            this.skip(value);
            this.skip("`");
            value = "`" + value + "`";
        } else {
            value = name;
            this.skip(value);
        }
        return new J.Identifier(Tree.randomId(), prefix, Markers.EMPTY, value, type, fieldType);
    }

    private J.MethodDeclaration createImplicitMethodDeclaration(String name) {
        return new J.MethodDeclaration(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), null, null, new J.MethodDeclaration.IdentifierWithAnnotations(new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, null, null), Collections.emptyList()), JContainer.empty(), null, null, null, null).withMarkers(Markers.EMPTY.addIfAbsent((Marker)new Implicit(Tree.randomId())));
    }

    private J.Annotation convertToAnnotation(K.Modifier modifier) {
        J.Identifier name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, modifier.getType().name().toLowerCase(), null, null);
        return new J.Annotation(Tree.randomId(), modifier.getPrefix(), Markers.EMPTY.addIfAbsent((Marker)new Modifier(Tree.randomId())), (NameTree)name, JContainer.empty());
    }

    @Nullable
    private List<J.Annotation> mapAnnotations(List<FirAnnotation> firAnnotations) {
        if (firAnnotations.isEmpty()) {
            return null;
        }
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>(firAnnotations.size());
        for (FirAnnotation annotation : firAnnotations) {
            J.Annotation a = (J.Annotation)this.visitElement((FirElement)annotation, null);
            annotations.add(a);
        }
        return annotations;
    }

    private J.Annotation mapAnnotation(List<FirAnnotation> firAnnotations) {
        if (firAnnotations.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty list of FIR Annotations.");
        }
        FirAnnotation firAnnotation = firAnnotations.get(0);
        J.Annotation annotation = (J.Annotation)this.visitElement((FirElement)firAnnotation, null);
        firAnnotations.remove(firAnnotation);
        return annotation;
    }

    private J.ControlParentheses<Expression> mapControlParentheses(FirElement firElement) {
        Space controlParenPrefix = this.whitespace();
        this.skip("(");
        return new J.ControlParentheses(Tree.randomId(), controlParenPrefix, Markers.EMPTY, this.convert(firElement, t -> this.sourceBefore(")"), this.ctx));
    }

    private J mapForLoop(FirBlock firBlock) {
        J.VariableDeclarations variable;
        FirWhileLoop forLoop = (FirWhileLoop)firBlock.getStatements().get(1);
        FirProperty receiver = (FirProperty)forLoop.getBlock().getStatements().get(0);
        J.Label label = null;
        if (forLoop.getLabel() != null) {
            label = (J.Label)this.visitElement((FirElement)forLoop.getLabel(), this.ctx);
        }
        Space prefix = this.whitespace();
        this.skip("for");
        Space controlPrefix = this.sourceBefore("(");
        int additionalVariables = 0;
        if ("<destruct>".equals(receiver.getName().asString())) {
            additionalVariables = this.source.substring(this.cursor, this.cursor + this.source.substring(this.cursor).indexOf(")") + 1).split(",").length;
            Space variablePrefix = this.sourceBefore("(");
            List statements = forLoop.getBlock().getStatements();
            ArrayList<JRightPadded> variables = new ArrayList<JRightPadded>(additionalVariables);
            for (int i = 1; i < additionalVariables + 1; ++i) {
                FirStatement statement = (FirStatement)statements.get(i);
                J.VariableDeclarations part = (J.VariableDeclarations)this.visitElement((FirElement)statement, this.ctx);
                JRightPadded named = (JRightPadded)part.getPadding().getVariables().get(0);
                named = named.withElement((Object)((J.VariableDeclarations.NamedVariable)named.getElement()).withName(((J.VariableDeclarations.NamedVariable)named.getElement()).getName().withPrefix(part.getPrefix())));
                Space after = i == additionalVariables ? this.sourceBefore(")") : this.sourceBefore(",");
                named = named.withAfter(after);
                variables.add(named);
            }
            variable = new J.VariableDeclarations(Tree.randomId(), variablePrefix, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), variables);
        } else {
            variable = (J.VariableDeclarations)this.visitElement((FirElement)receiver, this.ctx);
        }
        Space afterVariable = this.sourceBefore("in");
        FirProperty loopCondition = (FirProperty)firBlock.getStatements().get(0);
        Expression expression = loopCondition.getInitializer() instanceof FirFunctionCall && ((FirFunctionCall)loopCondition.getInitializer()).getExplicitReceiver() instanceof FirFunctionCall ? (Expression)this.visitElement((FirElement)((FirFunctionCall)loopCondition.getInitializer()).getExplicitReceiver(), this.ctx) : (Expression)this.visitElement((FirElement)((FirFunctionCall)loopCondition.getInitializer()).getExplicitReceiver(), this.ctx);
        Space afterExpression = this.sourceBefore(")");
        J.ForEachLoop.Control control = new J.ForEachLoop.Control(Tree.randomId(), controlPrefix, Markers.EMPTY, this.padRight(variable, afterVariable), this.padRight(expression, afterExpression));
        JRightPadded<Statement> body = null;
        if (!forLoop.getBlock().getStatements().isEmpty()) {
            Set<FirElement> skip = Collections.newSetFromMap(new IdentityHashMap());
            List statements = forLoop.getBlock().getStatements();
            for (int i = 0; i < 1 + additionalVariables; ++i) {
                skip.add((FirElement)statements.get(i));
            }
            Statement block = (Statement)this.visitBlock(forLoop.getBlock(), skip, this.ctx);
            body = this.padRight(block, Space.EMPTY);
        }
        J.ForEachLoop statement = new J.ForEachLoop(Tree.randomId(), prefix, Markers.EMPTY, control, body);
        return label != null ? label.withStatement((Statement)statement) : statement;
    }

    private List<J.Annotation> mapModifiers(List<FirAnnotation> firAnnotations, String stopWord) {
        if ("<no name provided>".equals(stopWord)) {
            List<J.Annotation> annotations = this.mapAnnotations(firAnnotations);
            return annotations == null ? Collections.emptyList() : annotations;
        }
        ArrayList<FirAnnotation> findMatch = new ArrayList<FirAnnotation>(firAnnotations.size());
        findMatch.addAll(firAnnotations);
        ArrayList<J.Annotation> modifiers = new ArrayList<J.Annotation>();
        for (int count = 0; count < 10; ++count) {
            int saveCursor = this.cursor;
            Space prefix = this.whitespace();
            if (this.cursor == this.source.length() - 1 || this.source.startsWith(stopWord, this.cursor) && (this.source.length() - 1 == this.cursor + stopWord.length() || Character.isWhitespace(this.source.charAt(this.cursor + stopWord.length())) || this.isDelimiter(this.source.charAt(this.cursor + stopWord.length())))) {
                this.cursor(saveCursor);
                return modifiers;
            }
            if (this.source.startsWith("@", this.cursor)) {
                this.cursor(saveCursor);
                J.Annotation annotation = this.mapAnnotation(findMatch);
                modifiers.add(annotation);
                continue;
            }
            if ((this.source.startsWith("val", this.cursor) || this.source.startsWith("var", this.cursor)) && (Character.isWhitespace(this.source.charAt(this.cursor + 3)) || this.isDelimiter(this.source.charAt(this.cursor + 3)))) {
                String word = this.source.startsWith("val", this.cursor) ? "val" : "var";
                J.Identifier name = this.createIdentifier(word);
                modifiers.add(new J.Annotation(Tree.randomId(), prefix, Markers.EMPTY.addIfAbsent((Marker)new Modifier(Tree.randomId())), (NameTree)name, JContainer.empty()));
                continue;
            }
            K.Modifier modifier = this.mapModifier(prefix, Collections.emptyList());
            if (modifier == null) {
                this.cursor(saveCursor);
                return modifiers;
            }
            J.Annotation annotation = this.convertToAnnotation(modifier);
            modifiers.add(annotation);
        }
        return modifiers;
    }

    private boolean isDelimiter(char c) {
        return c == '(' || c == ')' || c == '{' || c == '}' || c == '<' || c == '>' || c == ':' || c == '.' || c == ',';
    }

    @Nullable
    private K.Modifier mapModifier(Space prefix, List<J.Annotation> annotations) {
        K.Modifier.Type type;
        if (this.source.startsWith("public", this.cursor)) {
            type = K.Modifier.Type.Public;
        } else if (this.source.startsWith("protected", this.cursor)) {
            type = K.Modifier.Type.Protected;
        } else if (this.source.startsWith("private", this.cursor)) {
            type = K.Modifier.Type.Private;
        } else if (this.source.startsWith("internal", this.cursor)) {
            type = K.Modifier.Type.Internal;
        } else if (this.source.startsWith("expect", this.cursor)) {
            type = K.Modifier.Type.Expect;
        } else if (this.source.startsWith("actual", this.cursor)) {
            type = K.Modifier.Type.Actual;
        } else if (this.source.startsWith("final", this.cursor)) {
            type = K.Modifier.Type.Final;
        } else if (this.source.startsWith("open", this.cursor)) {
            type = K.Modifier.Type.Open;
        } else if (this.source.startsWith("abstract", this.cursor)) {
            type = K.Modifier.Type.Abstract;
        } else if (this.source.startsWith("sealed", this.cursor)) {
            type = K.Modifier.Type.Sealed;
        } else if (this.source.startsWith("const", this.cursor)) {
            type = K.Modifier.Type.Const;
        } else if (this.source.startsWith("external", this.cursor)) {
            type = K.Modifier.Type.External;
        } else if (this.source.startsWith("override", this.cursor)) {
            type = K.Modifier.Type.Override;
        } else if (this.source.startsWith("lateinit", this.cursor)) {
            type = K.Modifier.Type.LateInit;
        } else if (this.source.startsWith("tailrec", this.cursor)) {
            type = K.Modifier.Type.TailRec;
        } else if (this.source.startsWith("vararg", this.cursor)) {
            type = K.Modifier.Type.Vararg;
        } else if (this.source.startsWith("suspend", this.cursor)) {
            type = K.Modifier.Type.Suspend;
        } else if (this.source.startsWith("inner", this.cursor)) {
            type = K.Modifier.Type.Inner;
        } else if (this.source.startsWith("enum", this.cursor)) {
            type = K.Modifier.Type.Enum;
        } else if (this.source.startsWith("annotation", this.cursor)) {
            type = K.Modifier.Type.Annotation;
        } else if (this.source.startsWith("fun", this.cursor)) {
            type = K.Modifier.Type.Fun;
        } else if (this.source.startsWith("companion", this.cursor)) {
            type = K.Modifier.Type.Companion;
        } else if (this.source.startsWith("inline", this.cursor)) {
            type = K.Modifier.Type.Inline;
        } else if (this.source.startsWith("noinline", this.cursor)) {
            type = K.Modifier.Type.NoInline;
        } else if (this.source.startsWith("crossinline", this.cursor)) {
            type = K.Modifier.Type.CrossInline;
        } else if (this.source.startsWith("value", this.cursor)) {
            type = K.Modifier.Type.Value;
        } else if (this.source.startsWith("infix", this.cursor)) {
            type = K.Modifier.Type.Infix;
        } else if (this.source.startsWith("operator", this.cursor)) {
            type = K.Modifier.Type.Operator;
        } else if (this.source.startsWith("data", this.cursor)) {
            type = K.Modifier.Type.Data;
        } else {
            return null;
        }
        this.cursor += type.name().length();
        return new K.Modifier(Tree.randomId(), prefix, Markers.EMPTY, type, annotations);
    }

    private J.Binary.Type mapOperation(FirOperation firOp) {
        J.Binary.Type op = null;
        switch (firOp) {
            case EQ: {
                this.skip("=");
                op = J.Binary.Type.Equal;
                break;
            }
            case NOT_EQ: {
                this.skip("!=");
                op = J.Binary.Type.NotEqual;
                break;
            }
            case GT: {
                this.skip(">");
                op = J.Binary.Type.GreaterThan;
                break;
            }
            case GT_EQ: {
                this.skip(">=");
                op = J.Binary.Type.GreaterThanOrEqual;
                break;
            }
            case LT: {
                this.skip("<");
                op = J.Binary.Type.LessThan;
                break;
            }
            case LT_EQ: {
                this.skip("<=");
                op = J.Binary.Type.LessThanOrEqual;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported FirOperation " + op.name());
            }
        }
        return op;
    }

    private boolean isUnaryOperation(String name) {
        return "dec".equals(name) || "inc".equals(name) || "not".equals(name) || "unaryMinus".equals(name) || "unaryPlus".equals(name);
    }

    @Nullable
    private FirBasedSymbol<?> getCurrentFile() {
        return this.currentFile == null ? null : this.currentFile.getSymbol();
    }

    private void skip(@Nullable String token) {
        if (token != null && this.source.startsWith(token, this.cursor)) {
            this.cursor += token.length();
        }
    }

    private void cursor(int n) {
        this.cursor = n;
    }

    private int endPos(FirElement t) {
        if (t instanceof FirThisReceiverExpression) {
            return 0;
        }
        if (t.getSource() == null) {
            throw new IllegalStateException("Unexpected null source ... fix me.");
        }
        return t.getSource().getEndOffset();
    }

    private <J2 extends J> J2 convert(FirElement t, ExecutionContext ctx) {
        return (J2)this.visitElement(t, ctx);
    }

    @Nullable
    private <J2 extends J> JRightPadded<J2> convert(FirElement t, Function<FirElement, Space> suffix, ExecutionContext ctx) {
        J j = this.visitElement(t, ctx);
        JRightPadded rightPadded = j == null ? null : new JRightPadded((Object)j, suffix.apply(t), Markers.EMPTY);
        this.cursor(Math.max(this.endPos(t), this.cursor));
        return rightPadded;
    }

    @Nullable
    private <T extends J> T convertOrNull(@Nullable FirElement t, ExecutionContext ctx) {
        return t == null ? null : (T)this.convert(t, ctx);
    }

    private <J2 extends J> List<JRightPadded<J2>> convertAll(List<? extends FirElement> elements, Function<FirElement, Space> innerSuffix, Function<FirElement, Space> suffix, ExecutionContext ctx) {
        return this.convertAll(elements, innerSuffix, suffix, ctx, false);
    }

    private <J2 extends J> List<JRightPadded<J2>> convertAll(List<? extends FirElement> elements, Function<FirElement, Space> innerSuffix, Function<FirElement, Space> suffix, ExecutionContext ctx, boolean withUnknown) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList converted = new ArrayList(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            Space after;
            J j;
            FirElement element = elements.get(i);
            if (withUnknown && element.getSource() != null) {
                int saveCursor = this.cursor;
                try {
                    j = this.visitElement(element, ctx);
                }
                catch (Exception e) {
                    this.cursor = saveCursor;
                    Space prefix = this.whitespace();
                    String text = element.getSource().getLighterASTNode().toString();
                    this.skip(text);
                    j = new J.Unknown(Tree.randomId(), prefix, Markers.EMPTY, new J.Unknown.Source(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(ParseExceptionResult.build(KotlinParser.class, (Throwable)e).withTreeType(element.getSource().getKind().toString()))), text));
                }
            } else {
                j = this.visitElement(element, ctx);
            }
            Space space = after = i == elements.size() - 1 ? suffix.apply(element) : innerSuffix.apply(element);
            if (j == null && i < elements.size() - 1) continue;
            if (j == null) {
                j = new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
            }
            JRightPadded<J> rightPadded = this.padRight(j, after);
            converted.add(rightPadded);
        }
        return converted.isEmpty() ? Collections.emptyList() : converted;
    }

    private <K2 extends J> JRightPadded<K2> maybeSemicolon(K2 k) {
        int saveCursor = this.cursor;
        Space beforeSemi = this.whitespace();
        Semicolon semicolon = null;
        if (this.cursor < this.source.length() && this.source.charAt(this.cursor) == ';') {
            semicolon = new Semicolon(Tree.randomId());
            ++this.cursor;
        } else {
            beforeSemi = Space.EMPTY;
            this.cursor(saveCursor);
        }
        JRightPadded padded = JRightPadded.build(k).withAfter(beforeSemi);
        if (semicolon != null) {
            padded = padded.withMarkers(padded.getMarkers().add((Marker)semicolon));
        }
        return padded;
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    private <T> JRightPadded<T> padRight(T tree, @Nullable Space right) {
        return new JRightPadded(tree, right == null ? Space.EMPTY : right, Markers.EMPTY);
    }

    private int positionOfNext(String untilDelim) {
        return this.positionOfNext(untilDelim, null);
    }

    private int positionOfNext(String untilDelim, @Nullable Character stop) {
        int delimIndex;
        boolean inMultiLineComment = false;
        boolean inSingleLineComment = false;
        for (delimIndex = this.cursor; delimIndex < this.source.length() - untilDelim.length() + 1; ++delimIndex) {
            if (inSingleLineComment) {
                if (this.source.charAt(delimIndex) != '\n') continue;
                inSingleLineComment = false;
                continue;
            }
            if (this.source.length() - untilDelim.length() > delimIndex + 1) {
                char c1 = this.source.charAt(delimIndex);
                char c2 = this.source.charAt(delimIndex + 1);
                if (c1 == '/') {
                    if (c2 == '/') {
                        inSingleLineComment = true;
                        ++delimIndex;
                    } else if (c2 == '*') {
                        inMultiLineComment = true;
                        ++delimIndex;
                    }
                } else if (c1 == '*' && c2 == '/') {
                    inMultiLineComment = false;
                    delimIndex += 2;
                }
            }
            if (inMultiLineComment || inSingleLineComment) continue;
            if (stop != null && this.source.charAt(delimIndex) == stop.charValue()) {
                return -1;
            }
            if (this.source.startsWith(untilDelim, delimIndex)) break;
        }
        return delimIndex > this.source.length() - untilDelim.length() ? -1 : delimIndex;
    }

    private Space sourceBefore(String untilDelim) {
        int delimIndex = this.positionOfNext(untilDelim);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return Space.format((String)prefix);
    }

    private Space sourceBefore(String untilDelim, @Nullable Character stop) {
        int delimIndex = this.positionOfNext(untilDelim, stop);
        if (delimIndex < 0) {
            return Space.EMPTY;
        }
        if (delimIndex == this.cursor) {
            this.cursor += untilDelim.length();
            return Space.EMPTY;
        }
        String prefix = this.source.substring(this.cursor, delimIndex);
        this.cursor += prefix.length() + untilDelim.length();
        return Space.format((String)prefix);
    }

    private Space whitespace() {
        String prefix = this.source.substring(this.cursor, StringUtils.indexOfNextNonWhitespace((int)this.cursor, (String)this.source));
        this.cursor += prefix.length();
        return Space.format((String)prefix);
    }
}

