/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;

public final class EqualsMethodUsage
extends Recipe {
    private static J.Binary equalsBinaryTemplate = null;

    public String getDisplayName() {
        return "Structural equality tests should use \"==\" or \"!=\"";
    }

    public String getDescription() {
        return "In Kotlin, == means structural equality and != structural inequality and both map to the left-side term\u2019s equals() function. It is, therefore, redundant to call equals() as a function. Also, == and != are more general than equals() and !equals() because it allows either of both operands to be null.\nDevelopers using equals() instead of == or != is often the result of adapting styles from other languages like Java, where == means reference equality and != means reference inequality.\nThe == and != operators are a more concise and elegant way to test structural equality than calling a function.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-6519");
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(3L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinVisitor<ExecutionContext>(){

            public J visitUnary(J.Unary unary, ExecutionContext ctx) {
                J.Binary binary;
                if ((unary = (J.Unary)super.visitUnary(unary, (Object)ctx)).getExpression() instanceof J.Binary && replacedWithEqual.hasMarker((J)unary.getExpression()) && (binary = (J.Binary)unary.getExpression()).getOperator().equals((Object)J.Binary.Type.Equal)) {
                    return binary.withOperator(J.Binary.Type.NotEqual);
                }
                return unary;
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if ("equals".equals((method = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx)).getSimpleName()) && method.getArguments().size() == 1 && TypeUtils.isOfClassType((JavaType)method.getMethodType().getReturnType(), (String)"kotlin.Boolean") && method.getSelect() != null) {
                    Expression lhs = method.getSelect();
                    Expression rhs = (Expression)method.getArguments().get(0);
                    return replacedWithEqual.withMarker(EqualsMethodUsage.buildEqualsBinary(lhs, rhs));
                }
                return method;
            }
        };
    }

    private static J.Binary buildEqualsBinary(Expression left, Expression right) {
        Space rhsPrefix;
        if (equalsBinaryTemplate == null) {
            K.CompilationUnit kcu = KotlinParser.builder().build().parse("fun method(a : String, b : String) {val isSame = a == b}").map(K.CompilationUnit.class::cast).findFirst().get();
            equalsBinaryTemplate = (J.Binary)((AtomicReference)new KotlinVisitor<AtomicReference<J.Binary>>(){

                public J visitBinary(J.Binary binary, AtomicReference<J.Binary> target) {
                    target.set(binary);
                    return binary;
                }
            }.reduce((Tree)kcu, new AtomicReference())).get();
        }
        if ((rhsPrefix = right.getPrefix()).getWhitespace().isEmpty()) {
            rhsPrefix = rhsPrefix.withWhitespace(" ");
        }
        return equalsBinaryTemplate.withLeft((Expression)left.withPrefix(left.getPrefix())).withRight((Expression)right.withPrefix(rhsPrefix));
    }

    public String toString() {
        return "EqualsMethodUsage()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualsMethodUsage)) {
            return false;
        }
        EqualsMethodUsage other = (EqualsMethodUsage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof EqualsMethodUsage;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static final class replacedWithEqual
    implements Marker {
        private final UUID id;

        static <J2 extends J> J2 withMarker(J2 j) {
            return (J2)((J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new replacedWithEqual(Tree.randomId()))));
        }

        static boolean hasMarker(J j) {
            return j.getMarkers().findFirst(replacedWithEqual.class).isPresent();
        }

        public replacedWithEqual(UUID id) {
            this.id = id;
        }

        public UUID getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof replacedWithEqual)) {
                return false;
            }
            replacedWithEqual other = (replacedWithEqual)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public String toString() {
            return "EqualsMethodUsage.replacedWithEqual(id=" + this.getId() + ")";
        }

        public replacedWithEqual withId(UUID id) {
            return this.id == id ? this : new replacedWithEqual(id);
        }
    }
}

