/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaMethod;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameter;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitNullableAnyTypeRef;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaArrayType;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaConstructor;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaField;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.JavaWildcardType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaConstructor;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaMethod;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTypeMapping;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinTypeSignatureBuilder;

@Incubating(since="0.0")
public class KotlinTypeMapping
implements JavaTypeMapping<Object> {
    private final KotlinTypeSignatureBuilder signatureBuilder;
    private final JavaTypeCache typeCache;
    private final FirSession firSession;

    public KotlinTypeMapping(JavaTypeCache typeCache, FirSession firSession) {
        this.signatureBuilder = new KotlinTypeSignatureBuilder(firSession);
        this.typeCache = typeCache;
        this.firSession = firSession;
    }

    public JavaType type(@Nullable Object type) {
        return this.type(type, null);
    }

    public JavaType type(@Nullable Object type, @Nullable FirBasedSymbol<?> ownerFallBack) {
        if (type == null) {
            return JavaType.Unknown.getInstance();
        }
        String signature = this.signatureBuilder.signature(type, ownerFallBack);
        JavaType existing = (JavaType)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        if (type instanceof String) {
            JavaType.ShallowClass javaType = JavaType.ShallowClass.build((String)((String)type));
            this.typeCache.put(signature, (Object)javaType);
            return javaType;
        }
        if (type instanceof FirClass) {
            return this.classType(type, signature, ownerFallBack);
        }
        if (type instanceof FirFunction) {
            return this.methodDeclarationType((FirFunction)type, null, ownerFallBack);
        }
        if (type instanceof FirVariable) {
            return this.variableType((FirVariableSymbol<? extends FirVariable>)((FirVariable)type).getSymbol(), null, ownerFallBack);
        }
        if (type instanceof FirFile) {
            return JavaType.ShallowClass.build((String)((FirFile)type).getName());
        }
        if (type instanceof FirJavaTypeRef) {
            return this.type(((FirJavaTypeRef)type).getType(), ownerFallBack);
        }
        if (type instanceof org.jetbrains.kotlin.load.java.structure.JavaType) {
            return this.mapJavaType((org.jetbrains.kotlin.load.java.structure.JavaType)type, signature);
        }
        if (type instanceof JavaElement) {
            return this.mapJavaElementType((JavaElement)type, signature);
        }
        return this.resolveType(type, signature, ownerFallBack);
    }

    @Nullable
    private JavaType resolveType(Object type, String signature, @Nullable FirBasedSymbol<?> ownerFallBack) {
        if (type instanceof ConeTypeProjection) {
            return this.resolveConeTypeProjection((ConeTypeProjection)type, signature, ownerFallBack);
        }
        if (type instanceof FirExpression) {
            return this.type(((FirExpression)type).getTypeRef(), ownerFallBack);
        }
        if (type instanceof FirFunctionTypeRef) {
            return this.type(((FirFunctionTypeRef)type).getReturnTypeRef(), ownerFallBack);
        }
        if (type instanceof FirResolvedNamedReference) {
            FirBasedSymbol resolvedSymbol = ((FirResolvedNamedReference)type).getResolvedSymbol();
            if (resolvedSymbol instanceof FirConstructorSymbol) {
                return this.type(((FirConstructorSymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerFallBack);
            }
            if (resolvedSymbol instanceof FirEnumEntrySymbol) {
                return this.type(((FirEnumEntrySymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerFallBack);
            }
            if (resolvedSymbol instanceof FirNamedFunctionSymbol) {
                return this.type(((FirNamedFunctionSymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerFallBack);
            }
            if (resolvedSymbol instanceof FirPropertySymbol) {
                return this.type(((FirPropertySymbol)resolvedSymbol).getResolvedReturnTypeRef(), ownerFallBack);
            }
            if (resolvedSymbol instanceof FirValueParameterSymbol) {
                return this.type(((FirValueParameterSymbol)resolvedSymbol).getResolvedReturnType(), ownerFallBack);
            }
            if (resolvedSymbol instanceof FirFieldSymbol) {
                return this.type(((FirFieldSymbol)resolvedSymbol).getResolvedReturnType(), ownerFallBack);
            }
        } else {
            if (type instanceof FirResolvedTypeRef) {
                FirClassifierSymbol classifierSymbol;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)((FirResolvedTypeRef)type));
                if (coneKotlinType instanceof ConeTypeParameterType && (classifierSymbol = LookupTagUtilsKt.toSymbol((ConeClassifierLookupTag)((ConeTypeParameterType)coneKotlinType).getLookupTag(), (FirSession)this.firSession)) != null && classifierSymbol.getFir() instanceof FirTypeParameter) {
                    return this.resolveConeTypeProjection((FirTypeParameter)classifierSymbol.getFir(), signature);
                }
                return this.classType(type, signature, ownerFallBack);
            }
            if (type instanceof FirTypeParameter) {
                return this.resolveConeTypeProjection((FirTypeParameter)type, signature);
            }
            if (type instanceof FirVariableAssignment) {
                return this.type(((FirVariableAssignment)type).getCalleeReference(), ownerFallBack);
            }
        }
        return null;
    }

    private JavaType array(JavaArrayType type, String signature) {
        JavaType.Array arr = new JavaType.Array(null, null);
        this.typeCache.put(signature, (Object)arr);
        arr.unsafeSet(this.type(type.getComponentType()));
        return arr;
    }

    /*
     * WARNING - void declaration
     */
    private JavaType.FullyQualified classType(Object classType, String signature, @Nullable FirBasedSymbol<?> ownerFallBack) {
        FirClass firClass;
        FirResolvedTypeRef resolvedTypeRef = null;
        if (classType instanceof FirResolvedTypeRef) {
            FirRegularClassSymbol symbol;
            resolvedTypeRef = (FirResolvedTypeRef)classType;
            ConeKotlinType type = resolvedTypeRef.getType();
            if (type instanceof ConeFlexibleType) {
                type = ((ConeFlexibleType)type).getLowerBound();
            }
            if ((symbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)type, (FirSession)this.firSession)) == null) {
                this.typeCache.put(signature, (Object)JavaType.Unknown.getInstance());
                return JavaType.Unknown.getInstance();
            }
            firClass = (FirClass)symbol.getFir();
        } else {
            firClass = (FirClass)classType;
        }
        FirClassSymbol sym = firClass.getSymbol();
        String classFqn = KotlinTypeSignatureBuilder.convertClassIdToFqn(sym.getClassId());
        JavaType.FullyQualified fq = (JavaType.FullyQualified)this.typeCache.get(classFqn);
        if (fq instanceof JavaType.Unknown) {
            return fq;
        }
        JavaType.Class clazz = (JavaType.Class)(fq instanceof JavaType.Parameterized ? ((JavaType.Parameterized)fq).getType() : fq);
        if (clazz == null) {
            void var20_31;
            FirClassLikeSymbol ownerSymbol;
            clazz = new JavaType.Class(null, this.convertToFlagsBitMap(firClass.getStatus()), classFqn, this.convertToClassKind(firClass.getClassKind()), null, null, null, null, null, null, null);
            this.typeCache.put(classFqn, (Object)clazz);
            FirTypeRef superTypeRef = null;
            ArrayList<FirTypeRef> interfaceTypeRefs = null;
            for (FirTypeRef typeRef : firClass.getSuperTypeRefs()) {
                FirRegularClassSymbol symbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)typeRef), (FirSession)this.firSession);
                if (symbol != null && ClassKind.CLASS == ((FirRegularClass)symbol.getFir()).getClassKind()) {
                    superTypeRef = typeRef;
                    continue;
                }
                if (symbol == null || ClassKind.INTERFACE != ((FirRegularClass)symbol.getFir()).getClassKind()) continue;
                if (interfaceTypeRefs == null) {
                    interfaceTypeRefs = new ArrayList<FirTypeRef>();
                }
                interfaceTypeRefs.add(typeRef);
            }
            JavaType.FullyQualified supertype = superTypeRef == null || "java.lang.Object".equals(signature) ? null : TypeUtils.asFullyQualified((JavaType)this.type(superTypeRef));
            JavaType.FullyQualified owner = null;
            if (firClass.getSymbol().getClassId().getOuterClassId() != null && (ownerSymbol = FirSymbolProviderKt.getSymbolProvider((FirSession)this.firSession).getClassLikeSymbolByClassId(firClass.getSymbol().getClassId().getOuterClassId())) != null) {
                owner = TypeUtils.asFullyQualified((JavaType)this.type(ownerSymbol.getFir()));
            }
            ArrayList<FirProperty> properties = new ArrayList<FirProperty>(firClass.getDeclarations().size());
            ArrayList<FirJavaField> javaFields = new ArrayList<FirJavaField>(firClass.getDeclarations().size());
            ArrayList<FirFunction> functions = new ArrayList<FirFunction>(firClass.getDeclarations().size());
            ArrayList<FirEnumEntry> enumEntries = new ArrayList<FirEnumEntry>(firClass.getDeclarations().size());
            for (Object declaration : firClass.getDeclarations()) {
                if (declaration instanceof FirProperty) {
                    if (declaration.getSource() != null && declaration.getSource().getKind() instanceof KtFakeSourceElementKind) continue;
                    properties.add((FirProperty)declaration);
                    continue;
                }
                if (declaration instanceof FirJavaField) {
                    javaFields.add((FirJavaField)declaration);
                    continue;
                }
                if (declaration instanceof FirSimpleFunction) {
                    functions.add((FirFunction)declaration);
                    continue;
                }
                if (declaration instanceof FirConstructor) {
                    functions.add((FirFunction)declaration);
                    continue;
                }
                if (declaration instanceof FirRegularClass || !(declaration instanceof FirEnumEntry)) continue;
                enumEntries.add((FirEnumEntry)declaration);
            }
            ArrayList<JavaType.Variable> fields = null;
            if (!enumEntries.isEmpty()) {
                fields = new ArrayList<JavaType.Variable>(properties.size() + enumEntries.size());
                for (FirEnumEntry firEnumEntry : enumEntries) {
                    fields.add(this.variableType((FirVariableSymbol<? extends FirVariable>)firEnumEntry.getSymbol(), (JavaType.FullyQualified)clazz, ownerFallBack));
                }
            }
            if (!properties.isEmpty()) {
                if (fields == null) {
                    fields = new ArrayList(properties.size());
                }
                for (FirProperty firProperty : properties) {
                    fields.add(this.variableType((FirVariableSymbol<? extends FirVariable>)firProperty.getSymbol(), (JavaType.FullyQualified)clazz, ownerFallBack));
                }
            }
            if (!javaFields.isEmpty()) {
                if (fields == null) {
                    fields = new ArrayList(javaFields.size());
                }
                for (FirJavaField firJavaField : javaFields) {
                    fields.add(this.variableType((FirVariableSymbol<? extends FirVariable>)firJavaField.getSymbol(), (JavaType.FullyQualified)clazz, ownerFallBack));
                }
            }
            ArrayList<JavaType.Method> methods = null;
            if (!functions.isEmpty()) {
                methods = new ArrayList<JavaType.Method>(functions.size());
                for (FirFunction firFunction : functions) {
                    methods.add(this.methodDeclarationType(firFunction, (JavaType.FullyQualified)clazz, ownerFallBack));
                }
            }
            Object var20_29 = null;
            if (interfaceTypeRefs != null && !interfaceTypeRefs.isEmpty()) {
                ArrayList<JavaType.FullyQualified> arrayList = new ArrayList<JavaType.FullyQualified>(interfaceTypeRefs.size());
                for (FirTypeRef iParam : interfaceTypeRefs) {
                    JavaType.FullyQualified javaType = TypeUtils.asFullyQualified((JavaType)this.type(iParam));
                    if (javaType == null) continue;
                    arrayList.add(javaType);
                }
            }
            List<JavaType.FullyQualified> list = this.listAnnotations(firClass.getAnnotations());
            clazz.unsafeSet(null, supertype, owner, list, (List)var20_31, fields, methods);
        }
        if (!firClass.getTypeParameters().isEmpty()) {
            JavaType.Parameterized pt = (JavaType.Parameterized)this.typeCache.get(signature);
            if (pt == null) {
                pt = new JavaType.Parameterized(null, null, null);
                this.typeCache.put(signature, (Object)pt);
                ArrayList<JavaType> typeParameters = new ArrayList<JavaType>(firClass.getTypeParameters().size());
                if (resolvedTypeRef != null && resolvedTypeRef.getType().getTypeArguments().length > 0) {
                    for (ConeTypeProjection typeArgument : resolvedTypeRef.getType().getTypeArguments()) {
                        typeParameters.add(this.type(typeArgument));
                    }
                } else {
                    for (FirTypeParameterRef tParam : firClass.getTypeParameters()) {
                        typeParameters.add(this.type(tParam));
                    }
                }
                pt.unsafeSet((JavaType.FullyQualified)clazz, typeParameters);
            }
            return pt;
        }
        return clazz;
    }

    private JavaType classType(BinaryJavaClass classifier, String signature) {
        JavaType.Class clazz = (JavaType.Class)this.typeCache.get(classifier.getFqName().asString());
        if (clazz == null) {
            clazz = new JavaType.Class(null, (long)classifier.getAccess(), classifier.getFqName().asString(), this.convertToClassKind(classifier), null, null, null, null, null, null, null);
            this.typeCache.put(classifier.getFqName().asString(), (Object)clazz);
            JavaType.FullyQualified supertype = null;
            ArrayList<JavaType.FullyQualified> interfaces = null;
            for (JavaClassifierType classifierSupertype : classifier.getSupertypes()) {
                if (!(classifierSupertype.getClassifier() instanceof JavaClass)) continue;
                if (((JavaClass)classifierSupertype.getClassifier()).isInterface()) {
                    if (interfaces == null) {
                        interfaces = new ArrayList<JavaType.FullyQualified>();
                    }
                    interfaces.add((JavaType.FullyQualified)this.type(classifierSupertype));
                    continue;
                }
                if ("java.lang.Object".equals(signature)) continue;
                supertype = (JavaType.FullyQualified)this.type(classifierSupertype);
            }
            JavaType.FullyQualified owner = null;
            if (classifier.getOuterClass() != null) {
                owner = TypeUtils.asFullyQualified((JavaType)this.type(classifier.getOuterClass()));
            }
            ArrayList<JavaType.Variable> fields = null;
            if (!classifier.getFields().isEmpty()) {
                fields = new ArrayList<JavaType.Variable>(classifier.getFields().size());
                for (JavaField field : classifier.getFields()) {
                    fields.add(this.variableType(field, (JavaType.FullyQualified)clazz));
                }
            }
            ArrayList<JavaType.Method> methods = null;
            if (!classifier.getMethods().isEmpty()) {
                methods = new ArrayList<JavaType.Method>(classifier.getMethods().size());
                for (JavaConstructor method : classifier.getMethods()) {
                    methods.add(this.methodDeclarationType((JavaMethod)method, (JavaType.FullyQualified)clazz));
                }
            }
            if (!classifier.getConstructors().isEmpty()) {
                for (JavaConstructor method : classifier.getConstructors()) {
                    if (!(method instanceof BinaryJavaConstructor)) continue;
                    if (methods == null) {
                        methods = new ArrayList();
                    }
                    if (((long)((BinaryJavaConstructor)method).getAccess() & 0x20A0001000L) != 0L) continue;
                    methods.add(this.methodConstructorSignature(method, (JavaType.FullyQualified)clazz));
                }
            }
            ArrayList<JavaType> typeParameters = null;
            if (!classifier.getTypeParameters().isEmpty()) {
                typeParameters = new ArrayList<JavaType>(classifier.getTypeParameters().size());
                for (JavaTypeParameter typeArgument : classifier.getTypeParameters()) {
                    typeParameters.add(this.type(typeArgument));
                }
            }
            clazz.unsafeSet(typeParameters, supertype, owner, this.listAnnotations(classifier.getAnnotations()), interfaces, fields, methods);
        }
        if (!classifier.getTypeParameters().isEmpty()) {
            if (!signature.contains("<") || !signature.contains(">")) {
                throw new IllegalStateException("Signature " + signature + " does not contain type parameters in classType().");
            }
            JavaType.FullyQualified fq = (JavaType.FullyQualified)this.typeCache.get(signature);
            if (fq != null && !(fq instanceof JavaType.Parameterized)) {
                throw new IllegalStateException("JavaType$Parameterized was not returned for signature " + signature + " in classType().");
            }
            JavaType.Parameterized pt = (JavaType.Parameterized)this.typeCache.get(signature);
            if (pt == null) {
                pt = new JavaType.Parameterized(null, null, null);
                this.typeCache.put(signature, (Object)pt);
                ArrayList<JavaType> typeParameters = new ArrayList<JavaType>(classifier.getTypeParameters().size());
                for (JavaTypeParameter typeArgument : classifier.getTypeParameters()) {
                    typeParameters.add(this.type(typeArgument));
                }
                pt.unsafeSet((JavaType.FullyQualified)clazz, typeParameters);
            }
            return pt;
        }
        return clazz;
    }

    @Nullable
    public JavaType.Method methodDeclarationType(@Nullable FirFunction function, @Nullable JavaType.FullyQualified declaringType, @Nullable FirBasedSymbol<?> ownerFallBack) {
        FirFunctionSymbol methodSymbol;
        FirFunctionSymbol firFunctionSymbol = methodSymbol = function == null ? null : function.getSymbol();
        if (methodSymbol != null) {
            String signature = this.signatureBuilder.methodDeclarationSignature((FirFunctionSymbol<? extends FirFunction>)function.getSymbol());
            JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
            if (existing != null) {
                return existing;
            }
            ArrayList<String> paramNames = null;
            if (!methodSymbol.getValueParameterSymbols().isEmpty()) {
                paramNames = new ArrayList<String>(methodSymbol.getValueParameterSymbols().size());
                for (FirValueParameterSymbol p : methodSymbol.getValueParameterSymbols()) {
                    String s = p.getName().asString();
                    paramNames.add(s);
                }
            }
            List defaultValues = null;
            JavaType.Method method = new JavaType.Method(null, this.convertToFlagsBitMap((FirDeclarationStatus)methodSymbol.getResolvedStatus()), null, methodSymbol instanceof FirConstructorSymbol ? "<constructor>" : methodSymbol.getName().asString(), null, paramNames, null, null, null, defaultValues);
            this.typeCache.put(signature, (Object)method);
            JavaType.FullyQualified resolvedDeclaringType = declaringType;
            if (declaringType == null) {
                if (methodSymbol instanceof FirConstructorSymbol) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(methodSymbol.getResolvedReturnType()));
                } else if (methodSymbol.getDispatchReceiverType() != null) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(methodSymbol.getDispatchReceiverType()));
                } else if (ownerFallBack != null) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(ownerFallBack.getFir()));
                }
            }
            if (resolvedDeclaringType == null) {
                return null;
            }
            JavaType returnType = function instanceof FirJavaMethod ? this.type(((FirFunction)methodSymbol.getFir()).getReturnTypeRef()) : this.type(methodSymbol.getResolvedReturnTypeRef());
            ArrayList<JavaType> parameterTypes = null;
            if (!methodSymbol.getValueParameterSymbols().isEmpty()) {
                parameterTypes = new ArrayList<JavaType>(methodSymbol.getValueParameterSymbols().size());
                for (FirValueParameterSymbol parameterSymbol : methodSymbol.getValueParameterSymbols()) {
                    JavaType javaType = parameterSymbol.getFir() instanceof FirJavaValueParameter ? this.type(((FirValueParameter)parameterSymbol.getFir()).getReturnTypeRef()) : this.type(parameterSymbol.getResolvedReturnTypeRef());
                    parameterTypes.add(javaType);
                }
            }
            method.unsafeSet(resolvedDeclaringType, (JavaType)(methodSymbol instanceof FirConstructorSymbol ? resolvedDeclaringType : returnType), parameterTypes, null, this.listAnnotations(methodSymbol.getAnnotations()));
            return method;
        }
        return null;
    }

    @Nullable
    public JavaType.Method methodDeclarationType(@Nullable JavaMethod javaMethod, @Nullable JavaType.FullyQualified declaringType) {
        if (javaMethod != null) {
            String signature = this.signatureBuilder.methodDeclarationSignature(javaMethod);
            JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
            if (existing != null) {
                return existing;
            }
            ArrayList<String> paramNames = null;
            if (!javaMethod.getValueParameters().isEmpty()) {
                paramNames = new ArrayList<String>(javaMethod.getValueParameters().size());
                List valueParameters = javaMethod.getValueParameters();
                for (int i = 0; i < valueParameters.size(); ++i) {
                    paramNames.add("arg" + i);
                }
            }
            ArrayList<String> defaultValues = null;
            if (javaMethod.getAnnotationParameterDefaultValue() != null && javaMethod.getAnnotationParameterDefaultValue().getName() != null) {
                defaultValues = new ArrayList<String>();
                defaultValues.add(javaMethod.getAnnotationParameterDefaultValue().getName().asString());
            }
            JavaType.Method method = new JavaType.Method(null, javaMethod instanceof BinaryJavaMethod ? (long)((BinaryJavaMethod)javaMethod).getAccess() : this.convertToFlagsBitMap(javaMethod.getVisibility(), javaMethod.isStatic(), javaMethod.isFinal(), javaMethod.isAbstract()), null, javaMethod.getName().asString(), null, paramNames, null, null, null, defaultValues);
            this.typeCache.put(signature, (Object)method);
            List exceptionTypes = null;
            JavaType.FullyQualified resolvedDeclaringType = declaringType;
            if (declaringType == null) {
                resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(javaMethod.getContainingClass()));
            }
            if (resolvedDeclaringType == null) {
                return null;
            }
            JavaType returnType = this.type(javaMethod.getReturnType());
            ArrayList<JavaType> parameterTypes = null;
            if (!javaMethod.getValueParameters().isEmpty()) {
                parameterTypes = new ArrayList<JavaType>(javaMethod.getValueParameters().size());
                for (JavaValueParameter parameterSymbol : javaMethod.getValueParameters()) {
                    JavaType javaType = this.type(parameterSymbol.getType());
                    parameterTypes.add(javaType);
                }
            }
            method.unsafeSet(resolvedDeclaringType, returnType, parameterTypes, exceptionTypes, this.listAnnotations(javaMethod.getAnnotations()));
            return method;
        }
        return null;
    }

    @Nullable
    public JavaType.Method methodConstructorSignature(@Nullable JavaConstructor constructor, @Nullable JavaType.FullyQualified declaringType) {
        if (constructor != null) {
            String signature = this.signatureBuilder.methodConstructorSignature(constructor);
            JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
            if (existing != null) {
                return existing;
            }
            ArrayList<String> paramNames = null;
            if (!constructor.getValueParameters().isEmpty()) {
                paramNames = new ArrayList<String>(constructor.getValueParameters().size());
                List valueParameters = constructor.getValueParameters();
                for (int i = 0; i < valueParameters.size(); ++i) {
                    paramNames.add("arg" + i);
                }
            }
            List defaultValues = null;
            JavaType.Method method = new JavaType.Method(null, constructor instanceof BinaryJavaConstructor ? (long)((BinaryJavaConstructor)constructor).getAccess() : this.convertToFlagsBitMap(constructor.getVisibility(), constructor.isStatic(), constructor.isFinal(), constructor.isAbstract()), null, "<constructor>", null, paramNames, null, null, null, defaultValues);
            this.typeCache.put(signature, (Object)method);
            List exceptionTypes = null;
            JavaType.FullyQualified resolvedDeclaringType = declaringType;
            if (declaringType == null) {
                resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(constructor.getContainingClass()));
            }
            if (resolvedDeclaringType == null) {
                return null;
            }
            ArrayList<JavaType> parameterTypes = null;
            if (!constructor.getValueParameters().isEmpty()) {
                parameterTypes = new ArrayList<JavaType>(constructor.getValueParameters().size());
                for (JavaValueParameter parameterSymbol : constructor.getValueParameters()) {
                    JavaType javaType = this.type(parameterSymbol.getType());
                    parameterTypes.add(javaType);
                }
            }
            method.unsafeSet(resolvedDeclaringType, (JavaType)resolvedDeclaringType, parameterTypes, exceptionTypes, this.listAnnotations(constructor.getAnnotations()));
            return method;
        }
        return null;
    }

    @Nullable
    public JavaType.Method methodInvocationType(@Nullable FirFunctionCall functionCall, @Nullable FirBasedSymbol<?> ownerSymbol) {
        Object s;
        if (functionCall == null || functionCall.getCalleeReference() instanceof FirErrorNamedReference) {
            return null;
        }
        String signature = this.signatureBuilder.methodSignature(functionCall, ownerSymbol);
        JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        FirBasedSymbol symbol = ((FirResolvedNamedReference)functionCall.getCalleeReference()).getResolvedSymbol();
        FirConstructor constructor = null;
        FirSimpleFunction simpleFunction = null;
        if (symbol instanceof FirConstructorSymbol) {
            constructor = (FirConstructor)symbol.getFir();
        } else {
            simpleFunction = (FirSimpleFunction)symbol.getFir();
        }
        ArrayList<String> paramNames = null;
        if (simpleFunction != null && !simpleFunction.getValueParameters().isEmpty()) {
            paramNames = new ArrayList<String>(simpleFunction.getValueParameters().size());
            for (FirValueParameter p : simpleFunction.getValueParameters()) {
                s = p.getName().asString();
                paramNames.add((String)s);
            }
        } else if (constructor != null && !constructor.getValueParameters().isEmpty()) {
            paramNames = new ArrayList(constructor.getValueParameters().size());
            for (FirValueParameter p : constructor.getValueParameters()) {
                s = p.getName().asString();
                paramNames.add((String)s);
            }
        }
        JavaType.Method method = new JavaType.Method(null, this.convertToFlagsBitMap(constructor != null ? constructor.getStatus() : simpleFunction.getStatus()), null, constructor != null ? "<constructor>" : simpleFunction.getName().asString(), null, paramNames, null, null, null, null);
        this.typeCache.put(signature, (Object)method);
        ArrayList<JavaType> parameterTypes = null;
        if (constructor != null && !constructor.getValueParameters().isEmpty()) {
            parameterTypes = new ArrayList<JavaType>(constructor.getValueParameters().size());
            for (FirValueParameter argtype : constructor.getValueParameters()) {
                if (argtype == null) continue;
                JavaType javaType = this.type(argtype);
                parameterTypes.add(javaType);
            }
        }
        JavaType resolvedDeclaringType = null;
        if (functionCall.getCalleeReference() instanceof FirResolvedNamedReference && ((FirResolvedNamedReference)functionCall.getCalleeReference()).getResolvedSymbol() instanceof FirNamedFunctionSymbol) {
            FirNamedFunctionSymbol resolvedSymbol = (FirNamedFunctionSymbol)((FirResolvedNamedReference)functionCall.getCalleeReference()).getResolvedSymbol();
            if (ClassMembersKt.containingClass((FirCallableSymbol)resolvedSymbol) != null) {
                FirRegularClassSymbol classSymbol;
                ConeClassLikeLookupTag lookupTag = ClassMembersKt.containingClass((FirCallableSymbol)resolvedSymbol);
                if (lookupTag != null && (classSymbol = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)lookupTag, (FirSession)this.firSession)) != null) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(classSymbol.getFir()));
                }
            } else if (resolvedSymbol.getOrigin() == FirDeclarationOrigin.Library.INSTANCE) {
                if (((FirSimpleFunction)resolvedSymbol.getFir()).getContainerSource() instanceof JvmPackagePartSource) {
                    JvmPackagePartSource source = (JvmPackagePartSource)((FirSimpleFunction)resolvedSymbol.getFir()).getContainerSource();
                    resolvedDeclaringType = source.getFacadeClassName() != null ? TypeUtils.asFullyQualified((JavaType)this.type(KotlinTypeSignatureBuilder.convertKotlinFqToJavaFq(source.getFacadeClassName().toString()))) : TypeUtils.asFullyQualified((JavaType)this.type(KotlinTypeSignatureBuilder.convertKotlinFqToJavaFq(source.getClassName().toString())));
                } else if (!(((FirSimpleFunction)resolvedSymbol.getFir()).getOrigin().getGenerated() || ((FirSimpleFunction)resolvedSymbol.getFir()).getOrigin().getFromSupertypes() || ((FirSimpleFunction)resolvedSymbol.getFir()).getOrigin().getFromSource())) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type("kotlin.Library"));
                }
            } else if (resolvedSymbol.getOrigin() == FirDeclarationOrigin.Source.INSTANCE && ownerSymbol != null) {
                if (ownerSymbol instanceof FirFileSymbol) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(((FirFileSymbol)ownerSymbol).getFir()));
                } else if (ownerSymbol instanceof FirNamedFunctionSymbol) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(((FirNamedFunctionSymbol)ownerSymbol).getFir()));
                } else if (ownerSymbol instanceof FirRegularClassSymbol) {
                    resolvedDeclaringType = TypeUtils.asFullyQualified((JavaType)this.type(((FirRegularClassSymbol)ownerSymbol).getFir()));
                }
            }
        }
        if (resolvedDeclaringType == null) {
            return null;
        }
        JavaType returnType = this.type(functionCall.getTypeRef(), ownerSymbol);
        method.unsafeSet((JavaType.FullyQualified)resolvedDeclaringType, constructor != null ? resolvedDeclaringType : returnType, parameterTypes, null, this.listAnnotations(constructor != null ? constructor.getAnnotations() : simpleFunction.getAnnotations()));
        return method;
    }

    @Nullable
    public JavaType.Variable variableType(@Nullable FirVariableSymbol<? extends FirVariable> symbol, @Nullable JavaType.FullyQualified owner, @Nullable FirBasedSymbol<?> ownerFallBack) {
        if (symbol == null) {
            return null;
        }
        String signature = this.signatureBuilder.variableSignature(symbol, ownerFallBack);
        JavaType.Variable existing = (JavaType.Variable)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        JavaType.Variable variable = new JavaType.Variable(null, this.convertToFlagsBitMap(symbol.getRawStatus()), symbol.getName().asString(), null, null, null);
        this.typeCache.put(signature, (Object)variable);
        List<JavaType.FullyQualified> annotations = this.listAnnotations(symbol.getAnnotations());
        JavaType.FullyQualified resolvedOwner = owner;
        if (owner == null && ownerFallBack != null) {
            resolvedOwner = this.type(ownerFallBack.getFir());
        }
        if (resolvedOwner == null) {
            resolvedOwner = JavaType.Unknown.getInstance();
        }
        FirTypeRef typeRef = symbol.getFir() instanceof FirJavaField || symbol.getFir() instanceof FirEnumEntry ? ((FirVariable)symbol.getFir()).getReturnTypeRef() : symbol.getResolvedReturnTypeRef();
        variable.unsafeSet((JavaType)resolvedOwner, this.type(typeRef), annotations);
        return variable;
    }

    @Nullable
    public JavaType.Variable variableType(JavaField javaField, @Nullable JavaType.FullyQualified owner) {
        String signature = this.signatureBuilder.variableSignature(javaField);
        JavaType.Variable existing = (JavaType.Variable)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        JavaType.Variable variable = new JavaType.Variable(null, this.convertToFlagsBitMap(javaField.getVisibility(), javaField.isStatic(), javaField.isFinal(), javaField.isAbstract()), javaField.getName().asString(), null, null, null);
        this.typeCache.put(signature, (Object)variable);
        JavaType.FullyQualified resolvedOwner = owner;
        if (owner == null) {
            resolvedOwner = TypeUtils.asFullyQualified((JavaType)this.type(javaField.getContainingClass()));
            assert (resolvedOwner != null);
        }
        variable.unsafeSet((JavaType)resolvedOwner, this.type(javaField.getType()), this.listAnnotations(javaField.getAnnotations()));
        return variable;
    }

    public JavaType.Primitive primitive(ConeClassLikeType type) {
        ClassId classId = type.getLookupTag().getClassId();
        if (StandardClassIds.INSTANCE.getByte().equals((Object)classId)) {
            return JavaType.Primitive.Byte;
        }
        if (StandardClassIds.INSTANCE.getBoolean().equals((Object)classId)) {
            return JavaType.Primitive.Boolean;
        }
        if (StandardClassIds.INSTANCE.getChar().equals((Object)classId)) {
            return JavaType.Primitive.Char;
        }
        if (StandardClassIds.INSTANCE.getDouble().equals((Object)classId)) {
            return JavaType.Primitive.Double;
        }
        if (StandardClassIds.INSTANCE.getFloat().equals((Object)classId)) {
            return JavaType.Primitive.Float;
        }
        if (StandardClassIds.INSTANCE.getInt().equals((Object)classId)) {
            return JavaType.Primitive.Int;
        }
        if (StandardClassIds.INSTANCE.getLong().equals((Object)classId)) {
            return JavaType.Primitive.Long;
        }
        if (StandardClassIds.INSTANCE.getShort().equals((Object)classId)) {
            return JavaType.Primitive.Short;
        }
        if (StandardClassIds.INSTANCE.getString().equals((Object)classId)) {
            return JavaType.Primitive.String;
        }
        if (StandardClassIds.INSTANCE.getUnit().equals((Object)classId)) {
            return JavaType.Primitive.Void;
        }
        if (StandardClassIds.INSTANCE.getNothing().equals((Object)classId)) {
            return JavaType.Primitive.Null;
        }
        throw new IllegalArgumentException("Unsupported primitive type " + type);
    }

    private JavaType.Primitive primitive(@Nullable PrimitiveType primitiveType) {
        if (primitiveType == null) {
            return JavaType.Primitive.Void;
        }
        switch (primitiveType) {
            case BOOLEAN: {
                return JavaType.Primitive.Boolean;
            }
            case BYTE: {
                return JavaType.Primitive.Byte;
            }
            case CHAR: {
                return JavaType.Primitive.Char;
            }
            case DOUBLE: {
                return JavaType.Primitive.Double;
            }
            case FLOAT: {
                return JavaType.Primitive.Float;
            }
            case INT: {
                return JavaType.Primitive.Int;
            }
            case LONG: {
                return JavaType.Primitive.Long;
            }
            case SHORT: {
                return JavaType.Primitive.Short;
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type.");
    }

    private JavaType resolveConeTypeProjection(ConeTypeProjection type, String signature, @Nullable FirBasedSymbol<?> ownerSymbol) {
        boolean isGeneric;
        JavaType.Unknown resolvedType = JavaType.Unknown.getInstance();
        boolean bl = isGeneric = type instanceof ConeKotlinTypeProjectionIn || type instanceof ConeKotlinTypeProjectionOut || type instanceof ConeStarProjection || type instanceof ConeTypeParameterType;
        if (isGeneric) {
            JavaType.GenericTypeVariable.Variance variance = JavaType.GenericTypeVariable.Variance.INVARIANT;
            ArrayList<JavaType.Unknown> bounds = null;
            String name = type instanceof ConeKotlinTypeProjectionIn || type instanceof ConeKotlinTypeProjectionOut ? "" : (type instanceof ConeStarProjection ? "*" : type.toString());
            JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, name, JavaType.GenericTypeVariable.Variance.INVARIANT, null);
            this.typeCache.put(signature, (Object)gtv);
            if (type instanceof ConeKotlinTypeProjectionIn) {
                ConeKotlinTypeProjectionIn in = (ConeKotlinTypeProjectionIn)type;
                variance = JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
                FirRegularClassSymbol classSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)in.getType(), (FirSession)this.firSession);
                bounds = new ArrayList<JavaType.Unknown>(1);
                bounds.add((JavaType.Unknown)(classSymbol != null ? this.type(classSymbol.getFir()) : JavaType.Unknown.getInstance()));
            } else if (type instanceof ConeKotlinTypeProjectionOut) {
                ConeKotlinTypeProjectionOut out = (ConeKotlinTypeProjectionOut)type;
                variance = JavaType.GenericTypeVariable.Variance.COVARIANT;
                FirRegularClassSymbol classSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)out.getType(), (FirSession)this.firSession);
                bounds = new ArrayList(1);
                bounds.add((JavaType.Unknown)(classSymbol != null ? this.type(classSymbol.getFir()) : JavaType.Unknown.getInstance()));
            }
            gtv.unsafeSet(name, variance, bounds);
            resolvedType = gtv;
        } else if (type instanceof ConeClassLikeType) {
            resolvedType = this.resolveConeLikeClassType((ConeClassLikeType)type, signature, ownerSymbol);
        } else if (type instanceof ConeFlexibleType) {
            resolvedType = this.type(((ConeFlexibleType)type).getLowerBound());
        }
        return resolvedType;
    }

    private JavaType resolveConeLikeClassType(ConeClassLikeType coneClassLikeType, String signature, @Nullable FirBasedSymbol<?> ownerSymbol) {
        FirRegularClassSymbol classSymbol = TypeUtilsKt.toRegularClassSymbol((ConeClassLikeType)coneClassLikeType, (FirSession)this.firSession);
        if (classSymbol == null) {
            this.typeCache.put(signature, (Object)JavaType.Unknown.getInstance());
            return JavaType.Unknown.getInstance();
        }
        return this.type(classSymbol.getFir(), ownerSymbol);
    }

    private JavaType resolveConeTypeProjection(FirTypeParameter typeParameter, String signature) {
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, typeParameter.getName().asString(), JavaType.GenericTypeVariable.Variance.INVARIANT, null);
        this.typeCache.put(signature, (Object)gtv);
        ArrayList<JavaType> bounds = null;
        JavaType.GenericTypeVariable.Variance variance = JavaType.GenericTypeVariable.Variance.INVARIANT;
        if (typeParameter.getBounds().size() != 1 || !(typeParameter.getBounds().get(0) instanceof FirImplicitNullableAnyTypeRef)) {
            bounds = new ArrayList<JavaType>(typeParameter.getBounds().size());
            for (FirTypeRef bound : typeParameter.getBounds()) {
                bounds.add(this.type(bound));
            }
            if ("out".equals(typeParameter.getVariance().getLabel())) {
                variance = JavaType.GenericTypeVariable.Variance.COVARIANT;
            } else if ("in".equals(typeParameter.getVariance().getLabel())) {
                variance = JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
            }
        }
        gtv.unsafeSet(gtv.getName(), variance, bounds);
        return gtv;
    }

    private long convertToFlagsBitMap(FirDeclarationStatus status) {
        long bitMask = 0L;
        Visibility visibility = status.getVisibility();
        switch (visibility.getName()) {
            case "public": {
                ++bitMask;
                break;
            }
            case "private": {
                bitMask += 2L;
                break;
            }
            case "protected": {
                bitMask += 4L;
                break;
            }
            case "internal": {
                break;
            }
        }
        Modality modality = status.getModality();
        if (Modality.FINAL == modality) {
            bitMask += 16L;
        } else if (Modality.ABSTRACT == modality) {
            bitMask += 1024L;
        }
        if (status.isStatic()) {
            bitMask += 8L;
        }
        return bitMask;
    }

    private long convertToFlagsBitMap(Visibility visibility, boolean isStatic, boolean isFinal, boolean isAbstract) {
        long bitMask = 0L;
        switch (visibility.getName()) {
            case "public": {
                ++bitMask;
                break;
            }
            case "private": {
                bitMask += 2L;
                break;
            }
            case "protected": {
                bitMask += 4L;
                break;
            }
            case "internal": {
                break;
            }
        }
        if (isStatic) {
            bitMask += 8L;
        }
        if (isFinal) {
            bitMask += 16L;
        }
        if (isAbstract) {
            bitMask += 1024L;
        }
        return bitMask;
    }

    private JavaType.FullyQualified.Kind convertToClassKind(ClassKind classKind) {
        JavaType.FullyQualified.Kind kind;
        if (ClassKind.CLASS == classKind) {
            kind = JavaType.FullyQualified.Kind.Class;
        } else if (ClassKind.ANNOTATION_CLASS == classKind) {
            kind = JavaType.FullyQualified.Kind.Annotation;
        } else if (ClassKind.ENUM_CLASS == classKind) {
            kind = JavaType.FullyQualified.Kind.Enum;
        } else if (ClassKind.INTERFACE == classKind) {
            kind = JavaType.FullyQualified.Kind.Interface;
        } else if (ClassKind.OBJECT == classKind) {
            kind = JavaType.FullyQualified.Kind.Class;
        } else {
            throw new IllegalArgumentException("Unsupported classKind: " + classKind.name());
        }
        return kind;
    }

    private JavaType.FullyQualified.Kind convertToClassKind(BinaryJavaClass clazz) {
        if (clazz.isEnum()) {
            return JavaType.FullyQualified.Kind.Enum;
        }
        if (clazz.isInterface()) {
            return JavaType.FullyQualified.Kind.Interface;
        }
        return JavaType.FullyQualified.Kind.Class;
    }

    private JavaType mapJavaElementType(JavaElement type, String signature) {
        JavaClass c;
        if (type instanceof BinaryJavaClass) {
            return this.classType((BinaryJavaClass)type, signature);
        }
        if (type instanceof JavaTypeParameter) {
            return this.mapJavaTypeParameter((JavaTypeParameter)type, signature);
        }
        if (type instanceof JavaValueParameter) {
            return this.mapJavaValueParameter((JavaValueParameter)type);
        }
        if (type instanceof JavaAnnotation && ((JavaAnnotation)type).getClassId() != null && (c = ((JavaAnnotation)type).resolve()) != null) {
            return this.type(c);
        }
        return JavaType.Unknown.getInstance();
    }

    private JavaType mapJavaType(org.jetbrains.kotlin.load.java.structure.JavaType type, String signature) {
        if (type instanceof JavaPrimitiveType) {
            return this.primitive(((JavaPrimitiveType)type).getType());
        }
        if (type instanceof JavaClassifierType) {
            return this.mapClassifierType((JavaClassifierType)type, signature);
        }
        if (type instanceof JavaArrayType) {
            return this.array((JavaArrayType)type, signature);
        }
        if (type instanceof JavaWildcardType) {
            return this.mapWildcardType((JavaWildcardType)type, signature);
        }
        return JavaType.Unknown.getInstance();
    }

    private JavaType mapClassifierType(JavaClassifierType type, String signature) {
        JavaType javaType = this.type(type.getClassifier());
        if (!type.getTypeArguments().isEmpty()) {
            JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)javaType);
            fq = fq instanceof JavaType.Parameterized ? ((JavaType.Parameterized)fq).getType() : fq;
            JavaType.Parameterized pt = (JavaType.Parameterized)this.typeCache.get(signature);
            if (pt == null) {
                pt = new JavaType.Parameterized(null, null, null);
                this.typeCache.put(signature, (Object)pt);
                ArrayList<JavaType> typeParameters = new ArrayList<JavaType>(type.getTypeArguments().size());
                for (org.jetbrains.kotlin.load.java.structure.JavaType typeArgument : type.getTypeArguments()) {
                    typeParameters.add(this.type(typeArgument));
                }
                pt.unsafeSet(fq, typeParameters);
            }
            return pt;
        }
        return javaType;
    }

    private JavaType mapJavaTypeParameter(JavaTypeParameter type, String signature) {
        String name = type.getName().asString();
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, name, JavaType.GenericTypeVariable.Variance.INVARIANT, null);
        this.typeCache.put(signature, (Object)gtv);
        List<Object> bounds = null;
        if (type.getUpperBounds().size() == 1) {
            JavaType mappedBound = this.type(type.getUpperBounds().toArray()[0]);
            if (!(mappedBound instanceof JavaType.FullyQualified) || !"java.lang.Object".equals(((JavaType.FullyQualified)mappedBound).getFullyQualifiedName())) {
                bounds = Collections.singletonList(mappedBound);
            }
        } else {
            bounds = new ArrayList(type.getUpperBounds().size());
            for (org.jetbrains.kotlin.load.java.structure.JavaType bound : type.getUpperBounds()) {
                bounds.add(this.type(bound));
            }
        }
        gtv.unsafeSet(gtv.getName(), bounds == null ? JavaType.GenericTypeVariable.Variance.INVARIANT : JavaType.GenericTypeVariable.Variance.COVARIANT, bounds);
        return gtv;
    }

    private JavaType mapJavaValueParameter(JavaValueParameter type) {
        return this.type(type.getType());
    }

    private JavaType mapWildcardType(JavaWildcardType wildcardType, String signature) {
        List<JavaType> bounds;
        JavaType.GenericTypeVariable.Variance variance;
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, "?", JavaType.GenericTypeVariable.Variance.INVARIANT, null);
        this.typeCache.put(signature, (Object)gtv);
        if (wildcardType.getBound() != null) {
            variance = wildcardType.isExtends() ? JavaType.GenericTypeVariable.Variance.COVARIANT : JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
            bounds = Collections.singletonList(this.type(wildcardType.getBound()));
        } else {
            variance = JavaType.GenericTypeVariable.Variance.INVARIANT;
            bounds = null;
        }
        if (bounds != null && bounds.get(0) instanceof JavaType.FullyQualified && "java.lang.Object".equals(((JavaType.FullyQualified)bounds.get(0)).getFullyQualifiedName())) {
            bounds = null;
        }
        gtv.unsafeSet(gtv.getName(), variance, bounds);
        return gtv;
    }

    private List<JavaType.FullyQualified> listAnnotations(List<FirAnnotation> firAnnotations) {
        ArrayList<JavaType.FullyQualified> annotations = new ArrayList<JavaType.FullyQualified>(firAnnotations.size());
        for (FirAnnotation firAnnotation : firAnnotations) {
            JavaType.FullyQualified fq;
            FirRegularClassSymbol symbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)firAnnotation.getTypeRef()), (FirSession)this.firSession);
            if (this.skipAnnotation((FirClassLikeSymbol<?>)symbol) || (fq = TypeUtils.asFullyQualified((JavaType)this.type(firAnnotation.getTypeRef()))) == null) continue;
            annotations.add(fq);
        }
        return annotations;
    }

    private List<JavaType.FullyQualified> listAnnotations(Collection<JavaAnnotation> javaAnnotations) {
        ArrayList<JavaType.FullyQualified> annotations = new ArrayList<JavaType.FullyQualified>(javaAnnotations.size());
        for (JavaAnnotation javaAnnotation : javaAnnotations) {
            JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)this.type(javaAnnotation));
            if (fq == null) continue;
            annotations.add((JavaType.FullyQualified)this.type(javaAnnotation));
        }
        return annotations;
    }

    private boolean skipAnnotation(@Nullable FirClassLikeSymbol<?> symbol) {
        if (symbol != null) {
            for (FirAnnotation annotation : symbol.getAnnotations()) {
                if (!(annotation instanceof FirAnnotationCall) || ((FirAnnotationCall)annotation).getArgumentList().getArguments().isEmpty()) continue;
                for (FirExpression argument : ((FirAnnotationCall)annotation).getArgumentList().getArguments()) {
                    FirEnumEntrySymbol enumEntrySymbol;
                    FirPropertyAccessExpression accessExpression;
                    FirBasedSymbol callRefSymbol;
                    if (!(argument instanceof FirPropertyAccessExpression) || !((callRefSymbol = ((FirResolvedNamedReference)(accessExpression = (FirPropertyAccessExpression)argument).getCalleeReference()).getResolvedSymbol()) instanceof FirEnumEntrySymbol) || !"kotlin.annotation.AnnotationRetention$SOURCE".equals(KotlinTypeSignatureBuilder.convertKotlinFqToJavaFq((enumEntrySymbol = (FirEnumEntrySymbol)callRefSymbol).getCallableId().toString()))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

