/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.kotlin.marker.AnnotationCallSite;
import org.openrewrite.kotlin.marker.By;
import org.openrewrite.kotlin.marker.CheckNotNull;
import org.openrewrite.kotlin.marker.ExplicitInlineConstructor;
import org.openrewrite.kotlin.marker.Implicit;
import org.openrewrite.kotlin.marker.IsNullable;
import org.openrewrite.kotlin.marker.KObject;
import org.openrewrite.kotlin.marker.LogicalComma;
import org.openrewrite.kotlin.marker.Modifier;
import org.openrewrite.kotlin.marker.NotIs;
import org.openrewrite.kotlin.marker.OmitBraces;
import org.openrewrite.kotlin.marker.OmitEquals;
import org.openrewrite.kotlin.marker.ReceiverType;
import org.openrewrite.kotlin.marker.Reified;
import org.openrewrite.kotlin.marker.Semicolon;
import org.openrewrite.kotlin.marker.SingleExpressionBlock;
import org.openrewrite.kotlin.marker.SpreadArgument;
import org.openrewrite.kotlin.marker.TrailingLambdaArgument;
import org.openrewrite.kotlin.marker.TypeReferencePrefix;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.kotlin.tree.KContainer;
import org.openrewrite.kotlin.tree.KRightPadded;
import org.openrewrite.kotlin.tree.KSpace;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class KotlinPrinter<P>
extends KotlinVisitor<PrintOutputCapture<P>> {
    private final KotlinJavaPrinter delegate = new KotlinJavaPrinter();
    private static final UnaryOperator<String> JAVA_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
        if (!(tree instanceof K)) {
            return this.delegate.visit(tree, p);
        }
        return (J)super.visit(tree, p);
    }

    @Override
    public J visitCompilationUnit(K.CompilationUnit sourceFile, PrintOutputCapture<P> p) {
        K.CompilationUnit cu = sourceFile;
        this.beforeSyntax((K)cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visit(sourceFile.getAnnotations(), p);
        JRightPadded<J.Package> pkg = cu.getPadding().getPackageDeclaration();
        if (pkg != null) {
            this.visit((Tree)pkg.getElement(), p);
            this.visitSpace(pkg.getAfter(), Space.Location.PACKAGE_SUFFIX, p);
        }
        for (JRightPadded<J.Import> jRightPadded : cu.getPadding().getImports()) {
            this.visitRightPadded(jRightPadded, KRightPadded.Location.TOP_LEVEL_STATEMENT_SUFFIX, p);
        }
        for (JRightPadded<J.Import> jRightPadded : cu.getPadding().getStatements()) {
            this.visitRightPadded(jRightPadded, KRightPadded.Location.TOP_LEVEL_STATEMENT_SUFFIX, p);
        }
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        this.afterSyntax(cu, p);
        return cu;
    }

    @Override
    public J visitBinary(K.Binary binary, PrintOutputCapture<P> p) {
        String keyword = "";
        switch (binary.getOperator()) {
            case Contains: {
                keyword = "in";
                break;
            }
            case IdentityEquals: {
                keyword = "===";
                break;
            }
            case IdentityNotEquals: {
                keyword = "!==";
                break;
            }
            case RangeTo: {
                keyword = "..";
            }
        }
        this.beforeSyntax((K)binary, KSpace.Location.BINARY_PREFIX, p);
        this.visit((Tree)binary.getLeft(), p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), KSpace.Location.BINARY_OPERATOR, p);
        p.append(keyword);
        if (binary.getOperator() == K.Binary.Type.Get) {
            p.append("[");
        }
        this.visit((Tree)binary.getRight(), p);
        this.afterSyntax(binary, p);
        this.visitSpace(binary.getAfter(), KSpace.Location.BINARY_SUFFIX, p);
        if (binary.getOperator() == K.Binary.Type.Get) {
            p.append("]");
        }
        return binary;
    }

    @Override
    public J visitFunctionType(K.FunctionType functionType, PrintOutputCapture<P> p) {
        if (functionType.getSuspendModifier() != null) {
            this.visitAnnotation(functionType.getSuspendModifier(), p);
        }
        if (functionType.getReceiver() != null) {
            this.visitRightPadded(functionType.getReceiver(), KRightPadded.Location.FUNCTION_TYPE_RECEIVER, p);
            p.append(".");
        }
        this.visit((Tree)functionType.getTypedTree(), p);
        return functionType;
    }

    @Override
    public J visitKReturn(K.KReturn kReturn, PrintOutputCapture<P> p) {
        this.visit((Tree)kReturn.getExpression(), p);
        if (kReturn.getLabel() != null) {
            p.append("@");
            this.visit((Tree)kReturn.getLabel(), p);
        }
        return kReturn;
    }

    @Override
    public J visitKString(K.KString kString, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)kString, KSpace.Location.KSTRING_PREFIX, p);
        String delimiter = kString.getDelimiter();
        p.append(delimiter);
        this.visit(kString.getStrings(), p);
        p.append(delimiter);
        this.afterSyntax(kString, p);
        return kString;
    }

    @Override
    public J visitKThis(K.KThis kThis, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)kThis, KSpace.Location.KTHIS_PREFIX, p);
        p.append("this");
        if (kThis.getLabel() != null) {
            p.append("@");
            this.visit((Tree)kThis.getLabel(), p);
        }
        this.afterSyntax(kThis, p);
        return kThis;
    }

    @Override
    public J visitKStringValue(K.KString.Value value, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)value, KSpace.Location.KSTRING_PREFIX, p);
        if (value.isEnclosedInBraces()) {
            p.append("${");
        } else {
            p.append("$");
        }
        this.visit((Tree)value.getTree(), p);
        if (value.isEnclosedInBraces()) {
            p.append('}');
        }
        this.afterSyntax(value, p);
        return value;
    }

    @Override
    public J visitListLiteral(K.ListLiteral listLiteral, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)listLiteral, KSpace.Location.LIST_LITERAL_PREFIX, p);
        this.visitContainer("[", listLiteral.getPadding().getElements(), KContainer.Location.LIST_LITERAL_ELEMENTS, ",", "]", p);
        this.afterSyntax(listLiteral, p);
        return listLiteral;
    }

    @Override
    public J visitWhen(K.When when, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)when, KSpace.Location.WHEN_PREFIX, p);
        p.append("when");
        this.visit((Tree)when.getSelector(), p);
        this.visit((Tree)when.getBranches(), p);
        this.afterSyntax(when, p);
        return when;
    }

    @Override
    public J visitWhenBranch(K.WhenBranch whenBranch, PrintOutputCapture<P> p) {
        this.beforeSyntax((K)whenBranch, KSpace.Location.WHEN_BRANCH_PREFIX, p);
        this.visitContainer("", whenBranch.getPadding().getExpressions(), KContainer.Location.WHEN_BRANCH_EXPRESSION, ",", "->", p);
        this.visit((Tree)whenBranch.getBody(), p);
        return whenBranch;
    }

    @Override
    public Space visitSpace(Space space, KSpace.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, loc, p);
    }

    protected void visitContainer(String before, @Nullable JContainer<? extends J> container, KContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        p.append(after == null ? "" : after);
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, KRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        return this.delegate.visitMarker(marker, p);
    }

    private void beforeSyntax(K k, KSpace.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(k.getPrefix(), k.getMarkers(), loc, p);
    }

    private void beforeSyntax(J j, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable KSpace.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void beforeSyntax(K k, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(k.getPrefix(), k.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(J j, PrintOutputCapture<P> p) {
        this.afterSyntax(j.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private class KotlinJavaPrinter
    extends JavaPrinter<P> {
        private KotlinJavaPrinter() {
        }

        public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
            if (tree instanceof K) {
                return KotlinPrinter.this.visit(tree, p);
            }
            return (J)super.visit(tree, p);
        }

        public J visitAnnotation(J.Annotation annotation, PrintOutputCapture<P> p) {
            AnnotationCallSite callSite;
            this.beforeSyntax((J)annotation, Space.Location.ANNOTATION_PREFIX, p);
            boolean isKModifier = annotation.getMarkers().findFirst(Modifier.class).isPresent();
            if (!isKModifier) {
                p.append("@");
            }
            if ((callSite = (AnnotationCallSite)annotation.getMarkers().findFirst(AnnotationCallSite.class).orElse(null)) != null) {
                p.append(callSite.getName());
                KotlinPrinter.this.visitSpace(callSite.getSuffix(), KSpace.Location.FILE_ANNOTATION_SUFFIX, p);
                p.append(":");
            }
            this.visit((Tree)annotation.getAnnotationType(), p);
            if (!isKModifier) {
                this.visitContainer("(", (JContainer<? extends J>)annotation.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, ",", ")", p);
            }
            this.afterSyntax((J)annotation, p);
            return annotation;
        }

        public J visitBinary(J.Binary binary, PrintOutputCapture<P> p) {
            String keyword = "";
            switch (binary.getOperator()) {
                case Addition: {
                    keyword = "+";
                    break;
                }
                case Subtraction: {
                    keyword = "-";
                    break;
                }
                case Multiplication: {
                    keyword = "*";
                    break;
                }
                case Division: {
                    keyword = "/";
                    break;
                }
                case Modulo: {
                    keyword = "%";
                    break;
                }
                case LessThan: {
                    keyword = "<";
                    break;
                }
                case GreaterThan: {
                    keyword = ">";
                    break;
                }
                case LessThanOrEqual: {
                    keyword = "<=";
                    break;
                }
                case GreaterThanOrEqual: {
                    keyword = ">=";
                    break;
                }
                case Equal: {
                    keyword = "==";
                    break;
                }
                case NotEqual: {
                    keyword = "!=";
                    break;
                }
                case BitAnd: {
                    keyword = "&";
                    break;
                }
                case BitOr: {
                    keyword = "|";
                    break;
                }
                case BitXor: {
                    keyword = "^";
                    break;
                }
                case LeftShift: {
                    keyword = "<<";
                    break;
                }
                case RightShift: {
                    keyword = ">>";
                    break;
                }
                case UnsignedRightShift: {
                    keyword = ">>>";
                    break;
                }
                case Or: {
                    keyword = binary.getMarkers().findFirst(LogicalComma.class).isPresent() ? "," : "||";
                    break;
                }
                case And: {
                    keyword = "&&";
                }
            }
            this.beforeSyntax((J)binary, Space.Location.BINARY_PREFIX, p);
            this.visit((Tree)binary.getLeft(), p);
            this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
            p.append(keyword);
            this.visit((Tree)binary.getRight(), p);
            this.afterSyntax((J)binary, p);
            return binary;
        }

        public J visitBlock(J.Block block, PrintOutputCapture<P> p) {
            boolean omitParens;
            boolean singleExpressionBlock;
            this.beforeSyntax((J)block, Space.Location.BLOCK_PREFIX, p);
            if (block.isStatic()) {
                p.append("init");
                this.visitRightPadded(block.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, p);
            }
            if (singleExpressionBlock = block.getMarkers().findFirst(SingleExpressionBlock.class).isPresent()) {
                p.append("=");
            }
            if (!(omitParens = block.getMarkers().findFirst(OmitBraces.class).isPresent())) {
                p.append("{");
            }
            this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
            this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
            if (!omitParens) {
                p.append("}");
            }
            this.afterSyntax((J)block, p);
            return block;
        }

        public J visitBreak(J.Break breakStatement, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)breakStatement, Space.Location.BREAK_PREFIX, p);
            p.append("break");
            if (breakStatement.getLabel() != null) {
                p.append("@");
            }
            this.visit((Tree)breakStatement.getLabel(), p);
            this.afterSyntax((J)breakStatement, p);
            return breakStatement;
        }

        public J visitClassDeclaration(J.ClassDeclaration classDecl, PrintOutputCapture<P> p) {
            String kind;
            if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Class || classDecl.getKind() == J.ClassDeclaration.Kind.Type.Enum || classDecl.getKind() == J.ClassDeclaration.Kind.Type.Annotation) {
                kind = "class";
            } else if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
                kind = "interface";
            } else {
                throw new IllegalStateException("Implement me.");
            }
            this.beforeSyntax((J)classDecl, Space.Location.CLASS_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            classDecl.getLeadingAnnotations().forEach(a -> {
                if (!a.getMarkers().findFirst(ExplicitInlineConstructor.class).isPresent()) {
                    this.visit((Tree)a, p);
                }
            });
            for (J.Modifier m : classDecl.getModifiers()) {
                this.visitModifier(m, p);
            }
            this.visit(classDecl.getAnnotations().getKind().getAnnotations(), p);
            this.visitSpace(classDecl.getAnnotations().getKind().getPrefix(), Space.Location.CLASS_KIND, p);
            KObject KObject2 = classDecl.getMarkers().findFirst(KObject.class).orElse(null);
            if (KObject2 != null) {
                p.append("object");
                if (classDecl.getLeadingAnnotations().stream().noneMatch(a -> a.getAnnotationType() instanceof J.Identifier && "companion".equals(((J.Identifier)a.getAnnotationType()).getSimpleName()))) {
                    this.visit((Tree)classDecl.getName(), p);
                }
            } else {
                p.append(kind);
                this.visit((Tree)classDecl.getName(), p);
            }
            classDecl.getLeadingAnnotations().forEach(a -> {
                if (a.getMarkers().findFirst(ExplicitInlineConstructor.class).isPresent()) {
                    this.visit((Tree)a, p);
                }
            });
            this.visitContainer("<", (JContainer<? extends J>)classDecl.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            if (classDecl.getPrimaryConstructor() != null) {
                this.visitContainer("(", (JContainer<? extends J>)classDecl.getPadding().getPrimaryConstructor(), JContainer.Location.RECORD_STATE_VECTOR, ",", ")", p);
            }
            if (classDecl.getImplements() != null) {
                this.visitContainer(":", (JContainer<? extends J>)classDecl.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, ",", null, p);
            }
            if (!classDecl.getBody().getMarkers().findFirst(OmitBraces.class).isPresent()) {
                this.visit((Tree)classDecl.getBody(), p);
            }
            this.afterSyntax((J)classDecl, p);
            return classDecl;
        }

        public J visitContinue(J.Continue continueStatement, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)continueStatement, Space.Location.CONTINUE_PREFIX, p);
            p.append("continue");
            if (continueStatement.getLabel() != null) {
                p.append("@");
            }
            this.visit((Tree)continueStatement.getLabel(), p);
            this.afterSyntax((J)continueStatement, p);
            return continueStatement;
        }

        public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)fieldAccess, Space.Location.FIELD_ACCESS_PREFIX, p);
            this.visit((Tree)fieldAccess.getTarget(), p);
            String prefix = fieldAccess.getMarkers().findFirst(IsNullable.class).isPresent() ? "?." : ".";
            this.visitLeftPadded(prefix, fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
            this.afterSyntax((J)fieldAccess, p);
            return fieldAccess;
        }

        public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
            p.append("for");
            J.ForEachLoop.Control ctrl = forEachLoop.getControl();
            this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
            p.append('(');
            this.visitRightPadded(ctrl.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, "in", p);
            this.visitRightPadded(ctrl.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, "", p);
            p.append(')');
            this.visitStatement((JRightPadded<Statement>)forEachLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
            this.afterSyntax((J)forEachLoop, p);
            return forEachLoop;
        }

        public J visitIdentifier(J.Identifier ident, PrintOutputCapture<P> p) {
            CheckNotNull checkNotNull;
            this.beforeSyntax((J)ident, Space.Location.IDENTIFIER_PREFIX, p);
            p.append(ident.getSimpleName());
            IsNullable isNullable = ident.getMarkers().findFirst(IsNullable.class).orElse(null);
            if (isNullable != null) {
                KotlinPrinter.this.visitSpace(isNullable.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p);
                p.append("?");
            }
            if ((checkNotNull = (CheckNotNull)ident.getMarkers().findFirst(CheckNotNull.class).orElse(null)) != null) {
                KotlinPrinter.this.visitSpace(checkNotNull.getPrefix(), KSpace.Location.CHECK_NOT_NULL_PREFIX, p);
                p.append("!!");
            }
            this.afterSyntax((J)ident, p);
            return ident;
        }

        public J visitImport(J.Import import_, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)import_, Space.Location.IMPORT_PREFIX, p);
            p.append("import");
            if (import_.isStatic()) {
                J.FieldAccess qualid = import_.getQualid();
                this.visitSpace(qualid.getPrefix(), Space.Location.FIELD_ACCESS_PREFIX, p);
                if (qualid.getTarget() instanceof J.FieldAccess) {
                    this.visit((Tree)((J.FieldAccess)qualid.getTarget()).getTarget(), p);
                    p.append(".");
                } else {
                    this.visit((Tree)qualid.getTarget(), p);
                }
                this.visit((Tree)qualid.getName(), p);
            } else {
                this.visit((Tree)import_.getQualid(), p);
            }
            JLeftPadded alias = import_.getPadding().getAlias();
            if (alias != null) {
                this.visitSpace(alias.getBefore(), Space.Location.IMPORT_ALIAS_PREFIX, p);
                p.append("as");
                this.visit((Tree)alias.getElement(), p);
            }
            this.afterSyntax((J)import_, p);
            return import_;
        }

        public J visitInstanceOf(J.InstanceOf instanceOf, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)instanceOf, Space.Location.INSTANCEOF_PREFIX, p);
            String suffix = instanceOf.getMarkers().findFirst(NotIs.class).isPresent() ? "!is" : "is";
            this.visitRightPadded(instanceOf.getPadding().getExpr(), JRightPadded.Location.INSTANCEOF, suffix, p);
            this.visit((Tree)instanceOf.getClazz(), p);
            this.visit((Tree)instanceOf.getPattern(), p);
            this.afterSyntax((J)instanceOf, p);
            return instanceOf;
        }

        public J visitLabel(J.Label label, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)label, Space.Location.LABEL_PREFIX, p);
            this.visitRightPadded(label.getPadding().getLabel(), JRightPadded.Location.LABEL, "@", p);
            this.visit((Tree)label.getStatement(), p);
            this.afterSyntax((J)label, p);
            return label;
        }

        public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)lambda, Space.Location.LAMBDA_PREFIX, p);
            boolean omitBraces = lambda.getMarkers().findFirst(OmitBraces.class).isPresent();
            if (!omitBraces) {
                p.append('{');
            }
            this.visitLambdaParameters(lambda.getParameters(), p);
            if (!lambda.getParameters().getParameters().isEmpty()) {
                this.visitSpace(lambda.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
                p.append("->");
            }
            if (lambda.getBody() instanceof J.Block) {
                J.Block block = (J.Block)lambda.getBody();
                this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
                this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
            } else {
                this.visit((Tree)lambda.getBody(), p);
            }
            if (!omitBraces) {
                p.append('}');
            }
            this.afterSyntax((J)lambda, p);
            return lambda;
        }

        private void visitLambdaParameters(J.Lambda.Parameters parameters, PrintOutputCapture<P> p) {
            this.visitMarkers(parameters.getMarkers(), p);
            if (parameters.isParenthesized()) {
                this.visitSpace(parameters.getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
                p.append('(');
                this.visitRightPadded(parameters.getPadding().getParams(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
                p.append(')');
            } else {
                List params = parameters.getPadding().getParams();
                for (int i = 0; i < params.size(); ++i) {
                    JRightPadded param = (JRightPadded)params.get(i);
                    if (param.getElement() instanceof J.Lambda.Parameters) {
                        this.visitLambdaParameters((J.Lambda.Parameters)param.getElement(), p);
                        this.visitSpace(param.getAfter(), JRightPadded.Location.LAMBDA_PARAM.getAfterLocation(), p);
                        continue;
                    }
                    this.visit((Tree)param.getElement(), p);
                    this.visitSpace(param.getAfter(), JRightPadded.Location.LAMBDA_PARAM.getAfterLocation(), p);
                    this.visitMarkers(param.getMarkers(), p);
                    if (i >= params.size() - 1) continue;
                    p.append(',');
                }
            }
        }

        public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
            boolean hasReceiverType;
            if (method.getMarkers().findFirst(Implicit.class).isPresent()) {
                return method;
            }
            this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(method.getLeadingAnnotations(), p);
            for (J.Modifier m : method.getModifiers()) {
                this.visitModifier(m, p);
            }
            J.TypeParameters typeParameters = method.getAnnotations().getTypeParameters();
            if (typeParameters != null) {
                this.visit(typeParameters.getAnnotations(), p);
                this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
                this.visitMarkers(typeParameters.getMarkers(), p);
                p.append("<");
                this.visitRightPadded(typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
                p.append(">");
            }
            if (hasReceiverType = method.getMarkers().findFirst(ReceiverType.class).isPresent()) {
                J.VariableDeclarations infixReceiver = (J.VariableDeclarations)method.getParameters().get(0);
                JRightPadded receiver = (JRightPadded)infixReceiver.getPadding().getVariables().get(0);
                this.visitRightPadded(receiver, JRightPadded.Location.NAMED_VARIABLE, ".", p);
            }
            this.visit((Tree)method.getName(), p);
            JContainer params = method.getPadding().getParameters();
            this.beforeSyntax(params.getBefore(), params.getMarkers(), JContainer.Location.METHOD_DECLARATION_PARAMETERS.getBeforeLocation(), p);
            p.append("(");
            List elements = params.getPadding().getElements();
            for (int i = hasReceiverType ? 1 : 0; i < elements.size(); ++i) {
                JRightPadded element = (JRightPadded)elements.get(i);
                if (((Statement)element.getElement()).getMarkers().findFirst(Implicit.class).isPresent()) continue;
                String suffix = i == elements.size() - 1 ? "" : ",";
                this.visitRightPadded(element, JContainer.Location.METHOD_DECLARATION_PARAMETERS.getElementLocation(), suffix, p);
            }
            this.afterSyntax(params.getMarkers(), p);
            p.append(")");
            if (method.getReturnTypeExpression() != null) {
                TypeReferencePrefix typeReferencePrefix = method.getMarkers().findFirst(TypeReferencePrefix.class).orElse(null);
                if (typeReferencePrefix != null) {
                    KotlinPrinter.this.visitSpace(typeReferencePrefix.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p);
                    p.append(":");
                }
                this.visit((Tree)method.getReturnTypeExpression(), p);
            }
            this.visit((Tree)method.getBody(), p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            CheckNotNull checkNotNull;
            this.beforeSyntax((J)method, Space.Location.METHOD_INVOCATION_PREFIX, p);
            this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, p);
            if (method.getSelect() != null && !method.getMarkers().findFirst(ReceiverType.class).isPresent()) {
                if (method.getMarkers().findFirst(IsNullable.class).isPresent()) {
                    p.append("?");
                }
                p.append(".");
            }
            this.visit((Tree)method.getName(), p);
            this.visitContainer("<", (JContainer<? extends J>)method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            JContainer argContainer = method.getPadding().getArguments();
            this.visitSpace(argContainer.getBefore(), Space.Location.METHOD_INVOCATION_ARGUMENTS, p);
            List args = argContainer.getPadding().getElements();
            boolean omitParensOnMethod = method.getMarkers().findFirst(OmitParentheses.class).isPresent();
            boolean isTrailingLambda = !args.isEmpty() && ((Expression)((JRightPadded)args.get(args.size() - 1)).getElement()).getMarkers().findFirst(TrailingLambdaArgument.class).isPresent();
            for (int i = 0; i < args.size(); ++i) {
                JRightPadded arg = (JRightPadded)args.get(i);
                if (i == args.size() - 1 && isTrailingLambda) {
                    this.visitSpace(arg.getAfter(), JRightPadded.Location.METHOD_INVOCATION_ARGUMENT.getAfterLocation(), p);
                    p.append(")");
                    this.visit((Tree)arg.getElement(), p);
                    break;
                }
                if (i == 0 && !omitParensOnMethod) {
                    p.append('(');
                } else if (i > 0 && omitParensOnMethod && !((Expression)((JRightPadded)args.get(0)).getElement()).getMarkers().findFirst(OmitParentheses.class).isPresent() && !((Expression)((JRightPadded)args.get(0)).getElement()).getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                    p.append(')');
                } else if (i > 0) {
                    p.append(',');
                }
                SpreadArgument spread = ((Expression)arg.getElement()).getMarkers().findFirst(SpreadArgument.class).orElse(null);
                if (spread != null) {
                    KotlinPrinter.this.visitSpace(spread.getPrefix(), KSpace.Location.SPREAD_ARGUMENT_PREFIX, p);
                    p.append("*");
                }
                this.visitRightPadded(arg, JRightPadded.Location.METHOD_INVOCATION_ARGUMENT, p);
                if (i != args.size() - 1 || omitParensOnMethod) continue;
                p.append(')');
            }
            if ((checkNotNull = (CheckNotNull)method.getMarkers().findFirst(CheckNotNull.class).orElse(null)) != null) {
                KotlinPrinter.this.visitSpace(checkNotNull.getPrefix(), KSpace.Location.CHECK_NOT_NULL_PREFIX, p);
                p.append("!!");
            }
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitNewClass(J.NewClass newClass, PrintOutputCapture<P> p) {
            KObject kObject = newClass.getMarkers().findFirst(KObject.class).orElse(null);
            if (kObject != null) {
                KotlinPrinter.this.visitSpace(kObject.getPrefix(), KSpace.Location.OBJECT_PREFIX, p);
                p.append("object");
            }
            this.beforeSyntax((J)newClass, Space.Location.NEW_CLASS_PREFIX, p);
            if (kObject != null) {
                p.append(":");
            }
            this.visitRightPadded(newClass.getPadding().getEnclosing(), JRightPadded.Location.NEW_CLASS_ENCLOSING, ".", p);
            this.visitSpace(newClass.getNew(), Space.Location.NEW_PREFIX, p);
            this.visit((Tree)newClass.getClazz(), p);
            if (!newClass.getPadding().getArguments().getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                this.visitContainer("(", (JContainer<? extends J>)newClass.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, ",", ")", p);
            }
            this.visit((Tree)newClass.getBody(), p);
            this.afterSyntax((J)newClass, p);
            return newClass;
        }

        public J visitParameterizedType(J.ParameterizedType type, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)type, Space.Location.PARAMETERIZED_TYPE_PREFIX, p);
            this.visit((Tree)type.getClazz(), p);
            this.visitContainer("<", (JContainer<? extends J>)type.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            IsNullable isNullable = type.getMarkers().findFirst(IsNullable.class).orElse(null);
            if (isNullable != null) {
                KotlinPrinter.this.visitSpace(isNullable.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p);
                p.append("?");
            }
            this.afterSyntax((J)type, p);
            return type;
        }

        public J visitReturn(J.Return return_, PrintOutputCapture<P> p) {
            if (return_.getMarkers().findFirst(ImplicitReturn.class).isPresent()) {
                this.visitSpace(return_.getPrefix(), Space.Location.RETURN_PREFIX, p);
                this.visitMarkers(return_.getMarkers(), p);
                this.visit((Tree)return_.getExpression(), p);
                this.afterSyntax((J)return_, p);
                return return_;
            }
            return super.visitReturn(return_, p);
        }

        public J visitTernary(J.Ternary ternary, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)ternary, Space.Location.TERNARY_PREFIX, p);
            this.visitLeftPadded("", ternary.getPadding().getTruePart(), JLeftPadded.Location.TERNARY_TRUE, p);
            this.visitLeftPadded("?:", ternary.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p);
            this.afterSyntax((J)ternary, p);
            return ternary;
        }

        public J visitTypeCast(J.TypeCast typeCast, PrintOutputCapture<P> p) {
            boolean printParens;
            this.beforeSyntax((J)typeCast, Space.Location.TYPE_CAST_PREFIX, p);
            boolean bl = printParens = !typeCast.getMarkers().findFirst(OmitParentheses.class).isPresent();
            if (printParens) {
                p.append('(');
            }
            this.visit((Tree)typeCast.getExpression(), p);
            J.ControlParentheses controlParens = typeCast.getClazz();
            this.beforeSyntax((J)controlParens, Space.Location.CONTROL_PARENTHESES_PREFIX, p);
            String as = typeCast.getMarkers().findFirst(IsNullable.class).isPresent() ? "as?" : "as";
            p.append(as);
            this.visit((Tree)controlParens.getTree(), p);
            if (printParens) {
                p.append(')');
            }
            this.afterSyntax((J)typeCast, p);
            return typeCast;
        }

        public J visitTypeParameter(J.TypeParameter typeParam, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)typeParam, Space.Location.TYPE_PARAMETERS_PREFIX, p);
            this.visit(typeParam.getAnnotations(), p);
            this.visit((Tree)typeParam.getName(), p);
            this.visitContainer(":", (JContainer<? extends J>)typeParam.getPadding().getBounds(), JContainer.Location.TYPE_BOUNDS, "&", "", p);
            this.afterSyntax((J)typeParam, p);
            return typeParam;
        }

        public J visitWildcard(J.Wildcard wildcard, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)wildcard, Space.Location.WILDCARD_PREFIX, p);
            if (wildcard.getPadding().getBound() != null) {
                p.append(wildcard.getPadding().getBound().getElement() == J.Wildcard.Bound.Super ? "in" : "out");
            }
            if (wildcard.getBoundedType() == null) {
                p.append('*');
            } else {
                this.visit((Tree)wildcard.getBoundedType(), p);
            }
            this.afterSyntax((J)wildcard, p);
            return wildcard;
        }

        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
            Expression expression;
            if (multiVariable.getLeadingAnnotations().stream().anyMatch(it -> "typealias".equals(it.getSimpleName()))) {
                this.visitTypeAlias(multiVariable, p);
                return multiVariable;
            }
            this.beforeSyntax((J)multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(multiVariable.getLeadingAnnotations(), p);
            for (J.Modifier m : multiVariable.getModifiers()) {
                this.visitModifier(m, p);
            }
            boolean containsTypeReceiver = multiVariable.getMarkers().findFirst(ReceiverType.class).isPresent();
            if (containsTypeReceiver && (expression = ((J.VariableDeclarations.NamedVariable)multiVariable.getVariables().get(0)).getInitializer()) instanceof K.NamedVariableInitializer) {
                for (J init : ((K.NamedVariableInitializer)expression).getInitializations()) {
                    if (!(init instanceof J.MethodDeclaration) || !"get".equals(((J.MethodDeclaration)init).getSimpleName())) continue;
                    J.MethodDeclaration getter = (J.MethodDeclaration)init;
                    JRightPadded receiver = (JRightPadded)getter.getPadding().getParameters().getPadding().getElements().get(0);
                    this.visitRightPadded(receiver, JRightPadded.Location.NAMED_VARIABLE, p);
                    p.append(".");
                    break;
                }
            }
            List variables = multiVariable.getPadding().getVariables();
            for (int i = 0; i < variables.size(); ++i) {
                JRightPadded variable = (JRightPadded)variables.get(i);
                this.beforeSyntax((J)variable.getElement(), Space.Location.VARIABLE_PREFIX, p);
                if (variables.size() > 1 && !containsTypeReceiver && i == 0) {
                    p.append("(");
                }
                this.visit((Tree)((J.VariableDeclarations.NamedVariable)variable.getElement()).getName(), p);
                if (multiVariable.getTypeExpression() != null) {
                    TypeReferencePrefix typeReferencePrefix = multiVariable.getMarkers().findFirst(TypeReferencePrefix.class).orElse(null);
                    if (typeReferencePrefix != null) {
                        KotlinPrinter.this.visitSpace(typeReferencePrefix.getPrefix(), KSpace.Location.TYPE_REFERENCE_PREFIX, p);
                        p.append(":");
                    }
                    this.visit((Tree)multiVariable.getTypeExpression(), p);
                }
                this.visitSpace(variable.getAfter(), Space.Location.VARIABLE_INITIALIZER, p);
                if (i < variables.size() - 1) {
                    p.append(",");
                } else if (variables.size() > 1 && !containsTypeReceiver) {
                    p.append(")");
                }
                if (((J.VariableDeclarations.NamedVariable)variable.getElement()).getInitializer() != null) {
                    String equals = "=";
                    for (Marker marker : ((J.VariableDeclarations.NamedVariable)variable.getElement()).getInitializer().getMarkers().getMarkers()) {
                        if (marker instanceof By) {
                            equals = "by";
                            break;
                        }
                        if (!(marker instanceof OmitEquals)) continue;
                        equals = "";
                        break;
                    }
                    this.visitSpace(Objects.requireNonNull(((J.VariableDeclarations.NamedVariable)variable.getElement()).getPadding().getInitializer()).getBefore(), Space.Location.VARIABLE_INITIALIZER, p);
                    p.append(equals);
                }
                this.visit((Tree)((J.VariableDeclarations.NamedVariable)variable.getElement()).getInitializer(), p);
            }
            this.visitMarkers(((JRightPadded)multiVariable.getPadding().getVariables().get(0)).getMarkers(), p);
            this.afterSyntax((J)multiVariable, p);
            return multiVariable;
        }

        public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)variable, Space.Location.VARIABLE_PREFIX, p);
            boolean isTypeReceiver = variable.getMarkers().findFirst(ReceiverType.class).isPresent();
            if (!isTypeReceiver) {
                this.visit((Tree)variable.getName(), p);
            }
            this.visitLeftPadded(isTypeReceiver ? "" : "=", variable.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p);
            this.afterSyntax((J)variable, p);
            return variable;
        }

        private void visitTypeAlias(J.VariableDeclarations typeAlias, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)typeAlias, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(typeAlias.getLeadingAnnotations(), p);
            for (J.Modifier m : typeAlias.getModifiers()) {
                this.visitModifier(m, p);
            }
            this.visit((Tree)typeAlias.getTypeExpression(), p);
            this.visitVariable((J.VariableDeclarations.NamedVariable)((JRightPadded)typeAlias.getPadding().getVariables().get(0)).getElement(), p);
            this.visitMarkers(((JRightPadded)typeAlias.getPadding().getVariables().get(0)).getMarkers(), p);
            this.afterSyntax((J)typeAlias, p);
        }

        protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, PrintOutputCapture<P> p) {
            if (paddedStat != null) {
                this.visit((Tree)paddedStat.getElement(), p);
                this.visitSpace(paddedStat.getAfter(), location.getAfterLocation(), p);
                this.visitMarkers(paddedStat.getMarkers(), p);
            }
        }

        protected void visitContainer(String before, @Nullable JContainer<? extends J> container, JContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
            if (container == null) {
                return;
            }
            this.beforeSyntax(container.getBefore(), container.getMarkers(), location.getBeforeLocation(), p);
            p.append(before);
            this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
            this.afterSyntax(container.getMarkers(), p);
            p.append(after == null ? "" : after);
        }

        public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
            if (marker instanceof Semicolon) {
                p.append(';');
            } else if (marker instanceof Reified) {
                p.append("reified");
            }
            return (M)super.visitMarker(marker, p);
        }
    }
}

