/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.CreateFileVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.json.JsonParser;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Json;
import org.openrewrite.remote.Remote;

public final class CreateJsonFile
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="Relative file path", description="File path of new file.", example="foo/bar/baz.json")
    private final String relativeFileName;
    @Option(displayName="File contents", description="Multiline text content for the file.", example="{\"a\": {\"property\": \"value\"}, \"another\": {\"property\": \"value\"}}", required=false)
    @Language(value="json")
    private final @Nullable String fileContents;
    @Option(displayName="File contents URL", description="URL to file containing text content for the file. Use either `fileContents` or `fileContentsUrl` option.", example="http://foo.bar/baz.json", required=false)
    private final @Nullable String fileContentsUrl;
    @Option(displayName="Overwrite existing file", description="If there is an existing file, should it be overwritten.", required=false)
    private final @Nullable Boolean overwriteExisting;

    public String getDisplayName() {
        return "Create JSON file";
    }

    public String getDescription() {
        return "Create a new JSON file.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(true);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(AtomicBoolean shouldCreate) {
        return new CreateFileVisitor(Paths.get(this.relativeFileName, new String[0]), shouldCreate);
    }

    public Collection<SourceFile> generate(AtomicBoolean shouldCreate, ExecutionContext ctx) {
        if (shouldCreate.get()) {
            return JsonParser.builder().build().parse(this.getJsonContents(ctx)).map(brandNewFile -> brandNewFile.withSourcePath(Paths.get(this.relativeFileName, new String[0]))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean created) {
        final Path path = Paths.get(this.relativeFileName, new String[0]);
        return new JsonVisitor<ExecutionContext>(){

            @Override
            public Json visitDocument(Json.Document document, ExecutionContext ctx) {
                if (Boolean.TRUE.equals(CreateJsonFile.this.overwriteExisting) && path.equals(document.getSourcePath())) {
                    SourceFile sourceFile;
                    String jsonContents = CreateJsonFile.this.getJsonContents(ctx);
                    if (StringUtils.isBlank((String)jsonContents)) {
                        return document.withValue(null);
                    }
                    if (document.printAll().equals(jsonContents)) {
                        return document;
                    }
                    Optional<SourceFile> sourceFiles = JsonParser.builder().build().parse(jsonContents).findFirst();
                    if (sourceFiles.isPresent() && (sourceFile = sourceFiles.get()) instanceof Json.Document) {
                        return document.withValue(((Json.Document)sourceFile).getValue());
                    }
                }
                return document;
            }
        };
    }

    @Language(value="json")
    private String getJsonContents(ExecutionContext ctx) {
        String jsonContents = this.fileContents;
        if (jsonContents == null && this.fileContentsUrl != null) {
            jsonContents = Remote.builder((Path)Paths.get(this.relativeFileName, new String[0])).build(URI.create(this.fileContentsUrl)).printAll((Object)ctx);
        }
        return jsonContents == null ? "" : jsonContents;
    }

    @Generated
    public CreateJsonFile(String relativeFileName, @Language(value="json") @Nullable String fileContents, @Nullable String fileContentsUrl, @Nullable Boolean overwriteExisting) {
        this.relativeFileName = relativeFileName;
        this.fileContents = fileContents;
        this.fileContentsUrl = fileContentsUrl;
        this.overwriteExisting = overwriteExisting;
    }

    @Generated
    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    @Language(value="json")
    @Generated
    public @Nullable String getFileContents() {
        return this.fileContents;
    }

    @Generated
    public @Nullable String getFileContentsUrl() {
        return this.fileContentsUrl;
    }

    @Generated
    public @Nullable Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CreateJsonFile(relativeFileName=" + this.getRelativeFileName() + ", fileContents=" + this.getFileContents() + ", fileContentsUrl=" + this.getFileContentsUrl() + ", overwriteExisting=" + this.getOverwriteExisting() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateJsonFile)) {
            return false;
        }
        CreateJsonFile other = (CreateJsonFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overwriteExisting = this.getOverwriteExisting();
        Boolean other$overwriteExisting = other.getOverwriteExisting();
        if (this$overwriteExisting == null ? other$overwriteExisting != null : !((Object)this$overwriteExisting).equals(other$overwriteExisting)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        if (this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName)) {
            return false;
        }
        String this$fileContents = this.getFileContents();
        String other$fileContents = other.getFileContents();
        if (this$fileContents == null ? other$fileContents != null : !this$fileContents.equals(other$fileContents)) {
            return false;
        }
        String this$fileContentsUrl = this.getFileContentsUrl();
        String other$fileContentsUrl = other.getFileContentsUrl();
        return !(this$fileContentsUrl == null ? other$fileContentsUrl != null : !this$fileContentsUrl.equals(other$fileContentsUrl));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof CreateJsonFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwriteExisting = this.getOverwriteExisting();
        result = result * 59 + ($overwriteExisting == null ? 43 : ((Object)$overwriteExisting).hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        String $fileContents = this.getFileContents();
        result = result * 59 + ($fileContents == null ? 43 : $fileContents.hashCode());
        String $fileContentsUrl = this.getFileContentsUrl();
        result = result * 59 + ($fileContentsUrl == null ? 43 : $fileContentsUrl.hashCode());
        return result;
    }
}

