/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.format;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.style.TabsAndIndentsStyle;
import org.openrewrite.json.style.WrappingAndBracesStyle;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.LineWrapSetting;

public class WrappingAndBracesVisitor<P>
extends JsonIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final String singleIndent;
    private final WrappingAndBracesStyle wrappingAndBracesStyle;
    private final GeneralFormatStyle generalFormatStyle;

    public WrappingAndBracesVisitor(WrappingAndBracesStyle wrappingAndBracesStyle, TabsAndIndentsStyle tabsAndIndentsStyle, GeneralFormatStyle generalFormatStyle, @Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
        this.singleIndent = tabsAndIndentsStyle.singleIndent();
        this.wrappingAndBracesStyle = wrappingAndBracesStyle;
        this.generalFormatStyle = generalFormatStyle;
    }

    @Override
    public Json.JsonObject visitObject(Json.JsonObject obj, P p) {
        Json ret = super.visitObject(obj, (Object)p);
        List<JsonRightPadded<Json>> members = ((Json.JsonObject)ret).getPadding().getMembers();
        LineWrapSetting wrappingSetting = this.wrappingAndBracesStyle.getWrapObjects();
        members = this.ensureCollectionHasIndents(members, wrappingSetting);
        members = this.applyWrappingStyleToSuffixes(members, wrappingSetting, this.getCurrentIndent());
        return ((Json.JsonObject)ret).getPadding().withMembers(members);
    }

    @Override
    public Json.Array visitArray(Json.Array array, P p) {
        Json ret = super.visitArray(array, (Object)p);
        List<JsonRightPadded<JsonValue>> members = ((Json.Array)ret).getPadding().getValues();
        LineWrapSetting wrappingSetting = this.wrappingAndBracesStyle.getWrapArrays();
        members = this.ensureCollectionHasIndents(members, wrappingSetting);
        members = this.applyWrappingStyleToSuffixes(members, wrappingSetting, this.getCurrentIndent());
        return ((Json.Array)ret).getPadding().withValues(members);
    }

    public @Nullable Json postVisit(Json tree, P p) {
        if (tree instanceof Json.JsonObject || tree instanceof Json.Array) {
            String newIndent = this.getCurrentIndent() + this.singleIndent;
            this.getCursor().putMessage("indentToUse", (Object)newIndent);
        }
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Json.Document.class, "stop", (Object)true);
        }
        return (Json)super.postVisit((Tree)tree, p);
    }

    public @Nullable Json visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Json)tree;
        }
        return (Json)super.visit(tree, p);
    }

    private <J extends Json> List<JsonRightPadded<J>> ensureCollectionHasIndents(List<JsonRightPadded<J>> elements, LineWrapSetting wrapping) {
        return ListUtils.map(elements, (idx, elem) -> {
            String newPrefixString;
            Space prefix = elem.getElement().getPrefix();
            String currentAfterNewLine = prefix.getWhitespaceIndent();
            if (wrapping == LineWrapSetting.DoNotWrap && idx == 0) {
                newPrefixString = "";
            } else if (wrapping == LineWrapSetting.DoNotWrap) {
                newPrefixString = " ";
            } else if (wrapping == LineWrapSetting.WrapAlways) {
                newPrefixString = this.generalFormatStyle.newLine() + currentAfterNewLine;
            } else {
                throw new UnsupportedOperationException("Unknown LineWrapSetting: " + wrapping);
            }
            if (!newPrefixString.equals(prefix.getWhitespace())) {
                return elem.withElement(elem.getElement().withPrefix(prefix.withWhitespace(newPrefixString)));
            }
            return elem;
        });
    }

    private <JS extends Json> List<JsonRightPadded<JS>> applyWrappingStyleToSuffixes(List<JsonRightPadded<JS>> elements, LineWrapSetting wrapping, String relativeIndent) {
        return ListUtils.map(elements, (idx, elem) -> {
            String newAfter;
            String currentAfter = elem.getAfter().getWhitespace();
            if (idx == elements.size() - 1) {
                if (wrapping == LineWrapSetting.DoNotWrap) {
                    newAfter = "";
                } else {
                    if (wrapping != LineWrapSetting.WrapAlways) throw new UnsupportedOperationException("Unknown LineWrapSetting: " + wrapping);
                    newAfter = this.generalFormatStyle.newLine() + relativeIndent;
                }
            } else {
                newAfter = "";
            }
            if (newAfter.equals(currentAfter)) return elem;
            return elem.withAfter(Space.build(newAfter, Collections.emptyList()));
        });
    }

    private String getCurrentIndent() {
        String ret = (String)this.getCursor().getNearestMessage("indentToUse");
        if (ret == null) {
            Optional<Json> containingNode = this.getCursor().getPathAsStream().filter(obj -> obj instanceof Json && ((Json)obj).getPrefix().getWhitespace().contains("\n")).findFirst().map(obj -> (Json)obj);
            return containingNode.map(node -> node.getPrefix().getWhitespaceIndent()).orElse("");
        }
        return ret;
    }
}

