/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.tree;

import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.internal.JsonPrinter;
import org.openrewrite.json.tree.JsonKey;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.json.tree.Space;
import org.openrewrite.marker.Markers;

public interface Json
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptJson((JsonVisitor)v.adapt(JsonVisitor.class), p);
    }

    default public <P> @Nullable Json acceptJson(JsonVisitor<P> v, P p) {
        return (Json)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(JsonVisitor.class);
    }

    public Space getPrefix();

    public <J extends Json> J withPrefix(Space var1);

    public static class JsonObject
    implements JsonValue {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JsonRightPadded<Json>> members;

        public List<Json> getMembers() {
            return JsonRightPadded.getElements(this.members);
        }

        public JsonObject withMembers(List<Json> members) {
            return this.getPadding().withMembers(JsonRightPadded.withElements(this.members, members));
        }

        @Override
        public <P> Json acceptJson(JsonVisitor<P> v, P p) {
            return v.visitObject(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonObject)) {
                return false;
            }
            JsonObject other = (JsonObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof JsonObject;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public JsonObject(UUID id, Space prefix, Markers markers, List<JsonRightPadded<Json>> members) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.members = members;
        }

        @Generated
        private JsonObject(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JsonRightPadded<Json>> members) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.members = members;
        }

        @NonNull
        @Generated
        public JsonObject withId(UUID id) {
            return this.id == id ? this : new JsonObject(this.padding, id, this.prefix, this.markers, this.members);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public JsonObject withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new JsonObject(this.padding, this.id, prefix, this.markers, this.members);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public JsonObject withMarkers(Markers markers) {
            return this.markers == markers ? this : new JsonObject(this.padding, this.id, this.prefix, markers, this.members);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final JsonObject t;

            public List<JsonRightPadded<Json>> getMembers() {
                return this.t.members;
            }

            public JsonObject withMembers(List<JsonRightPadded<Json>> members) {
                return this.t.members == members ? this.t : new JsonObject(this.t.id, this.t.prefix, this.t.markers, members);
            }

            @Generated
            public Padding(JsonObject t) {
                this.t = t;
            }
        }
    }

    public static class Member
    implements Json {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JsonRightPadded<JsonKey> key;
        private final JsonValue value;

        public JsonKey getKey() {
            return this.key.getElement();
        }

        public Member withKey(JsonKey key) {
            return this.getPadding().withKey(this.key.withElement(key));
        }

        @Override
        public <P> Json acceptJson(JsonVisitor<P> v, P p) {
            return v.visitMember(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return "Member{prefix=" + this.prefix + ",key=" + this.key.getElement() + "}";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Member)) {
                return false;
            }
            Member other = (Member)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Member;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Member(UUID id, Space prefix, Markers markers, JsonRightPadded<JsonKey> key, JsonValue value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
        }

        @Generated
        private Member(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JsonRightPadded<JsonKey> key, JsonValue value) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Member withId(UUID id) {
            return this.id == id ? this : new Member(this.padding, id, this.prefix, this.markers, this.key, this.value);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Member withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Member(this.padding, this.id, prefix, this.markers, this.key, this.value);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Member withMarkers(Markers markers) {
            return this.markers == markers ? this : new Member(this.padding, this.id, this.prefix, markers, this.key, this.value);
        }

        @Generated
        public JsonValue getValue() {
            return this.value;
        }

        @NonNull
        @Generated
        public Member withValue(JsonValue value) {
            return this.value == value ? this : new Member(this.padding, this.id, this.prefix, this.markers, this.key, value);
        }

        public static class Padding {
            private final Member t;

            public JsonRightPadded<JsonKey> getKey() {
                return this.t.key;
            }

            public Member withKey(JsonRightPadded<JsonKey> key) {
                return this.t.key == key ? this.t : new Member(this.t.id, this.t.prefix, this.t.markers, key, this.t.value);
            }

            @Generated
            public Padding(Member t) {
                this.t = t;
            }
        }
    }

    public static final class Literal
    implements JsonValue,
    JsonKey {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String source;
        private final @Nullable Object value;

        @Override
        public <P> Json acceptJson(JsonVisitor<P> v, P p) {
            return v.visitLiteral(this, p);
        }

        public String toString() {
            return "Literal{prefix=" + this.prefix + ",source=" + this.source + "}";
        }

        @Generated
        public Literal(UUID id, Space prefix, Markers markers, String source, @Nullable Object value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.source = source;
            this.value = value;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public @Nullable Object getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Literal withId(UUID id) {
            return this.id == id ? this : new Literal(id, this.prefix, this.markers, this.source, this.value);
        }

        @NonNull
        @Generated
        public Literal withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Literal(this.id, prefix, this.markers, this.source, this.value);
        }

        @NonNull
        @Generated
        public Literal withMarkers(Markers markers) {
            return this.markers == markers ? this : new Literal(this.id, this.prefix, markers, this.source, this.value);
        }

        @NonNull
        @Generated
        public Literal withSource(String source) {
            return this.source == source ? this : new Literal(this.id, this.prefix, this.markers, source, this.value);
        }

        @NonNull
        @Generated
        public Literal withValue(@Nullable Object value) {
            return this.value == value ? this : new Literal(this.id, this.prefix, this.markers, this.source, value);
        }
    }

    public static final class Identifier
    implements JsonKey {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String name;

        @Override
        public <P> Json acceptJson(JsonVisitor<P> v, P p) {
            return v.visitIdentifier(this, p);
        }

        public String toString() {
            return "Identifier{prefix=" + this.prefix + ",name=" + this.name + "}";
        }

        @Generated
        public Identifier(UUID id, Space prefix, Markers markers, String name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Identifier withId(UUID id) {
            return this.id == id ? this : new Identifier(id, this.prefix, this.markers, this.name);
        }

        @NonNull
        @Generated
        public Identifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Identifier(this.id, prefix, this.markers, this.name);
        }

        @NonNull
        @Generated
        public Identifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Identifier(this.id, this.prefix, markers, this.name);
        }

        @NonNull
        @Generated
        public Identifier withName(String name) {
            return this.name == name ? this : new Identifier(this.id, this.prefix, this.markers, name);
        }
    }

    public static final class Empty
    implements JsonValue {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;

        @Override
        public <P> Json acceptJson(JsonVisitor<P> v, P p) {
            return v.visitEmpty(this, p);
        }

        public String toString() {
            return "Empty{prefix=" + this.prefix + "}";
        }

        @Generated
        public Empty(UUID id, Space prefix, Markers markers) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Empty)) {
                return false;
            }
            Empty other = (Empty)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Empty withId(UUID id) {
            return this.id == id ? this : new Empty(id, this.prefix, this.markers);
        }

        @NonNull
        @Generated
        public Empty withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Empty(this.id, prefix, this.markers);
        }

        @NonNull
        @Generated
        public Empty withMarkers(Markers markers) {
            return this.markers == markers ? this : new Empty(this.id, this.prefix, markers);
        }
    }

    public static class Document
    implements Json,
    SourceFile {
        private final UUID id;
        private final Path sourcePath;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable String charsetName;
        private final boolean charsetBomMarked;
        private final @Nullable Checksum checksum;
        private final @Nullable FileAttributes fileAttributes;
        private final JsonValue value;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        public <P> Json acceptJson(JsonVisitor<P> v, P p) {
            return v.visitDocument(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new JsonPrinter();
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Document)) {
                return false;
            }
            Document other = (Document)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Document;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Document(UUID id, Path sourcePath, Space prefix, Markers markers, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable FileAttributes fileAttributes, JsonValue value, Space eof) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.prefix = prefix;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.fileAttributes = fileAttributes;
            this.value = value;
            this.eof = eof;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Document withId(UUID id) {
            return this.id == id ? this : new Document(id, this.sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.value, this.eof);
        }

        @Generated
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @NonNull
        @Generated
        public Document withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new Document(this.id, sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.value, this.eof);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Document withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Document(this.id, this.sourcePath, prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.value, this.eof);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Document withMarkers(Markers markers) {
            return this.markers == markers ? this : new Document(this.id, this.sourcePath, this.prefix, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.value, this.eof);
        }

        @Generated
        public @Nullable String getCharsetName() {
            return this.charsetName;
        }

        @NonNull
        @Generated
        private Document withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.value, this.eof);
        }

        @NonNull
        @Generated
        public Document withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.fileAttributes, this.value, this.eof);
        }

        @Generated
        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @NonNull
        @Generated
        public Document withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.fileAttributes, this.value, this.eof);
        }

        @Generated
        public @Nullable Checksum getChecksum() {
            return this.checksum;
        }

        @NonNull
        @Generated
        public Document withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, fileAttributes, this.value, this.eof);
        }

        @Generated
        public @Nullable FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Generated
        public JsonValue getValue() {
            return this.value;
        }

        @NonNull
        @Generated
        public Document withValue(JsonValue value) {
            return this.value == value ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, value, this.eof);
        }

        @Generated
        public Space getEof() {
            return this.eof;
        }

        @NonNull
        @Generated
        public Document withEof(Space eof) {
            return this.eof == eof ? this : new Document(this.id, this.sourcePath, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.value, eof);
        }
    }

    public static class Array
    implements JsonValue {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JsonRightPadded<JsonValue>> values;

        public List<JsonValue> getValues() {
            return JsonRightPadded.getElements(this.values);
        }

        public Array withValues(List<JsonValue> values) {
            return this.getPadding().withValues(JsonRightPadded.withElements(this.values, values));
        }

        @Override
        public <P> Json acceptJson(JsonVisitor<P> v, P p) {
            return v.visitArray(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Array)) {
                return false;
            }
            Array other = (Array)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Array;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Array(UUID id, Space prefix, Markers markers, List<JsonRightPadded<JsonValue>> values) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.values = values;
        }

        @Generated
        private Array(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JsonRightPadded<JsonValue>> values) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.values = values;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Array withId(UUID id) {
            return this.id == id ? this : new Array(this.padding, id, this.prefix, this.markers, this.values);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Array withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Array(this.padding, this.id, prefix, this.markers, this.values);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Array withMarkers(Markers markers) {
            return this.markers == markers ? this : new Array(this.padding, this.id, this.prefix, markers, this.values);
        }

        public static class Padding {
            private final Array t;

            public List<JsonRightPadded<JsonValue>> getValues() {
                return this.t.values;
            }

            public Array withValues(List<JsonRightPadded<JsonValue>> values) {
                return this.t.values == values ? this.t : new Array(this.t.id, this.t.prefix, this.t.markers, values);
            }

            @Generated
            public Padding(Array t) {
                this.t = t;
            }
        }
    }
}

