/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

final class DependencyWorkspace {
    private static final Path WORKSPACE_BASE = Paths.get(System.getProperty("java.io.tmpdir"), "openrewrite-js-workspaces");
    private static final int MAX_CACHE_SIZE = 100;
    private static final Map<String, Path> cache = Collections.synchronizedMap(new LinkedHashMap<String, Path>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Path> eldest) {
            if (this.size() > 100) {
                DependencyWorkspace.cleanupDirectory(eldest.getValue());
                return true;
            }
            return false;
        }
    });

    static Path getOrCreateWorkspace(String packageJsonContent) {
        String hash = DependencyWorkspace.hashContent(packageJsonContent);
        Path cached = cache.get(hash);
        if (cached != null && DependencyWorkspace.isWorkspaceValid(cached)) {
            return cached;
        }
        Path workspaceDir = WORKSPACE_BASE.resolve(hash);
        if (DependencyWorkspace.isWorkspaceValid(workspaceDir)) {
            cache.put(hash, workspaceDir);
            return workspaceDir;
        }
        try {
            Files.createDirectories(WORKSPACE_BASE, new FileAttribute[0]);
            Path tempDir = Files.createTempDirectory(WORKSPACE_BASE, hash + ".tmp-", new FileAttribute[0]);
            try {
                Files.write(tempDir.resolve("package.json"), packageJsonContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                ProcessBuilder pb = new ProcessBuilder("npm", "install", "--silent");
                pb.directory(tempDir.toFile());
                pb.inheritIO();
                Process process = pb.start();
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    throw new RuntimeException("npm install failed with exit code: " + exitCode);
                }
                try {
                    Files.move(tempDir, workspaceDir, new CopyOption[0]);
                }
                catch (IOException e) {
                    if (DependencyWorkspace.isWorkspaceValid(workspaceDir)) {
                        DependencyWorkspace.cleanupDirectory(tempDir);
                    }
                    throw e;
                }
                cache.put(hash, workspaceDir);
                return workspaceDir;
            }
            catch (Exception e) {
                DependencyWorkspace.cleanupDirectory(tempDir);
                throw e;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create dependency workspace", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("npm install was interrupted", e);
        }
    }

    private static String hashContent(String content) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(content.getBytes(StandardCharsets.UTF_8));
            return Base64.getUrlEncoder().withoutPadding().encodeToString(hash).substring(0, 16).replace('/', '_').replace('+', '-');
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    private static boolean isWorkspaceValid(Path workspaceDir) {
        return Files.exists(workspaceDir, new LinkOption[0]) && Files.isDirectory(workspaceDir.resolve("node_modules"), new LinkOption[0]) && Files.exists(workspaceDir.resolve("package.json"), new LinkOption[0]);
    }

    private static void cleanupDirectory(Path dir) {
        try {
            if (Files.exists(dir, new LinkOption[0])) {
                Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void clearCache() {
        cache.clear();
    }

    private static void initializeCacheFromDisk() {
        try {
            if (!Files.exists(WORKSPACE_BASE, new LinkOption[0])) {
                return;
            }
            Files.list(WORKSPACE_BASE).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(dir -> !dir.getFileName().toString().contains(".tmp-")).filter(DependencyWorkspace::isWorkspaceValid).sorted((a, b) -> {
                try {
                    return Files.getLastModifiedTime(a, new LinkOption[0]).compareTo(Files.getLastModifiedTime(b, new LinkOption[0]));
                }
                catch (IOException e) {
                    return 0;
                }
            }).forEach(workspaceDir -> {
                String hash = workspaceDir.getFileName().toString();
                cache.put(hash, (Path)workspaceDir);
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Generated
    private DependencyWorkspace() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        DependencyWorkspace.initializeCacheFromDisk();
    }
}

