/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.openrewrite.FileAttributes;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.Semicolon;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.javascript.JavaScriptParser;
import org.openrewrite.javascript.TypeScriptTypeMapping;
import org.openrewrite.javascript.internal.JavaScriptParsingException;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCNodeList;
import org.openrewrite.javascript.internal.tsc.TSCSourceFileContext;
import org.openrewrite.javascript.internal.tsc.generated.TSCSyntaxKind;
import org.openrewrite.javascript.markers.Asterisk;
import org.openrewrite.javascript.markers.Braces;
import org.openrewrite.javascript.markers.Colon;
import org.openrewrite.javascript.markers.Comma;
import org.openrewrite.javascript.markers.ForLoopType;
import org.openrewrite.javascript.markers.FunctionKeyword;
import org.openrewrite.javascript.markers.ObjectLiteral;
import org.openrewrite.javascript.markers.OmitDot;
import org.openrewrite.javascript.markers.PostFixOperator;
import org.openrewrite.javascript.markers.TypeReferencePrefix;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.TsType;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;

public class TypeScriptParserVisitor {
    private final TSCNode source;
    private final String sourceText;
    private final TSCSourceFileContext cursorContext;
    private final Path sourcePath;
    private final TypeScriptTypeMapping typeMapping;
    private final String charset;
    private final boolean isCharsetBomMarked;
    private final Collection<NamedStyles> styles;
    private final Function<TSCNode, Space> commaDelim = ignored -> this.sourceBefore(TSCSyntaxKind.CommaToken);
    private final Function<TSCNode, Space> noDelim = ignored -> Space.EMPTY;

    public TypeScriptParserVisitor(TSCNode source, TSCSourceFileContext sourceContext, Path sourcePath, JavaTypeCache typeCache, String charset, boolean isCharsetBomMarked, Collection<NamedStyles> styles) {
        this.source = source;
        this.sourceText = source.getOptionalStringProperty("text");
        this.cursorContext = sourceContext;
        this.sourcePath = sourcePath;
        this.charset = charset;
        this.isCharsetBomMarked = isCharsetBomMarked;
        this.styles = styles;
        this.typeMapping = new TypeScriptTypeMapping(typeCache);
    }

    public JS.CompilationUnit visitSourceFile() {
        TSCNodeList statementList = this.source.getNodeListProperty("statements");
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>(statementList.size());
        Space prefix = this.whitespace();
        for (TSCNode child : statementList) {
            J visited;
            int saveCursor = this.getCursor();
            try {
                visited = this.visitNode(child);
            }
            catch (Throwable t) {
                this.cursor(saveCursor);
                Space childPrefix = this.whitespace();
                String text = child.getText();
                this.skip(text);
                Markers childMarkers = Markers.build(Collections.singletonList(ParseExceptionResult.build((Parser)JavaScriptParser.builder().build(), (Throwable)t).withTreeType(child.syntaxKind().name())));
                visited = new J.Unknown(Tree.randomId(), childPrefix, Markers.EMPTY, new J.Unknown.Source(Tree.randomId(), Space.EMPTY, childMarkers, text));
            }
            if (visited == null) continue;
            if (!(visited instanceof Statement) && visited instanceof Expression) {
                visited = new JS.ExpressionStatement(Tree.randomId(), (Expression)visited);
            }
            statements.add(this.maybeSemicolon((Statement)visited));
        }
        Space eof = this.whitespace();
        String remainingWhitespace = "";
        if (this.getCursor() < this.sourceText.length()) {
            remainingWhitespace = this.sourceText.substring(this.getCursor());
        }
        eof = eof.withWhitespace(eof.getWhitespace() + remainingWhitespace);
        return new JS.CompilationUnit(Tree.randomId(), prefix, Markers.build(this.styles), this.sourcePath, FileAttributes.fromPath((Path)this.sourcePath), this.charset, this.isCharsetBomMarked, null, Collections.emptyList(), statements, eof);
    }

    private J.Assignment visitAssignment(TSCNode node) {
        Space prefix = this.whitespace();
        Expression left = (Expression)this.visitNode(node.getNodeProperty("left"));
        Space before = this.sourceBefore(TSCSyntaxKind.EqualsToken);
        J j = this.visitNode(node.getNodeProperty("right"));
        if (!(j instanceof Expression) && j instanceof Statement) {
            j = new JS.StatementExpression(Tree.randomId(), (Statement)j);
        }
        return new J.Assignment(Tree.randomId(), prefix, Markers.EMPTY, left, this.padLeft(before, (Expression)j), this.typeMapping.type(node));
    }

    private J.AssignmentOperation visitAssignmentOperation(TSCNode node) {
        Space prefix = this.whitespace();
        Expression left = (Expression)this.visitNode(node.getNodeProperty("left"));
        JLeftPadded<J.AssignmentOperation.Type> op = null;
        TSCSyntaxKind opKind = node.getNodeProperty("operatorToken").syntaxKind();
        switch (opKind) {
            case AsteriskEqualsToken: {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.AsteriskEqualsToken), J.AssignmentOperation.Type.Multiplication);
                break;
            }
            case MinusEqualsToken: {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.MinusEqualsToken), J.AssignmentOperation.Type.Subtraction);
                break;
            }
            case PercentEqualsToken: {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.PercentEqualsToken), J.AssignmentOperation.Type.Modulo);
                break;
            }
            case PlusEqualsToken: {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.PlusEqualsToken), J.AssignmentOperation.Type.Addition);
                break;
            }
            case SlashEqualsToken: {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.SlashEqualsToken), J.AssignmentOperation.Type.Division);
                break;
            }
            default: {
                this.implementMe(node);
            }
        }
        Expression right = (Expression)this.visitNode(node.getNodeProperty("right"));
        return new J.AssignmentOperation(Tree.randomId(), prefix, Markers.EMPTY, left, op, right, this.typeMapping.type(node));
    }

    private J visitArrayBindingPattern(TSCNode node) {
        return this.unknown(node);
    }

    private J visitArrowFunction(TSCNode node) {
        boolean parenthesized;
        this.implementMe(node, "typeParameters");
        this.implementMe(node, "typeArguments");
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        if (!trailing.isEmpty()) {
            throw new UnsupportedOperationException("Add support for trailing annotations on: " + node.getText());
        }
        int saveCursor = this.getCursor();
        Space before = this.whitespace();
        TSCSyntaxKind next = this.scan();
        boolean bl = parenthesized = next == TSCSyntaxKind.OpenParenToken;
        if (!parenthesized) {
            before = Space.EMPTY;
            this.cursor(saveCursor);
        }
        TSCNodeList paramNodes = node.getNodeListProperty("parameters");
        J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), before, Markers.EMPTY, parenthesized, paramNodes.isEmpty() ? Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), parenthesized ? this.sourceBefore(TSCSyntaxKind.CloseParenToken) : Space.EMPTY)) : this.convertAll(node.getNodeListProperty("parameters"), this.commaDelim, parenthesized ? t -> this.sourceBefore(TSCSyntaxKind.CloseParenToken) : this.noDelim, true));
        TSCNode typeNode = node.getOptionalNodeProperty("type");
        TypeTree returnTypeExpression = null;
        if (typeNode != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ColonToken)));
            returnTypeExpression = (TypeTree)this.visitNode(typeNode);
        }
        return new JS.ArrowFunction(Tree.randomId(), prefix, markers, leading.isEmpty() ? Collections.emptyList() : leading, modifiers, params, returnTypeExpression, this.sourceBefore(TSCSyntaxKind.EqualsGreaterThanToken), this.visitNode(node.getOptionalNodeProperty("body")), this.typeMapping.type(node));
    }

    private J.NewArray visitArrayLiteralExpression(TSCNode node) {
        Space prefix = this.whitespace();
        JContainer<J> jContainer = this.mapContainer(TSCSyntaxKind.OpenBracketToken, node.getNodeListProperty("elements"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseBracketToken, this::visitNode, true);
        ArrayList<JRightPadded<Expression>> elements = new ArrayList<JRightPadded<Expression>>(jContainer.getElements().size());
        for (JRightPadded jjRightPadded : jContainer.getPadding().getElements()) {
            Expression exp = !(jjRightPadded.getElement() instanceof Expression) && jjRightPadded.getElement() instanceof Statement ? new JS.StatementExpression(Tree.randomId(), (Statement)jjRightPadded.getElement()) : (Expression)jjRightPadded.getElement();
            JRightPadded<Expression> apply = this.padRight(exp, jjRightPadded.getAfter(), jjRightPadded.getMarkers());
            elements.add(apply);
        }
        JContainer arguments = JContainer.build((Space)jContainer.getBefore(), elements, (Markers)jContainer.getMarkers());
        return new J.NewArray(Tree.randomId(), prefix, Markers.EMPTY, null, Collections.emptyList(), arguments, this.typeMapping.type(node));
    }

    private J.TypeCast visitAsExpression(TSCNode node) {
        Space prefix = this.whitespace();
        Expression nameExpr = (Expression)this.visitNode(node.getNodeProperty("expression"));
        Space asPrefix = this.sourceBefore(TSCSyntaxKind.AsKeyword);
        J.Identifier type = this.visitIdentifier(node.getNodeProperty("type"));
        J.ControlParentheses control = new J.ControlParentheses(Tree.randomId(), asPrefix, Markers.EMPTY, this.padRight(type, this.whitespace()));
        return new J.TypeCast(Tree.randomId(), prefix, Markers.EMPTY, control, nameExpr);
    }

    private J visitBinary(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Expression left = (Expression)this.visitNode(node.getNodeProperty("left"));
        Space opPrefix = this.whitespace();
        JLeftPadded<J.Binary.Type> op = null;
        JLeftPadded<JS.JsBinary.Type> jsOp = null;
        TSCSyntaxKind opKind = node.getNodeProperty("operatorToken").syntaxKind();
        switch (opKind) {
            case AmpersandToken: {
                this.consumeToken(TSCSyntaxKind.AmpersandToken);
                op = this.padLeft(opPrefix, J.Binary.Type.BitAnd);
                break;
            }
            case BarToken: {
                this.consumeToken(TSCSyntaxKind.BarToken);
                op = this.padLeft(opPrefix, J.Binary.Type.BitOr);
                break;
            }
            case CaretToken: {
                this.consumeToken(TSCSyntaxKind.CaretToken);
                op = this.padLeft(opPrefix, J.Binary.Type.BitXor);
                break;
            }
            case GreaterThanGreaterThanToken: {
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                op = this.padLeft(opPrefix, J.Binary.Type.RightShift);
                break;
            }
            case LessThanLessThanToken: {
                this.consumeToken(TSCSyntaxKind.LessThanLessThanToken);
                op = this.padLeft(opPrefix, J.Binary.Type.LeftShift);
                break;
            }
            case AmpersandAmpersandToken: {
                this.consumeToken(TSCSyntaxKind.AmpersandAmpersandToken);
                op = this.padLeft(opPrefix, J.Binary.Type.And);
                break;
            }
            case CommaToken: {
                markers = markers.addIfAbsent((Marker)new Comma(Tree.randomId()));
                this.consumeToken(TSCSyntaxKind.CommaToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Or);
                break;
            }
            case BarBarToken: {
                this.consumeToken(TSCSyntaxKind.BarBarToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Or);
                break;
            }
            case EqualsEqualsToken: {
                this.consumeToken(TSCSyntaxKind.EqualsEqualsToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Equal);
                break;
            }
            case ExclamationEqualsToken: {
                this.consumeToken(TSCSyntaxKind.ExclamationEqualsToken);
                op = this.padLeft(opPrefix, J.Binary.Type.NotEqual);
                break;
            }
            case GreaterThanToken: {
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                op = this.padLeft(opPrefix, J.Binary.Type.GreaterThan);
                break;
            }
            case GreaterThanEqualsToken: {
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                this.consumeToken(TSCSyntaxKind.EqualsToken);
                op = this.padLeft(opPrefix, J.Binary.Type.GreaterThanOrEqual);
                break;
            }
            case GreaterThanGreaterThanGreaterThanToken: {
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                op = this.padLeft(opPrefix, J.Binary.Type.UnsignedRightShift);
                break;
            }
            case LessThanToken: {
                this.consumeToken(TSCSyntaxKind.LessThanToken);
                op = this.padLeft(opPrefix, J.Binary.Type.LessThan);
                break;
            }
            case LessThanEqualsToken: {
                this.consumeToken(TSCSyntaxKind.LessThanEqualsToken);
                op = this.padLeft(opPrefix, J.Binary.Type.LessThanOrEqual);
                break;
            }
            case AsteriskToken: {
                this.consumeToken(TSCSyntaxKind.AsteriskToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Multiplication);
                break;
            }
            case MinusToken: {
                this.consumeToken(TSCSyntaxKind.MinusToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Subtraction);
                break;
            }
            case PercentToken: {
                this.consumeToken(TSCSyntaxKind.PercentToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Modulo);
                break;
            }
            case PlusToken: {
                this.consumeToken(TSCSyntaxKind.PlusToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Addition);
                break;
            }
            case SlashToken: {
                this.consumeToken(TSCSyntaxKind.SlashToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Division);
                break;
            }
            case InKeyword: {
                this.consumeToken(TSCSyntaxKind.InKeyword);
                jsOp = this.padLeft(opPrefix, JS.JsBinary.Type.In);
                break;
            }
            default: {
                this.implementMe(node);
            }
        }
        Expression right = (Expression)this.visitNode(node.getNodeProperty("right"));
        if (jsOp != null) {
            return new JS.JsBinary(Tree.randomId(), prefix, markers, left, jsOp, right, this.typeMapping.type(node));
        }
        return new J.Binary(Tree.randomId(), prefix, markers, left, op, right, this.typeMapping.type(node));
    }

    private J visitBinaryExpression(TSCNode node) {
        TSCSyntaxKind opKind = node.getNodeProperty("operatorToken").syntaxKind();
        switch (opKind) {
            case EqualsToken: {
                return this.visitAssignment(node);
            }
            case AsteriskEqualsToken: 
            case MinusEqualsToken: 
            case PercentEqualsToken: 
            case PlusEqualsToken: 
            case SlashEqualsToken: {
                return this.visitAssignmentOperation(node);
            }
            case AmpersandToken: 
            case BarToken: 
            case CaretToken: 
            case GreaterThanGreaterThanToken: 
            case LessThanLessThanToken: 
            case AmpersandAmpersandToken: 
            case CommaToken: 
            case BarBarToken: 
            case EqualsEqualsToken: 
            case ExclamationEqualsToken: 
            case GreaterThanToken: 
            case GreaterThanEqualsToken: 
            case GreaterThanGreaterThanGreaterThanToken: 
            case LessThanToken: 
            case LessThanEqualsToken: 
            case AsteriskToken: 
            case MinusToken: 
            case PercentToken: 
            case PlusToken: 
            case SlashToken: 
            case InKeyword: {
                return this.visitBinary(node);
            }
            case EqualsEqualsEqualsToken: 
            case ExclamationEqualsEqualsToken: {
                return this.visitJsBinary(node);
            }
            case InstanceOfKeyword: {
                return this.visitInstanceOf(node);
            }
        }
        this.implementMe(node.getNodeProperty("operatorToken"));
        return null;
    }

    private void visitBinaryUpdateExpression(TSCNode incrementor, List<JRightPadded<Statement>> updates) {
        assert (incrementor.syntaxKind() == TSCSyntaxKind.BinaryExpression);
        TSCNode left = incrementor.getNodeProperty("left");
        if (left.syntaxKind() == TSCSyntaxKind.BinaryExpression) {
            this.visitBinaryUpdateExpression(left, updates);
        } else {
            updates.add(this.padRight((Statement)this.visitNode(left), this.sourceBefore(TSCSyntaxKind.CommaToken)));
        }
        Statement r = (Statement)this.visitNode(incrementor.getNodeProperty("right"));
        Space after = this.whitespace();
        if (this.tryConsume(TSCSyntaxKind.CommaToken) || this.tryConsume(TSCSyntaxKind.CloseParenToken)) {
            // empty if block
        }
        updates.add(this.padRight(r, after));
    }

    @Nullable
    private J.Block visitBlock(@Nullable TSCNode node) {
        if (node == null) {
            return null;
        }
        Space prefix = this.sourceBefore(TSCSyntaxKind.OpenBraceToken);
        TSCNodeList statementNodes = node.getNodeListProperty("statements");
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>(statementNodes.size());
        for (TSCNode statementNode : statementNodes) {
            statements.add(this.visitStatement(statementNode));
        }
        Space endOfBlock = this.sourceBefore(TSCSyntaxKind.CloseBraceToken);
        return new J.Block(Tree.randomId(), prefix, Markers.EMPTY, JRightPadded.build((Object)false), statements, endOfBlock);
    }

    private J.Break visitBreakStatement(TSCNode node) {
        TSCNode label = node.getOptionalNodeProperty("label");
        return new J.Break(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.BreakKeyword), Markers.EMPTY, label != null ? (J.Identifier)this.visitNode(label) : null);
    }

    private J.MethodInvocation visitCallExpression(TSCNode node) {
        this.implementMe(node, "questionDotToken");
        TSCNodeList typeArgs = node.getOptionalNodeListProperty("typeArguments");
        if (typeArgs != null) {
            this.implementMe(node, "typeArguments");
        }
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        JRightPadded<Expression> select = null;
        TSCNode expression = node.getNodeProperty("expression");
        TSCNode expr = expression.getOptionalNodeProperty("expression");
        if (expr != null) {
            this.implementMe(expression, "questionDotToken");
            if (expression.syntaxKind() == TSCSyntaxKind.PropertyAccessExpression) {
                select = this.padRight((Expression)this.visitNode(expr), this.sourceBefore(TSCSyntaxKind.DotToken));
            } else if (expression.syntaxKind() == TSCSyntaxKind.ParenthesizedExpression) {
                markers = markers.addIfAbsent((Marker)new OmitDot(Tree.randomId()));
                select = this.padRight((Expression)this.visitNode(expression), this.whitespace());
            } else {
                this.implementMe(expression);
            }
        }
        JavaType.Method type = this.typeMapping.methodInvocationType(node);
        J.Identifier name = null;
        TSCNode nameNode = expression.getOptionalNodeProperty("name");
        if (nameNode != null) {
            name = this.visitIdentifier(nameNode, (JavaType)type);
        } else if (expression.syntaxKind() == TSCSyntaxKind.Identifier) {
            name = this.visitIdentifier(expression, (JavaType)type);
        } else if (expression.syntaxKind() == TSCSyntaxKind.SuperKeyword) {
            name = this.convertToIdentifier(this.sourceBefore(TSCSyntaxKind.SuperKeyword), "super");
        } else if (expression.syntaxKind() == TSCSyntaxKind.ParenthesizedExpression) {
            name = this.convertToIdentifier(Space.EMPTY, "");
        } else {
            this.implementMe(expression);
        }
        JContainer typeParameters = null;
        TSCNodeList tpNodes = node.getOptionalNodeListProperty("typeParameters");
        if (tpNodes != null) {
            JContainer<J> jContainer = this.mapContainer(TSCSyntaxKind.LessThanToken, tpNodes, TSCSyntaxKind.CommaToken, TSCSyntaxKind.GreaterThanToken, this::visitNode, true);
            ArrayList<JRightPadded<Expression>> typeParams = new ArrayList<JRightPadded<Expression>>(jContainer.getElements().size());
            for (JRightPadded jjRightPadded : jContainer.getPadding().getElements()) {
                Expression exp = !(jjRightPadded.getElement() instanceof Expression) && jjRightPadded.getElement() instanceof Statement ? new JS.StatementExpression(Tree.randomId(), (Statement)jjRightPadded.getElement()) : (Expression)jjRightPadded.getElement();
                JRightPadded<Expression> apply = this.padRight(exp, jjRightPadded.getAfter(), jjRightPadded.getMarkers());
                typeParams.add(apply);
            }
            typeParameters = JContainer.build((Space)jContainer.getBefore(), typeParams, (Markers)jContainer.getMarkers());
        }
        JContainer arguments = null;
        TSCNodeList argNodes = node.getOptionalNodeListProperty("arguments");
        if (argNodes != null) {
            JContainer<J> jContainer = this.mapContainer(TSCSyntaxKind.OpenParenToken, argNodes, TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, this::visitNode, true);
            ArrayList<JRightPadded<Expression>> elements = new ArrayList<JRightPadded<Expression>>(jContainer.getElements().size());
            for (JRightPadded jjRightPadded : jContainer.getPadding().getElements()) {
                Expression exp = !(jjRightPadded.getElement() instanceof Expression) && jjRightPadded.getElement() instanceof Statement ? new JS.StatementExpression(Tree.randomId(), (Statement)jjRightPadded.getElement()) : (Expression)jjRightPadded.getElement();
                JRightPadded<Expression> apply = this.padRight(exp, jjRightPadded.getAfter(), jjRightPadded.getMarkers());
                elements.add(apply);
            }
            arguments = JContainer.build((Space)jContainer.getBefore(), elements, (Markers)jContainer.getMarkers());
        }
        return new J.MethodInvocation(Tree.randomId(), prefix, markers, select, typeParameters, name, arguments, type);
    }

    private J.ClassDeclaration visitClassDeclaration(TSCNode node) {
        ArrayList<Object> members;
        Space bodyPrefix;
        TSCNodeList memberNodes;
        J.ClassDeclaration.Kind.Type type;
        Space kindPrefix;
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        TSCNodeList modifierNodes = node.getOptionalNodeListProperty("modifiers");
        List<Object> modifiers = modifierNodes != null ? this.mapModifiers(node.getNodeListProperty("modifiers"), leading, trailing) : Collections.emptyList();
        TSCSyntaxKind syntaxKind = node.syntaxKind();
        switch (syntaxKind) {
            case EnumDeclaration: {
                kindPrefix = this.sourceBefore(TSCSyntaxKind.EnumKeyword);
                type = J.ClassDeclaration.Kind.Type.Enum;
                break;
            }
            case InterfaceDeclaration: {
                kindPrefix = this.sourceBefore(TSCSyntaxKind.InterfaceKeyword);
                type = J.ClassDeclaration.Kind.Type.Interface;
                break;
            }
            default: {
                kindPrefix = this.sourceBefore(TSCSyntaxKind.ClassKeyword);
                type = J.ClassDeclaration.Kind.Type.Class;
            }
        }
        J.ClassDeclaration.Kind kind = new J.ClassDeclaration.Kind(Tree.randomId(), kindPrefix, Markers.EMPTY, trailing, type);
        TSCNode nameNode = node.getOptionalNodeProperty("name");
        J.Identifier name = nameNode != null ? this.visitIdentifier(nameNode) : this.convertToIdentifier(Space.EMPTY, "");
        TSCNodeList typeParameterNodes = node.getOptionalNodeListProperty("typeParameters");
        JContainer<J.TypeParameter> typeParams = typeParameterNodes == null ? null : this.mapContainer(TSCSyntaxKind.LessThanToken, typeParameterNodes, TSCSyntaxKind.CommaToken, TSCSyntaxKind.GreaterThanToken, t -> (J.TypeParameter)this.visitNode((TSCNode)t));
        JLeftPadded<TypeTree> extendings = null;
        JContainer implementings = null;
        TSCNodeList heritageClausesNodes = node.getOptionalNodeListProperty("heritageClauses");
        if (heritageClausesNodes != null) {
            for (TSCNode tscNode : heritageClausesNodes) {
                if (TSCSyntaxKind.fromCode(tscNode.getIntProperty("token")) == TSCSyntaxKind.ExtendsKeyword) {
                    TSCNodeList types = tscNode.getNodeListProperty("types");
                    assert (types.size() == 1);
                    extendings = this.padLeft(this.sourceBefore(TSCSyntaxKind.ExtendsKeyword), (TypeTree)this.visitNode((TSCNode)types.get(0)));
                    continue;
                }
                this.implementMe(tscNode);
            }
        }
        if ((memberNodes = node.getOptionalNodeListProperty("members")) != null) {
            bodyPrefix = this.sourceBefore(TSCSyntaxKind.OpenBraceToken);
            if (kind.getType() == J.ClassDeclaration.Kind.Type.Enum) {
                Space enumPrefix = this.whitespace();
                members = new ArrayList(1);
                ArrayList<JRightPadded> enumValues = new ArrayList<JRightPadded>(memberNodes.size());
                for (int i = 0; i < memberNodes.size(); ++i) {
                    boolean hasTrailingComma;
                    TSCNode enumValue = memberNodes.get(i);
                    J.EnumValue value = (J.EnumValue)this.visitNode(enumValue);
                    if (value == null) continue;
                    boolean bl = hasTrailingComma = i == memberNodes.size() - 1 && memberNodes.getBooleanProperty("hasTrailingComma");
                    Space after = i < memberNodes.size() - 1 ? this.sourceBefore(TSCSyntaxKind.CommaToken) : (hasTrailingComma ? this.sourceBefore(TSCSyntaxKind.CommaToken) : Space.EMPTY);
                    JRightPadded ev = this.padRight(value, after);
                    if (i == memberNodes.size() - 1 && hasTrailingComma) {
                        ev = ev.withMarkers(ev.getMarkers().addIfAbsent((Marker)new TrailingComma(Tree.randomId(), Space.EMPTY)));
                    }
                    enumValues.add(ev);
                }
                JRightPadded<J.EnumValueSet> enumSet = this.maybeSemicolon(new J.EnumValueSet(Tree.randomId(), enumPrefix, Markers.EMPTY, enumValues, false));
                members.add(enumSet);
            } else {
                members = new ArrayList<Object>(memberNodes.size());
                for (TSCNode statement : memberNodes) {
                    members.add(this.visitStatement(statement));
                }
            }
        } else {
            throw new UnsupportedOperationException("Add support for empty body");
        }
        J.Block body = new J.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), members, this.sourceBefore(TSCSyntaxKind.CloseBraceToken));
        JContainer primaryConstructor = null;
        return new J.ClassDeclaration(Tree.randomId(), prefix, markers, leading.isEmpty() ? Collections.emptyList() : leading, modifiers, kind, name, typeParams, primaryConstructor, extendings, implementings, null, body, (JavaType.FullyQualified)this.typeMapping.type(node));
    }

    private J visitCaseClause(TSCNode node) {
        TSCNode expression = node.getOptionalNodeProperty("expression");
        TSCNodeList statements = node.getNodeListProperty("statements");
        Space prefix = this.whitespace();
        JContainer expressions = JContainer.build((Space)(expression == null ? Space.EMPTY : this.sourceBefore(TSCSyntaxKind.CaseKeyword)), Collections.singletonList(JRightPadded.build((Object)((Expression)this.visitNode(expression)))), (Markers)Markers.EMPTY);
        ArrayList<JRightPadded<Statement>> list = new ArrayList<JRightPadded<Statement>>(statements.size());
        Space before = this.sourceBefore(TSCSyntaxKind.ColonToken);
        for (TSCNode it : statements) {
            JRightPadded<Statement> statementJRightPadded = this.maybeSemicolon((Statement)this.visitNode(it));
            list.add(statementJRightPadded);
        }
        return new J.Case(Tree.randomId(), prefix, Markers.EMPTY, J.Case.Type.Statement, null, expressions, JContainer.build((Space)before, list, (Markers)Markers.EMPTY), null);
    }

    private J.Ternary visitConditionalExpression(TSCNode node) {
        return new J.Ternary(Tree.randomId(), this.whitespace(), Markers.EMPTY, (Expression)this.visitNode(node.getNodeProperty("condition")), this.padLeft(this.sourceBefore(TSCSyntaxKind.QuestionToken), (Expression)this.visitNode(node.getNodeProperty("whenTrue"))), this.padLeft(this.sourceBefore(TSCSyntaxKind.ColonToken), (Expression)this.visitNode(node.getNodeProperty("whenFalse"))), this.typeMapping.type(node));
    }

    private J.Continue visitContinueStatement(TSCNode node) {
        TSCNode label = node.getOptionalNodeProperty("label");
        return new J.Continue(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ContinueKeyword), Markers.EMPTY, label != null ? (J.Identifier)this.visitNode(node.getNodeProperty("label")) : null);
    }

    private J.MethodDeclaration visitConstructor(TSCNode node) {
        this.implementMe(node, "type");
        this.implementMe(node, "typeArguments");
        Space prefix = this.whitespace();
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        TSCNodeList modifierNodes = node.getOptionalNodeListProperty("modifiers");
        List<Object> modifiers = modifierNodes != null ? this.mapModifiers(modifierNodes, leading, trailing) : Collections.emptyList();
        Space before = this.sourceBefore(TSCSyntaxKind.ConstructorKeyword);
        J.Identifier name = this.convertToIdentifier(before, "constructor");
        J.TypeParameters typeParameters = this.mapTypeParameters(node.getOptionalNodeListProperty("typeParameters"));
        JContainer<Statement> params = this.mapContainer(TSCSyntaxKind.OpenParenToken, node.getNodeListProperty("parameters"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, t -> (Statement)this.visitNode((TSCNode)t), true);
        J.Block body = (J.Block)this.visitNode(node.getNodeProperty("body"));
        return new J.MethodDeclaration(Tree.randomId(), prefix, Markers.EMPTY, leading.isEmpty() ? Collections.emptyList() : leading, modifiers, typeParameters, null, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, this.typeMapping.methodDeclarationType(node));
    }

    private J.Annotation visitDecorator(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.AtToken);
        this.implementMe(node, "questionDotToken");
        this.implementMe(node, "typeArguments");
        TSCNode callExpression = node.getNodeProperty("expression");
        NameTree name = (NameTree)this.visitNameExpression(callExpression.getNodeProperty("expression"));
        JContainer arguments = null;
        TSCNodeList args = callExpression.getOptionalNodeListProperty("arguments");
        if (args != null) {
            JContainer<J> jContainer = this.mapContainer(TSCSyntaxKind.OpenParenToken, args, TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, this::visitNode, true);
            ArrayList<JRightPadded<Expression>> elements = new ArrayList<JRightPadded<Expression>>(jContainer.getElements().size());
            for (JRightPadded jjRightPadded : jContainer.getPadding().getElements()) {
                Expression exp = !(jjRightPadded.getElement() instanceof Expression) && jjRightPadded.getElement() instanceof Statement ? new JS.StatementExpression(Tree.randomId(), (Statement)jjRightPadded.getElement()) : (Expression)jjRightPadded.getElement();
                JRightPadded<Expression> apply = this.padRight(exp, jjRightPadded.getAfter(), jjRightPadded.getMarkers());
                elements.add(apply);
            }
            arguments = JContainer.build((Space)jContainer.getBefore(), elements, (Markers)jContainer.getMarkers());
        }
        return new J.Annotation(Tree.randomId(), prefix, Markers.EMPTY, name, arguments);
    }

    private J visitDefaultClause(TSCNode node) {
        TSCNodeList statements = node.getNodeListProperty("statements");
        Space prefix = this.whitespace();
        JContainer expressions = JContainer.build((Space)Space.EMPTY, Collections.singletonList(JRightPadded.build((Object)new J.Identifier(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.DefaultKeyword), Markers.EMPTY, Collections.emptyList(), "default", null, null))), (Markers)Markers.EMPTY);
        Space before = this.sourceBefore(TSCSyntaxKind.ColonToken);
        ArrayList<JRightPadded<Statement>> list = new ArrayList<JRightPadded<Statement>>(statements.size());
        for (TSCNode it : statements) {
            JRightPadded<Statement> statementJRightPadded = this.maybeSemicolon((Statement)this.visitNode(it));
            list.add(statementJRightPadded);
        }
        return new J.Case(Tree.randomId(), prefix, Markers.EMPTY, J.Case.Type.Statement, null, expressions, JContainer.build((Space)before, list, (Markers)Markers.EMPTY), null);
    }

    private J visitDeleteExpression(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.DeleteKeyword);
        return new JS.Delete(Tree.randomId(), prefix, Markers.EMPTY, (Expression)this.visitNode(node.getNodeProperty("expression")), this.typeMapping.type(node));
    }

    private J.DoWhileLoop visitDoStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.DoKeyword);
        JRightPadded<Statement> body = this.maybeSemicolon((Statement)this.visitNode(node.getNodeProperty("statement")));
        JLeftPadded control = this.padLeft(this.sourceBefore(TSCSyntaxKind.WhileKeyword), this.mapControlParentheses(node.getNodeProperty("expression")));
        return new J.DoWhileLoop(Tree.randomId(), prefix, Markers.EMPTY, body, control);
    }

    private J.ArrayAccess visitElementAccessExpression(TSCNode node) {
        this.implementMe(node, "questionDotToken");
        return new J.ArrayAccess(Tree.randomId(), this.whitespace(), Markers.EMPTY, (Expression)this.visitNode(node.getNodeProperty("expression")), new J.ArrayDimension(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.OpenBracketToken), Markers.EMPTY, this.padRight((Expression)this.visitNode(node.getNodeProperty("argumentExpression")), this.sourceBefore(TSCSyntaxKind.CloseBracketToken))), this.typeMapping.type(node));
    }

    private Statement visitEmptyStatement(TSCNode ignored) {
        return new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
    }

    private J.EnumValue visitEnumMember(TSCNode node) {
        return new J.EnumValue(Tree.randomId(), this.whitespace(), Markers.EMPTY, Collections.emptyList(), this.visitIdentifier(node.getNodeProperty("name")), null);
    }

    private JS.Export visitExportAssignment(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.ExportKeyword);
        this.implementMe(node, "isExportEquals");
        return new JS.Export(Tree.randomId(), prefix, Markers.EMPTY, null, null, null, this.padLeft(this.sourceBefore(TSCSyntaxKind.DefaultKeyword), (Expression)this.visitNode(node.getNodeProperty("expression"))));
    }

    private JS.Export visitExportDeclaration(TSCNode node) {
        JContainer exports;
        TSCNode exportClause;
        this.implementMe(node, "assertClause");
        this.implementMe(node, "modifiers");
        Space prefix = this.sourceBefore(TSCSyntaxKind.ExportKeyword);
        boolean isTypeOnly = node.getBooleanProperty("isTypeOnly");
        if (isTypeOnly) {
            this.implementMe(node);
        }
        if ((exportClause = node.getOptionalNodeProperty("exportClause")) != null) {
            TSCNodeList elements;
            if (exportClause.syntaxKind() != TSCSyntaxKind.NamedExports) {
                this.implementMe(exportClause);
            }
            if ((elements = exportClause.getOptionalNodeListProperty("elements")) == null) {
                this.implementMe(exportClause);
            }
            exports = this.mapContainer(TSCSyntaxKind.OpenBraceToken, elements, TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseBraceToken, t -> (Expression)this.visitNode((TSCNode)t), true).withMarkers(Markers.build(Collections.singletonList(new Braces(Tree.randomId()))));
        } else {
            exports = JContainer.build((Space)this.sourceBefore(TSCSyntaxKind.AsteriskToken), Collections.singletonList(this.padRight(this.convertToIdentifier(Space.EMPTY, "*"), Space.EMPTY)), (Markers)Markers.EMPTY);
        }
        TSCNode moduleSpecifier = node.getOptionalNodeProperty("moduleSpecifier");
        Space beforeFrom = moduleSpecifier == null ? null : this.sourceBefore(TSCSyntaxKind.FromKeyword);
        J.Literal target = null;
        if (moduleSpecifier != null) {
            Space before = this.whitespace();
            String nodeText = moduleSpecifier.getText();
            this.skip(nodeText);
            target = new J.Literal(Tree.randomId(), before, Markers.EMPTY, (Object)moduleSpecifier.getStringProperty("text"), nodeText, null, JavaType.Primitive.None);
        }
        return new JS.Export(Tree.randomId(), prefix, Markers.EMPTY, (JContainer<Expression>)exports, beforeFrom, target, null);
    }

    private J visitExportSpecifier(TSCNode node) {
        TSCNode propertyName;
        boolean isTypeOnly = node.getBooleanProperty("isTypeOnly");
        if (isTypeOnly) {
            this.implementMe(node);
        }
        if ((propertyName = node.getOptionalNodeProperty("propertyName")) != null) {
            return new JS.Alias(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.padRight((J.Identifier)this.visitNode(propertyName), this.sourceBefore(TSCSyntaxKind.AsKeyword)), (J.Identifier)this.visitNode(node.getNodeProperty("name")));
        }
        return this.visitNode(node.getNodeProperty("name"));
    }

    public J visitExpressionStatement(TSCNode node) {
        return this.visitNode(node.getNodeProperty("expression"));
    }

    private J.ForLoop visitForStatement(TSCNode node) {
        List<JRightPadded<Statement>> update;
        Space prefix = this.sourceBefore(TSCSyntaxKind.ForKeyword);
        Space beforeControl = this.sourceBefore(TSCSyntaxKind.OpenParenToken);
        List<JRightPadded<Statement>> initStatements = Collections.singletonList(this.padRight((Statement)this.visitNode(node.getNodeProperty("initializer")), this.whitespace()));
        this.consumeToken(TSCSyntaxKind.SemicolonToken);
        JRightPadded<Expression> condition = this.padRight((Expression)this.visitNode(node.getNodeProperty("condition")), this.sourceBefore(TSCSyntaxKind.SemicolonToken));
        TSCNode incrementor = node.getNodeProperty("incrementor");
        if (incrementor.syntaxKind() == TSCSyntaxKind.BinaryExpression) {
            update = new ArrayList<JRightPadded<Statement>>(2);
            this.visitBinaryUpdateExpression(incrementor, update);
        } else {
            update = Collections.singletonList(this.padRight((Statement)this.visitNode(incrementor), this.sourceBefore(TSCSyntaxKind.CloseParenToken)));
        }
        J.ForLoop.Control control = new J.ForLoop.Control(Tree.randomId(), beforeControl, Markers.EMPTY, initStatements, condition, update);
        return new J.ForLoop(Tree.randomId(), prefix, Markers.EMPTY, control, this.maybeSemicolon((Statement)this.visitNode(node.getNodeProperty("statement"))));
    }

    private J.ForEachLoop visitForEachStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.ForKeyword);
        Markers markers = Markers.EMPTY;
        this.implementMe(node, "awaitModifier");
        Space beforeControl = this.sourceBefore(TSCSyntaxKind.OpenParenToken);
        JRightPadded<J.VariableDeclarations> variable = this.padRight((J.VariableDeclarations)this.visitNode(node.getNodeProperty("initializer")), this.whitespace());
        TSCSyntaxKind forEachKind = this.scan();
        if (forEachKind == TSCSyntaxKind.OfKeyword) {
            markers = markers.addIfAbsent((Marker)new ForLoopType(Tree.randomId(), ForLoopType.Keyword.OF));
        } else if (forEachKind == TSCSyntaxKind.InKeyword) {
            markers = markers.addIfAbsent((Marker)new ForLoopType(Tree.randomId(), ForLoopType.Keyword.IN));
        }
        JRightPadded<Expression> iterable = this.padRight((Expression)this.visitNode(node.getNodeProperty("expression")), this.sourceBefore(TSCSyntaxKind.CloseParenToken));
        J.ForEachLoop.Control control = new J.ForEachLoop.Control(Tree.randomId(), beforeControl, Markers.EMPTY, variable, iterable);
        JRightPadded<Statement> statement = this.maybeSemicolon((Statement)this.visitNode(node.getNodeProperty("statement")));
        return new J.ForEachLoop(Tree.randomId(), prefix, markers, control, statement);
    }

    private J visitExpressionWithTypeArguments(TSCNode node) {
        Space prefix = this.whitespace();
        NameTree nameTree = (NameTree)this.visitNode(node.getNodeProperty("expression"));
        TSCNodeList typeArguments = node.getOptionalNodeListProperty("typeArguments");
        if (typeArguments != null) {
            return new J.ParameterizedType(Tree.randomId(), prefix, Markers.EMPTY, nameTree, this.mapContainer(TSCSyntaxKind.LessThanToken, typeArguments, TSCSyntaxKind.CommaToken, TSCSyntaxKind.GreaterThanToken, t -> (Expression)this.visitNode((TSCNode)t), true), this.typeMapping.type(node));
        }
        return nameTree.withPrefix(prefix);
    }

    private J.MethodDeclaration visitFunctionDeclaration(TSCNode node) {
        this.implementMe(node, "asteriskToken");
        this.implementMe(node, "typeArguments");
        Space prefix = this.whitespace();
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        Space before = this.sourceBefore(TSCSyntaxKind.FunctionKeyword);
        Markers markers = Markers.build(Collections.singletonList(new FunctionKeyword(Tree.randomId(), before)));
        JavaType.Method method = this.typeMapping.methodDeclarationType(node);
        TSCNode nameNode = node.getOptionalNodeProperty("name");
        J.Identifier name = nameNode != null ? this.visitIdentifier(nameNode) : this.convertToIdentifier(Space.EMPTY, "");
        if (!trailing.isEmpty()) {
            name = name.withAnnotations(trailing);
        }
        name = name.withType((JavaType)method);
        J.TypeParameters typeParameters = this.mapTypeParameters(node.getOptionalNodeListProperty("typeParameters"));
        JContainer<Statement> parameters = this.mapContainer(TSCSyntaxKind.OpenParenToken, node.getNodeListProperty("parameters"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, this::visitFunctionParameter, true);
        TSCNode typeNode = node.getOptionalNodeProperty("type");
        TypeTree returnTypeExpression = null;
        if (typeNode != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ColonToken)));
            returnTypeExpression = (TypeTree)this.visitNode(typeNode);
        }
        J.Block block = this.visitBlock(node.getOptionalNodeProperty("body"));
        return new J.MethodDeclaration(Tree.randomId(), prefix, markers, leading.isEmpty() ? Collections.emptyList() : leading, modifiers, typeParameters, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), parameters, null, block, null, method);
    }

    private Statement visitFunctionParameter(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        Space variablePrefix = this.whitespace();
        J.Identifier name = this.visitIdentifier(node.getNodeProperty("name"));
        if (!trailing.isEmpty()) {
            name = name.withAnnotations(trailing);
        }
        TypeTree typeTree = null;
        TSCNode type = node.getOptionalNodeProperty("type");
        if (type != null) {
            TSCNode questionToken = node.getOptionalNodeProperty("questionToken");
            if (questionToken != null) {
                markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.QuestionToken), PostFixOperator.Operator.Question));
            }
            Space beforeColon = this.sourceBefore(TSCSyntaxKind.ColonToken);
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), beforeColon));
            typeTree = (TypeTree)this.visitNode(type);
        }
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> variables = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        variables.add(this.padRight(new J.VariableDeclarations.NamedVariable(Tree.randomId(), variablePrefix, Markers.EMPTY, name, Collections.emptyList(), null, this.typeMapping.variableType(node)), Space.EMPTY));
        this.implementMe(node, "initializer");
        Space varargs = null;
        List dimensionsBeforeName = Collections.emptyList();
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, leading.isEmpty() ? Collections.emptyList() : leading, modifiers.isEmpty() ? Collections.emptyList() : modifiers, typeTree, varargs, dimensionsBeforeName, variables);
    }

    private J visitExternalModuleReference(TSCNode node) {
        Space prefix = this.whitespace();
        this.consumeToken(TSCSyntaxKind.RequireKeyword);
        J.Identifier name = this.convertToIdentifier(Space.EMPTY, "require");
        return new J.MethodInvocation(Tree.randomId(), prefix, Markers.EMPTY, null, null, name, this.mapContainer(TSCSyntaxKind.OpenParenToken, Collections.singletonList(node.getNodeProperty("expression")), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, t -> (Expression)this.visitNode((TSCNode)t), true), null);
    }

    private J.Identifier visitIdentifier(TSCNode node) {
        return this.visitIdentifier(node, null, null);
    }

    private J.Identifier visitIdentifier(TSCNode node, @Nullable JavaType type) {
        return this.visitIdentifier(node, type, null);
    }

    private J.Identifier visitIdentifier(TSCNode node, @Nullable JavaType type, @Nullable JavaType.Variable fieldType) {
        Space prefix = this.whitespace();
        this.skip(node.getText());
        return new J.Identifier(Tree.randomId(), prefix, Markers.EMPTY, Collections.emptyList(), node.getText(), type == null ? this.typeMapping.type(node) : type, fieldType);
    }

    private J visitImportDeclaration(TSCNode node) {
        TSCNode moduleSpecifier;
        this.implementMe(node, "assertClause");
        this.implementMe(node, "modifiers");
        Space prefix = this.sourceBefore(TSCSyntaxKind.ImportKeyword);
        TSCNode importClause = node.getOptionalNodeProperty("importClause");
        JRightPadded<J.Identifier> name = null;
        JContainer imports = null;
        if (importClause != null) {
            TSCNode namedBindings;
            TSCNode nameNode;
            boolean isTypeOnly = importClause.getBooleanProperty("isTypeOnly");
            if (isTypeOnly) {
                this.implementMe(importClause, "isTypeOnly");
            }
            if ((nameNode = importClause.getOptionalNodeProperty("name")) != null) {
                name = this.padRight((J.Identifier)this.visitNode(nameNode), this.whitespace());
            }
            if ((namedBindings = importClause.getOptionalNodeProperty("namedBindings")) != null) {
                if (name != null) {
                    this.consumeToken(TSCSyntaxKind.CommaToken);
                }
                imports = this.mapContainer(TSCSyntaxKind.OpenBraceToken, namedBindings.getNodeListProperty("elements"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseBraceToken, t -> (Expression)this.visitNode((TSCNode)t), true).withMarkers(Markers.build(Collections.singletonList(new Braces(Tree.randomId()))));
            }
        }
        Space beforeFrom = (moduleSpecifier = node.getOptionalNodeProperty("moduleSpecifier")) == null ? null : this.sourceBefore(TSCSyntaxKind.FromKeyword);
        J.Literal target = null;
        if (moduleSpecifier != null) {
            Space before = this.whitespace();
            String nodeText = moduleSpecifier.getText();
            this.skip(nodeText);
            target = new J.Literal(Tree.randomId(), before, Markers.EMPTY, (Object)moduleSpecifier.getStringProperty("text"), nodeText, null, JavaType.Primitive.None);
        }
        JLeftPadded<Expression> initializer = null;
        TSCNode moduleReference = node.getOptionalNodeProperty("moduleReference");
        if (moduleReference != null) {
            name = this.padRight((J.Identifier)this.visitNode(node.getNodeProperty("name")), this.whitespace());
            initializer = this.padLeft(this.sourceBefore(TSCSyntaxKind.EqualsToken), (Expression)this.visitNode(moduleReference));
        }
        return new JS.JsImport(Tree.randomId(), prefix, Markers.EMPTY, name, imports, beforeFrom, target, initializer);
    }

    private J visitIndexedAccessType(TSCNode node) {
        return this.unknown(node);
    }

    private J.If visitIfStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.IfKeyword);
        J.ControlParentheses control = this.mapControlParentheses(node.getNodeProperty("expression"));
        JRightPadded<Statement> thenPart = this.visitStatement(node.getNodeProperty("thenStatement"));
        J.If.Else elsePart = null;
        TSCNode elseNode = node.getOptionalNodeProperty("elseStatement");
        if (elseNode != null) {
            Space elsePartPrefix = this.sourceBefore(TSCSyntaxKind.ElseKeyword);
            elsePart = new J.If.Else(Tree.randomId(), elsePartPrefix, Markers.EMPTY, this.visitStatement(elseNode));
        }
        return new J.If(Tree.randomId(), prefix, Markers.EMPTY, control, thenPart, elsePart);
    }

    private J.InstanceOf visitInstanceOf(TSCNode node) {
        return new J.InstanceOf(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.padRight((Expression)this.visitNode(node.getNodeProperty("left")), this.sourceBefore(TSCSyntaxKind.InstanceOfKeyword)), this.visitNode(node.getNodeProperty("right")), null, this.typeMapping.type(node));
    }

    private JS.JsBinary visitJsBinary(TSCNode node) {
        JLeftPadded<JS.JsBinary.Type> op;
        Space prefix = this.whitespace();
        Expression left = (Expression)this.visitNode(node.getNodeProperty("left"));
        TSCSyntaxKind opKind = node.getNodeProperty("operatorToken").syntaxKind();
        if (opKind == TSCSyntaxKind.EqualsEqualsEqualsToken) {
            op = this.padLeft(this.sourceBefore(TSCSyntaxKind.EqualsEqualsEqualsToken), JS.JsBinary.Type.IdentityEquals);
        } else if (opKind == TSCSyntaxKind.ExclamationEqualsEqualsToken) {
            op = this.padLeft(this.sourceBefore(TSCSyntaxKind.ExclamationEqualsEqualsToken), JS.JsBinary.Type.IdentityNotEquals);
        } else {
            throw new IllegalArgumentException(String.format("Binary operator kind <%s> is not supported.", new Object[]{opKind}));
        }
        Expression right = (Expression)this.visitNode(node.getNodeProperty("right"));
        return new JS.JsBinary(Tree.randomId(), prefix, Markers.EMPTY, left, op, right, this.typeMapping.type(node));
    }

    private J.Identifier visitKeyword(TSCNode node) {
        return this.visitIdentifier(node);
    }

    private J visitFunctionType(TSCNode node) {
        return this.unknown(node);
    }

    private J.Label visitLabelledStatement(TSCNode node) {
        return new J.Label(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.padRight(this.visitIdentifier(node.getNodeProperty("label")), this.sourceBefore(TSCSyntaxKind.ColonToken)), (Statement)this.visitNode(node.getNodeProperty("statement")));
    }

    private J.MethodDeclaration visitMethodDeclaration(TSCNode node) {
        this.implementMe(node, "questionToken");
        this.implementMe(node, "exclamationToken");
        this.implementMe(node, "typeArguments");
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        if (node.hasProperty("asteriskToken")) {
            markers = markers.addIfAbsent((Marker)new Asterisk(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.AsteriskToken)));
        }
        JavaType.Method methodType = this.typeMapping.methodDeclarationType(node);
        TSCNode nameNode = node.getOptionalNodeProperty("name");
        J.Identifier name = nameNode == null ? this.convertToIdentifier(Space.EMPTY, "") : this.visitIdentifier(nameNode, (JavaType)methodType);
        if (!trailing.isEmpty()) {
            name = name.withAnnotations(trailing);
        }
        J.TypeParameters typeParameters = this.mapTypeParameters(node.getOptionalNodeListProperty("typeParameters"));
        JContainer<Statement> parameters = this.mapContainer(TSCSyntaxKind.OpenParenToken, node.getNodeListProperty("parameters"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, t -> (Statement)this.visitNode((TSCNode)t), true);
        JContainer throw_ = null;
        TypeTree returnTypeExpression = null;
        TSCNode typeNode = node.getOptionalNodeProperty("type");
        if (typeNode != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ColonToken)));
            returnTypeExpression = (TypeTree)this.visitNode(typeNode);
        }
        J.Block body = this.visitBlock(node.getOptionalNodeProperty("body"));
        JLeftPadded defaultValue = null;
        return new J.MethodDeclaration(Tree.randomId(), prefix, markers, leading.isEmpty() ? Collections.emptyList() : leading, modifiers, typeParameters, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), parameters, throw_, body, defaultValue, methodType);
    }

    private Expression visitNameExpression(TSCNode expression) {
        TSCNode expr = expression.getOptionalNodeProperty("expression");
        if (expr != null) {
            Space prefix = this.whitespace();
            Expression select = this.visitNameExpression(expr);
            this.implementMe(expression, "questionDotToken");
            JLeftPadded<J.Identifier> name = this.padLeft(this.sourceBefore(TSCSyntaxKind.DotToken), this.visitIdentifier(expression.getNodeProperty("name")));
            return new J.FieldAccess(Tree.randomId(), prefix, Markers.EMPTY, select, name, this.typeMapping.type(expression));
        }
        Expression identifier = null;
        TSCNode name = expression.getOptionalNodeProperty("name");
        if (name != null) {
            identifier = (Expression)this.visitNode(name);
        }
        if (identifier == null && expression.hasProperty("escapedText") || expression.syntaxKind() == TSCSyntaxKind.ThisKeyword) {
            identifier = (Expression)this.visitNode(expression);
        }
        if (identifier == null) {
            this.implementMe(expression);
        }
        return identifier;
    }

    private J.Literal visitLiteralType(TSCNode node) {
        Space prefix = this.whitespace();
        TSCNode literal = node.getNodeProperty("literal");
        Object value = null;
        if (literal.syntaxKind() != TSCSyntaxKind.NullKeyword) {
            this.implementMe(literal, "text");
        }
        this.skip(node.getText());
        return new J.Literal(Tree.randomId(), prefix, Markers.EMPTY, value, node.getText(), null, this.typeMapping.primitive(literal));
    }

    private J visitMetaProperty(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Integer keywordToken = node.getOptionalIntProperty("keywordToken");
        TSCSyntaxKind syntaxKind = TSCSyntaxKind.fromCode(keywordToken);
        J.Identifier nameExpression = null;
        if (syntaxKind == TSCSyntaxKind.ImportKeyword) {
            this.consumeToken(TSCSyntaxKind.ImportKeyword);
            nameExpression = this.convertToIdentifier(Space.EMPTY, "import");
        } else {
            this.implementMe(node);
        }
        return new J.FieldAccess(Tree.randomId(), prefix, markers, (Expression)nameExpression, this.padLeft(this.sourceBefore(TSCSyntaxKind.DotToken), this.visitIdentifier(node.getNodeProperty("name"))), this.typeMapping.type(node));
    }

    private J.NewClass visitNewExpression(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.NewKeyword);
        TypeTree typeTree = null;
        TSCNode expr = node.getOptionalNodeProperty("expression");
        if (expr != null) {
            typeTree = (TypeTree)this.visitNameExpression(expr);
        }
        this.implementMe(node, "typeArguments");
        JContainer<J> jContainer = this.mapContainer(TSCSyntaxKind.OpenParenToken, node.getNodeListProperty("arguments"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, this::visitNode, true);
        ArrayList<JRightPadded<Expression>> elements = new ArrayList<JRightPadded<Expression>>(jContainer.getElements().size());
        for (JRightPadded jjRightPadded : jContainer.getPadding().getElements()) {
            Expression exp = !(jjRightPadded.getElement() instanceof Expression) && jjRightPadded.getElement() instanceof Statement ? new JS.StatementExpression(Tree.randomId(), (Statement)jjRightPadded.getElement()) : (Expression)jjRightPadded.getElement();
            JRightPadded<Expression> apply = this.padRight(exp, jjRightPadded.getAfter(), jjRightPadded.getMarkers());
            elements.add(apply);
        }
        JContainer arguments = JContainer.build((Space)jContainer.getBefore(), elements, (Markers)jContainer.getMarkers());
        return new J.NewClass(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, prefix, typeTree, arguments, null, this.typeMapping.methodInvocationType(node));
    }

    private J.Literal visitNumericLiteral(TSCNode node) {
        return new J.Literal(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.NumericLiteral), Markers.EMPTY, (Object)node.getStringProperty("text"), node.getText(), null, this.typeMapping.primitive(node));
    }

    private J visitObjectLiteralExpression(TSCNode node) {
        Space prefix = this.whitespace();
        return this.mapPropertyNodesToNewClass(node.getOptionalNodeListProperty("properties"), prefix);
    }

    private JS.ObjectBindingDeclarations mapObjectBindingDeclaration(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        Space beforeVariableModifier = this.whitespace();
        TSCSyntaxKind keyword = this.scan();
        if (keyword == TSCSyntaxKind.ConstKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "const", trailing));
        } else if (keyword == TSCSyntaxKind.LetKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "let", trailing));
        } else if (keyword == TSCSyntaxKind.VarKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "var", trailing));
        } else {
            this.implementMe(node);
        }
        TSCNode declarationList = node.getOptionalNodeProperty("declarationList");
        TSCNodeList declarations = declarationList == null ? Collections.emptyList() : declarationList.getNodeListProperty("declarations");
        TypeTree typeTree = null;
        TSCNode bindingNode = (TSCNode)declarations.get(0);
        TSCNode objectBindingPattern = bindingNode.getNodeProperty("name");
        this.implementMe(bindingNode, "exclamationToken");
        this.implementMe(bindingNode, "type");
        TSCNodeList elements = objectBindingPattern.getNodeListProperty("elements");
        ArrayList<JRightPadded> bindings = new ArrayList<JRightPadded>(elements.size());
        Space beforeBraces = this.sourceBefore(TSCSyntaxKind.OpenBraceToken);
        for (int i = 0; i < elements.size(); ++i) {
            TSCNode binding = (TSCNode)elements.get(i);
            Space bindingPrefix = this.whitespace();
            Space varArg = binding.hasProperty("dotDotDotToken") ? this.sourceBefore(TSCSyntaxKind.DotDotDotToken) : null;
            JRightPadded<J.Identifier> propertyName = null;
            TSCNode propertyNameNode = binding.getOptionalNodeProperty("propertyName");
            if (propertyNameNode != null) {
                J j = this.visitNode(propertyNameNode);
                J.Identifier name = null;
                if (j instanceof J.Identifier) {
                    name = (J.Identifier)j;
                } else {
                    this.implementMe(propertyNameNode);
                }
                propertyName = this.padRight(name, this.sourceBefore(TSCSyntaxKind.ColonToken));
            }
            TSCNode nameNode = binding.getNodeProperty("name");
            J j = this.visitNode(nameNode);
            J.Identifier name = null;
            if (j instanceof J.Identifier) {
                name = (J.Identifier)j;
            } else {
                this.implementMe(nameNode);
            }
            TSCNode initializer = binding.getOptionalNodeProperty("initializer");
            JLeftPadded<Expression> bindingInitializer = null;
            if (initializer != null) {
                bindingInitializer = this.padLeft(this.sourceBefore(TSCSyntaxKind.EqualsToken), (Expression)this.visitNode(initializer));
            }
            Space after = this.whitespace();
            Markers bindingMarkers = Markers.EMPTY;
            if (i < elements.size() - 1) {
                this.consumeToken(TSCSyntaxKind.CommaToken);
            } else {
                TSCSyntaxKind kind = this.scan();
                if (kind == TSCSyntaxKind.CommaToken) {
                    bindingMarkers = bindingMarkers.addIfAbsent((Marker)new TrailingComma(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.CloseBraceToken)));
                }
            }
            JS.ObjectBindingDeclarations.Binding b = new JS.ObjectBindingDeclarations.Binding(Tree.randomId(), bindingPrefix, Markers.EMPTY, propertyName, name, Collections.emptyList(), varArg, bindingInitializer, null);
            bindings.add(this.padRight(b, after).withMarkers(bindingMarkers));
        }
        TSCNode init = bindingNode.getOptionalNodeProperty("initializer");
        return new JS.ObjectBindingDeclarations(Tree.randomId(), prefix, markers, leading.isEmpty() ? Collections.emptyList() : leading, modifiers, typeTree, (JContainer<JS.ObjectBindingDeclarations.Binding>)JContainer.build((Space)beforeBraces, bindings, (Markers)Markers.EMPTY), init != null ? this.padLeft(this.sourceBefore(TSCSyntaxKind.EqualsToken), (Expression)this.visitNode(init)) : null);
    }

    private <J2 extends J> J.Parentheses<J2> visitParenthesizedExpression(TSCNode node) {
        return new J.Parentheses(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.OpenParenToken), Markers.EMPTY, this.padRight(this.visitNode(node.getNodeProperty("expression")), this.sourceBefore(TSCSyntaxKind.CloseParenToken)));
    }

    private J.FieldAccess visitPropertyAccessExpression(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Expression nameExpression = (Expression)this.visitNode(node.getNodeProperty("expression"));
        TSCNode questionToken = node.getOptionalNodeProperty("questionDotToken");
        boolean isQuestionDot = false;
        if (questionToken != null) {
            markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), Space.EMPTY, PostFixOperator.Operator.Question));
            isQuestionDot = true;
        }
        return new J.FieldAccess(Tree.randomId(), prefix, markers, nameExpression, this.padLeft(this.sourceBefore(isQuestionDot ? TSCSyntaxKind.QuestionDotToken : TSCSyntaxKind.DotToken), this.visitIdentifier(node.getNodeProperty("name"))), this.typeMapping.type(node));
    }

    private J.VariableDeclarations visitPropertyDeclaration(TSCNode node) {
        JLeftPadded<Expression> initializer;
        TSCNode initNode;
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        TSCNode varArgNode = node.getOptionalNodeProperty("dotDotDotToken");
        Space varArg = varArgNode != null ? this.sourceBefore(TSCSyntaxKind.DotDotDotToken) : null;
        J j = this.visitNode(node.getNodeProperty("name"));
        J.Identifier name = null;
        if (j instanceof J.Identifier) {
            name = (J.Identifier)j;
        } else {
            this.implementMe(node);
        }
        if (!trailing.isEmpty()) {
            name = name.withAnnotations(trailing);
        }
        TypeTree typeTree = null;
        TSCNode typeNode = node.getOptionalNodeProperty("type");
        if (typeNode != null) {
            TSCNode questionToken = node.getOptionalNodeProperty("questionToken");
            TSCNode exclamationToken = node.getOptionalNodeProperty("exclamationToken");
            if (questionToken != null) {
                markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.QuestionToken), PostFixOperator.Operator.Question));
            } else if (exclamationToken != null) {
                markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ExclamationToken), PostFixOperator.Operator.Exclamation));
            }
            Space beforeColon = this.sourceBefore(TSCSyntaxKind.ColonToken);
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), beforeColon));
            typeTree = (TypeTree)this.visitNode(typeNode);
            name = name.withType(this.typeMapping.type(typeNode));
        }
        if ((initNode = node.getOptionalNodeProperty("initializer")) != null) {
            Space beforeEquals = this.sourceBefore(TSCSyntaxKind.EqualsToken);
            J init = this.visitNode(initNode);
            if (init != null && !(init instanceof Expression)) {
                init = new JS.StatementExpression(Tree.randomId(), (Statement)init);
            }
            initializer = this.padLeft(beforeEquals, (Expression)init);
        } else {
            initializer = null;
        }
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> variables = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        variables.add(this.maybeSemicolon(new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, Collections.emptyList(), initializer, this.typeMapping.variableType(node))));
        List dimensions = Collections.emptyList();
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, leading.isEmpty() ? Collections.emptyList() : leading, modifiers.isEmpty() ? Collections.emptyList() : modifiers, typeTree, varArg, dimensions, variables);
    }

    private J visitPropertyAssignment(TSCNode node) {
        JLeftPadded<Expression> initializer;
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        Space variablePrefix = this.whitespace();
        J j = this.visitNode(node.getOptionalNodeProperty("name"));
        J.Identifier name = null;
        if (j instanceof J.Identifier) {
            name = (J.Identifier)j;
        } else if (j instanceof J.Literal) {
            name = this.convertToIdentifier(j.getPrefix(), ((J.Literal)j).getValueSource());
        } else {
            this.implementMe(node);
        }
        if (!trailing.isEmpty()) {
            name = name.withAnnotations(trailing);
        }
        TypeTree typeTree = null;
        TSCNode initNode = node.getOptionalNodeProperty("initializer");
        if (initNode != null) {
            TSCNode questionToken = node.getOptionalNodeProperty("questionToken");
            TSCNode exclamationToken = node.getOptionalNodeProperty("exclamationToken");
            if (questionToken != null) {
                markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.QuestionToken), PostFixOperator.Operator.Question));
            } else if (exclamationToken != null) {
                markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ExclamationToken), PostFixOperator.Operator.Exclamation));
            }
            Space beforeEquals = this.sourceBefore(TSCSyntaxKind.ColonToken);
            J init = this.visitNode(initNode);
            if (init != null && !(init instanceof Expression)) {
                init = new JS.StatementExpression(Tree.randomId(), (Statement)init);
            }
            initializer = this.padLeft(beforeEquals, (Expression)init);
        } else {
            initializer = null;
        }
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> variables = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        variables.add(this.maybeSemicolon(new J.VariableDeclarations.NamedVariable(Tree.randomId(), variablePrefix, Markers.build(Collections.singletonList(new Colon(Tree.randomId()))), name, Collections.emptyList(), initializer, this.typeMapping.variableType(node))));
        List dimensions = Collections.emptyList();
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, leading.isEmpty() ? Collections.emptyList() : leading, modifiers.isEmpty() ? Collections.emptyList() : modifiers, typeTree, null, dimensions, variables);
    }

    private J.FieldAccess visitQualifiedName(TSCNode node) {
        return new J.FieldAccess(Tree.randomId(), this.whitespace(), Markers.EMPTY, (Expression)this.visitNode(node.getNodeProperty("left")), this.padLeft(this.sourceBefore(TSCSyntaxKind.DotToken), (J.Identifier)this.visitNode(node.getNodeProperty("right"))), this.typeMapping.type(node));
    }

    private J visitRegularExpressionLiteral(TSCNode node) {
        Space prefix = this.whitespace();
        this.skip(node.getText());
        return new J.Literal(Tree.randomId(), prefix, Markers.EMPTY, (Object)node.getStringProperty("text"), node.getText(), null, JavaType.Primitive.None);
    }

    private J.Return visitReturnStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.ReturnKeyword);
        Expression expression = null;
        TSCNode expressionNode = node.getOptionalNodeProperty("expression");
        if (expressionNode != null) {
            J j = this.visitNode(expressionNode);
            expression = !(j instanceof Expression) && j instanceof Statement ? new JS.StatementExpression(Tree.randomId(), (Statement)j) : (Expression)j;
        }
        return new J.Return(Tree.randomId(), prefix, Markers.EMPTY, expression);
    }

    private JRightPadded<Statement> visitStatement(TSCNode node) {
        Statement statement = (Statement)this.visitNode(node);
        assert (statement != null);
        return this.maybeSemicolon(statement);
    }

    private J visitSpreadElement(TSCNode node) {
        Space prefix = this.whitespace();
        this.consumeToken(TSCSyntaxKind.DotDotDotToken);
        return new JS.Unary(Tree.randomId(), prefix, Markers.EMPTY, this.padLeft(Space.EMPTY, JS.Unary.Type.Spread), (Expression)this.convertToExpression(this.visitNode(node.getNodeProperty("expression"))), null);
    }

    private J.Literal visitStringLiteral(TSCNode node) {
        this.implementMe(node, "singleQuote");
        if (node.getBooleanProperty("hasExtendedUnicodeEscape")) {
            this.implementMe(node, "hasExtendedUnicodeEscape");
        }
        return new J.Literal(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.StringLiteral), Markers.EMPTY, (Object)node.getStringProperty("text"), node.getText(), null, JavaType.Primitive.String);
    }

    private J visitTemplateExpression(TSCNode node) {
        TSCNode templateExpression;
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        JRightPadded<Expression> tag = null;
        if (node.syntaxKind() == TSCSyntaxKind.TaggedTemplateExpression) {
            J j = this.visitNode(node.getNodeProperty("tag"));
            tag = this.padRight(!(j instanceof Expression) && j instanceof Statement ? new JS.StatementExpression(Tree.randomId(), (Statement)j) : (Expression)j, this.whitespace());
            if (node.hasProperty("questionDotToken")) {
                markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.QuestionDotToken), PostFixOperator.Operator.QuestionDot));
            }
            templateExpression = node.getNodeProperty("template");
        } else {
            templateExpression = node;
        }
        TSCNode head = templateExpression.syntaxKind() == TSCSyntaxKind.NoSubstitutionTemplateLiteral ? node : templateExpression.getNodeProperty("head");
        String text = head.getStringProperty("text");
        String rawText = head.getStringProperty("rawText");
        String delimiter = String.valueOf(head.getText().charAt(0));
        boolean isEnclosedInBraces = head.getText().endsWith("{");
        this.skip(delimiter);
        TSCNodeList spans = templateExpression.syntaxKind() == TSCSyntaxKind.NoSubstitutionTemplateLiteral ? Collections.emptyList() : templateExpression.getNodeListProperty("templateSpans");
        ArrayList<J> elements = new ArrayList<J>(spans.size() * 2 + 1);
        if (!rawText.isEmpty()) {
            this.skip(rawText);
            elements.add((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)text, rawText, null, JavaType.Primitive.String));
        }
        for (TSCNode span : spans) {
            this.cursor(this.getCursor() + (isEnclosedInBraces ? 2 : 1));
            elements.add(new JS.TemplateExpression.Value(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.visitNode(span.getNodeProperty("expression")), this.whitespace(), isEnclosedInBraces));
            this.consumeToken(TSCSyntaxKind.CloseBraceToken);
            TSCNode literal = span.getNodeProperty("literal");
            String snapText = literal.getStringProperty("text");
            String spanRawText = literal.getStringProperty("rawText");
            if (!spanRawText.isEmpty()) {
                this.skip(spanRawText);
                elements.add((J)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)snapText, spanRawText, null, JavaType.Primitive.String));
            }
            if (literal.syntaxKind() == TSCSyntaxKind.TemplateTail) {
                this.skip(delimiter);
                continue;
            }
            isEnclosedInBraces = literal.getText().endsWith("{");
        }
        if (templateExpression.syntaxKind() == TSCSyntaxKind.NoSubstitutionTemplateLiteral) {
            this.skip(delimiter);
        }
        return new JS.TemplateExpression(Tree.randomId(), prefix, markers, delimiter, tag, elements, this.typeMapping.type(node));
    }

    private J visitSwitchStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.SwitchKeyword);
        Space before = this.sourceBefore(TSCSyntaxKind.OpenParenToken);
        J j = this.visitNode(node.getNodeProperty("expression"));
        J.ControlParentheses selector = new J.ControlParentheses(Tree.randomId(), before, Markers.EMPTY, this.padRight(!(j instanceof Expression) && j instanceof Statement ? new JS.StatementExpression(Tree.randomId(), (Statement)j) : (Expression)j, this.sourceBefore(TSCSyntaxKind.CloseParenToken)));
        TSCNode caseBlock = node.getNodeProperty("caseBlock");
        return new J.Switch(Tree.randomId(), prefix, Markers.EMPTY, selector, new J.Block(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.OpenBraceToken), Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), this.convertAll(caseBlock.getNodeListProperty("clauses"), this.noDelim, this.noDelim, true), this.sourceBefore(TSCSyntaxKind.CloseBraceToken)));
    }

    private J.Throw visitThrowStatement(TSCNode node) {
        return new J.Throw(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ThrowKeyword), Markers.EMPTY, (Expression)this.visitNode(node.getNodeProperty("expression")));
    }

    private J.Try visitTryStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.TryKeyword);
        J.Block tryBlock = (J.Block)this.visitNode(node.getNodeProperty("tryBlock"));
        TSCNode catchClause = node.getNodeProperty("catchClause");
        J.Try.Catch aCatch = new J.Try.Catch(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.CatchKeyword), Markers.EMPTY, this.mapControlParentheses(catchClause.getNodeProperty("variableDeclaration")), (J.Block)this.visitNode(catchClause.getNodeProperty("block")));
        JLeftPadded<J.Block> finallyBlock = null;
        TSCNode finallyBlockNode = node.getOptionalNodeProperty("finallyBlock");
        if (finallyBlockNode != null) {
            finallyBlock = this.padLeft(this.sourceBefore(TSCSyntaxKind.FinallyKeyword), (J.Block)this.visitNode(finallyBlockNode));
        }
        return new J.Try(Tree.randomId(), prefix, Markers.EMPTY, null, tryBlock, Collections.singletonList(aCatch), finallyBlock);
    }

    private J visitTupleType(TSCNode node) {
        Space prefix = this.whitespace();
        TSCNodeList nodes = node.getOptionalNodeListProperty("elements");
        JContainer<J> types = this.mapContainer(TSCSyntaxKind.OpenBracketToken, nodes == null ? Collections.emptyList() : nodes, TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseBracketToken, this::visitNode, true);
        return new JS.Tuple(Tree.randomId(), prefix, Markers.EMPTY, types, this.typeMapping.type(node));
    }

    private J visitTypeAliasDeclaration(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        Space before = this.whitespace();
        modifiers.add(this.mapModifier(before, "type", trailing));
        TSCNode nameNode = node.getNodeProperty("name");
        J.Identifier name = (J.Identifier)this.visitNode(nameNode);
        name = name.withType(this.typeMapping.type(nameNode));
        J.TypeParameters typeParameters = this.mapTypeParameters(node.getOptionalNodeListProperty("typeParameters"));
        Space beforeEquals = this.sourceBefore(TSCSyntaxKind.EqualsToken);
        J j = this.visitNode(node.getNodeProperty("type"));
        JLeftPadded<Expression> initializer = this.padLeft(beforeEquals, !(j instanceof Expression) && j instanceof Statement ? new JS.StatementExpression(Tree.randomId(), (Statement)j) : (Expression)j);
        return new JS.TypeDeclaration(Tree.randomId(), prefix, markers, leading, modifiers, name, typeParameters, initializer, this.typeMapping.type(node));
    }

    private JS.JsOperator visitTsOperator(TSCNode node) {
        Space prefix = this.whitespace();
        Expression left = null;
        JLeftPadded<JS.JsOperator.Type> op = null;
        if (node.syntaxKind() == TSCSyntaxKind.AwaitExpression) {
            op = this.padLeft(this.sourceBefore(TSCSyntaxKind.AwaitKeyword), JS.JsOperator.Type.Await);
        } else if (node.syntaxKind() == TSCSyntaxKind.TypeOfExpression) {
            op = this.padLeft(this.sourceBefore(TSCSyntaxKind.TypeOfKeyword), JS.JsOperator.Type.TypeOf);
        } else {
            this.implementMe(node);
        }
        Expression right = (Expression)this.visitNode(node.getNodeProperty("expression"));
        return new JS.JsOperator(Tree.randomId(), prefix, Markers.EMPTY, left, op, right, this.typeMapping.type(node));
    }

    private J visitTypeLiteral(TSCNode node) {
        Space prefix = this.whitespace();
        return this.mapPropertyNodesToNewClass(node.getOptionalNodeListProperty("members"), prefix);
    }

    private JS.TypeOperator visitTypeOperator(TSCNode node) {
        Space prefix = this.whitespace();
        TSCSyntaxKind op = node.getSyntaxKindProperty("operator");
        JS.TypeOperator.Type operator = null;
        Space before = Space.EMPTY;
        if (op == TSCSyntaxKind.ReadonlyKeyword) {
            before = this.sourceBefore(TSCSyntaxKind.ReadonlyKeyword);
            operator = JS.TypeOperator.Type.ReadOnly;
        } else if (op == TSCSyntaxKind.KeyOfKeyword) {
            before = this.sourceBefore(TSCSyntaxKind.KeyOfKeyword);
            operator = JS.TypeOperator.Type.KeyOf;
        } else {
            this.implementMe(node);
        }
        return new JS.TypeOperator(Tree.randomId(), prefix, Markers.EMPTY, operator, this.padLeft(before, (Expression)this.visitNode(node.getNodeProperty("type"))));
    }

    private J.TypeParameter visitTypeParameter(TSCNode node) {
        TSCNode constraint;
        Space prefix = this.whitespace();
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        if (!trailing.isEmpty()) {
            throw new UnsupportedOperationException("Add support for trailing annotations on: " + node.getText());
        }
        this.implementMe(node, "expression");
        TSCNode defaultType = node.getOptionalNodeProperty("default");
        Expression name = (Expression)this.visitNode(node.getNodeProperty("name"));
        if (defaultType != null) {
            name = new JS.DefaultType(Tree.randomId(), name.getPrefix(), Markers.EMPTY, (Expression)name.withPrefix(Space.EMPTY), this.sourceBefore(TSCSyntaxKind.EqualsToken), (Expression)this.visitNode(defaultType), this.typeMapping.type(defaultType));
        }
        JContainer bounds = (constraint = node.getOptionalNodeProperty("constraint")) == null ? null : (constraint.syntaxKind() == TSCSyntaxKind.IntersectionType ? JContainer.build((Space)this.sourceBefore(TSCSyntaxKind.ExtendsKeyword), this.convertAll(constraint.getNodeListProperty("types"), t -> this.sourceBefore(TSCSyntaxKind.AmpersandToken), this.noDelim, true), (Markers)Markers.EMPTY) : JContainer.build((Space)this.sourceBefore(TSCSyntaxKind.ExtendsKeyword), this.convertAll(Collections.singletonList(constraint), t -> this.sourceBefore(TSCSyntaxKind.AmpersandToken), this.noDelim, true), (Markers)Markers.EMPTY));
        return new J.TypeParameter(Tree.randomId(), prefix, Markers.EMPTY, leading.isEmpty() ? Collections.emptyList() : leading, modifiers, name, bounds);
    }

    private J.ParameterizedType visitTypeQuery(TSCNode node) {
        Space prefix = this.whitespace();
        Space typeOfPrefix = this.sourceBefore(TSCSyntaxKind.TypeOfKeyword);
        Expression name = (Expression)this.visitNode(node.getNodeProperty("exprName"));
        JS.JsOperator op = new JS.JsOperator(Tree.randomId(), typeOfPrefix, Markers.EMPTY, null, this.padLeft(Space.EMPTY, JS.JsOperator.Type.TypeOf), name, this.typeMapping.type(node));
        TSCNodeList typeArguments = node.getOptionalNodeListProperty("typeArguments");
        return new J.ParameterizedType(Tree.randomId(), prefix, Markers.EMPTY, (NameTree)op, typeArguments == null ? null : this.mapContainer(TSCSyntaxKind.LessThanToken, typeArguments, TSCSyntaxKind.CommaToken, TSCSyntaxKind.GreaterThanToken, t -> (Expression)this.visitNode((TSCNode)t), true), this.typeMapping.type(node));
    }

    private J.ParameterizedType visitTypeReference(TSCNode node) {
        TSCNodeList typeArguments = node.getOptionalNodeListProperty("typeArguments");
        return new J.ParameterizedType(Tree.randomId(), this.whitespace(), Markers.EMPTY, (NameTree)this.visitNode(node.getNodeProperty("typeName")), typeArguments == null ? null : this.mapContainer(TSCSyntaxKind.LessThanToken, typeArguments, TSCSyntaxKind.CommaToken, TSCSyntaxKind.GreaterThanToken, t -> (Expression)this.visitNode((TSCNode)t), true), this.typeMapping.type(node));
    }

    private J.Unary visitUnaryExpression(TSCNode node) {
        Expression expression;
        Space prefix = this.whitespace();
        JLeftPadded<J.Unary.Type> op = null;
        TSCSyntaxKind opKind = TSCSyntaxKind.fromCode(node.getIntProperty("operator"));
        if (node.syntaxKind() == TSCSyntaxKind.PrefixUnaryExpression) {
            if (opKind == TSCSyntaxKind.ExclamationToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.ExclamationToken), J.Unary.Type.Not);
            } else if (opKind == TSCSyntaxKind.MinusMinusToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.MinusMinusToken), J.Unary.Type.PreDecrement);
            } else if (opKind == TSCSyntaxKind.PlusPlusToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.PlusPlusToken), J.Unary.Type.PreIncrement);
            } else if (opKind == TSCSyntaxKind.MinusToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.MinusToken), J.Unary.Type.Negative);
            } else if (opKind == TSCSyntaxKind.PlusToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.PlusToken), J.Unary.Type.Positive);
            } else {
                this.implementMe(node);
            }
            expression = (Expression)this.visitNode(node.getNodeProperty("operand"));
        } else {
            expression = (Expression)this.visitNode(node.getNodeProperty("operand"));
            if (opKind == TSCSyntaxKind.MinusMinusToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.MinusMinusToken), J.Unary.Type.PostDecrement);
            } else if (opKind == TSCSyntaxKind.PlusPlusToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.PlusPlusToken), J.Unary.Type.PostIncrement);
            } else {
                this.implementMe(node);
            }
        }
        return new J.Unary(Tree.randomId(), prefix, Markers.EMPTY, op, expression, this.typeMapping.type(node));
    }

    private JS.Union visitUnionType(TSCNode node) {
        Space prefix = this.whitespace();
        return new JS.Union(Tree.randomId(), prefix, Markers.EMPTY, this.convertAll(node.getNodeListProperty("types"), t -> this.sourceBefore(TSCSyntaxKind.BarToken), t -> Space.EMPTY, true), (JavaType)TsType.Union);
    }

    private J.VariableDeclarations visitVariableDeclaration(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        int saveCursor = this.getCursor();
        Space beforeVariableModifier = this.whitespace();
        TSCSyntaxKind keyword = this.scan();
        if (keyword == TSCSyntaxKind.ConstKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "const", trailing));
            trailing = null;
        } else if (keyword == TSCSyntaxKind.LetKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "let", trailing));
            trailing = null;
        } else if (keyword == TSCSyntaxKind.VarKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "var", trailing));
            trailing = null;
        } else {
            this.cursor(saveCursor);
        }
        TypeTree typeTree = null;
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> namedVariables = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        Space variablePrefix = this.whitespace();
        J j = this.visitNode(node.getNodeProperty("name"));
        J.Identifier name = null;
        if (j instanceof J.Identifier) {
            name = (J.Identifier)j;
            if (!trailing.isEmpty()) {
                name = name.withAnnotations(trailing);
            }
        } else {
            this.implementMe(node);
        }
        Markers variableMarker = Markers.EMPTY;
        TSCNode type = node.getOptionalNodeProperty("type");
        if (type != null) {
            TSCNode questionToken = node.getOptionalNodeProperty("questionToken");
            TSCNode exclamationToken = node.getOptionalNodeProperty("exclamationToken");
            if (questionToken != null) {
                markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.QuestionToken), PostFixOperator.Operator.Question));
            } else if (exclamationToken != null) {
                markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ExclamationToken), PostFixOperator.Operator.Exclamation));
            }
            Space beforeColon = this.sourceBefore(TSCSyntaxKind.ColonToken);
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), beforeColon));
            typeTree = (TypeTree)this.visitNode(type);
        }
        TSCNode init = node.getOptionalNodeProperty("initializer");
        J.VariableDeclarations.NamedVariable variable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), variablePrefix, variableMarker, name, Collections.emptyList(), init != null ? this.padLeft(this.sourceBefore(TSCSyntaxKind.EqualsToken), (Expression)Objects.requireNonNull(this.visitNode(init))) : null, this.typeMapping.variableType(node));
        namedVariables.add(this.padRight(variable, Space.EMPTY));
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, leading.isEmpty() ? Collections.emptyList() : leading, modifiers.isEmpty() ? Collections.emptyList() : modifiers, typeTree, null, Collections.emptyList(), namedVariables);
    }

    private J.VariableDeclarations visitVariableDeclarationList(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        Space beforeVariableModifier = this.whitespace();
        TSCSyntaxKind keyword = this.scan();
        ArrayList modifiers = new ArrayList();
        if (keyword == TSCSyntaxKind.ConstKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "const", null));
        } else if (keyword == TSCSyntaxKind.LetKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "let", null));
        } else if (keyword == TSCSyntaxKind.VarKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "var", null));
        } else {
            throw new UnsupportedOperationException("Unsupported variable modifier.");
        }
        List namedVariables = Collections.emptyList();
        TypeTree typeTree = null;
        TSCNodeList declarations = node.getOptionalNodeListProperty("declarations");
        if (declarations != null) {
            HashSet<JavaType> types = new HashSet<JavaType>(declarations.size());
            namedVariables = new ArrayList(declarations.size());
            for (int i = 0; i < declarations.size(); ++i) {
                TSCNode declaration = declarations.get(i);
                Space variablePrefix = this.whitespace();
                J j = this.visitNode(declaration.getNodeProperty("name"));
                J.Identifier name = null;
                if (j instanceof J.Identifier) {
                    name = (J.Identifier)j;
                } else {
                    this.implementMe(declaration);
                }
                TSCNode type = declaration.getOptionalNodeProperty("type");
                if (type != null) {
                    TSCNode questionToken = node.getOptionalNodeProperty("questionToken");
                    TSCNode exclamationToken = node.getOptionalNodeProperty("exclamationToken");
                    if (questionToken != null) {
                        markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.QuestionToken), PostFixOperator.Operator.Question));
                    } else if (exclamationToken != null) {
                        markers = markers.addIfAbsent((Marker)new PostFixOperator(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ExclamationToken), PostFixOperator.Operator.Exclamation));
                    }
                    Space beforeColon = this.sourceBefore(TSCSyntaxKind.ColonToken);
                    markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), beforeColon));
                    typeTree = (TypeTree)this.visitNode(type);
                    if (typeTree.getType() != null) {
                        types.add(typeTree.getType());
                        if (types.size() > 1) {
                            throw new UnsupportedOperationException("Multiple variable types are not supported");
                        }
                    }
                }
                TSCNode init = declaration.getOptionalNodeProperty("initializer");
                J.VariableDeclarations.NamedVariable variable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), variablePrefix, Markers.EMPTY, name, Collections.emptyList(), init != null ? this.padLeft(this.sourceBefore(TSCSyntaxKind.EqualsToken), (Expression)Objects.requireNonNull(this.visitNode(init))) : null, this.typeMapping.variableType(declaration));
                Space after = this.whitespace();
                if (i < declarations.size() - 1) {
                    this.consumeToken(TSCSyntaxKind.CommaToken);
                }
                namedVariables.add(this.padRight(variable, after));
            }
        }
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, Collections.emptyList(), modifiers.isEmpty() ? Collections.emptyList() : modifiers, typeTree, null, Collections.emptyList(), namedVariables);
    }

    private J.VariableDeclarations visitVariableStatement(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        this.implementMe(node, "exclamationToken");
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> trailing = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leading, trailing);
        Space beforeVariableModifier = this.whitespace();
        TSCSyntaxKind keyword = this.scan();
        if (keyword == TSCSyntaxKind.ConstKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "const", trailing));
        } else if (keyword == TSCSyntaxKind.LetKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "let", trailing));
        } else if (keyword == TSCSyntaxKind.VarKeyword) {
            modifiers.add(this.mapModifier(beforeVariableModifier, "var", trailing));
        } else {
            throw new UnsupportedOperationException("Unsupported variable modifier.");
        }
        TypeTree typeTree = null;
        TSCNode declarationList = node.getOptionalNodeProperty("declarationList");
        TSCNodeList declarations = declarationList == null ? Collections.emptyList() : declarationList.getNodeListProperty("declarations");
        HashSet<JavaType> types = new HashSet<JavaType>(declarations.size());
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> namedVariables = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(declarations.size());
        for (int i = 0; i < declarations.size(); ++i) {
            TSCNode declaration = (TSCNode)declarations.get(i);
            Space variablePrefix = this.whitespace();
            J j = this.visitNode(declaration.getNodeProperty("name"));
            J.Identifier name = null;
            if (j instanceof J.Identifier) {
                name = (J.Identifier)j;
            } else {
                this.implementMe(declaration);
            }
            TSCNode type = declaration.getOptionalNodeProperty("type");
            if (type != null) {
                Space beforeColon = this.sourceBefore(TSCSyntaxKind.ColonToken);
                markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), beforeColon));
                typeTree = (TypeTree)this.visitNode(type);
                if (typeTree.getType() != null) {
                    types.add(typeTree.getType());
                    if (types.size() > 1) {
                        throw new UnsupportedOperationException("Multiple variable types are not supported");
                    }
                }
            }
            JLeftPadded<Expression> initializer = null;
            TSCNode init = declaration.getOptionalNodeProperty("initializer");
            if (init != null) {
                Space before = this.sourceBefore(TSCSyntaxKind.EqualsToken);
                J element = this.visitNode(init);
                if (!(element instanceof Expression) && element instanceof Statement) {
                    initializer = this.padLeft(before, new JS.StatementExpression(Tree.randomId(), (Statement)element));
                } else if (element instanceof Expression) {
                    initializer = this.padLeft(before, (Expression)element);
                } else {
                    this.implementMe(init);
                }
            }
            J.VariableDeclarations.NamedVariable variable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), variablePrefix, Markers.EMPTY, name, Collections.emptyList(), initializer, this.typeMapping.variableType(declaration));
            Space after = this.whitespace();
            if (i < declarations.size() - 1) {
                this.consumeToken(TSCSyntaxKind.CommaToken);
            }
            namedVariables.add(this.padRight(variable, after));
        }
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, leading.isEmpty() ? Collections.emptyList() : leading, modifiers.isEmpty() ? Collections.emptyList() : modifiers, typeTree, null, Collections.emptyList(), namedVariables);
    }

    private J.WhileLoop visitWhileStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.WhileKeyword);
        J.ControlParentheses control = this.mapControlParentheses(node.getNodeProperty("expression"));
        return new J.WhileLoop(Tree.randomId(), prefix, Markers.EMPTY, control, this.maybeSemicolon((Statement)this.visitNode(node.getNodeProperty("statement"))));
    }

    private J visitYieldExpression(TSCNode node) {
        J j;
        Space prefix = this.sourceBefore(TSCSyntaxKind.YieldKeyword);
        Markers markers = Markers.EMPTY;
        if (node.hasProperty("asteriskToken")) {
            markers = markers.add((Marker)new Asterisk(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.AsteriskToken)));
        }
        Expression expr = !((j = this.visitNode(node.getNodeProperty("expression"))) instanceof Expression) && j instanceof Statement ? new JS.StatementExpression(Tree.randomId(), (Statement)j) : (Expression)j;
        return new J.Yield(Tree.randomId(), prefix, markers, false, expr);
    }

    @Nullable
    private J visitNode(@Nullable TSCNode node) {
        Object j;
        if (node == null) {
            return null;
        }
        switch (node.syntaxKind()) {
            case EnumDeclaration: 
            case InterfaceDeclaration: 
            case ClassDeclaration: 
            case ClassExpression: {
                j = this.visitClassDeclaration(node);
                break;
            }
            case AnyKeyword: 
            case AsyncKeyword: 
            case BooleanKeyword: 
            case DeclareKeyword: 
            case DefaultKeyword: 
            case ExportKeyword: 
            case NumberKeyword: 
            case NullKeyword: 
            case ReadonlyKeyword: 
            case StringKeyword: 
            case SuperKeyword: 
            case ThisKeyword: 
            case UndefinedKeyword: 
            case UnknownKeyword: 
            case VoidKeyword: {
                j = this.visitKeyword(node);
                break;
            }
            case FalseKeyword: 
            case TrueKeyword: {
                j = this.mapKeywordToLiteralType(node);
                break;
            }
            case ForOfStatement: 
            case ForInStatement: {
                j = this.visitForEachStatement(node);
                break;
            }
            case FunctionDeclaration: 
            case FunctionExpression: {
                j = this.visitFunctionDeclaration(node);
                break;
            }
            case ExportSpecifier: 
            case ImportSpecifier: {
                j = this.visitExportSpecifier(node);
                break;
            }
            case ImportEqualsDeclaration: 
            case ImportDeclaration: {
                j = this.visitImportDeclaration(node);
                break;
            }
            case CallSignature: 
            case MethodDeclaration: 
            case MethodSignature: {
                j = this.visitMethodDeclaration(node);
                break;
            }
            case BindingElement: 
            case Parameter: 
            case PropertyDeclaration: {
                j = this.visitPropertyDeclaration(node);
                break;
            }
            case NoSubstitutionTemplateLiteral: 
            case TaggedTemplateExpression: 
            case TemplateExpression: {
                j = this.visitTemplateExpression(node);
                break;
            }
            case AwaitExpression: 
            case TypeOfExpression: {
                j = this.visitTsOperator(node);
                break;
            }
            case PostfixUnaryExpression: 
            case PrefixUnaryExpression: {
                j = this.visitUnaryExpression(node);
                break;
            }
            case PropertySignature: 
            case VariableDeclaration: {
                j = this.visitVariableDeclaration(node);
                break;
            }
            case ArrayBindingPattern: {
                j = this.visitArrayBindingPattern(node);
                break;
            }
            case ArrowFunction: {
                j = this.visitArrowFunction(node);
                break;
            }
            case ArrayLiteralExpression: {
                j = this.visitArrayLiteralExpression(node);
                break;
            }
            case ArrayType: {
                j = this.mapArrayType(node);
                break;
            }
            case AsExpression: {
                j = this.visitAsExpression(node);
                break;
            }
            case BinaryExpression: {
                j = this.visitBinaryExpression(node);
                break;
            }
            case Block: {
                j = this.visitBlock(node);
                break;
            }
            case BreakStatement: {
                j = this.visitBreakStatement(node);
                break;
            }
            case CallExpression: {
                j = this.visitCallExpression(node);
                break;
            }
            case CaseClause: {
                j = this.visitCaseClause(node);
                break;
            }
            case ConditionalExpression: {
                j = this.visitConditionalExpression(node);
                break;
            }
            case ContinueStatement: {
                j = this.visitContinueStatement(node);
                break;
            }
            case Constructor: {
                j = this.visitConstructor(node);
                break;
            }
            case Decorator: {
                j = this.visitDecorator(node);
                break;
            }
            case DefaultClause: {
                j = this.visitDefaultClause(node);
                break;
            }
            case DeleteExpression: {
                j = this.visitDeleteExpression(node);
                break;
            }
            case DoStatement: {
                j = this.visitDoStatement(node);
                break;
            }
            case ElementAccessExpression: {
                j = this.visitElementAccessExpression(node);
                break;
            }
            case EmptyStatement: {
                j = this.visitEmptyStatement(node);
                break;
            }
            case EnumMember: {
                j = this.visitEnumMember(node);
                break;
            }
            case ExportAssignment: {
                j = this.visitExportAssignment(node);
                break;
            }
            case ExportDeclaration: {
                j = this.visitExportDeclaration(node);
                break;
            }
            case ExpressionStatement: {
                j = this.visitExpressionStatement(node);
                break;
            }
            case ExpressionWithTypeArguments: {
                j = this.visitExpressionWithTypeArguments(node);
                break;
            }
            case ExternalModuleReference: {
                j = this.visitExternalModuleReference(node);
                break;
            }
            case Identifier: {
                j = this.visitIdentifier(node);
                break;
            }
            case IfStatement: {
                j = this.visitIfStatement(node);
                break;
            }
            case IndexedAccessType: {
                j = this.visitIndexedAccessType(node);
                break;
            }
            case ForStatement: {
                j = this.visitForStatement(node);
                break;
            }
            case FunctionType: {
                j = this.visitFunctionType(node);
                break;
            }
            case LabeledStatement: {
                j = this.visitLabelledStatement(node);
                break;
            }
            case LiteralType: {
                j = this.visitLiteralType(node);
                break;
            }
            case MetaProperty: {
                j = this.visitMetaProperty(node);
                break;
            }
            case NewExpression: {
                j = this.visitNewExpression(node);
                break;
            }
            case NumericLiteral: {
                j = this.visitNumericLiteral(node);
                break;
            }
            case ObjectLiteralExpression: {
                j = this.visitObjectLiteralExpression(node);
                break;
            }
            case ParenthesizedExpression: {
                j = this.visitParenthesizedExpression(node);
                break;
            }
            case PropertyAccessExpression: {
                j = this.visitPropertyAccessExpression(node);
                break;
            }
            case PropertyAssignment: {
                j = this.visitPropertyAssignment(node);
                break;
            }
            case QualifiedName: {
                j = this.visitQualifiedName(node);
                break;
            }
            case RegularExpressionLiteral: {
                j = this.visitRegularExpressionLiteral(node);
                break;
            }
            case ReturnStatement: {
                j = this.visitReturnStatement(node);
                break;
            }
            case SpreadElement: {
                j = this.visitSpreadElement(node);
                break;
            }
            case StringLiteral: {
                j = this.visitStringLiteral(node);
                break;
            }
            case SwitchStatement: {
                j = this.visitSwitchStatement(node);
                break;
            }
            case ThrowStatement: {
                j = this.visitThrowStatement(node);
                break;
            }
            case TryStatement: {
                j = this.visitTryStatement(node);
                break;
            }
            case TupleType: {
                j = this.visitTupleType(node);
                break;
            }
            case TypeAliasDeclaration: {
                j = this.visitTypeAliasDeclaration(node);
                break;
            }
            case TypeLiteral: {
                j = this.visitTypeLiteral(node);
                break;
            }
            case TypeOperator: {
                j = this.visitTypeOperator(node);
                break;
            }
            case TypeParameter: {
                j = this.visitTypeParameter(node);
                break;
            }
            case TypeQuery: {
                j = this.visitTypeQuery(node);
                break;
            }
            case TypeReference: {
                j = this.visitTypeReference(node);
                break;
            }
            case UnionType: {
                j = this.visitUnionType(node);
                break;
            }
            case VariableDeclarationList: {
                j = this.visitVariableDeclarationList(node);
                break;
            }
            case VariableStatement: {
                j = this.mapVariableStatement(node);
                break;
            }
            case WhileStatement: {
                j = this.visitWhileStatement(node);
                break;
            }
            case YieldExpression: {
                j = this.visitYieldExpression(node);
                break;
            }
            default: {
                this.implementMe(node);
                j = null;
            }
        }
        return j;
    }

    private Integer getCursor() {
        return this.cursorContext.scannerTokenEnd();
    }

    private void skip(String text) {
        if (this.sourceStartsWithAtCursor(text)) {
            this.cursor(this.getCursor() + text.length());
        }
    }

    private void cursor(int cursor) {
        this.cursorContext.resetScanner(cursor);
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    private <T> JRightPadded<T> padRight(T tree, @Nullable Space right) {
        return new JRightPadded(tree, right == null ? Space.EMPTY : right, Markers.EMPTY);
    }

    private <T> JRightPadded<T> padRight(T tree, @Nullable Space right, Markers markers) {
        return new JRightPadded(tree, right == null ? Space.EMPTY : right, markers);
    }

    private <K2 extends J> JRightPadded<K2> maybeSemicolon(K2 k) {
        return this.tryConsumeWithPrefix(TSCSyntaxKind.SemicolonToken, prefix -> new JRightPadded((Object)k, prefix, Markers.EMPTY.add((Marker)new Semicolon(Tree.randomId())))).orElseGet(() -> JRightPadded.build((Object)k));
    }

    private boolean tryConsume(TSCSyntaxKind kind) {
        int saveCursor = this.getCursor();
        if (this.scan() == kind) {
            return true;
        }
        this.cursorContext.resetScanner(saveCursor);
        return false;
    }

    private <T> Optional<T> tryConsumeWithPrefix(TSCSyntaxKind kind, Function<Space, T> whenMatched) {
        int saveCursor = this.getCursor();
        Space prefix = this.whitespace();
        if (this.scan() == kind) {
            return Optional.of(whenMatched.apply(prefix));
        }
        this.cursorContext.resetScanner(saveCursor);
        return Optional.empty();
    }

    private TSCSyntaxKind scan() {
        return this.cursorContext.nextScannerSyntaxType();
    }

    private String lastToken() {
        return this.cursorContext.scannerTokenText();
    }

    private void consumeToken(TSCSyntaxKind kind) {
        TSCSyntaxKind actual = this.scan();
        if (kind != actual) {
            throw new IllegalStateException(String.format("expected kind '%s'; found '%s' at position %d", new Object[]{kind, actual, this.cursorContext.scannerTokenStart()}));
        }
    }

    private <J2 extends J> List<JRightPadded<J2>> convertAll(List<TSCNode> elements, Function<TSCNode, Space> innerSuffix, Function<TSCNode, Space> suffix) {
        return this.convertAll(elements, innerSuffix, suffix, false);
    }

    private <J2 extends J> List<JRightPadded<J2>> convertAll(List<TSCNode> elements, Function<TSCNode, Space> innerSuffix, Function<TSCNode, Space> suffix, boolean enableParseErrorRecovery) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList converted = new ArrayList(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            Space after;
            J j;
            TSCNode element = elements.get(i);
            int saveCursor = this.getCursor();
            try {
                j = this.visitNode(element);
            }
            catch (Exception e) {
                if (!enableParseErrorRecovery) {
                    throw new JavaScriptParsingException("Unable to parse JavaScript", e);
                }
                this.cursor(saveCursor);
                Space prefix = this.whitespace();
                String text = element.getText();
                this.skip(text);
                j = new J.Unknown(Tree.randomId(), prefix, Markers.EMPTY, new J.Unknown.Source(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(ParseExceptionResult.build((Parser)JavaScriptParser.builder().build(), (Throwable)e).withTreeType(element.syntaxKind().name()))), text));
            }
            Space space = after = i == elements.size() - 1 ? suffix.apply(element) : innerSuffix.apply(element);
            if (j == null && i < elements.size() - 1) continue;
            if (j == null) {
                j = new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
            }
            JRightPadded<J> rightPadded = this.padRight(j, after);
            converted.add(rightPadded);
        }
        return converted.isEmpty() ? Collections.emptyList() : converted;
    }

    private J.Identifier convertToIdentifier(Space prefix, String simpleName) {
        return new J.Identifier(Tree.randomId(), prefix, Markers.EMPTY, Collections.emptyList(), simpleName, null, null);
    }

    private J.Literal mapKeywordToLiteralType(TSCNode node) {
        JavaType.Primitive primitiveType;
        String valueSource;
        Boolean value;
        Space prefix = this.sourceBefore(node.syntaxKind());
        if (node.syntaxKind() == TSCSyntaxKind.TrueKeyword) {
            value = true;
            valueSource = "true";
            primitiveType = JavaType.Primitive.Boolean;
        } else if (node.syntaxKind() == TSCSyntaxKind.FalseKeyword) {
            value = false;
            valueSource = "false";
            primitiveType = JavaType.Primitive.Boolean;
        } else {
            throw new IllegalArgumentException("Cannot convert node to literal type: " + (Object)((Object)node.syntaxKind()));
        }
        return new J.Literal(Tree.randomId(), prefix, Markers.EMPTY, (Object)value, valueSource, null, primitiveType);
    }

    private <T extends J> JContainer<T> mapContainer(TSCSyntaxKind open, List<TSCNode> nodes, @Nullable TSCSyntaxKind delimiter, TSCSyntaxKind close, Function<TSCNode, T> visitFn) {
        return this.mapContainer(open, nodes, delimiter, close, visitFn, false);
    }

    private <T extends J> JContainer<T> mapContainer(TSCSyntaxKind open, List<TSCNode> nodes, @Nullable TSCSyntaxKind delimiter, TSCSyntaxKind close, Function<TSCNode, T> visitFn, boolean withUnknown) {
        List<Object> elements;
        Space containerPrefix = this.sourceBefore(open);
        if (nodes.isEmpty()) {
            Space withinContainerSpace = this.whitespace();
            elements = Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), withinContainerSpace, Markers.EMPTY)));
        } else {
            elements = new ArrayList(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                J visited;
                TSCNode node = nodes.get(i);
                int saveCursor = this.getCursor();
                try {
                    visited = (J)visitFn.apply(node);
                }
                catch (Exception e) {
                    if (withUnknown) {
                        this.cursor(saveCursor);
                        Space prefix = this.whitespace();
                        String text = node.getText();
                        this.skip(text);
                        visited = new J.Unknown(Tree.randomId(), prefix, Markers.EMPTY, new J.Unknown.Source(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(ParseExceptionResult.build((Parser)JavaScriptParser.builder().build(), (Throwable)e).withTreeType(node.syntaxKind().name()))), text));
                    }
                    throw e;
                }
                Markers markers = Markers.EMPTY;
                Space after = Space.EMPTY;
                if (delimiter != null) {
                    if (i < nodes.size() - 1) {
                        after = this.sourceBefore(delimiter);
                    } else if (delimiter == TSCSyntaxKind.CommaToken) {
                        after = this.whitespace();
                        if (this.tryConsume(TSCSyntaxKind.CommaToken)) {
                            markers = markers.add((Marker)new TrailingComma(Tree.randomId(), this.whitespace()));
                        }
                    } else {
                        after = this.whitespace();
                    }
                }
                elements.add(JRightPadded.build((Object)visited).withAfter(after).withMarkers(markers));
            }
        }
        this.consumeToken(close);
        return JContainer.build((Space)containerPrefix, elements, (Markers)Markers.EMPTY);
    }

    private <J2 extends J> J.ControlParentheses<J2> mapControlParentheses(TSCNode node) {
        return new J.ControlParentheses(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.OpenParenToken), Markers.EMPTY, this.padRight(this.visitNode(node), this.sourceBefore(TSCSyntaxKind.CloseParenToken)));
    }

    private J.ArrayType mapArrayType(TSCNode node) {
        Space prefix = this.whitespace();
        int dimensionsCount = 1;
        TSCNode curElement = node.getNodeProperty("elementType");
        while (curElement.syntaxKind() == TSCSyntaxKind.ArrayType) {
            ++dimensionsCount;
            curElement = curElement.getNodeProperty("elementType");
        }
        TypeTree typeTree = (TypeTree)this.visitNode(curElement);
        ArrayList<JRightPadded<Space>> dimensions = new ArrayList<JRightPadded<Space>>(dimensionsCount);
        for (int i = 0; i < dimensionsCount; ++i) {
            Space before = this.sourceBefore(TSCSyntaxKind.OpenBracketToken);
            dimensions.add(this.padRight(before, this.sourceBefore(TSCSyntaxKind.CloseBracketToken)));
        }
        return new J.ArrayType(Tree.randomId(), prefix, Markers.EMPTY, typeTree, dimensions);
    }

    private List<J.Modifier> mapModifiers(@Nullable List<TSCNode> nodes, List<J.Annotation> leadingAnnotations, List<J.Annotation> trailingAnnotations) {
        if (nodes == null) {
            return new ArrayList<J.Modifier>();
        }
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>(nodes.size());
        ArrayList<J.Annotation> leading = new ArrayList<J.Annotation>();
        ArrayList trailing = null;
        block10: for (TSCNode node : nodes) {
            Space prefix = this.whitespace();
            switch (node.syntaxKind()) {
                case Decorator: {
                    J.Annotation annotation = (J.Annotation)this.visitNode(node);
                    if (leading != null) {
                        leading.add(annotation);
                        continue block10;
                    }
                    if (trailing == null) {
                        trailing = new ArrayList(1);
                        continue block10;
                    }
                    trailing.add(annotation);
                    continue block10;
                }
                case DeclareKeyword: 
                case DefaultKeyword: 
                case ExportKeyword: 
                case ReadonlyKeyword: {
                    if (!leading.isEmpty()) {
                        leadingAnnotations.addAll(leading);
                        leading = null;
                    }
                    modifiers.add(this.mapModifier(prefix, node.getText(), trailing));
                    trailing = null;
                    continue block10;
                }
                case AbstractKeyword: {
                    if (!leading.isEmpty()) {
                        leadingAnnotations.addAll(leading);
                        leading = null;
                    }
                    this.consumeToken(TSCSyntaxKind.AbstractKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, null, J.Modifier.Type.Abstract, trailing == null ? Collections.emptyList() : trailing));
                    trailing = null;
                    continue block10;
                }
                case AsyncKeyword: {
                    if (!leading.isEmpty()) {
                        leadingAnnotations.addAll(leading);
                        leading = null;
                    }
                    this.consumeToken(TSCSyntaxKind.AsyncKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, null, J.Modifier.Type.Async, trailing == null ? Collections.emptyList() : trailing));
                    trailing = null;
                    continue block10;
                }
                case PublicKeyword: {
                    if (!leading.isEmpty()) {
                        leadingAnnotations.addAll(leading);
                        leading = null;
                    }
                    this.consumeToken(TSCSyntaxKind.PublicKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, null, J.Modifier.Type.Public, trailing == null ? Collections.emptyList() : trailing));
                    trailing = null;
                    continue block10;
                }
                case PrivateKeyword: {
                    if (!leading.isEmpty()) {
                        leadingAnnotations.addAll(leading);
                        leading = null;
                    }
                    this.consumeToken(TSCSyntaxKind.PrivateKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, null, J.Modifier.Type.Private, trailing == null ? Collections.emptyList() : trailing));
                    trailing = null;
                    continue block10;
                }
                case ProtectedKeyword: {
                    if (!leading.isEmpty()) {
                        leadingAnnotations.addAll(leading);
                        leading = null;
                    }
                    this.consumeToken(TSCSyntaxKind.ProtectedKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, null, J.Modifier.Type.Protected, trailing == null ? Collections.emptyList() : trailing));
                    trailing = null;
                    continue block10;
                }
                case StaticKeyword: {
                    if (!leading.isEmpty()) {
                        leadingAnnotations.addAll(leading);
                        leading = null;
                    }
                    this.consumeToken(TSCSyntaxKind.StaticKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, null, J.Modifier.Type.Static, trailing == null ? Collections.emptyList() : trailing));
                    trailing = null;
                    continue block10;
                }
            }
            this.implementMe(node);
        }
        if (leading != null) {
            leadingAnnotations.addAll(leading);
        }
        if (trailing != null) {
            trailingAnnotations.addAll(trailing);
        }
        return modifiers.isEmpty() ? new ArrayList<J.Modifier>() : modifiers;
    }

    @Nullable
    private J.TypeParameters mapTypeParameters(@Nullable List<TSCNode> typeParameters) {
        return typeParameters == null ? null : new J.TypeParameters(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.LessThanToken), Markers.EMPTY, Collections.emptyList(), this.convertAll(typeParameters, this.commaDelim, t -> this.sourceBefore(TSCSyntaxKind.GreaterThanToken)));
    }

    private J mapVariableStatement(TSCNode node) {
        TSCNodeList declarations;
        TSCNode declarationList = node.getOptionalNodeProperty("declarationList");
        TSCNodeList tSCNodeList = declarations = declarationList == null ? Collections.emptyList() : declarationList.getNodeListProperty("declarations");
        if (declarationList != null) {
            for (TSCNode declaration : declarations) {
                TSCNode name;
                if (declaration.syntaxKind() != TSCSyntaxKind.VariableDeclaration || (name = declaration.getOptionalNodeProperty("name")) == null || name.syntaxKind() != TSCSyntaxKind.ObjectBindingPattern) continue;
                return this.mapObjectBindingDeclaration(node);
            }
        }
        return this.visitVariableStatement(node);
    }

    private boolean sourceStartsWithAtCursor(String text) {
        return this.sourceText.startsWith(text, this.getCursor());
    }

    private Space sourceBefore(TSCSyntaxKind syntaxKind) {
        Space prefix = this.whitespace();
        this.consumeToken(syntaxKind);
        return prefix;
    }

    private J.Modifier mapModifier(Space prefix, String name, @Nullable List<J.Annotation> annotations) {
        this.skip(name);
        return new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, name, J.Modifier.Type.LanguageExtension, annotations == null ? Collections.emptyList() : annotations);
    }

    private J.NewClass mapPropertyNodesToNewClass(List<TSCNode> propertyNodes, Space prefix) {
        return new J.NewClass(Tree.randomId(), prefix, Markers.build(Collections.singletonList(new ObjectLiteral(Tree.randomId()))), null, Space.EMPTY, null, this.mapContainer(TSCSyntaxKind.OpenBraceToken, propertyNodes, TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseBraceToken, x -> (Expression)this.convertToExpression(this.visitNode((TSCNode)x)), true), null, null);
    }

    private <J2 extends J> J2 convertToExpression(J j) {
        if (j instanceof Statement && !(j instanceof Expression)) {
            j = new JS.StatementExpression(Tree.randomId(), (Statement)j);
        }
        return (J2)j;
    }

    private Space whitespace() {
        StringBuilder initialSpace = null;
        List comments = Collections.emptyList();
        boolean done = false;
        do {
            TSCSyntaxKind kind = this.scan();
            switch (kind) {
                case WhitespaceTrivia: 
                case NewLineTrivia: {
                    if (comments.isEmpty()) {
                        if (initialSpace == null) {
                            initialSpace = new StringBuilder();
                        }
                        initialSpace.append(this.lastToken());
                        break;
                    }
                    Comment lastComment = (Comment)comments.get(comments.size() - 1);
                    comments.set(comments.size() - 1, lastComment.withSuffix(lastComment.getSuffix() + this.lastToken()));
                    break;
                }
                case SingleLineCommentTrivia: 
                case MultiLineCommentTrivia: {
                    String commentText = this.lastToken();
                    commentText = commentText.substring(2, kind == TSCSyntaxKind.SingleLineCommentTrivia ? commentText.length() : commentText.length() - 2);
                    TextComment comment = new TextComment(kind == TSCSyntaxKind.MultiLineCommentTrivia, commentText, "", Markers.EMPTY);
                    if (comments.isEmpty()) {
                        comments = new ArrayList(1);
                        comments.add(comment);
                        break;
                    }
                    comments.add(comment);
                    break;
                }
                default: {
                    this.cursor(this.cursorContext.scannerTokenStart());
                    done = true;
                }
            }
        } while (!done);
        return Space.build((String)(initialSpace == null ? null : initialSpace.toString()), comments);
    }

    private J unknown(TSCNode node) {
        Space prefix = this.whitespace();
        String text = node.getText();
        this.skip(text);
        return new J.Unknown(Tree.randomId(), prefix, Markers.EMPTY, new J.Unknown.Source(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(ParseExceptionResult.build((Parser)JavaScriptParser.builder().build(), (Throwable)new UnsupportedOperationException(node.syntaxKind().name() + " not implemented")).withTreeType(node.syntaxKind().name()))), text));
    }

    private void implementMe(TSCNode node) {
        throw new UnsupportedOperationException((Object)((Object)node.syntaxKind()) + " not implemented");
    }

    private void implementMe(TSCNode node, String propertyName) {
        if (node.hasProperty(propertyName)) {
            throw new UnsupportedOperationException((Object)((Object)node.syntaxKind()) + "#" + propertyName + " not implemented");
        }
    }
}

