/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc.generated;

public enum TSCNodeFlag {
    None(0),
    Let(1),
    Const(2),
    Using(4),
    AwaitUsing(6),
    NestedNamespace(8),
    Synthesized(16),
    Namespace(32),
    OptionalChain(64),
    ExportContext(128),
    ContainsThis(256),
    HasImplicitReturn(512),
    HasExplicitReturn(1024),
    GlobalAugmentation(2048),
    HasAsyncFunctions(4096),
    DisallowInContext(8192),
    YieldContext(16384),
    DecoratorContext(32768),
    AwaitContext(65536),
    DisallowConditionalTypesContext(131072),
    ThisNodeHasError(262144),
    JavaScriptFile(524288),
    ThisNodeOrAnySubNodesHasError(0x100000),
    HasAggregatedChildData(0x200000),
    PossiblyContainsDynamicImport(0x400000),
    PossiblyContainsImportMeta(0x800000),
    JSDoc(0x1000000),
    Ambient(0x2000000),
    InWithStatement(0x4000000),
    JsonFile(0x8000000),
    TypeCached(0x10000000),
    Deprecated(0x20000000),
    BlockScoped(7),
    ReachabilityCheckFlags(1536),
    ReachabilityAndEmitFlags(5632),
    ContextFlags(101441536),
    TypeExcludesFlags(81920),
    PermanentlySetIncrementalFlags(0xC00000);

    public final int code;

    private TSCNodeFlag(int code) {
        this.code = code;
    }

    public static TSCNodeFlag fromMaskExact(int code) {
        switch (code) {
            case 0: {
                return None;
            }
            case 1: {
                return Let;
            }
            case 2: {
                return Const;
            }
            case 4: {
                return Using;
            }
            case 6: {
                return AwaitUsing;
            }
            case 8: {
                return NestedNamespace;
            }
            case 16: {
                return Synthesized;
            }
            case 32: {
                return Namespace;
            }
            case 64: {
                return OptionalChain;
            }
            case 128: {
                return ExportContext;
            }
            case 256: {
                return ContainsThis;
            }
            case 512: {
                return HasImplicitReturn;
            }
            case 1024: {
                return HasExplicitReturn;
            }
            case 2048: {
                return GlobalAugmentation;
            }
            case 4096: {
                return HasAsyncFunctions;
            }
            case 8192: {
                return DisallowInContext;
            }
            case 16384: {
                return YieldContext;
            }
            case 32768: {
                return DecoratorContext;
            }
            case 65536: {
                return AwaitContext;
            }
            case 131072: {
                return DisallowConditionalTypesContext;
            }
            case 262144: {
                return ThisNodeHasError;
            }
            case 524288: {
                return JavaScriptFile;
            }
            case 0x100000: {
                return ThisNodeOrAnySubNodesHasError;
            }
            case 0x200000: {
                return HasAggregatedChildData;
            }
            case 0x400000: {
                return PossiblyContainsDynamicImport;
            }
            case 0x800000: {
                return PossiblyContainsImportMeta;
            }
            case 0x1000000: {
                return JSDoc;
            }
            case 0x2000000: {
                return Ambient;
            }
            case 0x4000000: {
                return InWithStatement;
            }
            case 0x8000000: {
                return JsonFile;
            }
            case 0x10000000: {
                return TypeCached;
            }
            case 0x20000000: {
                return Deprecated;
            }
            case 7: {
                return BlockScoped;
            }
            case 1536: {
                return ReachabilityCheckFlags;
            }
            case 5632: {
                return ReachabilityAndEmitFlags;
            }
            case 101441536: {
                return ContextFlags;
            }
            case 81920: {
                return TypeExcludesFlags;
            }
            case 0xC00000: {
                return PermanentlySetIncrementalFlags;
            }
        }
        throw new IllegalArgumentException("unknown TSCNodeFlag code: " + code);
    }

    public boolean matches(int bitfield) {
        return (bitfield & this.code) != 0;
    }

    public static int union(TSCNodeFlag ... args) {
        int result = 0;
        for (TSCNodeFlag arg : args) {
            result |= arg.code;
        }
        return result;
    }
}

