/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCV8Backed;

public class TSCNodeList
implements TSCV8Backed,
List<TSCNode> {
    private final TSCProgramContext programContext;
    private final V8ValueArray arrayV8;

    public static TSCNodeList wrap(TSCProgramContext programContext, V8ValueObject maybeArrayV8) {
        if (!(maybeArrayV8 instanceof V8ValueArray)) {
            throw new IllegalArgumentException("expected a v8 array");
        }
        return new TSCNodeList(programContext, (V8ValueArray)maybeArrayV8);
    }

    private TSCNodeList(TSCProgramContext programContext, V8ValueArray arrayV8) {
        this.programContext = programContext;
        this.arrayV8 = arrayV8;
    }

    @Override
    public TSCProgramContext getProgramContext() {
        return this.programContext;
    }

    public V8ValueArray getBackingV8Object() {
        return this.arrayV8;
    }

    @Override
    public int size() {
        try {
            return this.arrayV8.getLength();
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<TSCNode> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] array = new Object[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public <T2> T2[] toArray(T2[] array) {
        int size = this.size();
        if (array.length < size) {
            array = Arrays.copyOf(array, size);
        }
        for (int i = 0; i < size; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public boolean add(TSCNode tscNode) {
        throw new UnsupportedOperationException("node list is not modifiable");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("node list is not modifiable");
    }

    @Override
    public boolean containsAll(Collection<?> args) {
        for (Object arg : args) {
            if (this.contains(arg)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends TSCNode> c) {
        throw new UnsupportedOperationException("node list is not modifiable");
    }

    @Override
    public boolean addAll(int index, Collection<? extends TSCNode> c) {
        throw new UnsupportedOperationException("node list is not modifiable");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("node list is not modifiable");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("node list is not modifiable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("node list is not modifiable");
    }

    @Override
    public TSCNode get(int index) {
        TSCNode tSCNode;
        block8: {
            V8Value childV8 = this.arrayV8.get(index);
            try {
                tSCNode = this.programContext.tscNode((V8ValueObject)childV8);
                if (childV8 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (childV8 != null) {
                        try {
                            childV8.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JavetException e) {
                    throw new RuntimeException(e);
                }
            }
            childV8.close();
        }
        return tSCNode;
    }

    @Override
    public TSCNode set(int index, TSCNode element) {
        throw new UnsupportedOperationException("node list is not modifiable");
    }

    @Override
    public void add(int index, TSCNode element) {
        throw new UnsupportedOperationException("node list is not modifiable");
    }

    @Override
    public TSCNode remove(int index) {
        throw new UnsupportedOperationException("node list is not modifiable");
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof TSCNode)) {
            return -1;
        }
        TSCNode node = (TSCNode)o;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.get(i) != node) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof TSCNode)) {
            return -1;
        }
        TSCNode node = (TSCNode)o;
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            if (this.get(i) != node) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<TSCNode> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<TSCNode> listIterator(final int startIndex) {
        return new ListIterator<TSCNode>(){
            final int size;
            int cursor;
            {
                this.size = TSCNodeList.this.size();
                this.cursor = startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.size;
            }

            @Override
            public TSCNode next() {
                return TSCNodeList.this.get(this.cursor++);
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            @Override
            public TSCNode previous() {
                return TSCNodeList.this.get(--this.cursor);
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("node list is not modifiable");
            }

            @Override
            public void set(TSCNode tscNode) {
                throw new UnsupportedOperationException("node list is not modifiable");
            }

            @Override
            public void add(TSCNode tscNode) {
                throw new UnsupportedOperationException("node list is not modifiable");
            }
        };
    }

    @Override
    public List<TSCNode> subList(int fromIndex, int toIndex) {
        ArrayList<TSCNode> result = new ArrayList<TSCNode>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(this.get(i));
        }
        return result;
    }
}

