/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc.generated;

public enum TSCModifierFlag {
    None(0),
    Export(1),
    Ambient(2),
    Public(4),
    Private(8),
    Protected(16),
    Static(32),
    Readonly(64),
    Accessor(128),
    Abstract(256),
    Async(512),
    Default(1024),
    Const(2048),
    HasComputedJSDocModifiers(4096),
    Deprecated(8192),
    Override(16384),
    In(32768),
    Out(65536),
    Decorator(131072),
    HasComputedFlags(0x20000000),
    AccessibilityModifier(28),
    ParameterPropertyModifier(16476),
    NonPublicAccessibilityModifier(24),
    TypeScriptModifier(117086),
    ExportDefault(1025),
    All(258047),
    Modifier(126975);

    public final int code;

    private TSCModifierFlag(int code) {
        this.code = code;
    }

    public static TSCModifierFlag fromMaskExact(int code) {
        switch (code) {
            case 0: {
                return None;
            }
            case 1: {
                return Export;
            }
            case 2: {
                return Ambient;
            }
            case 4: {
                return Public;
            }
            case 8: {
                return Private;
            }
            case 16: {
                return Protected;
            }
            case 32: {
                return Static;
            }
            case 64: {
                return Readonly;
            }
            case 128: {
                return Accessor;
            }
            case 256: {
                return Abstract;
            }
            case 512: {
                return Async;
            }
            case 1024: {
                return Default;
            }
            case 2048: {
                return Const;
            }
            case 4096: {
                return HasComputedJSDocModifiers;
            }
            case 8192: {
                return Deprecated;
            }
            case 16384: {
                return Override;
            }
            case 32768: {
                return In;
            }
            case 65536: {
                return Out;
            }
            case 131072: {
                return Decorator;
            }
            case 0x20000000: {
                return HasComputedFlags;
            }
            case 28: {
                return AccessibilityModifier;
            }
            case 16476: {
                return ParameterPropertyModifier;
            }
            case 24: {
                return NonPublicAccessibilityModifier;
            }
            case 117086: {
                return TypeScriptModifier;
            }
            case 1025: {
                return ExportDefault;
            }
            case 258047: {
                return All;
            }
            case 126975: {
                return Modifier;
            }
        }
        throw new IllegalArgumentException("unknown TSCModifierFlag code: " + code);
    }

    public boolean matches(int bitfield) {
        return (bitfield & this.code) != 0;
    }

    public static int union(TSCModifierFlag ... args) {
        int result = 0;
        for (TSCModifierFlag arg : args) {
            result |= arg.code;
        }
        return result;
    }
}

