/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc.generated;

public enum TSCNodeFlag {
    None(0),
    Let(1),
    Const(2),
    NestedNamespace(4),
    Synthesized(8),
    Namespace(16),
    OptionalChain(32),
    ExportContext(64),
    ContainsThis(128),
    HasImplicitReturn(256),
    HasExplicitReturn(512),
    GlobalAugmentation(1024),
    HasAsyncFunctions(2048),
    DisallowInContext(4096),
    YieldContext(8192),
    DecoratorContext(16384),
    AwaitContext(32768),
    DisallowConditionalTypesContext(65536),
    ThisNodeHasError(131072),
    JavaScriptFile(262144),
    ThisNodeOrAnySubNodesHasError(524288),
    HasAggregatedChildData(0x100000),
    PossiblyContainsDynamicImport(0x200000),
    PossiblyContainsImportMeta(0x400000),
    JSDoc(0x800000),
    Ambient(0x1000000),
    InWithStatement(0x2000000),
    JsonFile(0x4000000),
    TypeCached(0x8000000),
    Deprecated(0x10000000),
    BlockScoped(3),
    ReachabilityCheckFlags(768),
    ReachabilityAndEmitFlags(2816),
    ContextFlags(50720768),
    TypeExcludesFlags(40960),
    PermanentlySetIncrementalFlags(0x600000);

    public final int code;

    private TSCNodeFlag(int code) {
        this.code = code;
    }

    public static TSCNodeFlag fromMaskExact(int code) {
        switch (code) {
            case 0: {
                return None;
            }
            case 1: {
                return Let;
            }
            case 2: {
                return Const;
            }
            case 4: {
                return NestedNamespace;
            }
            case 8: {
                return Synthesized;
            }
            case 16: {
                return Namespace;
            }
            case 32: {
                return OptionalChain;
            }
            case 64: {
                return ExportContext;
            }
            case 128: {
                return ContainsThis;
            }
            case 256: {
                return HasImplicitReturn;
            }
            case 512: {
                return HasExplicitReturn;
            }
            case 1024: {
                return GlobalAugmentation;
            }
            case 2048: {
                return HasAsyncFunctions;
            }
            case 4096: {
                return DisallowInContext;
            }
            case 8192: {
                return YieldContext;
            }
            case 16384: {
                return DecoratorContext;
            }
            case 32768: {
                return AwaitContext;
            }
            case 65536: {
                return DisallowConditionalTypesContext;
            }
            case 131072: {
                return ThisNodeHasError;
            }
            case 262144: {
                return JavaScriptFile;
            }
            case 524288: {
                return ThisNodeOrAnySubNodesHasError;
            }
            case 0x100000: {
                return HasAggregatedChildData;
            }
            case 0x200000: {
                return PossiblyContainsDynamicImport;
            }
            case 0x400000: {
                return PossiblyContainsImportMeta;
            }
            case 0x800000: {
                return JSDoc;
            }
            case 0x1000000: {
                return Ambient;
            }
            case 0x2000000: {
                return InWithStatement;
            }
            case 0x4000000: {
                return JsonFile;
            }
            case 0x8000000: {
                return TypeCached;
            }
            case 0x10000000: {
                return Deprecated;
            }
            case 3: {
                return BlockScoped;
            }
            case 768: {
                return ReachabilityCheckFlags;
            }
            case 2816: {
                return ReachabilityAndEmitFlags;
            }
            case 50720768: {
                return ContextFlags;
            }
            case 40960: {
                return TypeExcludesFlags;
            }
            case 0x600000: {
                return PermanentlySetIncrementalFlags;
            }
        }
        throw new IllegalArgumentException("unknown TSCNodeFlag code: " + code);
    }

    public boolean matches(int bitfield) {
        return (bitfield & this.code) != 0;
    }

    public static int union(TSCNodeFlag ... args) {
        int result = 0;
        for (TSCNodeFlag arg : args) {
            result |= arg.code;
        }
        return result;
    }
}

