/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc.generated;

public enum TSCTypeFlag {
    Any(1),
    Unknown(2),
    String(4),
    Number(8),
    Boolean(16),
    Enum(32),
    BigInt(64),
    StringLiteral(128),
    NumberLiteral(256),
    BooleanLiteral(512),
    EnumLiteral(1024),
    BigIntLiteral(2048),
    ESSymbol(4096),
    UniqueESSymbol(8192),
    Void(16384),
    Undefined(32768),
    Null(65536),
    Never(131072),
    TypeParameter(262144),
    Object(524288),
    Union(0x100000),
    Intersection(0x200000),
    Index(0x400000),
    IndexedAccess(0x800000),
    Conditional(0x1000000),
    Substitution(0x2000000),
    NonPrimitive(0x4000000),
    TemplateLiteral(0x8000000),
    StringMapping(0x10000000),
    AnyOrUnknown(3),
    Nullable(98304),
    Literal(2944),
    Unit(109472),
    Freshable(2976),
    StringOrNumberLiteral(384),
    StringOrNumberLiteralOrUnique(8576),
    DefinitelyFalsy(117632),
    PossiblyFalsy(117724),
    Intrinsic(67359327),
    Primitive(134348796),
    StringLike(402653316),
    NumberLike(296),
    BigIntLike(2112),
    BooleanLike(528),
    EnumLike(1056),
    ESSymbolLike(12288),
    VoidLike(49152),
    DefinitelyNonNullable(470302716),
    DisjointDomains(469892092),
    UnionOrIntersection(0x300000),
    StructuredType(0x380000),
    TypeVariable(0x840000),
    InstantiableNonPrimitive(58982400),
    InstantiablePrimitive(406847488),
    Instantiable(465829888),
    StructuredOrInstantiable(469499904),
    ObjectFlagsType(3899393),
    Simplifiable(0x1800000),
    Singleton(67358815),
    Narrowable(536624127),
    IncludesMask(205258751),
    NotPrimitiveUnion(36323363);

    public final int code;

    private TSCTypeFlag(int code) {
        this.code = code;
    }

    public static TSCTypeFlag fromMaskExact(int code) {
        switch (code) {
            case 1: {
                return Any;
            }
            case 2: {
                return Unknown;
            }
            case 4: {
                return String;
            }
            case 8: {
                return Number;
            }
            case 16: {
                return Boolean;
            }
            case 32: {
                return Enum;
            }
            case 64: {
                return BigInt;
            }
            case 128: {
                return StringLiteral;
            }
            case 256: {
                return NumberLiteral;
            }
            case 512: {
                return BooleanLiteral;
            }
            case 1024: {
                return EnumLiteral;
            }
            case 2048: {
                return BigIntLiteral;
            }
            case 4096: {
                return ESSymbol;
            }
            case 8192: {
                return UniqueESSymbol;
            }
            case 16384: {
                return Void;
            }
            case 32768: {
                return Undefined;
            }
            case 65536: {
                return Null;
            }
            case 131072: {
                return Never;
            }
            case 262144: {
                return TypeParameter;
            }
            case 524288: {
                return Object;
            }
            case 0x100000: {
                return Union;
            }
            case 0x200000: {
                return Intersection;
            }
            case 0x400000: {
                return Index;
            }
            case 0x800000: {
                return IndexedAccess;
            }
            case 0x1000000: {
                return Conditional;
            }
            case 0x2000000: {
                return Substitution;
            }
            case 0x4000000: {
                return NonPrimitive;
            }
            case 0x8000000: {
                return TemplateLiteral;
            }
            case 0x10000000: {
                return StringMapping;
            }
            case 3: {
                return AnyOrUnknown;
            }
            case 98304: {
                return Nullable;
            }
            case 2944: {
                return Literal;
            }
            case 109472: {
                return Unit;
            }
            case 2976: {
                return Freshable;
            }
            case 384: {
                return StringOrNumberLiteral;
            }
            case 8576: {
                return StringOrNumberLiteralOrUnique;
            }
            case 117632: {
                return DefinitelyFalsy;
            }
            case 117724: {
                return PossiblyFalsy;
            }
            case 67359327: {
                return Intrinsic;
            }
            case 134348796: {
                return Primitive;
            }
            case 402653316: {
                return StringLike;
            }
            case 296: {
                return NumberLike;
            }
            case 2112: {
                return BigIntLike;
            }
            case 528: {
                return BooleanLike;
            }
            case 1056: {
                return EnumLike;
            }
            case 12288: {
                return ESSymbolLike;
            }
            case 49152: {
                return VoidLike;
            }
            case 470302716: {
                return DefinitelyNonNullable;
            }
            case 469892092: {
                return DisjointDomains;
            }
            case 0x300000: {
                return UnionOrIntersection;
            }
            case 0x380000: {
                return StructuredType;
            }
            case 0x840000: {
                return TypeVariable;
            }
            case 58982400: {
                return InstantiableNonPrimitive;
            }
            case 406847488: {
                return InstantiablePrimitive;
            }
            case 465829888: {
                return Instantiable;
            }
            case 469499904: {
                return StructuredOrInstantiable;
            }
            case 3899393: {
                return ObjectFlagsType;
            }
            case 0x1800000: {
                return Simplifiable;
            }
            case 67358815: {
                return Singleton;
            }
            case 536624127: {
                return Narrowable;
            }
            case 205258751: {
                return IncludesMask;
            }
            case 36323363: {
                return NotPrimitiveUnion;
            }
        }
        throw new IllegalArgumentException("unknown TSCTypeFlag code: " + code);
    }

    public boolean matches(int bitfield) {
        return (bitfield & this.code) != 0;
    }

    public static int union(TSCTypeFlag ... args) {
        int result = 0;
        for (TSCTypeFlag arg : args) {
            result |= arg.code;
        }
        return result;
    }
}

