/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc.generated;

public enum TSCTokenFlag {
    None(0),
    PrecedingLineBreak(1),
    PrecedingJSDocComment(2),
    Unterminated(4),
    ExtendedUnicodeEscape(8),
    Scientific(16),
    Octal(32),
    HexSpecifier(64),
    BinarySpecifier(128),
    OctalSpecifier(256),
    ContainsSeparator(512),
    UnicodeEscape(1024),
    ContainsInvalidEscape(2048),
    BinaryOrOctalSpecifier(384),
    NumericLiteralFlags(1008);

    public final int code;

    private TSCTokenFlag(int code) {
        this.code = code;
    }

    public static TSCTokenFlag fromMaskExact(int code) {
        switch (code) {
            case 0: {
                return None;
            }
            case 1: {
                return PrecedingLineBreak;
            }
            case 2: {
                return PrecedingJSDocComment;
            }
            case 4: {
                return Unterminated;
            }
            case 8: {
                return ExtendedUnicodeEscape;
            }
            case 16: {
                return Scientific;
            }
            case 32: {
                return Octal;
            }
            case 64: {
                return HexSpecifier;
            }
            case 128: {
                return BinarySpecifier;
            }
            case 256: {
                return OctalSpecifier;
            }
            case 512: {
                return ContainsSeparator;
            }
            case 1024: {
                return UnicodeEscape;
            }
            case 2048: {
                return ContainsInvalidEscape;
            }
            case 384: {
                return BinaryOrOctalSpecifier;
            }
            case 1008: {
                return NumericLiteralFlags;
            }
        }
        throw new IllegalArgumentException("unknown TSCTokenFlag code: " + code);
    }

    public boolean matches(int bitfield) {
        return (bitfield & this.code) != 0;
    }

    public static int union(TSCTokenFlag ... args) {
        int result = 0;
        for (TSCTokenFlag arg : args) {
            result |= arg.code;
        }
        return result;
    }
}

