/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc.generated;

public enum TSCSymbolFlag {
    None(0),
    FunctionScopedVariable(1),
    BlockScopedVariable(2),
    Property(4),
    EnumMember(8),
    Function(16),
    Class(32),
    Interface(64),
    ConstEnum(128),
    RegularEnum(256),
    ValueModule(512),
    NamespaceModule(1024),
    TypeLiteral(2048),
    ObjectLiteral(4096),
    Method(8192),
    Constructor(16384),
    GetAccessor(32768),
    SetAccessor(65536),
    Signature(131072),
    TypeParameter(262144),
    TypeAlias(524288),
    ExportValue(0x100000),
    Alias(0x200000),
    Prototype(0x400000),
    ExportStar(0x800000),
    Optional(0x1000000),
    Transient(0x2000000),
    Assignment(0x4000000),
    ModuleExports(0x8000000),
    All(0x3FFFFFF),
    Enum(384),
    Variable(3),
    Value(111551),
    Type(788968),
    Namespace(1920),
    Module(1536),
    Accessor(98304),
    FunctionScopedVariableExcludes(111550),
    EnumMemberExcludes(900095),
    FunctionExcludes(110991),
    ClassExcludes(899503),
    InterfaceExcludes(788872),
    RegularEnumExcludes(899327),
    ConstEnumExcludes(899967),
    ValueModuleExcludes(110735),
    MethodExcludes(103359),
    GetAccessorExcludes(46015),
    SetAccessorExcludes(78783),
    AccessorExcludes(13247),
    TypeParameterExcludes(526824),
    ModuleMember(2623475),
    ExportHasLocal(944),
    BlockScoped(418),
    PropertyOrAccessor(98308),
    ClassMember(106500),
    ExportSupportsDefaultModifier(112),
    ExportDoesNotSupportDefaultModifier(-113),
    Classifiable(2885600),
    LateBindingContainer(6256);

    public final int code;

    private TSCSymbolFlag(int code) {
        this.code = code;
    }

    public static TSCSymbolFlag fromMaskExact(int code) {
        switch (code) {
            case 0: {
                return None;
            }
            case 1: {
                return FunctionScopedVariable;
            }
            case 2: {
                return BlockScopedVariable;
            }
            case 4: {
                return Property;
            }
            case 8: {
                return EnumMember;
            }
            case 16: {
                return Function;
            }
            case 32: {
                return Class;
            }
            case 64: {
                return Interface;
            }
            case 128: {
                return ConstEnum;
            }
            case 256: {
                return RegularEnum;
            }
            case 512: {
                return ValueModule;
            }
            case 1024: {
                return NamespaceModule;
            }
            case 2048: {
                return TypeLiteral;
            }
            case 4096: {
                return ObjectLiteral;
            }
            case 8192: {
                return Method;
            }
            case 16384: {
                return Constructor;
            }
            case 32768: {
                return GetAccessor;
            }
            case 65536: {
                return SetAccessor;
            }
            case 131072: {
                return Signature;
            }
            case 262144: {
                return TypeParameter;
            }
            case 524288: {
                return TypeAlias;
            }
            case 0x100000: {
                return ExportValue;
            }
            case 0x200000: {
                return Alias;
            }
            case 0x400000: {
                return Prototype;
            }
            case 0x800000: {
                return ExportStar;
            }
            case 0x1000000: {
                return Optional;
            }
            case 0x2000000: {
                return Transient;
            }
            case 0x4000000: {
                return Assignment;
            }
            case 0x8000000: {
                return ModuleExports;
            }
            case 0x3FFFFFF: {
                return All;
            }
            case 384: {
                return Enum;
            }
            case 3: {
                return Variable;
            }
            case 111551: {
                return Value;
            }
            case 788968: {
                return Type;
            }
            case 1920: {
                return Namespace;
            }
            case 1536: {
                return Module;
            }
            case 98304: {
                return Accessor;
            }
            case 111550: {
                return FunctionScopedVariableExcludes;
            }
            case 900095: {
                return EnumMemberExcludes;
            }
            case 110991: {
                return FunctionExcludes;
            }
            case 899503: {
                return ClassExcludes;
            }
            case 788872: {
                return InterfaceExcludes;
            }
            case 899327: {
                return RegularEnumExcludes;
            }
            case 899967: {
                return ConstEnumExcludes;
            }
            case 110735: {
                return ValueModuleExcludes;
            }
            case 103359: {
                return MethodExcludes;
            }
            case 46015: {
                return GetAccessorExcludes;
            }
            case 78783: {
                return SetAccessorExcludes;
            }
            case 13247: {
                return AccessorExcludes;
            }
            case 526824: {
                return TypeParameterExcludes;
            }
            case 2623475: {
                return ModuleMember;
            }
            case 944: {
                return ExportHasLocal;
            }
            case 418: {
                return BlockScoped;
            }
            case 98308: {
                return PropertyOrAccessor;
            }
            case 106500: {
                return ClassMember;
            }
            case 112: {
                return ExportSupportsDefaultModifier;
            }
            case -113: {
                return ExportDoesNotSupportDefaultModifier;
            }
            case 2885600: {
                return Classifiable;
            }
            case 6256: {
                return LateBindingContainer;
            }
        }
        throw new IllegalArgumentException("unknown TSCSymbolFlag code: " + code);
    }

    public boolean matches(int bitfield) {
        return (bitfield & this.code) != 0;
    }

    public static int union(TSCSymbolFlag ... args) {
        int result = 0;
        for (TSCSymbolFlag arg : args) {
            result |= arg.code;
        }
        return result;
    }
}

