/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.openrewrite.javascript.internal.tsc.TSCConversions;
import org.openrewrite.javascript.internal.tsc.TSCIndexInfo;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCSignature;
import org.openrewrite.javascript.internal.tsc.TSCSymbol;
import org.openrewrite.javascript.internal.tsc.TSCType;
import org.openrewrite.javascript.internal.tsc.TSCV8Backed;
import org.openrewrite.javascript.internal.tsc.TSCV8ValueHolder;
import org.openrewrite.javascript.internal.tsc.generated.TSCIndexKind;
import org.openrewrite.javascript.internal.tsc.generated.TSCSignatureKind;
import org.openrewrite.javascript.internal.tsc.generated.TSCSymbolFlag;
import org.openrewrite.javascript.internal.tsc.generated.TSCTypeFlag;

public class TSCTypeChecker
extends TSCV8ValueHolder
implements TSCV8Backed {
    private final Supplier<TSCProgramContext> programContext;
    private final V8ValueObject objectV8;

    public static TSCTypeChecker fromJS(Supplier<TSCProgramContext> context, V8ValueObject objectV8) {
        return new TSCTypeChecker(context, objectV8);
    }

    private TSCTypeChecker(Supplier<TSCProgramContext> programContext, V8ValueObject objectV8) {
        this.programContext = programContext;
        this.objectV8 = this.lifecycleLinked(objectV8);
    }

    public TSCType getTypeOfSymbolAtLocation(TSCSymbol symbol, TSCNode node) {
        return this.invokeMethodNonNull("getTypeOfSymbolAtLocation", TSCConversions.TYPE, symbol, node);
    }

    public TSCType getTypeOfSymbol(TSCSymbol symbol) {
        return this.invokeMethodNonNull("getTypeOfSymbol", TSCConversions.TYPE, symbol);
    }

    public TSCType getDeclaredTypeOfSymbol(TSCSymbol symbol) {
        return this.invokeMethodNonNull("getDeclaredTypeOfSymbol", TSCConversions.TYPE, symbol);
    }

    public List<TSCSymbol> getPropertiesOfType(TSCType type) {
        return this.invokeMethodNonNull("getPropertiesOfType", TSCConversions.SYMBOL_LIST, type);
    }

    @Nullable
    public TSCSymbol getPropertyOfType(TSCType type, String name) {
        return this.invokeMethodNullable("getPropertyOfType", TSCConversions.SYMBOL, type, name);
    }

    @Nullable
    public TSCSymbol getPrivateIdentifierPropertyOfType(TSCType leftType, String name, TSCNode location) {
        return this.invokeMethodNullable("getPrivateIdentifierPropertyOfType", TSCConversions.SYMBOL, leftType, name, location);
    }

    @Nullable
    public TSCIndexInfo getIndexInfoOfType(TSCType type, TSCIndexKind kind) {
        return this.invokeMethodNullable("getIndexInfoOfType", TSCConversions.INDEX_INFO, type, kind.code);
    }

    public List<TSCIndexInfo> getIndexInfosOfType(TSCType type) {
        return this.invokeMethodNonNull("getIndexInfosOfType", TSCConversions.INDEX_INFO_LIST, type);
    }

    public List<TSCIndexInfo> getIndexInfosOfIndexSymbol(TSCSymbol indexSymbol) {
        return this.invokeMethodNonNull("getIndexInfosOfIndexSymbol", TSCConversions.INDEX_INFO_LIST, indexSymbol);
    }

    public List<TSCSignature> getSignaturesOfType(TSCType type, TSCSignatureKind signatureKind) {
        return this.invokeMethodNonNull("getSignaturesOfType", TSCConversions.SIGNATURE_LIST, type, signatureKind.code);
    }

    @Nullable
    public TSCType getIndexTypeOfType(TSCType type, TSCIndexKind indexKind) {
        return this.invokeMethodNullable("getIndexTypeOfType", TSCConversions.TYPE, type, indexKind.code);
    }

    @Nullable
    public List<TSCType> getBaseTypes(TSCType interfaceType) {
        return this.invokeMethodNonNull("getBaseTypes", TSCConversions.TYPE_LIST, interfaceType);
    }

    public TSCType getBaseTypeOfLiteralType(TSCType type) {
        return this.invokeMethodNonNull("getBaseTypeOfLiteralType", TSCConversions.TYPE, type);
    }

    public TSCType getWidenedType(TSCType type) {
        return this.invokeMethodNonNull("getWidenedType", TSCConversions.TYPE, type);
    }

    public TSCType getReturnTypeOfSignature(TSCSignature signature) {
        return this.invokeMethodNonNull("getReturnTypeOfSignature", TSCConversions.TYPE, signature);
    }

    public TSCType getNullableType(TSCType type, TSCTypeFlag ... typeFlags) {
        return this.invokeMethodNonNull("getNullableType", TSCConversions.TYPE, type, TSCTypeFlag.union(typeFlags));
    }

    public TSCType getNonNullableType(TSCType type) {
        return this.invokeMethodNonNull("getNonNullableType", TSCConversions.TYPE, type);
    }

    public List<TSCType> getTypeArguments(TSCType type) {
        return this.invokeMethodNonNull("getTypeArguments", TSCConversions.TYPE_LIST, type);
    }

    public List<TSCSymbol> getSymbolsInScope(TSCNode location, TSCSymbolFlag ... meaning) {
        return this.invokeMethodNonNull("getSymbolsInScope", TSCConversions.SYMBOL_LIST, location, TSCSymbolFlag.union(meaning));
    }

    @Nullable
    public TSCSymbol getSymbolAtLocation(TSCNode node) {
        return this.invokeMethodNullable("getSymbolAtLocation", TSCConversions.SYMBOL, node);
    }

    public List<TSCSymbol> getSymbolsOfParameterPropertyDeclaration(TSCNode parameterDeclaration, String parameterName) {
        return this.invokeMethodNonNull("getSymbolsOfParameterPropertyDeclaration", TSCConversions.SYMBOL_LIST, parameterDeclaration, parameterName);
    }

    public TSCType getTypeAtLocation(TSCNode node) {
        return this.invokeMethodNonNull("getTypeAtLocation", TSCConversions.TYPE, node);
    }

    public TSCType getTypeFromTypeNode(TSCNode node) {
        return this.invokeMethodNonNull("getTypeFromTypeNode", TSCConversions.TYPE, node);
    }

    public String signatureToString(TSCSignature signature) {
        return this.invokeMethodNonNull("signatureToString", TSCConversions.STRING, signature);
    }

    public String typeToString(TSCType type) {
        return this.invokeMethodNonNull("typeToString", TSCConversions.STRING, type);
    }

    public String symbolToString(TSCSymbol symbol) {
        return this.invokeMethodNonNull("symbolToString", TSCConversions.STRING, symbol);
    }

    public String getFullyQualifiedName(TSCSymbol symbol) {
        return this.invokeMethodNonNull("getFullyQualifiedName", TSCConversions.STRING, symbol);
    }

    public TSCType getAnyType() {
        return this.invokeMethodNonNull("getAnyType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getStringType() {
        return this.invokeMethodNonNull("getStringType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getStringLiteralType(String value) {
        return this.invokeMethodNonNull("getStringLiteralType", TSCConversions.TYPE, value);
    }

    public TSCType getNumberType() {
        return this.invokeMethodNonNull("getNumberType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getNumberLiteralType(Number value) {
        return this.invokeMethodNonNull("getNumberLiteralType", TSCConversions.TYPE, value);
    }

    public TSCType getBigIntType() {
        return this.invokeMethodNonNull("getBigIntType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getBooleanType() {
        return this.invokeMethodNonNull("getBooleanType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getFalseType() {
        return this.invokeMethodNonNull("getFalseType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getTrueType() {
        return this.invokeMethodNonNull("getTrueType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getVoidType() {
        return this.invokeMethodNonNull("getVoidType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getUndefinedType() {
        return this.invokeMethodNonNull("getUndefinedType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getNullType() {
        return this.invokeMethodNonNull("getNullType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getESSymbolType() {
        return this.invokeMethodNonNull("getESSymbolType", TSCConversions.TYPE, new Object[0]);
    }

    public TSCType getNeverType() {
        return this.invokeMethodNonNull("getNeverType", TSCConversions.TYPE, new Object[0]);
    }

    @Override
    public TSCProgramContext getProgramContext() {
        return this.programContext.get();
    }

    @Override
    public V8ValueObject getBackingV8Object() {
        return this.objectV8;
    }
}

