/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.values.reference.V8ValueObject;
import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCType;
import org.openrewrite.javascript.internal.tsc.TSCV8Backed;

public final class TSCIndexInfo {
    @NonNull
    private final TSCType keyType;
    @NonNull
    private final TSCType type;
    private final boolean isReadonly;
    private final TSCNode declaration;

    public static TSCIndexInfo fromJS(TSCProgramContext programContext, V8ValueObject objectV8) {
        TSCV8Backed temp = TSCV8Backed.temporary(programContext, objectV8);
        return new TSCIndexInfo(temp.getTypeProperty("keyType"), temp.getTypeProperty("type"), temp.getBooleanProperty("isReadonly"), temp.getOptionalNodeProperty("declaration"));
    }

    @ConstructorProperties(value={"keyType", "type", "isReadonly", "declaration"})
    public TSCIndexInfo(@NonNull TSCType keyType, @NonNull TSCType type, boolean isReadonly, TSCNode declaration) {
        if (keyType == null) {
            throw new NullPointerException("keyType is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.keyType = keyType;
        this.type = type;
        this.isReadonly = isReadonly;
        this.declaration = declaration;
    }

    @NonNull
    public TSCType getKeyType() {
        return this.keyType;
    }

    @NonNull
    public TSCType getType() {
        return this.type;
    }

    public boolean isReadonly() {
        return this.isReadonly;
    }

    public TSCNode getDeclaration() {
        return this.declaration;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TSCIndexInfo)) {
            return false;
        }
        TSCIndexInfo other = (TSCIndexInfo)o;
        if (this.isReadonly() != other.isReadonly()) {
            return false;
        }
        TSCType this$keyType = this.getKeyType();
        TSCType other$keyType = other.getKeyType();
        if (this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType)) {
            return false;
        }
        TSCType this$type = this.getType();
        TSCType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        TSCNode this$declaration = this.getDeclaration();
        TSCNode other$declaration = other.getDeclaration();
        return !(this$declaration == null ? other$declaration != null : !this$declaration.equals(other$declaration));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReadonly() ? 79 : 97);
        TSCType $keyType = this.getKeyType();
        result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
        TSCType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        TSCNode $declaration = this.getDeclaration();
        result = result * 59 + ($declaration == null ? 43 : $declaration.hashCode());
        return result;
    }

    @org.openrewrite.internal.lang.NonNull
    public String toString() {
        return "TSCIndexInfo(keyType=" + this.getKeyType() + ", type=" + this.getType() + ", isReadonly=" + this.isReadonly() + ", declaration=" + this.getDeclaration() + ")";
    }
}

