/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.openrewrite.FileAttributes;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.marker.Semicolon;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.javascript.JavaScriptParser;
import org.openrewrite.javascript.TypeScriptTypeMapping;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCNodeList;
import org.openrewrite.javascript.internal.tsc.TSCSourceFileContext;
import org.openrewrite.javascript.internal.tsc.generated.TSCSyntaxKind;
import org.openrewrite.javascript.table.ParseExceptionAnalysis;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.TsType;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.markers.ForLoopType;
import org.openrewrite.markers.FunctionDeclaration;
import org.openrewrite.markers.TypeReferencePrefix;
import org.openrewrite.markers.VariableModifier;

public class TypeScriptParserVisitor {
    private final TSCNode source;
    private final TSCSourceFileContext cursorContext;
    private final Path sourcePath;
    private final TypeScriptTypeMapping typeMapping;
    private final String charset;
    private final boolean isCharsetBomMarked;
    private final Function<TSCNode, Space> commaDelim = ignored -> this.sourceBefore(TSCSyntaxKind.CommaToken);
    private final Function<TSCNode, Space> noDelim = ignored -> Space.EMPTY;

    public TypeScriptParserVisitor(TSCNode source, TSCSourceFileContext sourceContext, Path sourcePath, JavaTypeCache typeCache, String charset, boolean isCharsetBomMarked) {
        this.source = source;
        this.cursorContext = sourceContext;
        this.sourcePath = sourcePath;
        this.charset = charset;
        this.isCharsetBomMarked = isCharsetBomMarked;
        this.typeMapping = new TypeScriptTypeMapping(typeCache);
    }

    public JS.CompilationUnit visitSourceFile() {
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>();
        Markers markers = null;
        for (TSCNode child : this.source.getNodeListProperty("statements")) {
            ParseExceptionResult result;
            J visited;
            block5: {
                int saveCursor = this.getCursor();
                try {
                    visited = this.visitNode(child);
                }
                catch (Throwable t) {
                    this.cursor(saveCursor);
                    JS.UnknownElement element = this.unknownElement(child);
                    ParseExceptionResult parseExceptionResult = ParseExceptionResult.build((Parser)JavaScriptParser.builder().build(), (Throwable)t);
                    element = element.withSource(element.getSource().withMarkers(Markers.EMPTY.withMarkers(Collections.singletonList(parseExceptionResult))));
                    visited = element;
                    if (markers != null) break block5;
                    markers = Markers.build(Collections.singletonList(parseExceptionResult));
                }
            }
            if (visited == null) continue;
            if (visited instanceof JS.UnknownElement && (result = (ParseExceptionResult)((JS.UnknownElement)visited).getSource().getMarkers().findFirst(ParseExceptionResult.class).orElse(null)) != null) {
                markers = Markers.build(Collections.singletonList(result));
            }
            if (!(visited instanceof Statement) && visited instanceof Expression) {
                visited = new JS.ExpressionStatement(Tree.randomId(), (Expression)visited);
            }
            statements.add(this.maybeSemicolon((Statement)visited));
        }
        Space eof = this.whitespace();
        eof = eof.withWhitespace(eof.getWhitespace() + (this.getCursor() < this.source.getText().length() ? this.source.getText().substring(this.getCursor()) : ""));
        return new JS.CompilationUnit(Tree.randomId(), Space.EMPTY, markers == null ? Markers.EMPTY : markers, this.sourcePath, FileAttributes.fromPath((Path)this.sourcePath), this.charset, this.isCharsetBomMarked, null, Collections.emptyList(), statements, eof);
    }

    private J.Assignment visitAssignment(TSCNode node) {
        Space prefix = this.whitespace();
        Expression left = (Expression)this.visitNode(node.getNodeProperty("left"));
        Space before = this.sourceBefore(TSCSyntaxKind.EqualsToken);
        Expression right = (Expression)this.visitNode(node.getNodeProperty("right"));
        return new J.Assignment(Tree.randomId(), prefix, Markers.EMPTY, left, this.padLeft(before, right), this.typeMapping.type(node));
    }

    private J.AssignmentOperation visitAssignmentOperation(TSCNode node) {
        Space prefix = this.whitespace();
        Expression left = (Expression)this.visitNode(node.getNodeProperty("left"));
        JLeftPadded<J.AssignmentOperation.Type> op = null;
        TSCSyntaxKind opKind = node.getNodeProperty("operatorToken").syntaxKind();
        switch (opKind) {
            case AsteriskEqualsToken: {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.AsteriskEqualsToken), J.AssignmentOperation.Type.Multiplication);
                break;
            }
            case MinusEqualsToken: {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.MinusEqualsToken), J.AssignmentOperation.Type.Subtraction);
                break;
            }
            case PercentEqualsToken: {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.PercentEqualsToken), J.AssignmentOperation.Type.Modulo);
                break;
            }
            case PlusEqualsToken: {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.PlusEqualsToken), J.AssignmentOperation.Type.Addition);
                break;
            }
            case SlashEqualsToken: {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.SlashEqualsToken), J.AssignmentOperation.Type.Division);
                break;
            }
            default: {
                this.implementMe(node);
            }
        }
        Expression right = (Expression)this.visitNode(node.getNodeProperty("right"));
        return new J.AssignmentOperation(Tree.randomId(), prefix, Markers.EMPTY, left, op, right, this.typeMapping.type(node));
    }

    private J visitArrayBindingPattern(TSCNode node) {
        this.implementMe(node);
        return null;
    }

    private J.NewArray visitArrayLiteralExpression(TSCNode node) {
        Space prefix = this.whitespace();
        TSCNodeList elements = node.getNodeListProperty("elements");
        JContainer<Expression> expression = this.mapContainer(TSCSyntaxKind.OpenBracketToken, elements, TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseBracketToken, t -> (Expression)this.visitNode((TSCNode)t));
        return new J.NewArray(Tree.randomId(), prefix, Markers.EMPTY, null, Collections.emptyList(), expression, this.typeMapping.type(node));
    }

    private J.TypeCast visitAsExpression(TSCNode node) {
        Space prefix = this.whitespace();
        Expression nameExpr = (Expression)this.visitNode(node.getNodeProperty("expression"));
        Space asPrefix = this.sourceBefore(TSCSyntaxKind.AsKeyword);
        J.Identifier type = this.visitIdentifier(node.getNodeProperty("type"));
        J.ControlParentheses control = new J.ControlParentheses(Tree.randomId(), asPrefix, Markers.EMPTY, this.padRight(type, this.whitespace()));
        return new J.TypeCast(Tree.randomId(), prefix, Markers.EMPTY, control, nameExpr);
    }

    private J.Binary visitBinary(TSCNode node) {
        Space prefix = this.whitespace();
        Expression left = (Expression)this.visitNode(node.getNodeProperty("left"));
        Space opPrefix = this.whitespace();
        JLeftPadded<J.Binary.Type> op = null;
        TSCSyntaxKind opKind = node.getNodeProperty("operatorToken").syntaxKind();
        switch (opKind) {
            case AmpersandToken: {
                this.consumeToken(TSCSyntaxKind.AmpersandToken);
                op = this.padLeft(opPrefix, J.Binary.Type.BitAnd);
                break;
            }
            case BarToken: {
                this.consumeToken(TSCSyntaxKind.BarToken);
                op = this.padLeft(opPrefix, J.Binary.Type.BitOr);
                break;
            }
            case CaretToken: {
                this.consumeToken(TSCSyntaxKind.CaretToken);
                op = this.padLeft(opPrefix, J.Binary.Type.BitXor);
                break;
            }
            case GreaterThanGreaterThanToken: {
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                op = this.padLeft(opPrefix, J.Binary.Type.RightShift);
                break;
            }
            case LessThanLessThanToken: {
                this.consumeToken(TSCSyntaxKind.LessThanLessThanToken);
                op = this.padLeft(opPrefix, J.Binary.Type.LeftShift);
                break;
            }
            case AmpersandAmpersandToken: {
                this.consumeToken(TSCSyntaxKind.AmpersandAmpersandToken);
                op = this.padLeft(opPrefix, J.Binary.Type.And);
                break;
            }
            case BarBarToken: {
                this.consumeToken(TSCSyntaxKind.BarBarToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Or);
                break;
            }
            case EqualsEqualsToken: {
                this.consumeToken(TSCSyntaxKind.EqualsEqualsToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Equal);
                break;
            }
            case ExclamationEqualsToken: {
                this.consumeToken(TSCSyntaxKind.ExclamationEqualsToken);
                op = this.padLeft(opPrefix, J.Binary.Type.NotEqual);
                break;
            }
            case GreaterThanToken: {
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                op = this.padLeft(opPrefix, J.Binary.Type.GreaterThan);
                break;
            }
            case GreaterThanEqualsToken: {
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                this.consumeToken(TSCSyntaxKind.EqualsToken);
                op = this.padLeft(opPrefix, J.Binary.Type.GreaterThanOrEqual);
                break;
            }
            case GreaterThanGreaterThanGreaterThanToken: {
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                this.consumeToken(TSCSyntaxKind.GreaterThanToken);
                op = this.padLeft(opPrefix, J.Binary.Type.UnsignedRightShift);
                break;
            }
            case LessThanToken: {
                this.consumeToken(TSCSyntaxKind.LessThanToken);
                op = this.padLeft(opPrefix, J.Binary.Type.LessThan);
                break;
            }
            case LessThanEqualsToken: {
                this.consumeToken(TSCSyntaxKind.LessThanEqualsToken);
                op = this.padLeft(opPrefix, J.Binary.Type.LessThanOrEqual);
                break;
            }
            case AsteriskToken: {
                this.consumeToken(TSCSyntaxKind.AsteriskToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Multiplication);
                break;
            }
            case MinusToken: {
                this.consumeToken(TSCSyntaxKind.MinusToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Subtraction);
                break;
            }
            case PercentToken: {
                this.consumeToken(TSCSyntaxKind.PercentToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Modulo);
                break;
            }
            case PlusToken: {
                this.consumeToken(TSCSyntaxKind.PlusToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Addition);
                break;
            }
            case SlashToken: {
                this.consumeToken(TSCSyntaxKind.SlashToken);
                op = this.padLeft(opPrefix, J.Binary.Type.Division);
                break;
            }
            default: {
                this.implementMe(node);
            }
        }
        Expression right = (Expression)this.visitNode(node.getNodeProperty("right"));
        return new J.Binary(Tree.randomId(), prefix, Markers.EMPTY, left, op, right, this.typeMapping.type(node));
    }

    private J visitBinaryExpression(TSCNode node) {
        TSCSyntaxKind opKind = node.getNodeProperty("operatorToken").syntaxKind();
        switch (opKind) {
            case EqualsToken: {
                return this.visitAssignment(node);
            }
            case AsteriskEqualsToken: 
            case MinusEqualsToken: 
            case PercentEqualsToken: 
            case PlusEqualsToken: 
            case SlashEqualsToken: {
                return this.visitAssignmentOperation(node);
            }
            case AmpersandToken: 
            case BarToken: 
            case CaretToken: 
            case GreaterThanGreaterThanToken: 
            case LessThanLessThanToken: 
            case AmpersandAmpersandToken: 
            case BarBarToken: 
            case EqualsEqualsToken: 
            case ExclamationEqualsToken: 
            case GreaterThanToken: 
            case GreaterThanEqualsToken: 
            case GreaterThanGreaterThanGreaterThanToken: 
            case LessThanToken: 
            case LessThanEqualsToken: 
            case AsteriskToken: 
            case MinusToken: 
            case PercentToken: 
            case PlusToken: 
            case SlashToken: {
                return this.visitBinary(node);
            }
            case EqualsEqualsEqualsToken: 
            case ExclamationEqualsEqualsToken: {
                return this.visitJsBinary(node);
            }
            case InstanceOfKeyword: {
                return this.visitInstanceOf(node);
            }
        }
        this.implementMe(node.getNodeProperty("operatorToken"));
        return null;
    }

    private void visitBinaryUpdateExpression(TSCNode incrementor, List<JRightPadded<Statement>> updates) {
        assert (incrementor.syntaxKind() == TSCSyntaxKind.BinaryExpression);
        TSCNode left = incrementor.getNodeProperty("left");
        if (left.syntaxKind() == TSCSyntaxKind.BinaryExpression) {
            this.visitBinaryUpdateExpression(left, updates);
        } else {
            updates.add(this.padRight((Statement)this.visitNode(left), this.sourceBefore(TSCSyntaxKind.CommaToken)));
        }
        Statement r = (Statement)this.visitNode(incrementor.getNodeProperty("right"));
        Space after = this.whitespace();
        if (this.source.getText().charAt(this.getCursor()) == ',') {
            this.consumeToken(TSCSyntaxKind.CommaToken);
        } else if (this.source.getText().charAt(this.getCursor()) == ')') {
            this.consumeToken(TSCSyntaxKind.CloseParenToken);
        }
        updates.add(this.padRight(r, after));
    }

    @Nullable
    private J.Block visitBlock(@Nullable TSCNode node) {
        if (node == null) {
            return null;
        }
        Space prefix = this.sourceBefore(TSCSyntaxKind.OpenBraceToken);
        TSCNodeList statementNodes = node.getNodeListProperty("statements");
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>(statementNodes.size());
        for (TSCNode statementNode : statementNodes) {
            statements.add(this.visitStatement(statementNode));
        }
        Space endOfBlock = this.sourceBefore(TSCSyntaxKind.CloseBraceToken);
        return new J.Block(Tree.randomId(), prefix, Markers.EMPTY, JRightPadded.build((Object)false), statements, endOfBlock);
    }

    private J.Break visitBreakStatement(TSCNode node) {
        return new J.Break(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.BreakKeyword), Markers.EMPTY, node.hasProperty("label") ? (J.Identifier)this.visitNode(node.getNodeProperty("label")) : null);
    }

    private J.MethodInvocation visitCallExpression(TSCNode node) {
        Space prefix = this.whitespace();
        this.implementMe(node, "questionDotToken");
        this.implementMe(node, "typeArguments");
        JRightPadded<Expression> select = null;
        JContainer typeParameters = null;
        TSCNode expression = node.getNodeProperty("expression");
        if (expression.hasProperty("expression")) {
            this.implementMe(expression, "questionDotToken");
            select = this.padRight(this.visitNameExpression(expression.getNodeProperty("expression")), this.sourceBefore(TSCSyntaxKind.DotToken));
        }
        JavaType.Method type = this.typeMapping.methodInvocationType(node);
        J.Identifier name = null;
        if (expression.hasProperty("name")) {
            name = this.visitIdentifier(expression.getNodeProperty("name"), (JavaType)type);
        } else if (expression.syntaxKind() == TSCSyntaxKind.SuperKeyword) {
            name = new J.Identifier(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.SuperKeyword), Markers.EMPTY, "super", this.typeMapping.type(node), null);
        } else {
            this.implementMe(expression);
        }
        JContainer<Expression> arguments = null;
        if (node.hasProperty("arguments")) {
            arguments = this.mapContainer(TSCSyntaxKind.OpenParenToken, node.getNodeListProperty("arguments"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, t -> (Expression)this.visitNode((TSCNode)t));
        }
        return new J.MethodInvocation(Tree.randomId(), prefix, Markers.EMPTY, select, typeParameters, name, arguments, type);
    }

    private J.ClassDeclaration visitClassDeclaration(TSCNode node) {
        ArrayList<Object> members;
        Space bodyPrefix;
        J.ClassDeclaration.Kind.Type type;
        Space kindPrefix;
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotation = new ArrayList<J.Annotation>();
        TSCNodeList modifierNodes = node.getOptionalNodeListProperty("modifiers");
        List<Object> modifiers = modifierNodes != null ? this.mapModifiers(node.getNodeListProperty("modifiers"), leadingAnnotation) : Collections.emptyList();
        List kindAnnotations = Collections.emptyList();
        TSCSyntaxKind syntaxKind = node.syntaxKind();
        switch (syntaxKind) {
            case EnumDeclaration: {
                kindPrefix = this.sourceBefore(TSCSyntaxKind.EnumKeyword);
                type = J.ClassDeclaration.Kind.Type.Enum;
                break;
            }
            case InterfaceDeclaration: {
                kindPrefix = this.sourceBefore(TSCSyntaxKind.InterfaceKeyword);
                type = J.ClassDeclaration.Kind.Type.Interface;
                break;
            }
            default: {
                kindPrefix = this.sourceBefore(TSCSyntaxKind.ClassKeyword);
                type = J.ClassDeclaration.Kind.Type.Class;
            }
        }
        J.ClassDeclaration.Kind kind = new J.ClassDeclaration.Kind(Tree.randomId(), kindPrefix, Markers.EMPTY, kindAnnotations, type);
        J.Identifier name = node.hasProperty("name") ? this.visitIdentifier(node.getNodeProperty("name")) : new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "", null, null);
        JContainer<J.TypeParameter> typeParams = !node.hasProperty("typeParameters") ? null : this.mapContainer(TSCSyntaxKind.LessThanToken, node.getNodeListProperty("typeParameters"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.GreaterThanToken, t -> (J.TypeParameter)this.visitNode((TSCNode)t));
        JLeftPadded<TypeTree> extendings = null;
        JContainer implementings = null;
        if (node.hasProperty("heritageClauses")) {
            for (TSCNode tscNode : node.getNodeListProperty("heritageClauses")) {
                if (TSCSyntaxKind.fromCode(tscNode.getIntProperty("token")) == TSCSyntaxKind.ExtendsKeyword) {
                    TSCNodeList types = tscNode.getNodeListProperty("types");
                    assert (types.size() == 1);
                    extendings = this.padLeft(this.sourceBefore(TSCSyntaxKind.ExtendsKeyword), (TypeTree)this.visitNode((TSCNode)types.get(0)));
                    continue;
                }
                this.implementMe(tscNode);
            }
        }
        if (node.hasProperty("members")) {
            bodyPrefix = this.sourceBefore(TSCSyntaxKind.OpenBraceToken);
            TSCNodeList memberNodes = node.getNodeListProperty("members");
            if (kind.getType() == J.ClassDeclaration.Kind.Type.Enum) {
                Space enumPrefix = this.whitespace();
                members = new ArrayList(1);
                ArrayList<JRightPadded> enumValues = new ArrayList<JRightPadded>(memberNodes.size());
                for (int i = 0; i < memberNodes.size(); ++i) {
                    boolean hasTrailingComma;
                    TSCNode enumValue = memberNodes.get(i);
                    J.EnumValue value = (J.EnumValue)this.visitNode(enumValue);
                    if (value == null) continue;
                    boolean bl = hasTrailingComma = i == memberNodes.size() - 1 && memberNodes.getBooleanProperty("hasTrailingComma");
                    Space after = i < memberNodes.size() - 1 ? this.sourceBefore(TSCSyntaxKind.CommaToken) : (hasTrailingComma ? this.sourceBefore(TSCSyntaxKind.CommaToken) : Space.EMPTY);
                    JRightPadded ev = this.padRight(value, after);
                    if (i == memberNodes.size() - 1 && hasTrailingComma) {
                        ev = ev.withMarkers(ev.getMarkers().addIfAbsent((Marker)new TrailingComma(Tree.randomId(), Space.EMPTY)));
                    }
                    enumValues.add(ev);
                }
                JRightPadded<J.EnumValueSet> enumSet = this.maybeSemicolon(new J.EnumValueSet(Tree.randomId(), enumPrefix, Markers.EMPTY, enumValues, false));
                members.add(enumSet);
            } else {
                members = new ArrayList<Object>(memberNodes.size());
                for (TSCNode statement : memberNodes) {
                    members.add(this.visitStatement(statement));
                }
            }
        } else {
            throw new UnsupportedOperationException("Add support for empty body");
        }
        J.Block body = new J.Block(Tree.randomId(), bodyPrefix, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), members, this.sourceBefore(TSCSyntaxKind.CloseBraceToken));
        JContainer primaryConstructor = null;
        return new J.ClassDeclaration(Tree.randomId(), prefix, markers, leadingAnnotation.isEmpty() ? Collections.emptyList() : leadingAnnotation, modifiers, kind, name, typeParams, primaryConstructor, extendings, implementings, null, body, (JavaType.FullyQualified)this.typeMapping.type(node));
    }

    private J.Ternary visitConditionalExpression(TSCNode node) {
        return new J.Ternary(Tree.randomId(), this.whitespace(), Markers.EMPTY, (Expression)this.visitNode(node.getNodeProperty("condition")), this.padLeft(this.sourceBefore(TSCSyntaxKind.QuestionToken), (Expression)this.visitNode(node.getNodeProperty("whenTrue"))), this.padLeft(this.sourceBefore(TSCSyntaxKind.ColonToken), (Expression)this.visitNode(node.getNodeProperty("whenFalse"))), this.typeMapping.type(node));
    }

    private J.Continue visitContinueStatement(TSCNode node) {
        return new J.Continue(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ContinueKeyword), Markers.EMPTY, node.hasProperty("label") ? (J.Identifier)this.visitNode(node.getNodeProperty("label")) : null);
    }

    private J.MethodDeclaration visitConstructor(TSCNode node) {
        Space prefix = this.whitespace();
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        List<Object> modifiers = node.hasProperty("modifiers") ? this.mapModifiers(node.getNodeListProperty("modifiers"), leadingAnnotations) : Collections.emptyList();
        Space before = this.whitespace();
        this.consumeToken(TSCSyntaxKind.ConstructorKeyword);
        J.Identifier name = new J.Identifier(Tree.randomId(), before, Markers.EMPTY, "constructor", this.typeMapping.type(node), null);
        JContainer<Statement> params = this.mapContainer(TSCSyntaxKind.OpenParenToken, node.getNodeListProperty("parameters"), null, TSCSyntaxKind.CloseParenToken, t -> (Statement)this.visitNode((TSCNode)t));
        J.Block body = (J.Block)this.visitNode(node.getNodeProperty("body"));
        this.implementMe(node, "typeParameters");
        this.implementMe(node, "type");
        this.implementMe(node, "typeArguments");
        return new J.MethodDeclaration(Tree.randomId(), prefix, Markers.EMPTY, leadingAnnotations.isEmpty() ? Collections.emptyList() : leadingAnnotations, modifiers, null, null, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, this.typeMapping.methodDeclarationType(node));
    }

    private J.Annotation visitDecorator(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.AtToken);
        this.implementMe(node, "questionDotToken");
        this.implementMe(node, "typeArguments");
        TSCNode callExpression = node.getNodeProperty("expression");
        NameTree name = (NameTree)this.visitNameExpression(callExpression.getNodeProperty("expression"));
        JContainer<Expression> arguments = callExpression.hasProperty("arguments") ? this.mapContainer(TSCSyntaxKind.OpenParenToken, callExpression.getNodeListProperty("arguments"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, t -> (Expression)this.visitNode((TSCNode)t)) : null;
        return new J.Annotation(Tree.randomId(), prefix, Markers.EMPTY, name, arguments);
    }

    private J.DoWhileLoop visitDoStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.DoKeyword);
        JRightPadded<Statement> body = this.maybeSemicolon((Statement)this.visitNode(node.getNodeProperty("statement")));
        JLeftPadded control = this.padLeft(this.sourceBefore(TSCSyntaxKind.WhileKeyword), this.mapControlParentheses(node.getNodeProperty("expression")));
        return new J.DoWhileLoop(Tree.randomId(), prefix, Markers.EMPTY, body, control);
    }

    private J.ArrayAccess visitElementAccessExpression(TSCNode node) {
        this.implementMe(node, "questionDotToken");
        return new J.ArrayAccess(Tree.randomId(), this.whitespace(), Markers.EMPTY, (Expression)this.visitNode(node.getNodeProperty("expression")), new J.ArrayDimension(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.OpenBracketToken), Markers.EMPTY, this.padRight((Expression)this.visitNode(node.getNodeProperty("argumentExpression")), this.sourceBefore(TSCSyntaxKind.CloseBracketToken))), this.typeMapping.type(node));
    }

    private Statement visitEmptyStatement(TSCNode ignored) {
        return new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
    }

    private J.EnumValue visitEnumMember(TSCNode node) {
        return new J.EnumValue(Tree.randomId(), this.whitespace(), Markers.EMPTY, Collections.emptyList(), this.visitIdentifier(node.getNodeProperty("name")), null);
    }

    public Expression visitExpressionStatement(TSCNode node) {
        return (Expression)this.visitNode(node.getNodeProperty("expression"));
    }

    private J.ForLoop visitForStatement(TSCNode node) {
        List<JRightPadded<Statement>> update;
        Space prefix = this.sourceBefore(TSCSyntaxKind.ForKeyword);
        Space beforeControl = this.sourceBefore(TSCSyntaxKind.OpenParenToken);
        List<JRightPadded<Statement>> initStatements = Collections.singletonList(this.padRight((Statement)this.visitNode(node.getNodeProperty("initializer")), this.whitespace()));
        this.consumeToken(TSCSyntaxKind.SemicolonToken);
        JRightPadded<Expression> condition = this.padRight((Expression)this.visitNode(node.getNodeProperty("condition")), this.sourceBefore(TSCSyntaxKind.SemicolonToken));
        TSCNode incrementor = node.getNodeProperty("incrementor");
        if (incrementor.syntaxKind() == TSCSyntaxKind.BinaryExpression) {
            update = new ArrayList<JRightPadded<Statement>>(2);
            this.visitBinaryUpdateExpression(incrementor, update);
        } else {
            update = Collections.singletonList(this.padRight((Statement)this.visitNode(incrementor), this.sourceBefore(TSCSyntaxKind.CloseParenToken)));
        }
        J.ForLoop.Control control = new J.ForLoop.Control(Tree.randomId(), beforeControl, Markers.EMPTY, initStatements, condition, update);
        return new J.ForLoop(Tree.randomId(), prefix, Markers.EMPTY, control, this.maybeSemicolon((Statement)this.visitNode(node.getNodeProperty("statement"))));
    }

    private J.ForEachLoop visitForEachStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.ForKeyword);
        Markers markers = Markers.EMPTY;
        this.implementMe(node, "awaitModifier");
        Space beforeControl = this.sourceBefore(TSCSyntaxKind.OpenParenToken);
        JRightPadded<J.VariableDeclarations> variable = this.padRight((J.VariableDeclarations)this.visitNode(node.getNodeProperty("initializer")), this.whitespace());
        TSCSyntaxKind forEachKind = this.scan();
        if (forEachKind == TSCSyntaxKind.OfKeyword) {
            markers = markers.addIfAbsent((Marker)new ForLoopType(Tree.randomId(), ForLoopType.Keyword.OF));
        } else if (forEachKind == TSCSyntaxKind.InKeyword) {
            markers = markers.addIfAbsent((Marker)new ForLoopType(Tree.randomId(), ForLoopType.Keyword.IN));
        }
        JRightPadded<Expression> iterable = this.padRight((Expression)this.visitNode(node.getNodeProperty("expression")), this.sourceBefore(TSCSyntaxKind.CloseParenToken));
        J.ForEachLoop.Control control = new J.ForEachLoop.Control(Tree.randomId(), beforeControl, Markers.EMPTY, variable, iterable);
        JRightPadded<Statement> statement = this.maybeSemicolon((Statement)this.visitNode(node.getNodeProperty("statement")));
        return new J.ForEachLoop(Tree.randomId(), prefix, markers, control, statement);
    }

    private J visitExpressionWithTypeArguments(TSCNode node) {
        Space prefix = this.whitespace();
        NameTree nameTree = (NameTree)this.visitNode(node.getNodeProperty("expression"));
        TSCNodeList typeArguments = node.getOptionalNodeListProperty("typeArguments");
        if (typeArguments != null) {
            return new J.ParameterizedType(Tree.randomId(), prefix, Markers.EMPTY, nameTree, this.mapContainer(TSCSyntaxKind.LessThanToken, typeArguments, TSCSyntaxKind.CommaToken, TSCSyntaxKind.GreaterThanToken, t -> (Expression)this.visitNode((TSCNode)t)), this.typeMapping.type(node));
        }
        return nameTree.withPrefix(prefix);
    }

    private J.MethodDeclaration visitFunctionDeclaration(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.FunctionKeyword);
        JavaType.Method method = this.typeMapping.methodDeclarationType(node);
        J.Identifier name = node.hasProperty("name") ? this.visitIdentifier(node.getNodeProperty("name")) : new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "", null, null);
        name = name.withType((JavaType)method);
        JContainer<Statement> parameters = this.mapContainer(TSCSyntaxKind.OpenParenToken, node.getNodeListProperty("parameters"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, this::visitFunctionParameter);
        J.Block block = this.visitBlock(node.getOptionalNodeProperty("body"));
        return new J.MethodDeclaration(Tree.randomId(), prefix, Markers.EMPTY.addIfAbsent((Marker)new FunctionDeclaration(Tree.randomId())), Collections.emptyList(), Collections.emptyList(), null, null, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), parameters, null, block, null, method);
    }

    private Statement visitFunctionParameter(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), leadingAnnotations);
        Space variablePrefix = this.whitespace();
        J.Identifier name = this.visitIdentifier(node.getNodeProperty("name"));
        this.implementMe(node, "questionToken");
        TypeTree typeTree = null;
        TSCNode type = node.getOptionalNodeProperty("type");
        if (type != null) {
            Space beforeColon = this.sourceBefore(TSCSyntaxKind.ColonToken);
            if (beforeColon != Space.EMPTY) {
                markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), beforeColon));
            }
            typeTree = (TypeTree)this.visitNode(type);
        }
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> variables = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        variables.add(this.padRight(new J.VariableDeclarations.NamedVariable(Tree.randomId(), variablePrefix, Markers.EMPTY, name, Collections.emptyList(), null, this.typeMapping.variableType(node)), Space.EMPTY));
        this.implementMe(node, "initializer");
        Space varargs = null;
        List dimensionsBeforeName = Collections.emptyList();
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, leadingAnnotations.isEmpty() ? Collections.emptyList() : leadingAnnotations, modifiers, typeTree, varargs, dimensionsBeforeName, variables);
    }

    private J.Identifier visitIdentifier(TSCNode node) {
        return this.visitIdentifier(node, null, null);
    }

    private J.Identifier visitIdentifier(TSCNode node, @Nullable JavaType type) {
        return this.visitIdentifier(node, type, null);
    }

    private J.Identifier visitIdentifier(TSCNode node, @Nullable JavaType type, @Nullable JavaType.Variable fieldType) {
        Space prefix = this.whitespace();
        this.cursorContext.resetScanner(this.getCursor() + node.getText().length());
        return new J.Identifier(Tree.randomId(), prefix, Markers.EMPTY, node.getText(), type == null ? this.typeMapping.type(node) : type, fieldType);
    }

    private J visitIndexedAccessType(TSCNode node) {
        return this.unknownElement(node);
    }

    private J.If visitIfStatement(TSCNode node) {
        Space prefix = this.whitespace();
        this.consumeToken(TSCSyntaxKind.IfKeyword);
        J.ControlParentheses control = this.mapControlParentheses(node.getNodeProperty("expression"));
        JRightPadded<Statement> thenPart = this.visitStatement(node.getNodeProperty("thenStatement"));
        J.If.Else elsePart = null;
        if (node.hasProperty("elseStatement")) {
            Space elsePartPrefix = this.whitespace();
            this.consumeToken(TSCSyntaxKind.ElseKeyword);
            elsePart = new J.If.Else(Tree.randomId(), elsePartPrefix, Markers.EMPTY, this.visitStatement(node.getNodeProperty("elseStatement")));
        }
        return new J.If(Tree.randomId(), prefix, Markers.EMPTY, control, thenPart, elsePart);
    }

    private J.InstanceOf visitInstanceOf(TSCNode node) {
        return new J.InstanceOf(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.padRight((Expression)this.visitNode(node.getNodeProperty("left")), this.sourceBefore(TSCSyntaxKind.InstanceOfKeyword)), this.visitNode(node.getNodeProperty("right")), null, this.typeMapping.type(node));
    }

    private JS.JsBinary visitJsBinary(TSCNode node) {
        JLeftPadded<JS.JsBinary.Type> op;
        Space prefix = this.whitespace();
        Expression left = (Expression)this.visitNode(node.getNodeProperty("left"));
        TSCSyntaxKind opKind = node.getNodeProperty("operatorToken").syntaxKind();
        if (opKind == TSCSyntaxKind.EqualsEqualsEqualsToken) {
            op = this.padLeft(this.sourceBefore(TSCSyntaxKind.EqualsEqualsEqualsToken), JS.JsBinary.Type.IdentityEquals);
        } else if (opKind == TSCSyntaxKind.ExclamationEqualsEqualsToken) {
            op = this.padLeft(this.sourceBefore(TSCSyntaxKind.ExclamationEqualsEqualsToken), JS.JsBinary.Type.IdentityNotEquals);
        } else {
            throw new IllegalArgumentException(String.format("Binary operator kind <%s> is not supported.", new Object[]{opKind}));
        }
        Expression right = (Expression)this.visitNode(node.getNodeProperty("right"));
        return new JS.JsBinary(Tree.randomId(), prefix, Markers.EMPTY, left, op, right, this.typeMapping.type(node));
    }

    private J.Identifier visitKeyword(TSCNode node) {
        return this.visitIdentifier(node);
    }

    private J.Label visitLabelledStatement(TSCNode node) {
        return new J.Label(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.padRight(this.visitIdentifier(node.getNodeProperty("label")), this.sourceBefore(TSCSyntaxKind.ColonToken)), (Statement)this.visitNode(node.getNodeProperty("statement")));
    }

    private J.MethodDeclaration visitMethodDeclaration(TSCNode node) {
        Space prefix = this.whitespace();
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), annotations);
        this.implementMe(node, "asteriskToken");
        this.implementMe(node, "questionToken");
        this.implementMe(node, "exclamationToken");
        this.implementMe(node, "typeArguments");
        JavaType.Method methodType = this.typeMapping.methodDeclarationType(node);
        J.Identifier name = this.visitIdentifier(node.getNodeProperty("name"), (JavaType)methodType);
        J.TypeParameters typeParameters = node.hasProperty("typeParameters") ? new J.TypeParameters(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.LessThanToken), Markers.EMPTY, Collections.emptyList(), this.convertAll(node.getNodeListProperty("typeParameters"), this.commaDelim, t -> this.sourceBefore(TSCSyntaxKind.GreaterThanToken))) : null;
        JContainer<Statement> parameters = this.mapContainer(TSCSyntaxKind.OpenParenToken, node.getNodeListProperty("parameters"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, t -> (Statement)this.visitNode((TSCNode)t));
        JContainer throw_ = null;
        TypeTree returnTypeExpression = null;
        if (node.hasProperty("type")) {
            Markers markers = Markers.EMPTY.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ColonToken)));
            returnTypeExpression = (TypeTree)this.visitNode(node.getNodeProperty("type")).withMarkers(markers);
        }
        J.Block body = this.visitBlock(node.getOptionalNodeProperty("body"));
        JLeftPadded defaultValue = null;
        return new J.MethodDeclaration(Tree.randomId(), prefix, Markers.EMPTY, annotations.isEmpty() ? Collections.emptyList() : annotations, modifiers, typeParameters, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), parameters, throw_, body, defaultValue, methodType);
    }

    private Expression visitNameExpression(TSCNode expression) {
        if (expression.hasProperty("expression")) {
            Space prefix = this.whitespace();
            Expression select = this.visitNameExpression(expression.getNodeProperty("expression"));
            this.implementMe(expression, "questionDotToken");
            JLeftPadded<J.Identifier> name = this.padLeft(this.sourceBefore(TSCSyntaxKind.DotToken), this.visitIdentifier(expression.getNodeProperty("name")));
            return new J.FieldAccess(Tree.randomId(), prefix, Markers.EMPTY, select, name, this.typeMapping.type(expression));
        }
        Expression identifier = null;
        if (expression.hasProperty("name")) {
            identifier = (Expression)this.visitNode(expression.getNodeProperty("name"));
        } else if (expression.hasProperty("escapedText") || expression.syntaxKind() == TSCSyntaxKind.ThisKeyword) {
            identifier = (Expression)this.visitNode(expression);
        } else {
            this.implementMe(expression);
        }
        return identifier;
    }

    private J visitLiteralType(TSCNode node) {
        Space prefix = this.whitespace();
        Object obj = null;
        TSCNode literal = node.getNodeProperty("literal");
        if (literal.syntaxKind() == TSCSyntaxKind.NullKeyword) {
            this.consumeToken(TSCSyntaxKind.NullKeyword);
        } else {
            this.implementMe(literal);
        }
        return new J.Literal(Tree.randomId(), prefix, Markers.EMPTY, obj, literal.getText(), null, this.typeMapping.primitive(literal));
    }

    private J.NewClass visitNewExpression(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.NewKeyword);
        TypeTree typeTree = null;
        if (node.hasProperty("expression")) {
            typeTree = (TypeTree)this.visitNameExpression(node.getNodeProperty("expression"));
        }
        this.implementMe(node, "typeArguments");
        JContainer<Expression> arguments = this.mapContainer(TSCSyntaxKind.OpenParenToken, node.getNodeListProperty("arguments"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.CloseParenToken, t -> (Expression)this.visitNode((TSCNode)t));
        return new J.NewClass(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, prefix, typeTree, arguments, null, this.typeMapping.methodInvocationType(node));
    }

    private J.Literal visitNumericLiteral(TSCNode node) {
        return new J.Literal(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.NumericLiteral), Markers.EMPTY, (Object)node.getStringProperty("text"), node.getText(), null, this.typeMapping.primitive(node));
    }

    private J visitObjectBindingPattern(TSCNode node) {
        return this.unknownElement(node);
    }

    private J visitObjectLiteralExpression(TSCNode node) {
        return this.unknownElement(node);
    }

    private <J2 extends J> J.Parentheses<J2> visitParenthesizedExpression(TSCNode node) {
        return new J.Parentheses(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.OpenParenToken), Markers.EMPTY, this.padRight(this.visitNode(node.getNodeProperty("expression")), this.sourceBefore(TSCSyntaxKind.CloseParenToken)));
    }

    private J.FieldAccess visitPropertyAccessExpression(TSCNode node) {
        Space prefix = this.whitespace();
        this.implementMe(node, "questionDotToken");
        Expression nameExpression = (Expression)this.visitNode(node.getNodeProperty("expression"));
        return new J.FieldAccess(Tree.randomId(), prefix, Markers.EMPTY, nameExpression, this.padLeft(this.sourceBefore(TSCSyntaxKind.DotToken), this.visitIdentifier(node.getNodeProperty("name"))), this.typeMapping.type(node));
    }

    private J.VariableDeclarations visitPropertyDeclaration(TSCNode node) {
        JLeftPadded<Expression> initializer;
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        this.implementMe(node, "questionToken");
        this.implementMe(node, "exclamationToken");
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        List<Object> modifiers = node.hasProperty("modifiers") ? this.mapModifiers(node.getNodeListProperty("modifiers"), leadingAnnotations) : Collections.emptyList();
        Space variablePrefix = this.whitespace();
        J j = this.visitNode(node.getNodeProperty("name"));
        J.Identifier name = null;
        if (j instanceof J.Identifier) {
            name = (J.Identifier)j;
        } else {
            this.implementMe(node);
        }
        TypeTree typeTree = null;
        if (node.hasProperty("type")) {
            Space beforeColon = this.sourceBefore(TSCSyntaxKind.ColonToken);
            if (beforeColon != Space.EMPTY) {
                markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), beforeColon));
            }
            TSCNode type = node.getNodeProperty("type");
            typeTree = (TypeTree)this.visitNode(type);
            name = name.withType(this.typeMapping.type(type));
        }
        if (node.hasProperty("initializer")) {
            Space beforeEquals = this.sourceBefore(TSCSyntaxKind.EqualsToken);
            J init = this.visitNode(node.getNodeProperty("initializer"));
            if (init != null && !(init instanceof Expression)) {
                init = new JS.StatementExpression(Tree.randomId(), (Statement)init);
            }
            initializer = this.padLeft(beforeEquals, (Expression)init);
        } else {
            initializer = null;
        }
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> variables = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        variables.add(this.maybeSemicolon(new J.VariableDeclarations.NamedVariable(Tree.randomId(), variablePrefix, Markers.EMPTY, name, Collections.emptyList(), initializer, this.typeMapping.variableType(node))));
        List dimensions = Collections.emptyList();
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, leadingAnnotations.isEmpty() ? Collections.emptyList() : leadingAnnotations, modifiers, typeTree, null, dimensions, variables);
    }

    private J.FieldAccess visitQualifiedName(TSCNode node) {
        return new J.FieldAccess(Tree.randomId(), this.whitespace(), Markers.EMPTY, (Expression)this.visitNode(node.getNodeProperty("left")), this.padLeft(this.sourceBefore(TSCSyntaxKind.DotToken), (J.Identifier)this.visitNode(node.getNodeProperty("right"))), this.typeMapping.type(node));
    }

    private J.Return visitReturnStatement(TSCNode node) {
        J j;
        Space prefix = this.sourceBefore(TSCSyntaxKind.ReturnKeyword);
        Expression expression = null;
        J j2 = j = !node.hasProperty("expression") ? null : this.visitNode(node.getNodeProperty("expression"));
        if (j != null) {
            expression = j instanceof Expression ? (Expression)j : new JS.StatementExpression(Tree.randomId(), (Statement)j);
        }
        return new J.Return(Tree.randomId(), prefix, Markers.EMPTY, expression);
    }

    private JRightPadded<Statement> visitStatement(TSCNode node) {
        Statement statement = (Statement)this.visitNode(node);
        assert (statement != null);
        return this.maybeSemicolon(statement);
    }

    private J.Literal visitStringLiteral(TSCNode node) {
        this.implementMe(node, "singleQuote");
        if (node.getBooleanProperty("hasExtendedUnicodeEscape")) {
            this.implementMe(node, "hasExtendedUnicodeEscape");
        }
        return new J.Literal(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.StringLiteral), Markers.EMPTY, (Object)node.getStringProperty("text"), node.getText(), null, JavaType.Primitive.String);
    }

    private J.Throw visitThrowStatement(TSCNode node) {
        return new J.Throw(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.ThrowKeyword), Markers.EMPTY, (Expression)this.visitNode(node.getNodeProperty("expression")));
    }

    private J.Try visitTryStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.TryKeyword);
        J.Block tryBlock = (J.Block)this.visitNode(node.getNodeProperty("tryBlock"));
        TSCNode catchClause = node.getNodeProperty("catchClause");
        J.Try.Catch aCatch = new J.Try.Catch(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.CatchKeyword), Markers.EMPTY, this.mapControlParentheses(catchClause.getNodeProperty("variableDeclaration")), (J.Block)this.visitNode(catchClause.getNodeProperty("block")));
        JLeftPadded<J.Block> finallyBlock = null;
        if (node.hasProperty("finallyBlock")) {
            finallyBlock = this.padLeft(this.sourceBefore(TSCSyntaxKind.FinallyKeyword), (J.Block)this.visitNode(node.getNodeProperty("finallyBlock")));
        }
        return new J.Try(Tree.randomId(), prefix, Markers.EMPTY, null, tryBlock, Collections.singletonList(aCatch), finallyBlock);
    }

    private J visitTupleType(TSCNode node) {
        return this.unknownElement(node);
    }

    private JS.JsOperator visitTsOperator(TSCNode node) {
        Space prefix = this.whitespace();
        Expression left = null;
        JLeftPadded<JS.JsOperator.Type> op = null;
        Expression right = null;
        if (node.syntaxKind() == TSCSyntaxKind.TypeOfExpression) {
            op = this.padLeft(this.sourceBefore(TSCSyntaxKind.TypeOfKeyword), JS.JsOperator.Type.TypeOf);
            right = (Expression)this.visitNode(node.getNodeProperty("expression"));
        } else {
            this.implementMe(node);
        }
        return new JS.JsOperator(Tree.randomId(), prefix, Markers.EMPTY, left, op, right, this.typeMapping.type(node));
    }

    private JS.TypeOperator visitTypeOperator(TSCNode node) {
        Space prefix = this.whitespace();
        TSCSyntaxKind op = node.getSyntaxKindProperty("operator");
        JS.TypeOperator.Type operator = null;
        Space before = Space.EMPTY;
        if (op == TSCSyntaxKind.ReadonlyKeyword) {
            before = this.sourceBefore(TSCSyntaxKind.ReadonlyKeyword);
            operator = JS.TypeOperator.Type.ReadOnly;
        } else {
            this.implementMe(node);
        }
        return new JS.TypeOperator(Tree.randomId(), prefix, Markers.EMPTY, operator, this.padLeft(before, (Expression)this.visitNode(node.getNodeProperty("type"))), null);
    }

    private J.TypeParameter visitTypeParameter(TSCNode node) {
        Space prefix = this.whitespace();
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(node.getOptionalNodeListProperty("modifiers"), annotations);
        this.implementMe(node, "expression");
        this.implementMe(node, "default");
        Expression name = (Expression)this.visitNode(node.getNodeProperty("name"));
        JContainer bounds = !node.hasProperty("constraint") ? null : JContainer.build((Space)this.sourceBefore(TSCSyntaxKind.ExtendsKeyword), this.convertAll(node.getNodeProperty("constraint").syntaxKind() == TSCSyntaxKind.IntersectionType ? node.getNodeProperty("constraint").getNodeListProperty("types") : Collections.singletonList(node.getNodeProperty("constraint")), t -> this.sourceBefore(TSCSyntaxKind.AmpersandToken), this.noDelim), (Markers)Markers.EMPTY);
        return new J.TypeParameter(Tree.randomId(), prefix, Markers.EMPTY, annotations.isEmpty() ? Collections.emptyList() : annotations, name, bounds);
    }

    private J.ParameterizedType visitTypeQuery(TSCNode node) {
        Space prefix = this.whitespace();
        Space typeOfPrefix = this.sourceBefore(TSCSyntaxKind.TypeOfKeyword);
        Expression name = (Expression)this.visitNode(node.getNodeProperty("exprName"));
        JS.JsOperator op = new JS.JsOperator(Tree.randomId(), typeOfPrefix, Markers.EMPTY, null, this.padLeft(Space.EMPTY, JS.JsOperator.Type.TypeOf), name, this.typeMapping.type(node));
        return new J.ParameterizedType(Tree.randomId(), prefix, Markers.EMPTY, (NameTree)op, !node.hasProperty("typeArguments") ? null : this.mapContainer(TSCSyntaxKind.LessThanToken, node.getNodeListProperty("typeArguments"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.GreaterThanToken, t -> (Expression)this.visitNode((TSCNode)t)), this.typeMapping.type(node));
    }

    private J.ParameterizedType visitTypeReference(TSCNode node) {
        return new J.ParameterizedType(Tree.randomId(), this.whitespace(), Markers.EMPTY, (NameTree)this.visitNode(node.getNodeProperty("typeName")), !node.hasProperty("typeArguments") ? null : this.mapContainer(TSCSyntaxKind.LessThanToken, node.getNodeListProperty("typeArguments"), TSCSyntaxKind.CommaToken, TSCSyntaxKind.GreaterThanToken, t -> (Expression)this.visitNode((TSCNode)t)), this.typeMapping.type(node));
    }

    private J.Unary visitUnaryExpression(TSCNode node) {
        Expression expression;
        Space prefix = this.whitespace();
        JLeftPadded<J.Unary.Type> op = null;
        TSCSyntaxKind opKind = TSCSyntaxKind.fromCode(node.getIntProperty("operator"));
        if (node.syntaxKind() == TSCSyntaxKind.PrefixUnaryExpression) {
            if (opKind == TSCSyntaxKind.ExclamationToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.ExclamationToken), J.Unary.Type.Not);
            } else if (opKind == TSCSyntaxKind.MinusMinusToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.MinusMinusToken), J.Unary.Type.PreDecrement);
            } else if (opKind == TSCSyntaxKind.PlusPlusToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.PlusPlusToken), J.Unary.Type.PreIncrement);
            } else {
                this.implementMe(node);
            }
            expression = (Expression)this.visitNode(node.getNodeProperty("operand"));
        } else {
            expression = (Expression)this.visitNode(node.getNodeProperty("operand"));
            if (opKind == TSCSyntaxKind.MinusMinusToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.MinusMinusToken), J.Unary.Type.PostDecrement);
            } else if (opKind == TSCSyntaxKind.PlusPlusToken) {
                op = this.padLeft(this.sourceBefore(TSCSyntaxKind.PlusPlusToken), J.Unary.Type.PostIncrement);
            } else {
                this.implementMe(node);
            }
        }
        return new J.Unary(Tree.randomId(), prefix, Markers.EMPTY, op, expression, this.typeMapping.type(node));
    }

    private JS.Union visitUnionType(TSCNode node) {
        Space prefix = this.whitespace();
        return new JS.Union(Tree.randomId(), prefix, Markers.EMPTY, this.convertAll(node.getNodeListProperty("types"), t -> this.sourceBefore(TSCSyntaxKind.BarToken), t -> Space.EMPTY), (JavaType)TsType.UNION);
    }

    private J.WhileLoop visitWhileStatement(TSCNode node) {
        Space prefix = this.sourceBefore(TSCSyntaxKind.WhileKeyword);
        J.ControlParentheses control = this.mapControlParentheses(node.getNodeProperty("expression"));
        return new J.WhileLoop(Tree.randomId(), prefix, Markers.EMPTY, control, this.maybeSemicolon((Statement)this.visitNode(node.getNodeProperty("statement"))));
    }

    private J.VariableDeclarations visitVariableDeclaration(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        this.implementMe(node, "exclamationToken");
        int saveCursor = this.getCursor();
        TSCSyntaxKind keyword = this.scan();
        VariableModifier.Keyword variableModifier = null;
        if (keyword == TSCSyntaxKind.ConstKeyword) {
            variableModifier = VariableModifier.Keyword.CONST;
        } else if (keyword == TSCSyntaxKind.LetKeyword) {
            variableModifier = VariableModifier.Keyword.LET;
        } else if (keyword == TSCSyntaxKind.VarKeyword) {
            variableModifier = VariableModifier.Keyword.VAR;
        } else {
            this.cursor(saveCursor);
        }
        if (variableModifier != null) {
            markers = markers.addIfAbsent((Marker)new VariableModifier(Tree.randomId(), variableModifier));
        }
        TypeTree typeTree = null;
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> namedVariables = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        Space variablePrefix = this.whitespace();
        J j = this.visitNode(node.getNodeProperty("name"));
        J.Identifier name = null;
        if (j instanceof J.Identifier) {
            name = (J.Identifier)j;
        } else {
            this.implementMe(node);
        }
        if (node.hasProperty("type")) {
            Space beforeColon = this.sourceBefore(TSCSyntaxKind.ColonToken);
            if (beforeColon != Space.EMPTY) {
                markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), beforeColon));
            }
            typeTree = (TypeTree)this.visitNode(node.getNodeProperty("type"));
        }
        J.VariableDeclarations.NamedVariable variable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), variablePrefix, Markers.EMPTY, name, Collections.emptyList(), node.hasProperty("initializer") ? this.padLeft(this.sourceBefore(TSCSyntaxKind.EqualsToken), (Expression)Objects.requireNonNull(this.visitNode(node.getNodeProperty("initializer")))) : null, this.typeMapping.variableType(node));
        namedVariables.add(this.padRight(variable, Space.EMPTY));
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, Collections.emptyList(), Collections.emptyList(), typeTree, null, Collections.emptyList(), namedVariables);
    }

    private J.VariableDeclarations visitVariableDeclarationList(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        TSCSyntaxKind keyword = this.scan();
        VariableModifier.Keyword variableModifier = null;
        if (keyword == TSCSyntaxKind.ConstKeyword) {
            variableModifier = VariableModifier.Keyword.CONST;
        } else if (keyword == TSCSyntaxKind.LetKeyword) {
            variableModifier = VariableModifier.Keyword.LET;
        } else if (keyword == TSCSyntaxKind.VarKeyword) {
            variableModifier = VariableModifier.Keyword.VAR;
        } else {
            this.implementMe(node);
        }
        markers = markers.addIfAbsent((Marker)new VariableModifier(Tree.randomId(), variableModifier));
        List namedVariables = Collections.emptyList();
        TypeTree typeTree = null;
        if (node.hasProperty("declarations")) {
            TSCNodeList declarations = node.getNodeListProperty("declarations");
            HashSet<JavaType> types = new HashSet<JavaType>(declarations.size());
            namedVariables = new ArrayList(declarations.size());
            for (int i = 0; i < declarations.size(); ++i) {
                TSCNode declaration = (TSCNode)declarations.get(i);
                this.implementMe(declaration, "exclamationToken");
                Space variablePrefix = this.whitespace();
                J j = this.visitNode(declaration.getNodeProperty("name"));
                J.Identifier name = null;
                if (j instanceof J.Identifier) {
                    name = (J.Identifier)j;
                } else {
                    this.implementMe(declaration);
                }
                if (declaration.hasProperty("type")) {
                    TSCNode type;
                    Space beforeColon = this.sourceBefore(TSCSyntaxKind.ColonToken);
                    if (beforeColon != Space.EMPTY) {
                        markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), beforeColon));
                    }
                    if ((typeTree = (TypeTree)this.visitNode(type = declaration.getNodeProperty("type"))).getType() != null) {
                        types.add(typeTree.getType());
                        if (types.size() > 1) {
                            throw new UnsupportedOperationException("Multiple variable types are not supported");
                        }
                    }
                }
                J.VariableDeclarations.NamedVariable variable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), variablePrefix, Markers.EMPTY, name, Collections.emptyList(), declaration.hasProperty("initializer") ? this.padLeft(this.sourceBefore(TSCSyntaxKind.EqualsToken), (Expression)Objects.requireNonNull(this.visitNode(declaration.getNodeProperty("initializer")))) : null, this.typeMapping.variableType(declaration));
                Space after = this.whitespace();
                if (i < declarations.size() - 1) {
                    this.consumeToken(TSCSyntaxKind.CommaToken);
                }
                namedVariables.add(this.padRight(variable, after));
            }
        }
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, Collections.emptyList(), Collections.emptyList(), typeTree, null, Collections.emptyList(), namedVariables);
    }

    private J.VariableDeclarations visitVariableStatement(TSCNode node) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        List annotations = Collections.emptyList();
        List modifiers = Collections.emptyList();
        this.implementMe(node, "modifiers");
        this.implementMe(node, "exclamationToken");
        TSCSyntaxKind keyword = this.scan();
        VariableModifier.Keyword variableModifier = null;
        if (keyword == TSCSyntaxKind.ConstKeyword) {
            variableModifier = VariableModifier.Keyword.CONST;
        } else if (keyword == TSCSyntaxKind.LetKeyword) {
            variableModifier = VariableModifier.Keyword.LET;
        } else if (keyword == TSCSyntaxKind.VarKeyword) {
            variableModifier = VariableModifier.Keyword.VAR;
        } else {
            this.implementMe(node);
        }
        markers = markers.addIfAbsent((Marker)new VariableModifier(Tree.randomId(), variableModifier));
        List namedVariables = Collections.emptyList();
        TypeTree typeTree = null;
        if (node.hasProperty("declarationList")) {
            TSCNode declarationList = node.getNodeProperty("declarationList");
            TSCNodeList declarations = declarationList.getNodeListProperty("declarations");
            HashSet<JavaType> types = new HashSet<JavaType>(declarations.size());
            namedVariables = new ArrayList(declarations.size());
            for (int i = 0; i < declarations.size(); ++i) {
                TSCNode declaration = (TSCNode)declarations.get(i);
                Space variablePrefix = this.whitespace();
                J j = this.visitNode(declaration.getNodeProperty("name"));
                J.Identifier name = null;
                if (j instanceof J.Identifier) {
                    name = (J.Identifier)j;
                } else {
                    this.implementMe(declaration);
                }
                if (declaration.hasProperty("type")) {
                    TSCNode type;
                    Space beforeColon = this.sourceBefore(TSCSyntaxKind.ColonToken);
                    if (beforeColon != Space.EMPTY) {
                        markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), beforeColon));
                    }
                    if ((typeTree = (TypeTree)this.visitNode(type = declaration.getNodeProperty("type"))).getType() != null) {
                        types.add(typeTree.getType());
                        if (types.size() > 1) {
                            throw new UnsupportedOperationException("Multiple variable types are not supported");
                        }
                    }
                }
                J.VariableDeclarations.NamedVariable variable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), variablePrefix, Markers.EMPTY, name, Collections.emptyList(), declaration.hasProperty("initializer") ? this.padLeft(this.sourceBefore(TSCSyntaxKind.EqualsToken), (Expression)Objects.requireNonNull(this.visitNode(declaration.getNodeProperty("initializer")))) : null, this.typeMapping.variableType(declaration));
                Space after = this.whitespace();
                if (i < declarations.size() - 1) {
                    this.consumeToken(TSCSyntaxKind.CommaToken);
                }
                namedVariables.add(this.padRight(variable, after));
            }
        }
        return new J.VariableDeclarations(Tree.randomId(), prefix, markers, annotations, modifiers, typeTree, null, Collections.emptyList(), namedVariables);
    }

    @Nullable
    private J visitNode(TSCNode node) {
        Object j;
        switch (node.syntaxKind()) {
            case EnumDeclaration: 
            case InterfaceDeclaration: 
            case ClassDeclaration: 
            case ClassExpression: {
                j = this.visitClassDeclaration(node);
                break;
            }
            case AnyKeyword: 
            case BooleanKeyword: 
            case FalseKeyword: 
            case NumberKeyword: 
            case StringKeyword: 
            case SuperKeyword: 
            case ThisKeyword: 
            case TrueKeyword: 
            case UndefinedKeyword: 
            case UnknownKeyword: 
            case VoidKeyword: {
                j = this.visitKeyword(node);
                break;
            }
            case ForOfStatement: 
            case ForInStatement: {
                j = this.visitForEachStatement(node);
                break;
            }
            case FunctionDeclaration: 
            case FunctionExpression: {
                j = this.visitFunctionDeclaration(node);
                break;
            }
            case MethodDeclaration: 
            case MethodSignature: {
                j = this.visitMethodDeclaration(node);
                break;
            }
            case Parameter: 
            case PropertyDeclaration: {
                j = this.visitPropertyDeclaration(node);
                break;
            }
            case PostfixUnaryExpression: 
            case PrefixUnaryExpression: {
                j = this.visitUnaryExpression(node);
                break;
            }
            case ArrayBindingPattern: {
                j = this.visitArrayBindingPattern(node);
                break;
            }
            case ArrayLiteralExpression: {
                j = this.visitArrayLiteralExpression(node);
                break;
            }
            case ArrayType: {
                j = this.mapArrayType(node);
                break;
            }
            case AsExpression: {
                j = this.visitAsExpression(node);
                break;
            }
            case BinaryExpression: {
                j = this.visitBinaryExpression(node);
                break;
            }
            case Block: {
                j = this.visitBlock(node);
                break;
            }
            case BreakStatement: {
                j = this.visitBreakStatement(node);
                break;
            }
            case CallExpression: {
                j = this.visitCallExpression(node);
                break;
            }
            case ConditionalExpression: {
                j = this.visitConditionalExpression(node);
                break;
            }
            case ContinueStatement: {
                j = this.visitContinueStatement(node);
                break;
            }
            case Constructor: {
                j = this.visitConstructor(node);
                break;
            }
            case Decorator: {
                j = this.visitDecorator(node);
                break;
            }
            case DoStatement: {
                j = this.visitDoStatement(node);
                break;
            }
            case ElementAccessExpression: {
                j = this.visitElementAccessExpression(node);
                break;
            }
            case EmptyStatement: {
                j = this.visitEmptyStatement(node);
                break;
            }
            case EnumMember: {
                j = this.visitEnumMember(node);
                break;
            }
            case ExpressionStatement: {
                j = this.visitExpressionStatement(node);
                break;
            }
            case ExpressionWithTypeArguments: {
                j = this.visitExpressionWithTypeArguments(node);
                break;
            }
            case Identifier: {
                j = this.visitIdentifier(node);
                break;
            }
            case IndexedAccessType: {
                j = this.visitIndexedAccessType(node);
                break;
            }
            case IfStatement: {
                j = this.visitIfStatement(node);
                break;
            }
            case ForStatement: {
                j = this.visitForStatement(node);
                break;
            }
            case LabeledStatement: {
                j = this.visitLabelledStatement(node);
                break;
            }
            case LiteralType: {
                j = this.visitLiteralType(node);
                break;
            }
            case NewExpression: {
                j = this.visitNewExpression(node);
                break;
            }
            case NumericLiteral: {
                j = this.visitNumericLiteral(node);
                break;
            }
            case ObjectBindingPattern: {
                j = this.visitObjectBindingPattern(node);
                break;
            }
            case ObjectLiteralExpression: {
                j = this.visitObjectLiteralExpression(node);
                break;
            }
            case ParenthesizedExpression: {
                j = this.visitParenthesizedExpression(node);
                break;
            }
            case PropertyAccessExpression: {
                j = this.visitPropertyAccessExpression(node);
                break;
            }
            case QualifiedName: {
                j = this.visitQualifiedName(node);
                break;
            }
            case ReturnStatement: {
                j = this.visitReturnStatement(node);
                break;
            }
            case StringLiteral: {
                j = this.visitStringLiteral(node);
                break;
            }
            case ThrowStatement: {
                j = this.visitThrowStatement(node);
                break;
            }
            case TryStatement: {
                j = this.visitTryStatement(node);
                break;
            }
            case TupleType: {
                j = this.visitTupleType(node);
                break;
            }
            case TypeOfExpression: {
                j = this.visitTsOperator(node);
                break;
            }
            case TypeOperator: {
                j = this.visitTypeOperator(node);
                break;
            }
            case TypeParameter: {
                j = this.visitTypeParameter(node);
                break;
            }
            case TypeQuery: {
                j = this.visitTypeQuery(node);
                break;
            }
            case TypeReference: {
                j = this.visitTypeReference(node);
                break;
            }
            case UnionType: {
                j = this.visitUnionType(node);
                break;
            }
            case WhileStatement: {
                j = this.visitWhileStatement(node);
                break;
            }
            case VariableDeclaration: {
                j = this.visitVariableDeclaration(node);
                break;
            }
            case VariableDeclarationList: {
                j = this.visitVariableDeclarationList(node);
                break;
            }
            case VariableStatement: {
                j = this.visitVariableStatement(node);
                break;
            }
            default: {
                this.implementMe(node);
                System.err.println("unsupported syntax kind: " + (Object)((Object)node.syntaxKind()));
                j = null;
            }
        }
        return j;
    }

    private Integer getCursor() {
        return this.cursorContext.scannerTokenEnd();
    }

    private void cursor(int cursor) {
        this.cursorContext.resetScanner(cursor);
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    private <T> JRightPadded<T> padRight(T tree, @Nullable Space right) {
        return new JRightPadded(tree, right == null ? Space.EMPTY : right, Markers.EMPTY);
    }

    private <K2 extends J> JRightPadded<K2> maybeSemicolon(K2 k) {
        int saveCursor = this.getCursor();
        Space beforeSemi = this.whitespace();
        Semicolon semicolon = null;
        if (this.getCursor() < this.source.getText().length() && this.source.getText().charAt(this.getCursor()) == ';') {
            semicolon = new Semicolon(Tree.randomId());
            this.consumeToken(TSCSyntaxKind.SemicolonToken);
        } else {
            beforeSemi = Space.EMPTY;
            this.cursor(saveCursor);
        }
        JRightPadded padded = JRightPadded.build(k).withAfter(beforeSemi);
        if (semicolon != null) {
            padded = padded.withMarkers(padded.getMarkers().add((Marker)semicolon));
        }
        return padded;
    }

    private TSCSyntaxKind scan() {
        return this.cursorContext.nextScannerSyntaxType();
    }

    private String lastToken() {
        return this.cursorContext.scannerTokenText();
    }

    private void consumeToken(TSCSyntaxKind kind) {
        TSCSyntaxKind actual = this.scan();
        if (kind != actual) {
            throw new IllegalStateException(String.format("expected kind '%s'; found '%s' at position %d", new Object[]{kind, actual, this.cursorContext.scannerTokenStart()}));
        }
    }

    private <J2 extends J> List<JRightPadded<J2>> convertAll(List<TSCNode> elements, Function<TSCNode, Space> innerSuffix, Function<TSCNode, Space> suffix) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList converted = new ArrayList(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            Space after;
            TSCNode element = elements.get(i);
            J j = this.visitNode(element);
            Space space = after = i == elements.size() - 1 ? suffix.apply(element) : innerSuffix.apply(element);
            if (j == null && i < elements.size() - 1) continue;
            if (j == null) {
                j = new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
            }
            JRightPadded<J> rightPadded = this.padRight(j, after);
            converted.add(rightPadded);
        }
        return converted.isEmpty() ? Collections.emptyList() : converted;
    }

    private <T extends J> JContainer<T> mapContainer(TSCSyntaxKind open, List<TSCNode> nodes, @Nullable TSCSyntaxKind delimiter, TSCSyntaxKind close, Function<TSCNode, T> visitFn) {
        List<Object> elements;
        Space containerPrefix = this.sourceBefore(open);
        if (nodes.isEmpty()) {
            Space withinContainerSpace = this.whitespace();
            elements = Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), withinContainerSpace, Markers.EMPTY)));
        } else {
            elements = new ArrayList(nodes.size());
            for (int i = 0; i < nodes.size(); ++i) {
                Space after;
                TSCNode node = nodes.get(i);
                J visited = (J)visitFn.apply(node);
                Markers markers = Markers.EMPTY;
                if (i < nodes.size() - 1) {
                    after = this.sourceBefore(delimiter);
                } else if (delimiter == TSCSyntaxKind.CommaToken) {
                    after = this.whitespace();
                    if (this.source.getText().charAt(this.getCursor()) == ',') {
                        this.consumeToken(delimiter);
                        markers = markers.addIfAbsent((Marker)new TrailingComma(Tree.randomId(), this.whitespace()));
                    }
                } else {
                    after = this.whitespace();
                }
                elements.add(JRightPadded.build((Object)visited).withAfter(after).withMarkers(markers));
            }
        }
        this.consumeToken(close);
        return JContainer.build((Space)containerPrefix, elements, (Markers)Markers.EMPTY);
    }

    private <J2 extends J> J.ControlParentheses<J2> mapControlParentheses(TSCNode node) {
        return new J.ControlParentheses(Tree.randomId(), this.sourceBefore(TSCSyntaxKind.OpenParenToken), Markers.EMPTY, this.padRight(this.visitNode(node), this.sourceBefore(TSCSyntaxKind.CloseParenToken)));
    }

    private J.ArrayType mapArrayType(TSCNode node) {
        Space prefix = this.whitespace();
        int dimensionsCount = 1;
        TSCNode curElement = node.getNodeProperty("elementType");
        while (curElement.syntaxKind() == TSCSyntaxKind.ArrayType) {
            ++dimensionsCount;
            curElement = curElement.getNodeProperty("elementType");
        }
        TypeTree typeTree = (TypeTree)this.visitNode(curElement);
        ArrayList<JRightPadded<Space>> dimensions = new ArrayList<JRightPadded<Space>>(dimensionsCount);
        for (int i = 0; i < dimensionsCount; ++i) {
            Space before = this.sourceBefore(TSCSyntaxKind.OpenBracketToken);
            dimensions.add(this.padRight(before, this.sourceBefore(TSCSyntaxKind.CloseBracketToken)));
        }
        return new J.ArrayType(Tree.randomId(), prefix, Markers.EMPTY, typeTree, dimensions);
    }

    private List<J.Modifier> mapModifiers(@Nullable List<TSCNode> nodes, List<J.Annotation> leadingAnnotations) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList modifiers = new ArrayList(nodes.size());
        ArrayList annotations = null;
        block9: for (TSCNode node : nodes) {
            Space prefix = this.whitespace();
            switch (node.syntaxKind()) {
                case Decorator: {
                    J.Annotation annotation = (J.Annotation)this.visitNode(node);
                    if (annotations == null) {
                        annotations = new ArrayList(1);
                    }
                    annotations.add(annotation);
                    continue block9;
                }
                case AbstractKeyword: {
                    this.consumeToken(TSCSyntaxKind.AbstractKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, J.Modifier.Type.Abstract, annotations == null ? Collections.emptyList() : annotations));
                    annotations = null;
                    continue block9;
                }
                case AsyncKeyword: {
                    this.consumeToken(TSCSyntaxKind.AsyncKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, J.Modifier.Type.Async, annotations == null ? Collections.emptyList() : annotations));
                    annotations = null;
                    continue block9;
                }
                case PublicKeyword: {
                    this.consumeToken(TSCSyntaxKind.PublicKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, J.Modifier.Type.Public, annotations == null ? Collections.emptyList() : annotations));
                    annotations = null;
                    continue block9;
                }
                case PrivateKeyword: {
                    this.consumeToken(TSCSyntaxKind.PrivateKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, J.Modifier.Type.Private, annotations == null ? Collections.emptyList() : annotations));
                    annotations = null;
                    continue block9;
                }
                case ProtectedKeyword: {
                    this.consumeToken(TSCSyntaxKind.ProtectedKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, J.Modifier.Type.Protected, annotations == null ? Collections.emptyList() : annotations));
                    annotations = null;
                    continue block9;
                }
                case StaticKeyword: {
                    this.consumeToken(TSCSyntaxKind.StaticKeyword);
                    modifiers.add(new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, J.Modifier.Type.Static, annotations == null ? Collections.emptyList() : annotations));
                    annotations = null;
                    continue block9;
                }
            }
            this.implementMe(node);
        }
        if (annotations != null) {
            leadingAnnotations.addAll(annotations);
        }
        return modifiers.isEmpty() ? Collections.emptyList() : modifiers;
    }

    private Space sourceBefore(TSCSyntaxKind syntaxKind) {
        Space prefix = this.whitespace();
        this.consumeToken(syntaxKind);
        return prefix;
    }

    private Space whitespace() {
        String initialSpace = "";
        List comments = Collections.emptyList();
        boolean done = false;
        do {
            TSCSyntaxKind kind = this.scan();
            switch (kind) {
                case WhitespaceTrivia: 
                case NewLineTrivia: {
                    if (comments.isEmpty()) {
                        initialSpace = initialSpace + this.lastToken();
                        break;
                    }
                    comments = ListUtils.map(comments, comment -> comment.withSuffix(comment.getSuffix() + this.lastToken()));
                    break;
                }
                case SingleLineCommentTrivia: 
                case MultiLineCommentTrivia: {
                    String commentText = this.lastToken();
                    commentText = commentText.substring(2, kind == TSCSyntaxKind.SingleLineCommentTrivia ? commentText.length() : commentText.length() - 2);
                    TextComment comment2 = new TextComment(kind == TSCSyntaxKind.MultiLineCommentTrivia, commentText, "", Markers.EMPTY);
                    if (comments.isEmpty()) {
                        comments = Collections.singletonList(comment2);
                        break;
                    }
                    comments = ListUtils.concat(comments, (Object)comment2);
                    break;
                }
                default: {
                    this.cursor(this.cursorContext.scannerTokenStart());
                    done = true;
                }
            }
        } while (!done);
        return Space.build((String)initialSpace, (List)comments);
    }

    private JS.UnknownElement unknownElement(TSCNode node) {
        Space prefix = this.whitespace();
        String text = node.getText();
        this.cursor(this.getCursor() + text.length());
        ParseExceptionResult result = new ParseExceptionResult(Tree.randomId(), ParseExceptionAnalysis.getAnalysisMessage(node.syntaxKind().name(), this.getCursor() + 20 < this.source.getText().length() ? this.source.getText().substring(this.getCursor(), this.getCursor() + 20) : this.source.getText().substring(this.getCursor())));
        return new JS.UnknownElement(Tree.randomId(), prefix, Markers.EMPTY, new JS.UnknownElement.Source(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(result)), text));
    }

    private void implementMe(TSCNode node) {
        throw new RuntimeException(ParseExceptionAnalysis.getAnalysisMessage(node.syntaxKind().name(), this.getCursor() + 20 < this.source.getText().length() ? this.source.getText().substring(this.getCursor(), this.getCursor() + 20) : this.source.getText().substring(this.getCursor())));
    }

    private void implementMe(TSCNode node, String propertyName) {
        if (node.hasProperty(propertyName)) {
            throw new RuntimeException(ParseExceptionAnalysis.getAnalysisMessage(node.syntaxKind().name() + "." + propertyName, this.getCursor() + 20 < this.source.getText().length() ? this.source.getText().substring(this.getCursor(), this.getCursor() + 20) : this.source.getText().substring(this.getCursor())));
        }
    }
}

