/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.SimplifyBooleanExpressionVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class InvertCondition
extends JavaVisitor<ExecutionContext> {
    public static <J2 extends J> J.ControlParentheses<J2> invert(J.ControlParentheses<J2> controlParentheses, Cursor cursor) {
        return (J.ControlParentheses)new InvertCondition().visit(controlParentheses, new InMemoryExecutionContext(), cursor.getParentOrThrow());
    }

    @Nullable
    public J visit(@Nullable Tree tree, ExecutionContext ctx) {
        J t;
        if (tree instanceof Expression && !(tree instanceof J.ControlParentheses) && !(tree instanceof J.Binary)) {
            Expression expression = (Expression)tree;
            t = new J.Unary(Tree.randomId(), expression.getPrefix(), Markers.EMPTY, JLeftPadded.build(J.Unary.Type.Not), (Expression)expression.withPrefix(Space.EMPTY), expression.getType());
        } else {
            t = (J)super.visit(tree, (Object)ctx);
        }
        return (J)new SimplifyBooleanExpressionVisitor().visit(t, ctx, this.getCursor().getParentOrThrow());
    }

    @Override
    public J visitBinary(J.Binary binary, ExecutionContext ctx) {
        switch (binary.getOperator()) {
            case LessThan: {
                return binary.withOperator(J.Binary.Type.GreaterThanOrEqual);
            }
            case GreaterThan: {
                return binary.withOperator(J.Binary.Type.LessThanOrEqual);
            }
            case LessThanOrEqual: {
                return binary.withOperator(J.Binary.Type.GreaterThan);
            }
            case GreaterThanOrEqual: {
                return binary.withOperator(J.Binary.Type.LessThan);
            }
            case Equal: {
                return binary.withOperator(J.Binary.Type.NotEqual);
            }
            case NotEqual: {
                return binary.withOperator(J.Binary.Type.Equal);
            }
        }
        return new J.Unary(Tree.randomId(), binary.getPrefix(), Markers.EMPTY, JLeftPadded.build(J.Unary.Type.Not), new J.Parentheses<J.Binary>(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build(binary.withPrefix(Space.EMPTY))), binary.getType());
    }
}

