/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.format.MergeSpacesVisitor;
import org.openrewrite.java.format.MinimumViableSpacingVisitor;
import org.openrewrite.java.format.NormalizeFormatVisitor;
import org.openrewrite.java.format.NormalizeLineBreaksVisitor;
import org.openrewrite.java.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.java.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;

public class AutoFormatVisitor<P>
extends JavaIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final List<NamedStyles> styles;
    private final boolean removeCustomLineBreaks;

    public AutoFormatVisitor() {
        this(null, new NamedStyles[0]);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter, NamedStyles ... style) {
        this(stopAfter, false, style);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter, boolean removeCustomLineBreaks, NamedStyles ... style) {
        this.stopAfter = stopAfter;
        this.styles = Arrays.stream(style).collect(Collectors.toList());
        this.removeCustomLineBreaks = removeCustomLineBreaks;
    }

    @Override
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof J.CompilationUnit;
    }

    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        JavaSourceFile cu;
        JavaSourceFile javaSourceFile = cu = tree instanceof JavaSourceFile ? (JavaSourceFile)tree : (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        if (tree == null) {
            tree = (Tree)cursor.getValue();
        }
        ArrayList<NamedStyles> activeStyles = new ArrayList<NamedStyles>(this.styles);
        activeStyles.addAll(cu.getMarkers().findAll(NamedStyles.class));
        J t = (J)new NormalizeFormatVisitor(this.stopAfter).visitNonNull(tree, p, cursor.fork());
        t = (J)new MinimumViableSpacingVisitor(this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new BlankLinesVisitor(activeStyles, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new SpacesVisitor(activeStyles, this.removeCustomLineBreaks, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new WrappingAndBracesVisitor(activeStyles, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new NormalizeTabsOrSpacesVisitor(activeStyles, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new TabsAndIndentsVisitor(activeStyles, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new NormalizeLineBreaksVisitor(activeStyles, cu, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visitNonNull(t, p, cursor.fork());
        tree = new MergeSpacesVisitor().visit(tree, t);
        if (tree instanceof JavaSourceFile) {
            return AutoFormatVisitor.addStyleMarker((JavaSourceFile)tree, this.styles);
        }
        return (J)tree;
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            if (!(cu instanceof J.CompilationUnit)) {
                return cu;
            }
            ArrayList<NamedStyles> activeStyles = new ArrayList<NamedStyles>(this.styles);
            activeStyles.addAll(cu.getMarkers().findAll(NamedStyles.class));
            JavaSourceFile t = (JavaSourceFile)new NormalizeFormatVisitor(this.stopAfter).visitNonNull(tree, p);
            t = (JavaSourceFile)new MinimumViableSpacingVisitor(this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new BlankLinesVisitor(activeStyles, this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new SpacesVisitor(activeStyles, this.removeCustomLineBreaks, this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new WrappingAndBracesVisitor(activeStyles, this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new NormalizeTabsOrSpacesVisitor(activeStyles, this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new TabsAndIndentsVisitor(activeStyles, this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new NormalizeLineBreaksVisitor(activeStyles, cu, this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visitNonNull(t, p);
            tree = new MergeSpacesVisitor().visit(tree, t);
            if (tree instanceof J.CompilationUnit) {
                return AutoFormatVisitor.addStyleMarker((JavaSourceFile)tree, this.styles);
            }
        }
        return (J)tree;
    }

    private static <T extends SourceFile> T addStyleMarker(T t, List<NamedStyles> styles) {
        if (!styles.isEmpty()) {
            HashSet<NamedStyles> newNamedStyles = new HashSet<NamedStyles>(styles);
            boolean styleAlreadyPresent = false;
            for (NamedStyles namedStyle : t.getMarkers().findAll(NamedStyles.class)) {
                styleAlreadyPresent = !newNamedStyles.add(namedStyle) || styleAlreadyPresent;
            }
            if (!styleAlreadyPresent) {
                Markers markers = t.getMarkers().removeByType(NamedStyles.class);
                for (NamedStyles namedStyle : newNamedStyles) {
                    markers = markers.add((Marker)namedStyle);
                }
                return (T)((SourceFile)t.withMarkers(markers));
            }
        }
        return t;
    }
}

